// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/talent/v4beta1/application.proto

package talent

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum that represents the application status.
type Application_ApplicationState int32

const (
	// Default value.
	Application_APPLICATION_STATE_UNSPECIFIED Application_ApplicationState = 0
	// The current stage is in progress or pending, for example, interviews in
	// progress.
	Application_IN_PROGRESS Application_ApplicationState = 1
	// The current stage was terminated by a candidate decision.
	Application_CANDIDATE_WITHDREW Application_ApplicationState = 2
	// The current stage was terminated by an employer or agency decision.
	Application_EMPLOYER_WITHDREW Application_ApplicationState = 3
	// The current stage is successfully completed, but the next stage (if
	// applicable) has not begun.
	Application_COMPLETED Application_ApplicationState = 4
	// The current stage was closed without an exception, or terminated for
	// reasons unrealated to the candidate.
	Application_CLOSED Application_ApplicationState = 5
)

// Enum value maps for Application_ApplicationState.
var (
	Application_ApplicationState_name = map[int32]string{
		0: "APPLICATION_STATE_UNSPECIFIED",
		1: "IN_PROGRESS",
		2: "CANDIDATE_WITHDREW",
		3: "EMPLOYER_WITHDREW",
		4: "COMPLETED",
		5: "CLOSED",
	}
	Application_ApplicationState_value = map[string]int32{
		"APPLICATION_STATE_UNSPECIFIED": 0,
		"IN_PROGRESS":                   1,
		"CANDIDATE_WITHDREW":            2,
		"EMPLOYER_WITHDREW":             3,
		"COMPLETED":                     4,
		"CLOSED":                        5,
	}
)

func (x Application_ApplicationState) Enum() *Application_ApplicationState {
	p := new(Application_ApplicationState)
	*p = x
	return p
}

func (x Application_ApplicationState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Application_ApplicationState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_application_proto_enumTypes[0].Descriptor()
}

func (Application_ApplicationState) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_application_proto_enumTypes[0]
}

func (x Application_ApplicationState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Application_ApplicationState.Descriptor instead.
func (Application_ApplicationState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_application_proto_rawDescGZIP(), []int{0, 0}
}

// The stage of the application.
type Application_ApplicationStage int32

const (
	// Default value.
	Application_APPLICATION_STAGE_UNSPECIFIED Application_ApplicationStage = 0
	// Candidate has applied or a recruiter put candidate into consideration but
	// candidate is not yet screened / no decision has been made to move or not
	// move the candidate to the next stage.
	Application_NEW Application_ApplicationStage = 1
	// A recruiter decided to screen the candidate for this role.
	Application_SCREEN Application_ApplicationStage = 2
	// Candidate is being / was sent to the customer / hiring manager for
	// detailed review.
	Application_HIRING_MANAGER_REVIEW Application_ApplicationStage = 3
	// Candidate was approved by the client / hiring manager and is being / was
	// interviewed for the role.
	Application_INTERVIEW Application_ApplicationStage = 4
	// Candidate will be / has been given an offer of employment.
	Application_OFFER_EXTENDED Application_ApplicationStage = 5
	// Candidate has accepted their offer of employment.
	Application_OFFER_ACCEPTED Application_ApplicationStage = 6
	// Candidate has begun (or completed) their employment or assignment with
	// the employer.
	Application_STARTED Application_ApplicationStage = 7
)

// Enum value maps for Application_ApplicationStage.
var (
	Application_ApplicationStage_name = map[int32]string{
		0: "APPLICATION_STAGE_UNSPECIFIED",
		1: "NEW",
		2: "SCREEN",
		3: "HIRING_MANAGER_REVIEW",
		4: "INTERVIEW",
		5: "OFFER_EXTENDED",
		6: "OFFER_ACCEPTED",
		7: "STARTED",
	}
	Application_ApplicationStage_value = map[string]int32{
		"APPLICATION_STAGE_UNSPECIFIED": 0,
		"NEW":                           1,
		"SCREEN":                        2,
		"HIRING_MANAGER_REVIEW":         3,
		"INTERVIEW":                     4,
		"OFFER_EXTENDED":                5,
		"OFFER_ACCEPTED":                6,
		"STARTED":                       7,
	}
)

func (x Application_ApplicationStage) Enum() *Application_ApplicationStage {
	p := new(Application_ApplicationStage)
	*p = x
	return p
}

func (x Application_ApplicationStage) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Application_ApplicationStage) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_talent_v4beta1_application_proto_enumTypes[1].Descriptor()
}

func (Application_ApplicationStage) Type() protoreflect.EnumType {
	return &file_google_cloud_talent_v4beta1_application_proto_enumTypes[1]
}

func (x Application_ApplicationStage) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Application_ApplicationStage.Descriptor instead.
func (Application_ApplicationStage) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_application_proto_rawDescGZIP(), []int{0, 1}
}

// Resource that represents a job application record of a candidate.
type Application struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required during application update.
	//
	// Resource name assigned to an application by the API.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}/applications/{application_id}".
	// For example, "projects/foo/tenants/bar/profiles/baz/applications/qux".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Client side application identifier, used to uniquely identify the
	// application.
	//
	// The maximum number of allowed characters is 255.
	ExternalId string `protobuf:"bytes,31,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Output only. Resource name of the candidate of this application.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}".
	// For example, "projects/foo/tenants/bar/profiles/baz".
	Profile string `protobuf:"bytes,2,opt,name=profile,proto3" json:"profile,omitempty"`
	// Required. Resource name of the job which the candidate applied for.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For example,
	// "projects/foo/tenants/bar/jobs/baz".
	Job string `protobuf:"bytes,4,opt,name=job,proto3" json:"job,omitempty"`
	// Resource name of the company which the candidate applied for.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}".
	// For example, "projects/foo/tenants/bar/companies/baz".
	Company string `protobuf:"bytes,5,opt,name=company,proto3" json:"company,omitempty"`
	// The application date.
	ApplicationDate *date.Date `protobuf:"bytes,7,opt,name=application_date,json=applicationDate,proto3" json:"application_date,omitempty"`
	// Required. What is the most recent stage of the application (that is, new,
	// screen, send cv, hired, finished work)?  This field is intentionally not
	// comprehensive of every possible status, but instead, represents statuses
	// that would be used to indicate to the ML models good / bad matches.
	Stage Application_ApplicationStage `protobuf:"varint,11,opt,name=stage,proto3,enum=google.cloud.talent.v4beta1.Application_ApplicationStage" json:"stage,omitempty"`
	// The application state.
	State Application_ApplicationState `protobuf:"varint,13,opt,name=state,proto3,enum=google.cloud.talent.v4beta1.Application_ApplicationState" json:"state,omitempty"`
	// All interviews (screen, onsite, and so on) conducted as part of this
	// application (includes details such as user conducting the interview,
	// timestamp, feedback, and so on).
	Interviews []*Interview `protobuf:"bytes,16,rep,name=interviews,proto3" json:"interviews,omitempty"`
	// If the candidate is referred by a employee.
	Referral *wrapperspb.BoolValue `protobuf:"bytes,18,opt,name=referral,proto3" json:"referral,omitempty"`
	// Required. Reflects the time that the application was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,19,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The last update timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,20,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Free text reason behind the recruitement outcome (for example, reason for
	// withdraw / reject, reason for an unsuccessful finish, and so on).
	//
	// Number of characters allowed is 100.
	OutcomeNotes string `protobuf:"bytes,21,opt,name=outcome_notes,json=outcomeNotes,proto3" json:"outcome_notes,omitempty"`
	// Outcome positiveness shows how positive the outcome is.
	Outcome Outcome `protobuf:"varint,22,opt,name=outcome,proto3,enum=google.cloud.talent.v4beta1.Outcome" json:"outcome,omitempty"`
	// Output only. Indicates whether this job application is a match to
	// application related filters. This value is only applicable in profile
	// search response.
	IsMatch *wrapperspb.BoolValue `protobuf:"bytes,28,opt,name=is_match,json=isMatch,proto3" json:"is_match,omitempty"`
	// Output only. Job title snippet shows how the job title is related to a
	// search query. It's empty if the job title isn't related to the search
	// query.
	JobTitleSnippet string `protobuf:"bytes,29,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
}

func (x *Application) Reset() {
	*x = Application{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_talent_v4beta1_application_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Application) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Application) ProtoMessage() {}

func (x *Application) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_talent_v4beta1_application_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Application.ProtoReflect.Descriptor instead.
func (*Application) Descriptor() ([]byte, []int) {
	return file_google_cloud_talent_v4beta1_application_proto_rawDescGZIP(), []int{0}
}

func (x *Application) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Application) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

func (x *Application) GetProfile() string {
	if x != nil {
		return x.Profile
	}
	return ""
}

func (x *Application) GetJob() string {
	if x != nil {
		return x.Job
	}
	return ""
}

func (x *Application) GetCompany() string {
	if x != nil {
		return x.Company
	}
	return ""
}

func (x *Application) GetApplicationDate() *date.Date {
	if x != nil {
		return x.ApplicationDate
	}
	return nil
}

func (x *Application) GetStage() Application_ApplicationStage {
	if x != nil {
		return x.Stage
	}
	return Application_APPLICATION_STAGE_UNSPECIFIED
}

func (x *Application) GetState() Application_ApplicationState {
	if x != nil {
		return x.State
	}
	return Application_APPLICATION_STATE_UNSPECIFIED
}

func (x *Application) GetInterviews() []*Interview {
	if x != nil {
		return x.Interviews
	}
	return nil
}

func (x *Application) GetReferral() *wrapperspb.BoolValue {
	if x != nil {
		return x.Referral
	}
	return nil
}

func (x *Application) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Application) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Application) GetOutcomeNotes() string {
	if x != nil {
		return x.OutcomeNotes
	}
	return ""
}

func (x *Application) GetOutcome() Outcome {
	if x != nil {
		return x.Outcome
	}
	return Outcome_OUTCOME_UNSPECIFIED
}

func (x *Application) GetIsMatch() *wrapperspb.BoolValue {
	if x != nil {
		return x.IsMatch
	}
	return nil
}

func (x *Application) GetJobTitleSnippet() string {
	if x != nil {
		return x.JobTitleSnippet
	}
	return ""
}

var File_google_cloud_talent_v4beta1_application_proto protoreflect.FileDescriptor

var file_google_cloud_talent_v4beta1_application_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74,
	0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64,
	0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x0a, 0x0a, 0x0b, 0x41, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a,
	0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x1f, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x12, 0x31, 0x0a, 0x03, 0x6a, 0x6f, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x1f, 0xfa, 0x41, 0x19, 0x0a, 0x17, 0x6a, 0x6f, 0x62, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0xe0, 0x41, 0x02,
	0x52, 0x03, 0x6a, 0x6f, 0x62, 0x12, 0x3a, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x6a, 0x6f, 0x62,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e,
	0x79, 0x12, 0x3c, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x52, 0x0f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12,
	0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61,
	0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x67, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x46, 0x0a, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76,
	0x69, 0x65, 0x77, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74,
	0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x69,
	0x65, 0x77, 0x52, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x36,
	0x0a, 0x08, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x61, 0x6c, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x08, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x72, 0x61, 0x6c, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65,
	0x5f, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x63, 0x6f, 0x6d, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x07, 0x6f, 0x75,
	0x74, 0x63, 0x6f, 0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e,
	0x74, 0x2e, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x63, 0x6f, 0x6d,
	0x65, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x69, 0x73,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42,
	0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x69,
	0x73, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x2f, 0x0a, 0x11, 0x6a, 0x6f, 0x62, 0x5f, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x18, 0x1d, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x6a, 0x6f, 0x62, 0x54, 0x69, 0x74, 0x6c, 0x65,
	0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x22, 0x90, 0x01, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x1d,
	0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x01,
	0x12, 0x16, 0x0a, 0x12, 0x43, 0x41, 0x4e, 0x44, 0x49, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x57, 0x49,
	0x54, 0x48, 0x44, 0x52, 0x45, 0x57, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x45, 0x4d, 0x50, 0x4c,
	0x4f, 0x59, 0x45, 0x52, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x44, 0x52, 0x45, 0x57, 0x10, 0x03, 0x12,
	0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x10, 0x05, 0x22, 0xa9, 0x01, 0x0a, 0x10, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x67, 0x65, 0x12,
	0x21, 0x0a, 0x1d, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x54, 0x41, 0x47, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x45, 0x57, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x43, 0x52, 0x45, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x48, 0x49, 0x52, 0x49, 0x4e,
	0x47, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x56, 0x49, 0x45, 0x57, 0x10,
	0x04, 0x12, 0x12, 0x0a, 0x0e, 0x4f, 0x46, 0x46, 0x45, 0x52, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x4e,
	0x44, 0x45, 0x44, 0x10, 0x05, 0x12, 0x12, 0x0a, 0x0e, 0x4f, 0x46, 0x46, 0x45, 0x52, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x50, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x45, 0x44, 0x10, 0x07, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x1f, 0x6a, 0x6f, 0x62,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74,
	0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x7d, 0x2f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42,
	0x86, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x2e, 0x76, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x42, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x74, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x2f, 0x76, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x74, 0x61, 0x6c, 0x65,
	0x6e, 0x74, 0xa2, 0x02, 0x03, 0x43, 0x54, 0x53, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_talent_v4beta1_application_proto_rawDescOnce sync.Once
	file_google_cloud_talent_v4beta1_application_proto_rawDescData = file_google_cloud_talent_v4beta1_application_proto_rawDesc
)

func file_google_cloud_talent_v4beta1_application_proto_rawDescGZIP() []byte {
	file_google_cloud_talent_v4beta1_application_proto_rawDescOnce.Do(func() {
		file_google_cloud_talent_v4beta1_application_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_talent_v4beta1_application_proto_rawDescData)
	})
	return file_google_cloud_talent_v4beta1_application_proto_rawDescData
}

var file_google_cloud_talent_v4beta1_application_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_talent_v4beta1_application_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_talent_v4beta1_application_proto_goTypes = []interface{}{
	(Application_ApplicationState)(0), // 0: google.cloud.talent.v4beta1.Application.ApplicationState
	(Application_ApplicationStage)(0), // 1: google.cloud.talent.v4beta1.Application.ApplicationStage
	(*Application)(nil),               // 2: google.cloud.talent.v4beta1.Application
	(*date.Date)(nil),                 // 3: google.type.Date
	(*Interview)(nil),                 // 4: google.cloud.talent.v4beta1.Interview
	(*wrapperspb.BoolValue)(nil),      // 5: google.protobuf.BoolValue
	(*timestamppb.Timestamp)(nil),     // 6: google.protobuf.Timestamp
	(Outcome)(0),                      // 7: google.cloud.talent.v4beta1.Outcome
}
var file_google_cloud_talent_v4beta1_application_proto_depIdxs = []int32{
	3, // 0: google.cloud.talent.v4beta1.Application.application_date:type_name -> google.type.Date
	1, // 1: google.cloud.talent.v4beta1.Application.stage:type_name -> google.cloud.talent.v4beta1.Application.ApplicationStage
	0, // 2: google.cloud.talent.v4beta1.Application.state:type_name -> google.cloud.talent.v4beta1.Application.ApplicationState
	4, // 3: google.cloud.talent.v4beta1.Application.interviews:type_name -> google.cloud.talent.v4beta1.Interview
	5, // 4: google.cloud.talent.v4beta1.Application.referral:type_name -> google.protobuf.BoolValue
	6, // 5: google.cloud.talent.v4beta1.Application.create_time:type_name -> google.protobuf.Timestamp
	6, // 6: google.cloud.talent.v4beta1.Application.update_time:type_name -> google.protobuf.Timestamp
	7, // 7: google.cloud.talent.v4beta1.Application.outcome:type_name -> google.cloud.talent.v4beta1.Outcome
	5, // 8: google.cloud.talent.v4beta1.Application.is_match:type_name -> google.protobuf.BoolValue
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_talent_v4beta1_application_proto_init() }
func file_google_cloud_talent_v4beta1_application_proto_init() {
	if File_google_cloud_talent_v4beta1_application_proto != nil {
		return
	}
	file_google_cloud_talent_v4beta1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_talent_v4beta1_application_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Application); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_talent_v4beta1_application_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_talent_v4beta1_application_proto_goTypes,
		DependencyIndexes: file_google_cloud_talent_v4beta1_application_proto_depIdxs,
		EnumInfos:         file_google_cloud_talent_v4beta1_application_proto_enumTypes,
		MessageInfos:      file_google_cloud_talent_v4beta1_application_proto_msgTypes,
	}.Build()
	File_google_cloud_talent_v4beta1_application_proto = out.File
	file_google_cloud_talent_v4beta1_application_proto_rawDesc = nil
	file_google_cloud_talent_v4beta1_application_proto_goTypes = nil
	file_google_cloud_talent_v4beta1_application_proto_depIdxs = nil
}
