// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/endpoint.proto

package serviceconfig // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// `Endpoint` describes a network endpoint that serves a set of APIs.
// A service may expose any number of endpoints, and all endpoints share the
// same service configuration, such as quota configuration and monitoring
// configuration.
//
// Example service configuration:
//
//     name: library-example.googleapis.com
//     endpoints:
//       # Below entry makes 'google.example.library.v1.Library'
//       # API be served from endpoint address library-example.googleapis.com.
//       # It also allows HTTP OPTIONS calls to be passed to the backend, for
//       # it to decide whether the subsequent cross-origin request is
//       # allowed to proceed.
//     - name: library-example.googleapis.com
//       allow_cors: true
type Endpoint struct {
	// The canonical name of this endpoint.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// DEPRECATED: This field is no longer supported. Instead of using aliases,
	// please specify multiple [google.api.Endpoint][google.api.Endpoint] for each of the intended
	// aliases.
	//
	// Additional names that this endpoint will be hosted on.
	Aliases []string `protobuf:"bytes,2,rep,name=aliases,proto3" json:"aliases,omitempty"`
	// The list of features enabled on this endpoint.
	Features []string `protobuf:"bytes,4,rep,name=features,proto3" json:"features,omitempty"`
	// The specification of an Internet routable address of API frontend that will
	// handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary).
	// It should be either a valid IPv4 address or a fully-qualified domain name.
	// For example, "8.8.8.8" or "myservice.appspot.com".
	Target string `protobuf:"bytes,101,opt,name=target,proto3" json:"target,omitempty"`
	// Allowing
	// [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka
	// cross-domain traffic, would allow the backends served from this endpoint to
	// receive and respond to HTTP OPTIONS requests. The response will be used by
	// the browser to determine whether the subsequent cross-origin request is
	// allowed to proceed.
	AllowCors            bool     `protobuf:"varint,5,opt,name=allow_cors,json=allowCors,proto3" json:"allow_cors,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Endpoint) Reset()         { *m = Endpoint{} }
func (m *Endpoint) String() string { return proto.CompactTextString(m) }
func (*Endpoint) ProtoMessage()    {}
func (*Endpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_endpoint_d87650ae3428bec5, []int{0}
}
func (m *Endpoint) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Endpoint.Unmarshal(m, b)
}
func (m *Endpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Endpoint.Marshal(b, m, deterministic)
}
func (dst *Endpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Endpoint.Merge(dst, src)
}
func (m *Endpoint) XXX_Size() int {
	return xxx_messageInfo_Endpoint.Size(m)
}
func (m *Endpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_Endpoint.DiscardUnknown(m)
}

var xxx_messageInfo_Endpoint proto.InternalMessageInfo

func (m *Endpoint) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Endpoint) GetAliases() []string {
	if m != nil {
		return m.Aliases
	}
	return nil
}

func (m *Endpoint) GetFeatures() []string {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *Endpoint) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *Endpoint) GetAllowCors() bool {
	if m != nil {
		return m.AllowCors
	}
	return false
}

func init() {
	proto.RegisterType((*Endpoint)(nil), "google.api.Endpoint")
}

func init() { proto.RegisterFile("google/api/endpoint.proto", fileDescriptor_endpoint_d87650ae3428bec5) }

var fileDescriptor_endpoint_d87650ae3428bec5 = []byte{
	// 245 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x8f, 0xb1, 0x4e, 0xc3, 0x30,
	0x10, 0x86, 0xe5, 0x12, 0x4a, 0x72, 0x12, 0x0c, 0x1e, 0x90, 0xa9, 0x40, 0x8a, 0x98, 0x32, 0x25,
	0x03, 0x23, 0x13, 0x45, 0x15, 0x62, 0x8b, 0x32, 0xb2, 0xa0, 0x23, 0x5c, 0x2d, 0x4b, 0xae, 0xcf,
	0xb2, 0x0d, 0x3c, 0x04, 0x6f, 0xc1, 0x93, 0x22, 0x9c, 0x14, 0xe8, 0xe6, 0xcf, 0xdf, 0xdd, 0xe9,
	0xff, 0xe1, 0x42, 0x33, 0x6b, 0x4b, 0x1d, 0x7a, 0xd3, 0x91, 0x7b, 0xf5, 0x6c, 0x5c, 0x6a, 0x7d,
	0xe0, 0xc4, 0x12, 0x26, 0xd5, 0xa2, 0x37, 0xab, 0xcb, 0x7f, 0x63, 0xe8, 0x1c, 0x27, 0x4c, 0x86,
	0x5d, 0x9c, 0x26, 0xaf, 0x3f, 0x05, 0x94, 0x9b, 0x79, 0x59, 0x4a, 0x28, 0x1c, 0xee, 0x48, 0x89,
	0x5a, 0x34, 0xd5, 0x90, 0xdf, 0x52, 0xc1, 0x09, 0x5a, 0x83, 0x91, 0xa2, 0x5a, 0xd4, 0x47, 0x4d,
	0x35, 0xec, 0x51, 0xae, 0xa0, 0xdc, 0x12, 0xa6, 0xb7, 0x40, 0x51, 0x15, 0x59, 0xfd, 0xb2, 0x3c,
	0x87, 0x65, 0xc2, 0xa0, 0x29, 0x29, 0xca, 0xb7, 0x66, 0x92, 0x57, 0x00, 0x68, 0x2d, 0x7f, 0x3c,
	0x8f, 0x1c, 0xa2, 0x3a, 0xae, 0x45, 0x53, 0x0e, 0x55, 0xfe, 0xb9, 0xe7, 0x10, 0xd7, 0x0c, 0x67,
	0x23, 0xef, 0xda, 0xbf, 0xf4, 0xeb, 0xd3, 0x7d, 0xb8, 0xfe, 0x27, 0x6e, 0x2f, 0x9e, 0x36, 0xb3,
	0xd4, 0x6c, 0xd1, 0xe9, 0x96, 0x83, 0xee, 0x34, 0xb9, 0x5c, 0xa6, 0x9b, 0x14, 0x7a, 0x13, 0x73,
	0xdb, 0x48, 0xe1, 0xdd, 0x8c, 0x34, 0xb2, 0xdb, 0x1a, 0x7d, 0x7b, 0x40, 0x5f, 0x8b, 0xe2, 0xe1,
	0xae, 0x7f, 0x7c, 0x59, 0xe6, 0xc5, 0x9b, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0xc8, 0x32, 0xa4,
	0x36, 0x4c, 0x01, 0x00, 0x00,
}
