/*
 * menu_midi.h - MIDI menu for SDL UI.
 *
 * Written by
 *  Hannu Nuotio <hannu.nuotio@tut.fi>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_MENU_MIDI_H
#define VICE_MENU_MIDI_H

#include "vice.h"
#include "types.h"
#include "uimenu.h"

extern UI_MENU_CALLBACK(MIDIInDev_dynmenu_callback);
extern UI_MENU_CALLBACK(MIDIOutDev_dynmenu_callback);

extern const ui_menu_entry_t midi_c64_menu[];
extern const ui_menu_entry_t midi_vic20_menu[];

extern void sdl_menu_midi_in_free(void);
extern void sdl_menu_midi_out_free(void);

#endif
