/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/reporting/CompileError.hpp"

namespace ast {

void
CompileError::put(std::ostream &stream) const
{
	stream << this->location << ": " << this->message;
}

std::ostream&
operator<<(std::ostream &stream, const CompileError &err)
{
	err.put(stream);
	return stream;
}

}; /* namespace ast */
