
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file ColourTechniqueAttributes.h
    \\brief Definition of ColourTechnique Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "ColourTechniqueAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

ColourTechniqueAttributes::ColourTechniqueAttributes():
	oob_min_colour_(ParameterManager::getString("contour_out_of_bound_min_colour")),
	oob_max_colour_(ParameterManager::getString("contour_out_of_bound_max_colour"))
	
	
{
}


ColourTechniqueAttributes::~ColourTechniqueAttributes()
{

}


void ColourTechniqueAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "contour_out_of_bound_min_colour", oob_min_colour_, params);
	setAttribute(prefix, "contour_out_of_bound_max_colour", oob_max_colour_, params);
	
	
}

void ColourTechniqueAttributes::copy(const ColourTechniqueAttributes& other)
{
	oob_min_colour_ = other.oob_min_colour_;
	oob_max_colour_ = other.oob_max_colour_;
	
}


bool ColourTechniqueAttributes::accept(const string& node)
{

	if ( magCompare(node, "")  )
		return true;
	
	return false;
}

void ColourTechniqueAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void ColourTechniqueAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " oob_min_colour = " <<  oob_min_colour_;
	out << " oob_max_colour = " <<  oob_max_colour_;
	
	out << "]" << "\n";
}

void ColourTechniqueAttributes::toxml(ostream& out)  const
{
	out <<  "\"\"";
	out << ", \"contour_out_of_bound_min_colour\":";
	niceprint(out,oob_min_colour_);
	out << ", \"contour_out_of_bound_max_colour\":";
	niceprint(out,oob_max_colour_);
	
}

static MagicsParameter<string> contour_out_of_bound_min_colour("contour_out_of_bound_min_colour", "automatic");
static MagicsParameter<string> contour_out_of_bound_max_colour("contour_out_of_bound_max_colour", "automatic");
