# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AgeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Age Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified age unit"""
    YEAR = "Year"
    """Year age unit"""
    MONTH = "Month"
    """Month age unit"""
    WEEK = "Week"
    """Week age unit"""
    DAY = "Day"
    """Day age unit"""


class AnalyzeConversationInputKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported Conversation tasks."""

    CONVERSATION = "Conversation"
    """Conversation task kind"""
    CONVERSATIONAL_AI = "ConversationalAI"
    """Conversation task kind"""


class AnalyzeConversationOperationActionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported analysis tasks on a collection of conversations."""

    CONVERSATIONAL_SUMMARIZATION_TASK = "ConversationalSummarizationTask"
    """Conversational Summarization Task"""
    CONVERSATIONAL_PII_TASK = "ConversationalPIITask"
    """Conversational PII Task"""
    CUSTOM_CONVERSATIONAL_SUMMARIZATION_TASK = "CustomConversationalSummarizationTask"
    """Custom Conversational Summarization Task"""


class AnalyzeConversationOperationResultsKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of results for supported conversation analysis Results."""

    SUMMARIZATION_OPERATION_RESULTS = "conversationalSummarizationResults"
    """Conversational Summarization Results"""
    PII_OPERATION_RESULTS = "conversationalPIIResults"
    """Conversational PII Results"""
    CUSTOM_SUMMARIZATION_OPERATION_RESULTS = "customConversationalSummarizationResults"
    """Custom Conversational Summarization Results"""


class AnalyzeConversationResultKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported conversational task results."""

    CONVERSATION_RESULT = "ConversationResult"
    """Conversation result task kind"""
    CONVERSATIONAL_AI_RESULT = "ConversationalAIResult"
    """Conversation result task kind"""


class AreaUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The area unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified area unit"""
    SQUARE_KILOMETER = "SquareKilometer"
    """Square kilometer area unit"""
    SQUARE_HECTOMETER = "SquareHectometer"
    """Square hectometer area unit"""
    SQUARE_DECAMETER = "SquareDecameter"
    """Square decameter area unit"""
    SQUARE_DECIMETER = "SquareDecimeter"
    """Square decimeter area unit"""
    SQUARE_METER = "SquareMeter"
    """Square meter area unit"""
    SQUARE_CENTIMETER = "SquareCentimeter"
    """Square centimeter area unit"""
    SQUARE_MILLIMETER = "SquareMillimeter"
    """Square millimeter area unit"""
    SQUARE_INCH = "SquareInch"
    """Square inch area unit"""
    SQUARE_FOOT = "SquareFoot"
    """Square foot area unit"""
    SQUARE_MILE = "SquareMile"
    """Square mile area unit"""
    SQUARE_YARD = "SquareYard"
    """Square yard area unit"""
    ACRE = "Acre"
    """Acre area unit"""


class ConversationActionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the task at the mentioned last update time."""

    NOT_STARTED = "notStarted"
    """Not started state"""
    RUNNING = "running"
    """Running state"""
    SUCCEEDED = "succeeded"
    """Succeeded state"""
    PARTIALLY_COMPLETED = "partiallyCompleted"
    """Partially completed state"""
    FAILED = "failed"
    """Failed state"""
    CANCELLED = "cancelled"
    """Cancelled state"""
    CANCELLING = "cancelling"
    """Cancelling state"""


class ConversationDomain(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported conversational domains."""

    FINANCE = "finance"
    """Enumeration of supported conversational domains."""
    HEALTHCARE = "healthcare"
    """Enumeration of supported conversational domains."""
    GENERIC = "generic"
    """Enumeration of supported conversational domains."""


class ConversationErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_ARGUMENT = "InvalidArgument"
    """Invalid argument error"""
    UNAUTHORIZED = "Unauthorized"
    """Unauthorized access error"""
    FORBIDDEN = "Forbidden"
    """Forbidden access error"""
    NOT_FOUND = "NotFound"
    """Not found error"""
    PROJECT_NOT_FOUND = "ProjectNotFound"
    """Project not found error"""
    OPERATION_NOT_FOUND = "OperationNotFound"
    """Operation not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_INDEX_NOT_FOUND = "AzureCognitiveSearchIndexNotFound"
    """Azure Cognitive Search index not found error"""
    TOO_MANY_REQUESTS = "TooManyRequests"
    """Too many requests error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    AZURE_COGNITIVE_SEARCH_INDEX_LIMIT_REACHED = "AzureCognitiveSearchIndexLimitReached"
    """Azure Cognitive Search index limit reached error"""
    INTERNAL_SERVER_ERROR = "InternalServerError"
    """Internal server error"""
    SERVICE_UNAVAILABLE = "ServiceUnavailable"
    """Service unavailable error"""
    TIMEOUT = "Timeout"
    """Timeout error"""
    QUOTA_EXCEEDED = "QuotaExceeded"
    """Quota exceeded error"""
    CONFLICT = "Conflict"
    """Conflict error"""
    WARNING = "Warning"
    """Warning error"""


class ConversationPiiCategories(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the PII categories to return for detection. If not provided, 'default' categories
    will be returned which will vary with the language.
    """

    ADDRESS = "Address"
    """Address category"""
    CREDIT_CARD = "CreditCard"
    """Credit card category"""
    EMAIL = "Email"
    """Email category"""
    PERSON = "Person"
    """Person category"""
    NUMERIC_IDENTIFIER = "NumericIdentifier"
    """Numeric identifier category"""
    PHONE = "Phone"
    """Phone category"""
    US_SOCIAL_SECURITY_NUMBER = "USSocialSecurityNumber"
    """US social security number category"""
    DRIVERS_LICENSE_NUMBER = "DriversLicenseNumber"
    """Driver's license number category"""
    PASSPORT_NUMBER = "PassportNumber"
    """Passport number category"""
    PERSON_TYPE = "PersonType"
    """Person type category"""
    ORGANIZATION = "Organization"
    """Organization category"""
    ABA_ROUTING_NUMBER = "ABARoutingNumber"
    """ABA routing number category"""
    BANK_ACCOUNT_NUMBER = "BankAccountNumber"
    """Bank account number category"""
    DATE_OF_BIRTH = "DateOfBirth"
    """Date of birth category"""
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER = "InternationalBankingAccountNumber"
    """International Bank Account Number category"""
    SWIFT_CODE = "SWIFTCode"
    """SWIFT code category"""
    VEHICLE_IDENTIFICATION_NUMBER = "VehicleIdentificationNumber"
    """Vehicle identification number category"""
    AGE = "Age"
    """Age category"""
    DATE = "Date"
    """Date category"""
    ZIP_CODE = "ZipCode"
    """Zip code category"""
    GOVERNMENT_ISSUED_ID = "GovernmentIssuedId"
    """Government issued ID category"""
    CVV = "CVV"
    """Card verification value category"""
    HEALTH_CARD_NUMBER = "HealthCardNumber"
    """Health card number category"""
    CA_SOCIAL_INSURANCE_NUMBER = "CASocialInsuranceNumber"
    """CA Social insurance number category"""
    US_MEDICARE_BENEFICIARY_ID = "USMedicareBeneficiaryId"
    """US Medicare beneficiary ID category"""
    GITHUB_ACCOUNT = "GithubAccount"
    """Github account category"""
    LOCATION = "Location"
    """Location category"""
    GPE = "GPE"
    """GPE category"""
    ALL = "All"
    """All categories"""
    DEFAULT = "Default"
    """Default categories"""


class ConversationPiiCategoryExclusions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the PII categories to exclude for detection. If not provided, 'default' categories
    will be returned which will vary with the language.
    """

    ADDRESS = "Address"
    """Address category"""
    CREDIT_CARD = "CreditCard"
    """Credit card category"""
    EMAIL = "Email"
    """Email category"""
    PERSON = "Person"
    """Person category"""
    NUMERIC_IDENTIFIER = "NumericIdentifier"
    """Numeric identifier category"""
    PHONE = "Phone"
    """Phone category"""
    US_SOCIAL_SECURITY_NUMBER = "USSocialSecurityNumber"
    """US social security number category"""
    DRIVERS_LICENSE_NUMBER = "DriversLicenseNumber"
    """Driver's license number category"""
    PASSPORT_NUMBER = "PassportNumber"
    """Passport number category"""
    PERSON_TYPE = "PersonType"
    """Person type category"""
    ORGANIZATION = "Organization"
    """Organization category"""
    ABA_ROUTING_NUMBER = "ABARoutingNumber"
    """ABA routing number category"""
    BANK_ACCOUNT_NUMBER = "BankAccountNumber"
    """Bank account number category"""
    DATE_OF_BIRTH = "DateOfBirth"
    """Date of birth category"""
    INTERNATIONAL_BANKING_ACCOUNT_NUMBER = "InternationalBankingAccountNumber"
    """International Bank Account Number category"""
    SWIFT_CODE = "SWIFTCode"
    """SWIFT code category"""
    VEHICLE_IDENTIFICATION_NUMBER = "VehicleIdentificationNumber"
    """Vehicle identification number category"""
    AGE = "Age"
    """Age category"""
    DATE = "Date"
    """Date category"""
    ZIP_CODE = "ZipCode"
    """Zip code category"""
    GOVERNMENT_ISSUED_ID = "GovernmentIssuedId"
    """Government issued ID category"""
    CVV = "CVV"
    """Card verification value category"""
    HEALTH_CARD_NUMBER = "HealthCardNumber"
    """Health card number category"""
    CA_SOCIAL_INSURANCE_NUMBER = "CASocialInsuranceNumber"
    """CA Social insurance number category"""
    US_MEDICARE_BENEFICIARY_ID = "USMedicareBeneficiaryId"
    """US Medicare beneficiary ID category"""
    GITHUB_ACCOUNT = "GithubAccount"
    """Github account category"""
    LOCATION = "Location"
    """Location category"""
    GPE = "GPE"
    """GPE category"""


class DateTimeSubKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Datetime SubKind."""

    TIME = "Time"
    """Time subkind"""
    DATE = "Date"
    """Date subkind"""
    DATE_TIME = "DateTime"
    """DateTime subkind"""
    DURATION = "Duration"
    """Duration subkind"""
    SET = "Set"
    """Set subkind"""


class ExtraInformationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The extra information object kind."""

    ENTITY_SUBTYPE = "EntitySubtype"
    """Entity subtype extra information kind"""
    LIST_KEY = "ListKey"
    """List key extra information kind"""
    REGEX_KEY = "RegexKey"
    """Regex key extra information kind"""


class InformationUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The information (data) Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified information unit"""
    BIT = "Bit"
    """Bit information unit"""
    KILOBIT = "Kilobit"
    """Kilobit information unit"""
    MEGABIT = "Megabit"
    """Megabit information unit"""
    GIGABIT = "Gigabit"
    """Gigabit information unit"""
    TERABIT = "Terabit"
    """Terabit information unit"""
    PETABIT = "Petabit"
    """Petabit information unit"""
    BYTE = "Byte"
    """Byte information unit"""
    KILOBYTE = "Kilobyte"
    """Kilobyte information unit"""
    MEGABYTE = "Megabyte"
    """Megabyte information unit"""
    GIGABYTE = "Gigabyte"
    """Gigabyte information unit"""
    TERABYTE = "Terabyte"
    """Terabyte information unit"""
    PETABYTE = "Petabyte"
    """Petabyte information unit"""


class InnerErrorCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Human-readable error code."""

    INVALID_REQUEST = "InvalidRequest"
    """Invalid request error"""
    INVALID_PARAMETER_VALUE = "InvalidParameterValue"
    """Invalid parameter value error"""
    KNOWLEDGE_BASE_NOT_FOUND = "KnowledgeBaseNotFound"
    """Knowledge base not found error"""
    AZURE_COGNITIVE_SEARCH_NOT_FOUND = "AzureCognitiveSearchNotFound"
    """Azure Cognitive Search not found error"""
    AZURE_COGNITIVE_SEARCH_THROTTLING = "AzureCognitiveSearchThrottling"
    """Azure Cognitive Search throttling error"""
    EXTRACTION_FAILURE = "ExtractionFailure"
    """Extraction failure error"""
    INVALID_REQUEST_BODY_FORMAT = "InvalidRequestBodyFormat"
    """Invalid request body format error"""
    EMPTY_REQUEST = "EmptyRequest"
    """Empty request error"""
    MISSING_INPUT_DOCUMENTS = "MissingInputDocuments"
    """Missing input documents error"""
    INVALID_DOCUMENT = "InvalidDocument"
    """Invalid document error"""
    MODEL_VERSION_INCORRECT = "ModelVersionIncorrect"
    """Model version incorrect error"""
    INVALID_DOCUMENT_BATCH = "InvalidDocumentBatch"
    """Invalid document batch error"""
    UNSUPPORTED_LANGUAGE_CODE = "UnsupportedLanguageCode"
    """Unsupported language code error"""
    INVALID_COUNTRY_HINT = "InvalidCountryHint"
    """Invalid country hint error"""


class InputModality(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported conversational modalities."""

    TRANSCRIPT = "transcript"
    """Transcript input modality"""
    TEXT = "text"
    """Text input modality"""


class LengthUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The length unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified length unit"""
    KILOMETER = "Kilometer"
    """Kilometer length unit"""
    HECTOMETER = "Hectometer"
    """Hectometer length unit"""
    DECAMETER = "Decameter"
    """Decameter length unit"""
    METER = "Meter"
    """Meter length unit"""
    DECIMETER = "Decimeter"
    """Decimeter length unit"""
    CENTIMETER = "Centimeter"
    """Centimeter length unit"""
    MILLIMETER = "Millimeter"
    """Millimeter length unit"""
    MICROMETER = "Micrometer"
    """Micrometer length unit"""
    NANOMETER = "Nanometer"
    """Nanometer length unit"""
    PICOMETER = "Picometer"
    """Picometer length unit"""
    MILE = "Mile"
    """Mile length unit"""
    YARD = "Yard"
    """Yard length unit"""
    INCH = "Inch"
    """Inch length unit"""
    FOOT = "Foot"
    """Foot length unit"""
    LIGHT_YEAR = "LightYear"
    """Light year length unit"""
    POINT = "Pt"
    """Point length unit"""


class LogicalOperationKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Set to 'OR' or 'AND' for using corresponding logical operation."""

    AND = "AND"
    """Logical AND"""
    OR = "OR"
    """Logical OR"""


class NumberKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the extracted number entity."""

    INTEGER = "Integer"
    """Integer number"""
    DECIMAL = "Decimal"
    """Decimal number"""
    POWER = "Power"
    """Power number"""
    FRACTION = "Fraction"
    """Fraction number"""
    PERCENT = "Percent"
    """Percent number"""
    UNSPECIFIED = "Unspecified"
    """Unspecified number kind"""


class ParticipantRole(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Role of the participant."""

    CUSTOMER = "customer"
    """The participant is a customer."""
    AGENT = "agent"
    """The participant is an agent."""
    GENERIC = "generic"
    """The is a generic participant."""


class ProjectKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the project."""

    CONVERSATION = "Conversation"
    """Conversation type"""
    ORCHESTRATION = "Orchestration"
    """Orchestration type"""
    CONVERSATIONAL_AI = "ConversationalAI"
    """Conversation type"""


class RangeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of range that the resolution object represents."""

    NUMBER = "Number"
    """Number range"""
    SPEED = "Speed"
    """Speed range"""
    WEIGHT = "Weight"
    """Weight range"""
    LENGTH = "Length"
    """Length range"""
    VOLUME = "Volume"
    """Volume range"""
    AREA = "Area"
    """Area range"""
    AGE = "Age"
    """Age range"""
    INFORMATION = "Information"
    """Information range"""
    TEMPERATURE = "Temperature"
    """Temperature range"""
    CURRENCY = "Currency"
    """Currency range"""


class RankerKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of ranker to be used."""

    DEFAULT = "Default"
    """Default ranker."""
    QUESTION_ONLY = "QuestionOnly"
    """Question only ranker."""


class RedactionCharacter(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional parameter to use a Custom Character to be used for redaction in PII responses. Default
    character will be * as before. We allow specific ascii characters for redaction.
    """

    EXCLAMATION_POINT = "!"
    """Exclamation point character"""
    NUMBER_SIGN = "#"
    """Number sign character"""
    DOLLAR = "$"
    """Dollar sign character"""
    PERCENT = "%"
    """Percent sign character"""
    AMPERSAND = "&"
    """Ampersand character"""
    ASTERISK = "*"
    """Asterisk character"""
    PLUS = "+"
    """Plus sign character"""
    MINUS = "-"
    """Minus sign character"""
    EQUALS = "="
    """Equals sign character"""
    QUESTION_MARK = "?"
    """Question mark character"""
    AT_SIGN = "@"
    """At sign character"""
    CARET = "^"
    """Caret character"""
    UNDERSCORE = "_"
    """Underscore character"""
    TILDE = "~"
    """Tilde character"""


class RedactionPolicyKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Kinds of redaction policies supported."""

    NO_MASK = "noMask"
    """Do not mask detected entities"""
    CHARACTER_MASK = "characterMask"
    """Mask detected entities with redaction character"""
    ENTITY_MASK = "entityMask"
    """Mask detected entities with entity type"""


class RelativeTo(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reference point that the ordinal number denotes."""

    CURRENT = "Current"
    """Current state"""
    END = "End"
    """End state"""
    START = "Start"
    """Start state"""


class ResolutionKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The entity resolution object kind."""

    BOOLEAN_RESOLUTION = "BooleanResolution"
    """Resolution of a boolean entity"""
    DATE_TIME_RESOLUTION = "DateTimeResolution"
    """Resolution of a date/time entity"""
    NUMBER_RESOLUTION = "NumberResolution"
    """Resolution of a number entity"""
    ORDINAL_RESOLUTION = "OrdinalResolution"
    """Resolution of an ordinal entity"""
    SPEED_RESOLUTION = "SpeedResolution"
    """Resolution of a speed entity"""
    WEIGHT_RESOLUTION = "WeightResolution"
    """Resolution of a weight entity"""
    LENGTH_RESOLUTION = "LengthResolution"
    """Resolution of a length entity"""
    VOLUME_RESOLUTION = "VolumeResolution"
    """Resolution of a volume entity"""
    AREA_RESOLUTION = "AreaResolution"
    """Resolution of an area entity"""
    AGE_RESOLUTION = "AgeResolution"
    """Resolution of an age entity"""
    INFORMATION_RESOLUTION = "InformationResolution"
    """Resolution of an information entity"""
    TEMPERATURE_RESOLUTION = "TemperatureResolution"
    """Resolution of a temperature entity"""
    CURRENCY_RESOLUTION = "CurrencyResolution"
    """Resolution of a currency entity"""
    NUMERIC_RANGE_RESOLUTION = "NumericRangeResolution"
    """Resolution of a numeric range entity"""
    TEMPORAL_SPAN_RESOLUTION = "TemporalSpanResolution"
    """Resolution of a temporal span entity"""


class SpeedUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The speed Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified speed unit"""
    METERS_PER_SECOND = "MetersPerSecond"
    """Meters per second speed unit"""
    KILOMETERS_PER_HOUR = "KilometersPerHour"
    """Kilometers per hour speed unit"""
    KILOMETERS_PER_MINUTE = "KilometersPerMinute"
    """Kilometers per minute speed unit"""
    KILOMETERS_PER_SECOND = "KilometersPerSecond"
    """Kilometers per second speed unit"""
    MILES_PER_HOUR = "MilesPerHour"
    """Miles per hour speed unit"""
    KNOT = "Knot"
    """Knot speed unit"""
    FOOT_PER_SECOND = "FootPerSecond"
    """Foot per second speed unit"""
    FOOT_PER_MINUTE = "FootPerMinute"
    """Foot per minute speed unit"""
    YARDS_PER_MINUTE = "YardsPerMinute"
    """Yards per minute speed unit"""
    YARDS_PER_SECOND = "YardsPerSecond"
    """Yards per second speed unit"""
    METERS_PER_MILLISECOND = "MetersPerMillisecond"
    """Meters per millisecond speed unit"""
    CENTIMETERS_PER_MILLISECOND = "CentimetersPerMillisecond"
    """Centimeters per millisecond speed unit"""
    KILOMETERS_PER_MILLISECOND = "KilometersPerMillisecond"
    """Kilometers per millisecond speed unit"""


class StringIndexType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes)
    according to Unicode v8.0.0. For additional information see
    `https://aka.ms/text-analytics-offsets <https://aka.ms/text-analytics-offsets>`_.
    """

    TEXT_ELEMENTS_V8 = "TextElements_v8"
    """Returned offset and length values will correspond to TextElements (Graphemes and Grapheme
    clusters) confirming to the Unicode 8.0.0 standard. Use this option if your application is
    written in .Net Framework or .Net Core and you will be using StringInfo."""
    UNICODE_CODE_POINT = "UnicodeCodePoint"
    """Returned offset and length values will correspond to Unicode code points. Use this option if
    your application is written in a language that support Unicode, for example Python."""
    UTF16_CODE_UNIT = "Utf16CodeUnit"
    """Returned offset and length values will correspond to UTF-16 code units. Use this option if your
    application is written in a language that support Unicode, for example Java, JavaScript."""


class SummaryAspect(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported parameters for a conversational summarization task."""

    ISSUE = "issue"
    """Summary of issues in transcripts of web chats and service calls between customer-service agents
    and customers."""
    RESOLUTION = "resolution"
    """Summary of resolutions in transcripts of web chats and service calls between customer-service
    agents and customers."""
    CHAPTER_TITLE = "chapterTitle"
    """Chapter title of any conversation. It's usually one phrase or several phrases naturally
    combined. Long conversations tend to have more chapters. You can find the chapter boundary from
    the summary context."""
    NARRATIVE = "narrative"
    """Generic narrative summary of any conversation. It generally converts the conversational
    language into formal written language, compresses the text length, and keeps the salient
    information."""
    RECAP = "recap"
    """A concise one-paragraph summary to provide a quick overview."""
    FOLLOW_UP_TASKS = "follow-up tasks"
    """Action items and tasks that arose during a meeting."""


class SummaryLengthBucket(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum that defines the length of the output summaries."""

    SHORT = "short"
    """Instructs model to generate shorter length summaries."""
    MEDIUM = "medium"
    """Instructs model to generate medium length summaries."""
    LONG = "long"
    """Instructs model to generate longer length summaries."""


class TargetProjectKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of a target service."""

    LUIS = "Luis"
    """Luis target service type"""
    CONVERSATION = "Conversation"
    """Conversation target service type"""
    QUESTION_ANSWERING = "QuestionAnswering"
    """QuestionAnswering target service type"""
    NON_LINKED = "NonLinked"
    """NonLinked target service type"""


class TemperatureUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The temperature Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified temperature unit"""
    FAHRENHEIT = "Fahrenheit"
    """Fahrenheit temperature unit"""
    KELVIN = "Kelvin"
    """Kelvin temperature unit"""
    RANKINE = "Rankine"
    """Rankine temperature unit"""
    CELSIUS = "Celsius"
    """Celsius temperature unit"""


class TemporalModifier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """An optional modifier of a date/time instance."""

    AFTER_APPROXIMATE = "AfterApprox"
    """AfterApprox temporal modifier"""
    BEFORE = "Before"
    """Before temporal modifier"""
    BEFORE_START = "BeforeStart"
    """BeforeStart temporal modifier"""
    APPROXIMATE = "Approx"
    """Approx temporal modifier"""
    REFERENCE_UNDEFINED = "ReferenceUndefined"
    """ReferenceUndefined temporal modifier"""
    SINCE_END = "SinceEnd"
    """SinceEnd temporal modifier"""
    AFTER_MID = "AfterMid"
    """AfterMid temporal modifier"""
    START = "Start"
    """Start temporal modifier"""
    AFTER = "After"
    """After temporal modifier"""
    BEFORE_END = "BeforeEnd"
    """BeforeEnd temporal modifier"""
    UNTIL = "Until"
    """Until temporal modifier"""
    END = "End"
    """End temporal modifier"""
    LESS = "Less"
    """Less temporal modifier"""
    SINCE = "Since"
    """Since temporal modifier"""
    AFTER_START = "AfterStart"
    """AfterStart temporal modifier"""
    BEFORE_APPROXIMATE = "BeforeApprox"
    """BeforeApprox temporal modifier"""
    MID = "Mid"
    """Mid temporal modifier"""
    MORE = "More"
    """More temporal modifier"""


class TranscriptContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enumeration of supported transcript content types."""

    LEXICAL = "lexical"
    """Lexical content type"""
    ITN = "itn"
    """ITN content type"""
    MASKED_ITN = "maskedItn"
    """Masked ITN content type"""
    TEXT = "text"
    """Text content type"""


class VolumeUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Volume Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified volume unit."""
    CUBIC_METER = "CubicMeter"
    """Volume unit in cubic meters."""
    CUBIC_CENTIMETER = "CubicCentimeter"
    """Volume unit in cubic centimeters."""
    CUBIC_MILLIMETER = "CubicMillimeter"
    """Volume unit in cubic millimeters."""
    HECTOLITER = "Hectoliter"
    """Volume unit in hectoliters."""
    DECALITER = "Decaliter"
    """Volume unit in decaliters."""
    LITER = "Liter"
    """Volume unit in liters."""
    CENTILITER = "Centiliter"
    """Volume unit in centiliters."""
    MILLILITER = "Milliliter"
    """Volume unit in milliliters."""
    CUBIC_YARD = "CubicYard"
    """Volume unit in cubic yards."""
    CUBIC_INCH = "CubicInch"
    """Volume unit in cubic inches."""
    CUBIC_FOOT = "CubicFoot"
    """Volume unit in cubic feet."""
    CUBIC_MILE = "CubicMile"
    """Volume unit in cubic miles."""
    FLUID_OUNCE = "FluidOunce"
    """Volume unit in fluid ounces."""
    TEASPOON = "Teaspoon"
    """Volume unit in teaspoons."""
    TABLESPOON = "Tablespoon"
    """Volume unit in tablespoons."""
    PINT = "Pint"
    """Volume unit in pints."""
    QUART = "Quart"
    """Volume unit in quarts."""
    CUP = "Cup"
    """Volume unit in cups."""
    GILL = "Gill"
    """Volume unit in gills."""
    PINCH = "Pinch"
    """Volume unit in pinches."""
    FLUID_DRAM = "FluidDram"
    """Volume unit in fluid drams."""
    BARREL = "Barrel"
    """Volume unit in barrels."""
    MINIM = "Minim"
    """Volume unit in minims."""
    CORD = "Cord"
    """Volume unit in cords."""
    PECK = "Peck"
    """Volume unit in pecks."""
    BUSHEL = "Bushel"
    """Volume unit in bushels."""
    HOGSHEAD = "Hogshead"
    """Volume unit in hogsheads."""


class WeightUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The weight Unit of measurement."""

    UNSPECIFIED = "Unspecified"
    """Unspecified weight unit"""
    KILOGRAM = "Kilogram"
    """Weight unit in kilograms"""
    GRAM = "Gram"
    """Weight unit in grams"""
    MILLIGRAM = "Milligram"
    """Weight unit in milligrams"""
    GALLON = "Gallon"
    """Volume unit in gallons"""
    METRIC_TON = "MetricTon"
    """Weight unit in metric tons"""
    TON = "Ton"
    """Weight unit in tons"""
    POUND = "Pound"
    """Weight unit in pounds"""
    OUNCE = "Ounce"
    """Weight unit in ounces"""
    GRAIN = "Grain"
    """Weight unit in grains"""
    PENNY_WEIGHT = "PennyWeight"
    """Weight unit in pennyweights"""
    LONG_TON_BRITISH = "LongTonBritish"
    """Weight unit in long tons (British)"""
    SHORT_TON_US = "ShortTonUS"
    """Weight unit in short tons (US)"""
    SHORT_HUNDRED_WEIGHT_US = "ShortHundredWeightUS"
    """Weight unit in short hundredweights (US)"""
    STONE = "Stone"
    """Weight unit in stones"""
    DRAM = "Dram"
    """Weight unit in drams"""
