# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.newrelicobservability import NewRelicObservabilityMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNewRelicObservabilityMgmtMonitorsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NewRelicObservabilityMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_list_by_subscription(self, resource_group):
        response = self.client.monitors.list_by_subscription(
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_list_by_resource_group(self, resource_group):
        response = self.client.monitors.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_get(self, resource_group):
        response = self.client.monitors.get(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_begin_create_or_update(self, resource_group):
        response = self.client.monitors.begin_create_or_update(
            resource_group_name=resource_group.name,
            monitor_name="str",
            resource={
                "location": "str",
                "accountCreationSource": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "liftrResourceCategory": "str",
                "liftrResourcePreference": 0,
                "marketplaceSubscriptionId": "str",
                "marketplaceSubscriptionStatus": "str",
                "monitoringStatus": "str",
                "name": "str",
                "newRelicAccountProperties": {
                    "accountInfo": {"accountId": "str", "ingestionKey": "str", "region": "str"},
                    "organizationInfo": {"organizationId": "str"},
                    "singleSignOnProperties": {
                        "enterpriseAppId": "str",
                        "provisioningState": "str",
                        "singleSignOnState": "str",
                        "singleSignOnUrl": "str",
                    },
                    "userId": "str",
                },
                "orgCreationSource": "str",
                "planData": {
                    "billingCycle": "str",
                    "effectiveDate": "2020-02-20 00:00:00",
                    "planDetails": "str",
                    "usageType": "str",
                },
                "provisioningState": "str",
                "saaSAzureSubscriptionStatus": "str",
                "saaSData": {"saaSResourceId": "str"},
                "subscriptionState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "userInfo": {
                    "country": "str",
                    "emailAddress": "str",
                    "firstName": "str",
                    "lastName": "str",
                    "phoneNumber": "str",
                },
            },
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_begin_update(self, resource_group):
        response = self.client.monitors.begin_update(
            resource_group_name=resource_group.name,
            monitor_name="str",
            properties={
                "accountCreationSource": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "newRelicAccountProperties": {
                    "accountInfo": {"accountId": "str", "ingestionKey": "str", "region": "str"},
                    "organizationInfo": {"organizationId": "str"},
                    "singleSignOnProperties": {
                        "enterpriseAppId": "str",
                        "provisioningState": "str",
                        "singleSignOnState": "str",
                        "singleSignOnUrl": "str",
                    },
                    "userId": "str",
                },
                "orgCreationSource": "str",
                "planData": {
                    "billingCycle": "str",
                    "effectiveDate": "2020-02-20 00:00:00",
                    "planDetails": "str",
                    "usageType": "str",
                },
                "saaSData": {"saaSResourceId": "str"},
                "tags": {"str": "str"},
                "userInfo": {
                    "country": "str",
                    "emailAddress": "str",
                    "firstName": "str",
                    "lastName": "str",
                    "phoneNumber": "str",
                },
            },
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_begin_delete(self, resource_group):
        response = self.client.monitors.begin_delete(
            resource_group_name=resource_group.name,
            user_email="str",
            monitor_name="str",
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_get_metric_rules(self, resource_group):
        response = self.client.monitors.get_metric_rules(
            resource_group_name=resource_group.name,
            monitor_name="str",
            request={"userEmail": "str"},
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_get_metric_status(self, resource_group):
        response = self.client.monitors.get_metric_status(
            resource_group_name=resource_group.name,
            monitor_name="str",
            request={"userEmail": "str", "azureResourceIds": ["str"]},
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_list_app_services(self, resource_group):
        response = self.client.monitors.list_app_services(
            resource_group_name=resource_group.name,
            monitor_name="str",
            request={"userEmail": "str", "azureResourceIds": ["str"]},
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_switch_billing(self, resource_group):
        response = self.client.monitors.switch_billing(
            resource_group_name=resource_group.name,
            monitor_name="str",
            request={
                "userEmail": "str",
                "azureResourceId": "str",
                "organizationId": "str",
                "planData": {
                    "billingCycle": "str",
                    "effectiveDate": "2020-02-20 00:00:00",
                    "planDetails": "str",
                    "usageType": "str",
                },
            },
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_list_hosts(self, resource_group):
        response = self.client.monitors.list_hosts(
            resource_group_name=resource_group.name,
            monitor_name="str",
            request={"userEmail": "str", "vmIds": ["str"]},
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_refresh_ingestion_key(self, resource_group):
        response = self.client.monitors.refresh_ingestion_key(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_list_monitored_resources(self, resource_group):
        response = self.client.monitors.list_monitored_resources(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_list_linked_resources(self, resource_group):
        response = self.client.monitors.list_linked_resources(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_vm_host_payload(self, resource_group):
        response = self.client.monitors.vm_host_payload(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_latest_linked_saa_s(self, resource_group):
        response = self.client.monitors.latest_linked_saa_s(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_begin_link_saa_s(self, resource_group):
        response = self.client.monitors.begin_link_saa_s(
            resource_group_name=resource_group.name,
            monitor_name="str",
            body={"saaSResourceId": "str"},
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_monitors_begin_resubscribe(self, resource_group):
        response = self.client.monitors.begin_resubscribe(
            resource_group_name=resource_group.name,
            monitor_name="str",
            api_version="2025-05-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
