% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{Assertions}
\alias{Assertions}
\alias{isTRUEorFALSE}
\alias{isScalarCharacter}
\alias{isScalarInteger}
\alias{isScalarNumber}
\alias{isCharacter}
\alias{isZeroOneCharacter}
\title{Suite of helper functions to test for types}
\usage{
isTRUEorFALSE(x, na.ok = FALSE)

isScalarCharacter(x, na.ok = FALSE, zchar = FALSE)

isScalarInteger(x, na.ok = FALSE)

isScalarNumber(x, na.ok = FALSE, infinite.ok = FALSE)

isCharacter(x, na.ok = FALSE, zchar = FALSE)

isZeroOneCharacter(x, na.ok = FALSE, zchar = FALSE)
}
\arguments{
\item{x}{The input vector whose type is to be checked}

\item{na.ok}{logical(1L) Whether it is acceptable to consider \code{NA} type
inputs (default: \code{FALSE}).}

\item{zchar}{logical(1L) Whether is is acceptable to consider 'zero'
characters as defined by \code{nchar}, e.g., \code{nchar("")} (default: \code{FALSE}).}

\item{infinite.ok}{logical(1L) Whether it is acceptable to consider infinite
values as identified by \code{is.finite} (default: \code{FALSE}).}
}
\value{
Either \code{TRUE} or \code{FALSE}
}
\description{
These are a group of helper functions that allow the developer
to easily check for common data types in Bioconductor. These include
logical, character, and numeric (& integer).
}
\details{
Some functions such as \code{isScalarCharacter} allow exceptions to the type
checks via the \code{na.ok} and \code{zchar} arguments. Others, for example
\code{isScalarNumber} can permit \code{Inf} with the \code{infinite.ok} argument.
}
\section{Functions}{
\itemize{
\item \code{isTRUEorFALSE()}: Is the input a single logical vector?

\item \code{isScalarCharacter()}: Is the input a single character vector?

\item \code{isScalarInteger()}: Is the input a single integer vector?

\item \code{isScalarNumber()}: Is the input a single numeric vector?

\item \code{isCharacter()}: Is the input a character vector?

\item \code{isZeroOneCharacter()}: Is the input a character vector of zero or one length?

}}
\examples{

isTRUEorFALSE(TRUE)
isTRUEorFALSE(FALSE)
isTRUEorFALSE(NA, na.ok = TRUE)

isScalarCharacter(LETTERS)
isScalarCharacter("L")
isCharacter(LETTERS)
isCharacter(NA_character_, na.ok = TRUE)
isZeroOneCharacter("")
isZeroOneCharacter("", zchar = TRUE)

isScalarInteger(1L)
isScalarInteger(1)

isScalarNumber(1)
isScalarNumber(1:2)

}
\author{
M. Morgan, H. Pagès
}
