% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterSweep.R
\name{clusterSweep}
\alias{clusterSweep}
\title{Clustering parameter sweeps}
\usage{
clusterSweep(
  x,
  BLUSPARAM,
  ...,
  full = FALSE,
  BPPARAM = SerialParam(),
  args = list()
)
}
\arguments{
\item{x}{A numeric matrix-like object where rows represent observations and columns represent variables.}

\item{BLUSPARAM}{A \linkS4class{BlusterParam} object specifying the algorithm to use.}

\item{...}{Named vectors or lists specifying the parameters to sweep over.}

\item{full}{Logical scalar indicating whether the full clustering statistics should be returned for each method.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} specifying how the sweep should be parallelized.}

\item{args}{A named list of additional arguments to use with \code{...}.
This is provided in case there is a name conflict with the existing arguments in this function signature.}
}
\value{
A \linkS4class{List} containing:
\itemize{
\item \code{clusters}, a \linkS4class{DataFrame} with number of rows equal to that of \code{x},
where each column corresponds to (and is named after) a specific combination of clustering parameters.
\item \code{parameters}, another DataFrame with number of rows equal to the number of columns in the previous \code{clusters} DataFrame.
Each row contains the specific parameter combination for each column of \code{clusters}.
\item If \code{full=TRUE}, \code{objects} is an additional list of length equal to the number of rows in \code{clusters}.
This contains the \code{objects} produced by each run.
}
}
\description{
Perform a sweep across combinations of parameters to obtain different clusterings from the same algorithm.
}
\details{
This function allows users to conveniently test out a range of clustering parameters in a single call.
The name of each argument in \code{...} should be a legitimate argument to \code{x[[i]]},
and will be used to modify any existing values in \code{BLUSPARAM} to obtain a new set of parameters.
(For all other parameters, the existing values in \code{BLUSPARAM} are used.)
If multiple arguments are provided, all combinations are tested.

We attempt to create a unique name for each column based on its parameter combination.
This has the format of \code{<NAME1>.<VALUE1>_<NAME2>.<VALUE2>_...} based on the parameter names and values.
Note that any non-atomic values are simply represented by the name of their class;
no attempt is made to convert these into a compact string.

If an entry of \code{...} is a \emph{named} list of vectors, we expand those to generate all possible combinations of values.
For example, if we passed:
\preformatted{    blah.args = list(a = 1:5, b = LETTERS[1:3])}
This would be equivalent to manually specifying:
\preformatted{    blah.args = list(list(a = 1, b = "A"), list(a = 1, b = "B"), ...)}
The auto-expansion mechanism allows us to conveniently test parameter combinations when those parameters are stored inside \code{x} as a list.
The algorithm is recursive so any internal named lists containing vectors are similarly expanded.
Expansion can be disabled by wrapping vectors in \code{\link{I}}, in which case they are passed verbatim.
No expansion is performed for non-vector arguments.
}
\examples{
out <- clusterSweep(iris[,1:4], KmeansParam(10), 
    centers=4:10, algorithm=c("Lloyd", "Hartigan-Wong"))
out$clusters[,1:5]
out$parameters

out <- clusterSweep(iris[,1:4], NNGraphParam(), k=c(5L, 10L, 15L, 20L),
    cluster.fun=c("louvain", "walktrap"))
out$clusters[,1:5]
out$parameters

# Combinations are automatically expanded inside named lists:
out <- clusterSweep(iris[,1:4], NNGraphParam(), k=c(5L, 10L, 15L, 20L), 
    cluster.args=list(steps=3:4))
out$clusters[,1:5]
out$parameters

}
\seealso{
\code{\link{clusterRows}}, which manages the dispatch to specific methods based on \code{BLUSPARAM}.

\linkS4class{BlusterParam}, which determines which algorithm is actually used.
}
\author{
Aaron Lun
}
