#! /bin/bash

# Test upload of a CSV file.

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

BASENAME=$(basename $0 .pl)
TMP_TEST_DB=$(echo tmp${BASENAME}$$ | sed 's/[^-0-9a-zA-Z]//g')

DB_DIR=db
DB_FILE=${DB_DIR}/test1.db
TMP_DB_BASE=${TMP_TEST_DB}.db
TMP_DB_FILE=${DB_DIR}/${TMP_DB_BASE}

sqlite3 ${TMP_DB_FILE} <<END
    create table events (event_date date default null);
END

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/events"
export HTTP_HOST=${TMP_TEST_DB}.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

(

cat <<PART1
--------------------------b989696a28305e74
Content-Disposition: form-data; name="xlsfile"; filename="dates.xls"
Content-Type: application/vnd.ms-excel

PART1
cat tests/inputs/dates.xls
echo -e "\r"
cat <<PART2
--------------------------b989696a28305e74
Content-Disposition: form-data; name="db"

${TMP_DB_BASE}
--------------------------b989696a28305e74
Content-Disposition: form-data; name="table"

events
--------------------------b989696a28305e74--
PART2

) | ${INPUT_SCRIPT}

sqlite3 -echo -nullvalue NULL ${TMP_DB_FILE} 'select * from events order by event_date';

rm -f ${TMP_DB_FILE}
