#include "Xcos.hxx"
/* Generated by GIWS (version 2.0.2) with command:
giws --disable-return-size-array --output-dir src/jni/ --throws-exception-on-error --description-file src/jni/Xcos.giws.xml
*/
/*

This is generated code.

This software is a computer program whose purpose is to hide the complexity
of accessing Java objects/methods from C++ code.

Copyright (C) 2012 - 2016 - Scilab Enterprises

This file is hereby licensed under the terms of the GNU GPL v2.0,
pursuant to article 5.3.4 of the CeCILL v.2.1.
This file was originally licensed under the terms of the CeCILL v2.1,
and continues to be available under such terms.
For more information, see the COPYING file which you should have received
along with this program.
*/

namespace org_scilab_modules_xcos {

                // Static declarations (if any)
                
// Returns the current env

JNIEnv * Xcos::getCurrentEnv() {
JNIEnv * curEnv = NULL;
jint res=this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
if (res != JNI_OK) {
throw GiwsException::JniException(getCurrentEnv());
}
return curEnv;
}
// Destructor

Xcos::~Xcos() {
JNIEnv * curEnv = NULL;
this->jvm->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
curEnv->DeleteGlobalRef(this->instance);
curEnv->DeleteGlobalRef(this->instanceClass);
curEnv->DeleteGlobalRef(this->stringArrayClass);}
// Constructors
Xcos::Xcos(JavaVM * jvm_) {
jmethodID constructObject = NULL ;
jobject localInstance ;
jclass localClass ;

const std::string construct="<init>";
const std::string param="()V";
jvm=jvm_;

JNIEnv * curEnv = getCurrentEnv();

localClass = curEnv->FindClass( this->className().c_str() ) ;
if (localClass == NULL) {
  throw GiwsException::JniClassNotFoundException(curEnv, this->className());
}

this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));

/* localClass is not needed anymore */
curEnv->DeleteLocalRef(localClass);

if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}


constructObject = curEnv->GetMethodID( this->instanceClass, construct.c_str() , param.c_str() ) ;
if(constructObject == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}

localInstance = curEnv->NewObject( this->instanceClass, constructObject ) ;
if(localInstance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
 
this->instance = curEnv->NewGlobalRef(localInstance) ;
if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
}
/* localInstance not needed anymore */
curEnv->DeleteLocalRef(localInstance);

                /* Methods ID set to NULL */
voidxcosjstringjava_lang_StringjlonglongID=NULL;
voidxcosDiagramToScilabjstringjava_lang_StringjlonglongjbooleanbooleanID=NULL;
voidwarnCellByUIDjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidcloseXcosFromScilabID=NULL;
voidaddToolsMenujstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidxcosSimulationStartedID=NULL;


}

Xcos::Xcos(JavaVM * jvm_, jobject JObj) {
        jvm=jvm_;

        JNIEnv * curEnv = getCurrentEnv();

jclass localClass = curEnv->GetObjectClass(JObj);
        this->instanceClass = static_cast<jclass>(curEnv->NewGlobalRef(localClass));
        curEnv->DeleteLocalRef(localClass);

        if (this->instanceClass == NULL) {
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }

        this->instance = curEnv->NewGlobalRef(JObj) ;
        if(this->instance == NULL){
throw GiwsException::JniObjectCreationException(curEnv, this->className());
        }
        /* Methods ID set to NULL */
        voidxcosjstringjava_lang_StringjlonglongID=NULL;
voidxcosDiagramToScilabjstringjava_lang_StringjlonglongjbooleanbooleanID=NULL;
voidwarnCellByUIDjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidcloseXcosFromScilabID=NULL;
voidaddToolsMenujstringjava_lang_Stringjstringjava_lang_StringID=NULL;
voidxcosSimulationStartedID=NULL;


}

// Generic methods

void Xcos::synchronize() {
if (getCurrentEnv()->MonitorEnter(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Xcos");
}
}

void Xcos::endSynchronize() {
if ( getCurrentEnv()->MonitorExit(instance) != JNI_OK) {
throw GiwsException::JniMonitorException(getCurrentEnv(), "Xcos");
}
}
// Method(s)

void Xcos::xcos (JavaVM * jvm_, char const* file, long long diagramId){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidxcosjstringjava_lang_StringjlonglongID = curEnv->GetStaticMethodID(cls, "xcos", "(Ljava/lang/String;J)V" ) ;
if (voidxcosjstringjava_lang_StringjlonglongID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcos");
}

jstring file_ = curEnv->NewStringUTF( file );
if (file != NULL && file_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidxcosjstringjava_lang_StringjlonglongID ,file_, diagramId);
                        curEnv->DeleteLocalRef(file_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::xcosDiagramToScilab (JavaVM * jvm_, char const* file, long long diagramId, bool exported){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidxcosDiagramToScilabjstringjava_lang_StringjlonglongjbooleanbooleanID = curEnv->GetStaticMethodID(cls, "xcosDiagramToScilab", "(Ljava/lang/String;JZ)V" ) ;
if (voidxcosDiagramToScilabjstringjava_lang_StringjlonglongjbooleanbooleanID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosDiagramToScilab");
}

jstring file_ = curEnv->NewStringUTF( file );
if (file != NULL && file_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jboolean exported_ = (static_cast<bool>(exported) ? JNI_TRUE : JNI_FALSE);

                         curEnv->CallStaticVoidMethod(cls, voidxcosDiagramToScilabjstringjava_lang_StringjlonglongjbooleanbooleanID ,file_, diagramId, exported_);
                        curEnv->DeleteLocalRef(file_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::warnCellByUID (JavaVM * jvm_, char const* const* uids, int uidsSize, char const* message){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidwarnCellByUIDjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "warnCellByUID", "([Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidwarnCellByUIDjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "warnCellByUID");
}
jclass stringArrayClass = curEnv->FindClass("java/lang/String");

// create java array of strings.
jobjectArray uids_ = curEnv->NewObjectArray( uidsSize, stringArrayClass, NULL);
if (uids_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

// convert each char * to java strings and fill the java array.
for ( int i = 0; i < uidsSize; i++)
{
jstring TempString = curEnv->NewStringUTF( uids[i] );
if (TempString == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}

curEnv->SetObjectArrayElement( uids_, i, TempString);

// avoid keeping reference on too many strings
curEnv->DeleteLocalRef(TempString);
}
jstring message_ = curEnv->NewStringUTF( message );
if (message != NULL && message_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidwarnCellByUIDjobjectArray_java_lang_Stringjava_lang_Stringjstringjava_lang_StringID ,uids_, message_);
                        curEnv->DeleteLocalRef(stringArrayClass);
curEnv->DeleteLocalRef(uids_);
curEnv->DeleteLocalRef(message_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::closeXcosFromScilab (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidcloseXcosFromScilabID = curEnv->GetStaticMethodID(cls, "closeXcosFromScilab", "()V" ) ;
if (voidcloseXcosFromScilabID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "closeXcosFromScilab");
}

                         curEnv->CallStaticVoidMethod(cls, voidcloseXcosFromScilabID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::addToolsMenu (JavaVM * jvm_, char const* label, char const* command){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidaddToolsMenujstringjava_lang_Stringjstringjava_lang_StringID = curEnv->GetStaticMethodID(cls, "addToolsMenu", "(Ljava/lang/String;Ljava/lang/String;)V" ) ;
if (voidaddToolsMenujstringjava_lang_Stringjstringjava_lang_StringID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "addToolsMenu");
}

jstring label_ = curEnv->NewStringUTF( label );
if (label != NULL && label_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


jstring command_ = curEnv->NewStringUTF( command );
if (command != NULL && command_ == NULL)
{
throw GiwsException::JniBadAllocException(curEnv);
}


                         curEnv->CallStaticVoidMethod(cls, voidaddToolsMenujstringjava_lang_Stringjstringjava_lang_StringID ,label_, command_);
                        curEnv->DeleteLocalRef(label_);
curEnv->DeleteLocalRef(command_);
if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

void Xcos::xcosSimulationStarted (JavaVM * jvm_){

JNIEnv * curEnv = NULL;
jvm_->AttachCurrentThread(reinterpret_cast<void **>(&curEnv), NULL);
jclass cls = initClass(curEnv);
if ( cls == NULL) {
throw GiwsException::JniCallMethodException(curEnv);
}

static jmethodID voidxcosSimulationStartedID = curEnv->GetStaticMethodID(cls, "xcosSimulationStarted", "()V" ) ;
if (voidxcosSimulationStartedID == NULL) {
throw GiwsException::JniMethodNotFoundException(curEnv, "xcosSimulationStarted");
}

                         curEnv->CallStaticVoidMethod(cls, voidxcosSimulationStartedID );
                        if (curEnv->ExceptionCheck()) {
throw GiwsException::JniCallMethodException(curEnv);
}
}

}
