/*
 *  Test that ToNumber(ToString(x)) === x, except for -0 where the sign is
 *  lost.  This is not required, but very preferable.
 */

var values = [
    // Some basic values
    Number.NEGATIVE_INFINITY,
    -1e100,
    -98765432109876543210.9876543210,
    -123456789.01234567890123456789,
    -1, -0, 0, 1,
    123456789.01234567890123456789,
    98765432109876543210.9876543210,
    1e100,
    Number.POSITIVE_INFINITY,
    Number.NaN,

    // Random numbers generated with Node and:
    //
    // for (var i = 0; i < 1000; i++) { console.log(Math.exp(Math.random() * 200 - 100)); }

    9.47885972948749e+39,
    2.6532555092896124e-38,
    6758389328007.754,
    10628584993.157171,
    2.6387756640974324e-14,
    1.7009553077579215e+22,
    9.09378225144655e-8,
    2.570245047158704e+33,
    1.9396386619107822e-16,
    6.73978643029618e+30,
    23023475.15899063,
    2.944663902929539e+36,
    8.765212372975559e+33,
    2.0281186554367569e+30,
    3162760770626405.5,
    2.511274146889772e+28,
    8.273496767055383e+26,
    7315.408519400525,
    1.2453729136986092e+31,
    2.1488528837888795e-14,
    207831500826.3388,
    8.467475251390892e+28,
    160140468041.11798,
    2317443293048.422,
    2.626896285281776e-40,
    2.594342974576634e+35,
    2.560414490937443e-11,
    25378617.623473298,
    2.5086804709066974e+42,
    15164278368312.924,
    4.217769679901025e+22,
    137.70455950632692,
    1.0548485556959191e-15,
    7.88141881125595e-21,
    6.599780780745824e-42,
    2.322325270214259e-27,
    2.0461779359754773e-33,
    1.838590481791029,
    1.2315098521695652e+28,
    29365216.899717223,
    1.8001999764457677e-43,
    21290712747578480,
    3.677207262793838e-14,
    1.648593206994196e-23,
    1185481181649142800,
    9.596424686955204e-35,
    4.859110177701829e-19,
    9.984892831955197e-38,
    3718356750368012.5,
    1.479854978525036e-18,
    9.22461085881936e-38,
    9.691971681128414e-13,
    116857149.18747038,
    4.598053300885936e-30,
    1.5643595682150466e-20,
    34310480000.875927,
    1.589379365466063e-23,
    2.86992846730546e-26,
    21.40464114985228,
    0.000004996221917552839,
    8.927342560451363e+41,
    1.841921770591009e-38,
    9.155549677555242e+21,
    0.00043778433690965077,
    240473519618175.78,
    2.0914968630022918e-30,
    429136.9588103832,
    5.395161976218836e-26,
    1.142133604058351e+23,
    1.8562515444810014e-36,
    1.99914335068539e-26,
    3.793450432146888e+36,
    4.007678784637975e-18,
    1.4058148134409361e-14,
    2.3048131860111467e-38,
    1.1277210513016002e+25,
    5.642142384495337e+39,
    5.641360878806083e-41,
    1.5842289268233725e-9,
    80101487.0206429,
    452674066963903700000,
    2.0268223440670318e-31,
    36.44390739434274,
    71969389276008700000,
    2.4846406732254622e-20,
    4.0231679528554584e-28,
    3.804351513120633e-23,
    1.0781924461124128e-20,
    7.344859248893897e-8,
    4.403703286249895e-20,
    1.7392485650115742e-23,
    4.921032261162188e-15,
    4929271822697.627,
    45926331875.24537,
    5.386658157398103e+34,
    1.6607384850645418e-10,
    1936096341068.3835,
    220987060.0482705,
    1.7405833116858833e-9,
    8.213482547587643e+28,
    3.310318575828092e-21,
    3.183002715787965e+21,
    7.197732536389885e-43,
    1.9326708934562343e-16,
    0.004496917544921244,
    7.983458506100303e+23,
    0.31405549198915556,
    1937244739.9472232,
    2.6385092363838773e-30,
    6.593841600966287e+26,
    4.901829130741176e+31,
    9.538720591254787e-30,
    2.9538540487017115e-39,
    1.114440513687204e+25,
    1.2758427724245513e-13,
    0.0000137847414380527,
    1.927820260547553e-26,
    172645928638300740,
    959903779.5509624,
    2.8226648717647724,
    1.3774358925598547e-20,
    1.870450853361116e-35,
    6402561.449475099,
    9948788829888060000,
    3.233972832174404e-27,
    7.079676411437938e-13,
    3.0502404894688147e+41,
    23455607645329332,
    2.957168347382617e+21,
    5.519925273460977e-24,
    2.6680962229936957e+31,
    3.625029985340905e-11,
    2.6513955655572123e-43,
    8.812648092763192e+40,
    1.9875687741639483e-10,
    2.272450621607019e-28,
    0.028219159841700068,
    0.00004073766236272613,
    251046023700898680000,
    5.0910594200681556e+38,
    5411912555997676,
    1.3618279894882253e+43,
    1.7318743462926325e-33,
    4.870759398349554e-8,
    7.164875969910862e-35,
    10095636711842.91,
    217369360224245840000,
    0.00010828643494654476,
    4.680332052636842e+25,
    4.824208776804383e-18,
    6.682096501766571e-17,
    2.702283917297994e-43,
    4.641541678646538e-20,
    240913799577.92993,
    1.0086571722661292e-12,
    0.000010602379173274184,
    0.0000034075066715415917,
    4.472939134539071e+26,
    2.6352062834306173e-34,
    1.2911449251750682e-15,
    3.1648912278807764e-38,
    0.017703959429513454,
    1.0494841308811966e-10,
    1.2909931468052337e-19,
    1.0882803203226296e-13,
    8.488906429859187e-29,
    0.023595887878547897,
    4.177380454441682e-14,
    2.838373625973475e-11,
    8.0378962156574e-22,
    8.648948213315644e-29,
    4.96670149558718e-33,
    0.5247970677156614,
    15890740495.670502,
    1.3136269351136367e-8,
    0.13428324076065562,
    1.2031428208597315e-20,
    1.0847421373256445e-10,
    2.3025741455312388e+36,
    2.096784586120349e-22,
    0.0000026836631355521113,
    1.0044394840031275e-43,
    1.971522986159444e-34,
    5.168505395368058e-29,
    138359480.23802164,
    23024420.783052843,
    1.5865672938359943e+36,
    3.156218188171681e-43,
    8.022706842469358e-31,
    43005421420.40497,
    160001310639123970,
    4160768457433803.5,
    2.808282637754872e-12,
    1.0828621102700475e-17,
    2.5167599734560993e+36,
    6.803540547128114e-17,
    2.325021177702014e-24,
    0.0004234470228008734,
    4.980943502928653e-13,
    4.512232760408178e-31,
    847.4690099058901,
    0.008177902894893145,
    0.04492015064922013,
    0.002658687165770774,
    3.3600209546015584e+25,
    3372.4973987003823,
    1.0293827454224923e+22,
    3.784165708579286e+29,
    8.606362714516306e+29,
    4.634054846942846e-37,
    4.8302305020762815e-43,
    9.268184378057874e-24,
    8189.676542527737,
    211771689.8344541,
    9.393075355053436e-30,
    7.881582101786487e+33,
    0.0000036824289890170733,
    6.706442360684001e+22,
    5.382705053212894e-7,
    5.20866398645923e-14,
    2.681105963794558e-36,
    2.2587044349855854e+40,
    814764666774.5638,
    1468446.1230291438,
    1312880243932499700,
    1.1442581426433276e+42,
    29916078.22609532,
    1.9574190400651977e-7,
    1.2215861726065884e+40,
    7.02443113316486e-21,
    2087603821.705248,
    4.601583080635527e-8,
    1.0131185741003657e-18,
    532066873040.0648,
    1.429087925367884e+23,
    286309668235096800,
    104572178866.81352,
    7.629767823293742e-19,
    8219572019232723000,
    8.702354676233087e-33,
    1.899745319025575e+41,
    1.5172435665385133e+22,
    4.505627806257819e-32,
    28346042811.069992,
    558120711960586800,
    7914953423561.014,
    2.8628922649900925e+32,
    7.066232210626548e-38,
    3.712303501191739e-27,
    1.5308730770395358e-31,
    4763306928785022000,
    389497311.069316,
    1.0590049886410428e-13,
    14041819542699184,
    5.015328779378029e-11,
    4.680548450816998e+31,
    1.1608161279558315e-25,
    1.999936091264257e-40,
    430.0332240390734,
    5.0887686940409796e-39,
    8739784703.401863,
    5.543428181906374e-13,
    1.3421536663142957e+31,
    2.185731295740616e-15,
    12.338744881642135,
    48626924.03490777,
    1.148752223350521e+41,
    386476513650954.9,
    3.209104639459157e-11,
    1102231.6975239604,
    1.3024846173413516e+42,
    1.0620077960238208e-15,
    4.698393184809084e-42,
    4.777738041452508e+33,
    1.0094539492382727e+33,
    2061032228660.802,
    2.0848207157164644e-35,
    3.761160254252829e-26,
    3.656017066298804e+38,
    2.927719700428662e+29,
    1.5216989913096347e+22,
    2.9516245722610234e-23,
    2.7369056607495903e-25,
    663075.130783618,
    4.597378648646106e+27,
    8026881914672102,
    4.0588824532693785e-32,
    348952590735211460,
    3915368045565.3643,
    2.0672791861572085e+39,
    2.5752047458998682e-27,
    3.103710427674285e+27,
    5.388162778720115e+21,
    5.067908927449983e+32,
    2.629696082885292e-29,
    2.7757319699423522e+35,
    7.116393014613727e-27,
    0.10790650639587003,
    67374690987.329315,
    1420732885648125000,
    1.0065062052525906e-40,
    1.3739202136976854e-17,
    5177261759171205000,
    0.000053075052050702564,
    1.858783814511676e+30,
    3494390571795226.5,
    31426861255769.875,
    1.5861528755631368e+22,
    5.379402361661471e-34,
    6.535060428593052e-22,
    1.0493182064651795e-37,
    8.191234110092956e-39,
    6.540775688854157e+27,
    9.419169044180122e-18,
    0.00007938175189966031,
    0.000015606384802272992,
    1.0485818335790389e-10,
    1.6144739844586096e-26,
    8792424.868500602,
    5.536634218561672e-40,
    1.1922276893418234e-32,
    4958841.936841724,
    1.5585285596768963e-17,
    2.387542333664712e-18,
    1490407881.9346793,
    3.0757025155702272e-33,
    1.3292707958710675e-25,
    107.50321336781654,
    3.4265791323643775e-19,
    3.91553953189286e-15,
    1.6660377979982443e-15,
    1.1584356274238696e-28,
    3.586510928660827e-15,
    1.2146339520952988e-21,
    1.2868295335652243e-22,
    4714078254.050786,
    3.430288498404329e-12,
    0.01451305704850652,
    0.04531930361812054,
    1.1841359157385398e-41,
    8806768936237903000,
    0.0028002395850805616,
    450125408737817.7,
    476611503296495350000,
    9.401693649450755e-20,
    11075693345367864,
    5.183253423931408e-9,
    2.4551715136463307e+21,
    2.32969868970677e-7,
    1.5513365493147388e-10,
    7.742236418435471e-36,
    1.8985763515327156e-35,
    29785931147.529037,
    1.2908561272114576e-18,
    8719855.391317248,
    9.73298561393458e-42,
    4.84879923943333e+28,
    3718738.768907544,
    2.729161845042725e+32,
    0.00005997813044217788,
    4.225472384591459e-28,
    52494129.90356238,
    7.514500334527513e-39,
    6.633332947530864e+32,
    7.156115985256923e-44,
    460865824679.57306,
    4.0806011603850384e-42,
    70742098437278.69,
    609449820509640.2,
    5.071497544348298e-22,
    6.2859581784228596e+38,
    7.379565951005698e+34,
    5.6920771548037824e-15,
    1.6356844504356467e-25,
    6.582146258648851e+21,
    2.4027340202277025e-16,
    2.452921648094062e-41,
    2.406508753236293e-41,
    7.478731468689848e-14,
    2.3937960209543058e-42,
    1.9077563404628163e-26,
    8.603002654205493,
    15266021532855.506,
    0.0007276256270563531,
    22809754506.631783,
    4.289513419450045e-30,
    40191201.20513851,
    55515426035984550000,
    5.02503342720859e-41,
    460145758.97764814,
    2.464560525523685e-27,
    2.70435633490738e+39,
    3.5272911477909396e-42,
    1.1498046549446435e-36,
    179042588809822.44,
    53.21858257625384,
    4.766314390615282e+25,
    3180486497562489000,
    105930976787.31683,
    9.591060977854042e-23,
    6.411753123799624e+38,
    2.9944619064714943e+30,
    97.51666885236374,
    2.7465508250282993e-27,
    2.040095851269645e-10,
    7816851606.110808,
    1.936440176838924e-26,
    2.0349182822600685e+25,
    529123073778147.7,
    9.271635985035115e-10,
    1.1472872974826523e+35,
    4670.509738220687,
    6.684451077739826e-39,
    8.464646021546174e-27,
    1.633376842840018e-31,
    2.664600499739963e+30,
    1.6076719120088346e-33,
    7202859999.80012,
    7.746163830561268e+24,
    1325.0180406292227,
    2.2861158241854285e+30,
    154426911392097100000,
    7.635241841520905e-38,
    10783462057283468,
    1.5401673610266776e+27,
    5.370268821382419e-41,
    2.7971725251236084e+28,
    2.0626523365655915e-22,
    0.000258600705122514,
    1.2775594090881394e+30,
    0.0001384995109619511,
    0.0000026154768735407747,
    1.570015152663751e-38,
    0.00004473475288866755,
    7.5374335548146e+39,
    4.878868844120475e-37,
    1.4104681282892606e-32,
    7.822221714946537e-39,
    1.3706044591959596e-17,
    2.1809821966976512e+21,
    3.7988699373488015e-35,
    3.598576086863721e+39,
    1.8073792818722521e+43,
    8.835743234792013e-31,
    6.367995603830518e+27,
    1.0601973544179813e+42,
    6.898791045852963e+24,
    1.5429030267023223e+41,
    201320584865198660,
    30159221910756588,
    1.5467687219259754e+29,
    4.850860500167834e+36,
    1.2870794984915239e-8,
    3.0325248192378404e-14,
    8.130413962626762e-13,
    2.712068991344025e-31,
    380124938317403.8,
    3.3250535259060983e-41,
    0.9286853981498499,
    83.5558392041277,
    5.44442101102656e+38,
    7.30118894944897e-11,
    2.5412867178439167e+39,
    2.2332441810850866e+38,
    457391572227961.5,
    1.2381401669620485e+42,
    1.9238791838074166e+40,
    250966837.61184663,
    5.777955117417873e-35,
    1.0091471577619532e+29,
    1.1326217117499063e-19,
    3.5625825961847457e-32,
    707114741702937300000,
    2.3721139439505586e-25,
    659339128.5002419,
    7.521903813924498e+37,
    0.00003526565215321841,
    5.115363152812673e-35,
    5.870746702113685e-21,
    0.007648210144851871,
    1.349741142004035e+37,
    6.418104087372744e+36,
    1.901734340721659e-22,
    1.3283528290131686e+35,
    2.4568896478556213e+27,
    1.1294265520786209e-14,
    7.786050193595171e+24,
    1.916224007812804e-18,
    140.28035438646205,
    5.635413709087255e-13,
    495308911.813428,
    119666364097074050,
    1128452200559198.2,
    5799588505987950,
    3.1303437354185194e-21,
    6.547199992201305e-27,
    2289128183080172300,
    6.404813699927093e-8,
    5.2736921661392556e+36,
    6.179421742185883e+21,
    142659372739427300000,
    29.610385758890878,
    6.513504035313245e-32,
    6.880897316823562e-25,
    5.953058385930844e-18,
    696193813.6503868,
    177385.00629603802,
    3.6206585052849625e-21,
    2.3048165989916284e+22,
    2.5946654679665995e+37,
    2.7390673872624065e-28,
    2.930484008691879e+30,
    690544.2105143096,
    25732062514.91042,
    1.7927671408336376e-32,
    5.110129137461466e+25,
    6.004581873837893e+24,
    4.526095539317243e+39,
    3.5751037715272825e-9,
    3.444698619789413e+26,
    0.004974090926869167,
    3.3086141473874186e-10,
    3.215921629217277e+29,
    5.227341380155958e-35,
    260592084801889730,
    3.059462747858057e-19,
    2.4504166387166775e-38,
    1.9671594869491937e+23,
    5.205853018691378e+27,
    1.1521784356954115e+34,
    9.730446472473534e+29,
    41710918213905016,
    0.011484657612066932,
    2.888044869723409e+40,
    3105084358386257.5,
    1.8741201319101585e+27,
    538754849.4103799,
    1.1773161645763398e-19,
    4.663833619813242e-38,
    1.744526643624044e-28,
    62931357178075460,
    31067796658405590000,
    0.000003736530534920502,
    1.523605301302362e-34,
    5.2152810559484976e-43,
    1.8326535407031062e-17,
    4.221318901153302e-27,
    3.938640435768072e+36,
    1.5781251136545167e-8,
    8.54452735407941e-24,
    3.9837648918037996e-39,
    1.2381587067667405e-36,
    1.0419968422543088e-38,
    8.390999674497346e-31,
    3706915549.9629827,
    131085604.4372903,
    6.935150554468519e-33,
    5.374826467421854e+31,
    1.4520919847118405e-20,
    1.8415650096779013e+38,
    3897173529213734,
    4.115078917152226e-24,
    0.3065270897363328,
    1.5246870257764265e-12,
    119229735501.7435,
    4.4838852874273716e-36,
    9.272984523832478e-22,
    5.0153207252208775e+30,
    4.2485254906485546e-19,
    9.203275669746532e-19,
    8.061790399137155e-40,
    3.9769883829872016e-32,
    3210664491287661600,
    9.219177101610607e-14,
    1.9302186672496128e-41,
    1.0425807620302848e-12,
    1.86437871004991e-20,
    8.201172224336286e-13,
    6.687629611739329e-11,
    2.2383138760440777e-21,
    2.9283622263555432e+25,
    1.0606754572622105e-43,
    3.837228029390835e-24,
    1.2359952829178016e+28,
    2.747324819714157e-38,
    0.000012153252847988485,
    3.0778807553613883e-14,
    1.6964606080154135e+43,
    1.85310003081373e+28,
    347241421.8540997,
    2.3470360451168446e-20,
    8.315460921396437e-21,
    34.51790065391571,
    2.222121850238862e+39,
    2.5786456549159315e+30,
    8.659944911429806e-20,
    3.2774379802221025e+35,
    552992359830483140,
    7454686547.026965,
    1.2504786597179964e-34,
    0.000053223021485149484,
    27937604.579543248,
    4.6435464427671415e-38,
    1.1839600320470305e+24,
    4.720925396599533e-40,
    1.2866651266497243e-14,
    1.4327109977832142e-19,
    1.2378199614838225e-33,
    1.7124377741428709e+28,
    94.35406613156425,
    4.816513487109239e+35,
    3.7989341815937807e-10,
    7410860126694.868,
    19361332629164315000,
    9818761630954.729,
    9.793837596051732e-10,
    5.202498875407852e-19,
    892242998315474000,
    3.320950456068139e-7,
    1.5243664862935538e+31,
    8.36425918755244e-27,
    1.17133323006932e+29,
    1.6196553371172193e-32,
    3.8736165983034776e+21,
    8178063127.460905,
    89995838307.54329,
    0.00000794307987392098,
    1129275245.4286642,
    9.216950635720408e-20,
    3.698394977054524e-22,
    9.680580039131022e-28,
    2.880662831746149e+27,
    0.8893312915209106,
    1.979026283528525e+35,
    7.699449525447098e-41,
    1.7259559287224191e+34,
    1.0190272497661714e-18,
    6.747292118621075e-32,
    1.3494322457033782e-36,
    5.65109762464144e-9,
    1.4435365565560711e-10,
    8.620558837558969e-40,
    9.271685578194773e+30,
    3.1500784435743695e-8,
    9552596699500920000,
    3.0454506845728166e+34,
    2.1539944680966724e-16,
    4.4469214017718345e-41,
    9.952694823464103e+39,
    18304252684.81903,
    5.233940389842428e+42,
    1.1329430780121528e+31,
    1.5208503126726654e+34,
    3.668484092506268e-12,
    44633377239781340,
    2.994760480195583e+24,
    1.970043436654377e-31,
    3.4706615929192735e-24,
    1.5881852407234693e+32,
    217297355591.75436,
    6.97833604089416e-22,
    1.120818060147741e-19,
    7.547992675520375e-20,
    5.301723648157409e+28,
    4.569813207770128e-25,
    1.097723264665422e-36,
    3.220523154526017e+39,
    8.173097461228163e-24,
    1.666107590230961e-11,
    1542907.579413737,
    8.573067641336999e-42,
    4.014783708976682e-42,
    7.247740843041414e-42,
    2.42063772273911e+29,
    24727504.224095527,
    2.871012139685621e+27,
    1.1611308519272408e-35,
    14141563.588718228,
    1.4391775189132772e-17,
    1.6167505504445767e-7,
    3.4090142043355585e+26,
    9.526551731003627e-31,
    339428117748753.6,
    5.232301405328196e-18,
    3.981637498123785e+26,
    3.1169758166290927e+22,
    6.6771553431552234e-15,
    5.801201574577378e-22,
    3511177953.946187,
    2.9361630628671602e-36,
    3.4500849973713475e-9,
    1.0566835668243321e+30,
    1686071419890.2163,
    2.8210947549730764e+22,
    7.671653248696393e+24,
    535181540.2163695,
    2.2290634630963133e-26,
    7280418394.91816,
    3.6932769120150124,
    2.8339569137311826e-24,
    1.6977567431155537e+26,
    0.0002762078422762132,
    38076.11914484091,
    1179342466239650.5,
    81764259855822.39,
    1.0996534037118368e-17,
    1.7570364359524268e+23,
    4.555620378465192e-31,
    3.828362892284951e-8,
    1.3272434186564108e-42,
    3.9159430486918136e+36,
    0.00010592351027787052,
    6.122261162473887e-33,
    1176757265846650.2,
    2.3942218400713988e-27,
    2.0016234863801486e+33,
    1.118162706946887e+23,
    144150522079046000,
    1.680660525923759e-41,
    0.28236728530351385,
    7.684100539573692e-15,
    580964422804084600,
    7.76011021449483e+21,
    2.902812593066012e+27,
    1.3180987903531964e-21,
    1.3981432463248792e-15,
    842896216528.149,
    577786220920272.9,
    1.489928901047774e+39,
    5.599049713717422e+24,
    1.6419266349756687e-29,
    3.281064420022995e+28,
    43784382815.86703,
    5.02253334435264e-44,
    3.357097446577497e-37,
    3.102231061590438e+42,
    1.8669366948289877e-17,
    21680935643696.77,
    657345106776222600,
    1.9717122824811435e-8,
    366523500218656.94,
    5.860342334140768e+28,
    1.4010352412314634e-40,
    6.346868818654604e-17,
    6.848444886336575e-15,
    9.304051160829881e-9,
    1.0889566771551257e+23,
    2.2193867236103425e-35,
    2632.2073214305888,
    94616.77897141261,
    684313418177258300000,
    6.3033283318099e-19,
    2.2069157582880715e-36,
    5.2791312346200725e-23,
    1.0464346168427087e+32,
    5.24736246777135e+30,
    229101745820387.5,
    1.0620035842338566e-40,
    5.2460301037941026e-17,
    1.3387707879965373e-19,
    1636.037228257467,
    1.7723705289157174e-34,
    1.4586449433321518e-37,
    5.877464072191629e+28,
    2291506.850628766,
    1.6105969239828873e-33,
    4.7287528917231644e-42,
    40031462438414450,
    3.189745634866442e-20,
    3.4755410538816707e+28,
    2.3786942518725402e-40,
    3.165821411951001e+28,
    0.0000550357298490359,
    1.958203881515669e-12,
    9.15684368928839e-27,
    26206201391682110,
    0.7211235183298685,
    1.2828376165113609e-21,
    4.792387627945108e-23,
    6.727389601623787e+36,
    65847312.00496182,
    6.272416038173885e+30,
    4.965660892146652e+40,
    2.5891998207061212e-30,
    5.898681318905094e+39,
    0.06013976338791962,
    0.0010339078322754796,
    6.289187892780209e-7,
    2.0010601322514423e-38,
    3.622329083128696e-33,
    1.0399573902538441e-27,
    2.1870150664340196e-33,
    0.5071873425824882,
    3.1047485486942647e+28,
    1.0067740387208747e+23,
    3.6489648844283163e+22,
    8478.944781892962,
    2.443525639009486e-18,
    3.991861287663331e-8,
    2.528035844746265e-35,
    0.0000010310028534116322,
    1.604084936814009e-32,
    0.5050820684664914,
    1.7614717794980736e-26,
    111264182399.285,
    7.341469244676732e+23,
    75899630.76074159,
    3.81991924072437e-33,
    1.572654467794675e-31,
    0.04086458643364023,
    5.4582550996073585e-43,
    5.337950163219487e-31,
    5.0203066758757e+23,
    5.062287606530833e-30,
    4.4642018290758964e-41,
    1.3800523689355022e+30,
    2.2217187720271964e-7,
    0.000009020333800751803,
    0.0014816044729526292,
    302903533657911070000,
    7.19901904483676e+39,
    9.776194019046424e-22,
    1.5745824348648458e+41,
    1.6644924776774503e-12,
    1151201604972808300,
    9.464699239725575e+37,
    1.9837631433377265e-28,
    2.436848172842151e-18,
    0.00007760007295512155,
    8.840108669727238e-32,
    1.029513979554209e-42,
    7.117421692569809e+41,
    8.26097520637046e-17,
    6073224.190814234,
    28469150637.596027,
    14326.379373901736,
    2.459123017079656e-19,
    1.6065323149408074e-42,
    75059439.49122809,
    728889.5938290723,
    630776130286.4564,
    5.190183706165328e+34,
    3.544581879597933e-34,
    5.341112728082873e+33,
    158884272.9993618,
    2.549834806262046e-13,
    1.6046821570396742e+42,
    2.927046361307523e-12,
    2197798716188.2334,
    4.040289755149377e-30,
    2.3060302446413767e-12,
    8.231751638135694e-23,
    1.32029853908943e-7,
    193611125.42146808,
    122504252971945870,
    2.627064126232389e-26,
    7.587448907170274e-8,
    6.168830719890369e-28,
    7.450319903409975e-37,
    1256396542.264522,
    101386564701121.64,
    7.252508194191505e-19,
    1.3353019646574961e+28,
    1.44704745506892e+42,
    1.9677631156892953e-24,
    8.257086288015025e-9,
    5.280218907591393e-26,
    1662105719.0386572,
    3.723702723252516e-38,
    938208885673.178,
    2.911021222154232e-19,
    0.000036753996239311626,
    19956283238.380695,
    6.783137087164889e+33,
    1.0220724510993471e+43,
    1.7342670723540472e-38,
    1.735648856377998e-22,
    1.5258708287449794e+33,
    4.926105826122978e-35,
    0.04354056553878701,
    9.988204854038758e+24,
    8.437050435478508e-37,
    1.5589908866088064e-38,
    4.678601735688052e+27,
    7.2932889382704315e+25,
    8.203386483587637e+40,
    4.0760821896601433e-25,
    568517701258594500000,
    1482.5365715969965,
    9.640418759700963e-23,
    1.225920657604702e-14,
    6.076847970489929e+32,
    8.916624370173442e+36,
    1.609710167896528e+23,
    5.220149385789496e+31,
    2.8792814556299536e-37,
    1.3563527990567148e+26,
    1.1485761334381476e-38,
    49984.67648667718,
    4486.229276570017,
    1.026175889412808e-8,
    0.000008841864864671137,
    4.1612680947346466e-32,
    293076168146.2288,
    1.3257157470358658e-25,
    3.1528942250502992e+28,
    2.9244380309820614e-43,
    2.9923377041856196e-12,
    2.601082591055239e-28,
    6.599224396190625e-18,
    4.659158005537065e-44,
    1.0501339139019328e+27,
    1.806666022378114e-18,
    8.753887493469356e-18,
    1.7457910480750275e+40,
    0.04484579589018176,
    7.965033510046266e-28,
    18599081707863464,
    6.9821040578288014e-9,
    6.357641382109683e-38,
    1.3902461785622785e-23,
    1.4414913746917647e-36,
    2.8861162494410348e-15,
    1.6812762740920892e-42,
    1.6155279161206104e-38,
    7.34023001095252e+35,
    1.735059578132831e+41,
    1.8946101081390796e-9,
    8.11722992035527e-18,
    2.8454622537723404e-42,
    291404841224040050000,
    1.949861000517895e+29,
    0.005874224180566871,
    198549329.75270534,
    1425781422344919600,
    53797607.142503895,
    3.5137433241390494e-12,
    6.534704654412742e+35,
    2.8629930715516845e-42,
    1.2755269395598274e+23,
    243178.73480165444,
    2.1702449318254366e-17,
    4.614324663734265e-27,
    2.3283972212073138e-35,
    1.5079410431404525e-21,
    7.2402304156242505e-40,
    0.000006678929996355326,
    27394664588.690548,
    7.756347139726547e-18,
    1.1564752548036227e-40,
    5396369394038196000,
    5.541361887339177e-38,
    6712632513620381,
    174863952.28203693,
    4.665170839423276e-25,
    551603052883742360000,
    3349317422855386,
    14599670154416.775,
    4.185915495929087e+35,
    0.000511565639981174,
    1.6149250094906882e+35,
    1.606164896775328e+37,
    2.6627248957134024e-17,
    269250414156.0632,
    3.0255178802628784e+40,
    78728842529407090,
    1.0124392576955514e+39,
    0.00005380431193299243,
    1.5576445784490746e-29,
    1.6057567664841882e-38,
    3.279305635868852e+35,
    1.4082132164016864e-20,
    2.5321441852256966e+31,
    1.5924618876256781e+25,
    2.4817656092754062e+30,
    1.8217358874802652e-27,
    170704840495.65204,
    1.464037331834931e-28,
    2.9722808631837626e+21,
    2.101043888611546e-38,
    1.008034889156473e-21,
    5.790077819688833e-38,
    2.0988102834340029e-10,
    2.828563756890298e-28,
    7.714663613659423e-8,
    2.0492323604830823e-12,
    2.7726567951065257e+37,
    1.0687728710219703e+23,
    2.397164572117887,
    1.4029304153940949e-21,
    5.257241989729196e+33,
    2.0722903917095583e-41,
    7.423983495446385e+30,
    0.5088589688075345,
    53.99811882868713,
    26101183.069467608,
    2.7382496178295854e+27,
    1.23489146839775e+36,
    6.13421377737374e-44,
    1.3675170336263068e-43
];

function sign(x) {
    if (x !== 0) { return (x < 0 ? -1 : 1); }
    if (1 / x > 0) { return 1; }
    return -1;
}

function fmt(x) {
    if (x === 0) { return (1 / x > 0 ? '0' : '-0'); }
    return String(x);
}

/* The negative zero test fails intentionally: ToString() doesn't print out
 * the sign of a negative zero.
 */
/*===
fail 5 -0 0 0
===*/

function roundTripTest() {
    var i;
    var num1, str, num2;
    var fail;

    for (i = 0; i < values.length; i++) {
        num1 = values[i];
        str = num1.toString();
        num2 = Number(str);

        // Careful when comparing: even strict equality has (-0 === 0 => true).
        // On the other hand NaNs are never equal.

        fail = false;
        if (isNaN(num1) || isNaN(num2)) {
            if (!(isNaN(num1) && isNaN(num2))) {
                fail = true;
            }
        } else if (num1 === 0 && num2 === 0) {
            if (!(sign(num1) === sign(num2))) {
                fail = true;
            }
        } else if (num1 !== num2) {
            fail = true;
        }

        if (fail) {
            print('fail', i, fmt(num1), str, fmt(num2));
        }
    }
}

try {
    roundTripTest();
} catch (e) {
    print(e.stack || e);
}
