/*
 * e-settings-cal-model.c
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the program; if not, see <http://www.gnu.org/licenses/>
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "e-settings-cal-model.h"

#include <calendar/gui/e-cal-model.h>
#include <calendar/gui/e-cal-model-tasks.h>

#define E_SETTINGS_CAL_MODEL_GET_PRIVATE(obj) \
	(G_TYPE_INSTANCE_GET_PRIVATE \
	((obj), E_TYPE_SETTINGS_CAL_MODEL, ESettingsCalModelPrivate))

struct _ESettingsCalModelPrivate {
	gint placeholder;
};

G_DEFINE_DYNAMIC_TYPE (
	ESettingsCalModel,
	e_settings_cal_model,
	E_TYPE_EXTENSION)

static gboolean
settings_map_string_to_icaltimezone (GValue *value,
                                     GVariant *variant,
                                     gpointer user_data)
{
	GSettings *settings;
	const gchar *location = NULL;
	icaltimezone *timezone = NULL;

	settings = g_settings_new ("org.gnome.evolution.calendar");

	if (g_settings_get_boolean (settings, "use-system-timezone"))
		timezone = e_cal_util_get_system_timezone ();
	else
		location = g_variant_get_string (variant, NULL);

	if (location != NULL && *location != '\0')
		timezone = icaltimezone_get_builtin_timezone (location);

	if (timezone == NULL)
		timezone = icaltimezone_get_utc_timezone ();

	g_value_set_pointer (value, timezone);

	g_object_unref (settings);

	return TRUE;
}

static void
settings_cal_model_constructed (GObject *object)
{
	EExtension *extension;
	EExtensible *extensible;
	GSettings *settings;

	extension = E_EXTENSION (object);
	extensible = e_extension_get_extensible (extension);

	settings = g_settings_new ("org.gnome.evolution.calendar");

	/*** ECalModel ***/

	g_settings_bind (
		settings, "compress-weekend",
		extensible, "compress-weekend",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "confirm-delete",
		extensible, "confirm-delete",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "default-reminder-interval",
		extensible, "default-reminder-interval",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "default-reminder-units",
		extensible, "default-reminder-units",
		G_SETTINGS_BIND_GET);

	g_settings_bind_with_mapping (
		settings, "timezone",
		extensible, "timezone",
		G_SETTINGS_BIND_GET,
		settings_map_string_to_icaltimezone,
		NULL, /* one-way binding */
		NULL, (GDestroyNotify) NULL);

	g_settings_bind (
		settings, "use-24hour-format",
		extensible, "use-24-hour-format",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "use-default-reminder",
		extensible, "use-default-reminder",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "week-start-day-name",
		extensible, "week-start-day",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "work-day-monday",
		extensible, "work-day-monday",
		G_SETTINGS_BIND_GET);

	g_settings_bind  (
		settings, "work-day-tuesday",
		extensible, "work-day-tuesday",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "work-day-wednesday",
		extensible, "work-day-wednesday",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "work-day-thursday",
		extensible, "work-day-thursday",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "work-day-friday",
		extensible, "work-day-friday",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "work-day-saturday",
		extensible, "work-day-saturday",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "work-day-sunday",
		extensible, "work-day-sunday",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "day-end-hour",
		extensible, "work-day-end-hour",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "day-end-minute",
		extensible, "work-day-end-minute",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "day-start-hour",
		extensible, "work-day-start-hour",
		G_SETTINGS_BIND_GET);

	g_settings_bind (
		settings, "day-start-minute",
		extensible, "work-day-start-minute",
		G_SETTINGS_BIND_GET);

	/*** ECalModelTasks ***/

	if (E_IS_CAL_MODEL_TASKS (extensible)) {

		g_settings_bind (
			settings, "task-due-today-highlight",
			extensible, "highlight-due-today",
			G_SETTINGS_BIND_GET);

		g_settings_bind (
			settings, "task-due-today-color",
			extensible, "color-due-today",
			G_SETTINGS_BIND_GET);

		g_settings_bind (
			settings, "task-overdue-highlight",
			extensible, "highlight-overdue",
			G_SETTINGS_BIND_GET);

		g_settings_bind (
			settings, "task-overdue-color",
			extensible, "color-overdue",
			G_SETTINGS_BIND_GET);
	}

	g_object_unref (settings);

	/* Chain up to parent's constructed() method. */
	G_OBJECT_CLASS (e_settings_cal_model_parent_class)->
		constructed (object);
}

static void
e_settings_cal_model_class_init (ESettingsCalModelClass *class)
{
	GObjectClass *object_class;
	EExtensionClass *extension_class;

	g_type_class_add_private (class, sizeof (ESettingsCalModelPrivate));

	object_class = G_OBJECT_CLASS (class);
	object_class->constructed = settings_cal_model_constructed;

	extension_class = E_EXTENSION_CLASS (class);
	extension_class->extensible_type = E_TYPE_CAL_MODEL;
}

static void
e_settings_cal_model_class_finalize (ESettingsCalModelClass *class)
{
}

static void
e_settings_cal_model_init (ESettingsCalModel *extension)
{
	extension->priv = E_SETTINGS_CAL_MODEL_GET_PRIVATE (extension);
}

void
e_settings_cal_model_type_register (GTypeModule *type_module)
{
	/* XXX G_DEFINE_DYNAMIC_TYPE declares a static type registration
	 *     function, so we have to wrap it with a public function in
	 *     order to register types from a separate compilation unit. */
	e_settings_cal_model_register_type (type_module);
}

