; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -attributor -enable-new-pm=0 -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=53 -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_CGSCC_NPM,NOT_CGSCC_OPM,NOT_TUNIT_NPM,IS__TUNIT____,IS________OPM,IS__TUNIT_OPM
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-max-iterations-verify -attributor-annotate-decl-cs -attributor-max-iterations=53 -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_CGSCC_OPM,NOT_CGSCC_NPM,NOT_TUNIT_OPM,IS__TUNIT____,IS________NPM,IS__TUNIT_NPM
; RUN: opt -attributor-cgscc -enable-new-pm=0 -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_TUNIT_NPM,NOT_TUNIT_OPM,NOT_CGSCC_NPM,IS__CGSCC____,IS________OPM,IS__CGSCC_OPM
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,NOT_TUNIT_NPM,NOT_TUNIT_OPM,NOT_CGSCC_OPM,IS__CGSCC____,IS________NPM,IS__CGSCC_NPM
;
%struct.S = type { i32, i32, i32, float, float, float }

@globalBytes = global [1024 x i8] zeroinitializer, align 16
@Gint1 = global i32 zeroinitializer, align 4
@Gint2 = global i32 zeroinitializer, align 4
@Gstatic_int1 = internal global i32 zeroinitializer, align 4
@Gstatic_int2 = internal global i32 zeroinitializer, align 4
@Gstatic_int3 = internal global i32 zeroinitializer, align 4
@Gstatic_undef_int1 = internal global i32 undef, align 4
@Gstatic_undef_int2 = internal global i32 undef, align 4
@GI1 = internal global i32 undef, align 4
@GI2 = internal global i32 undef, align 4
@Gs1 = internal global %struct.S undef, align 4
@Gs2 = internal global %struct.S zeroinitializer, align 4
@GBytes = internal global [1024 x i8] zeroinitializer, align 16
@Flag0 = global i32 0, align 4
@Flag1 = internal global i32 undef, align 4
@Flag2 = internal global i32 undef, align 4
@Flag3 = internal global i32 zeroinitializer, align 4
@a1 = internal global i32 zeroinitializer
@a2 = internal global i32 zeroinitializer
@a3 = internal global i32 undef
@bytes1 = internal global i32 undef
@bytes2 = internal global i32 undef

;.
; CHECK: @[[GLOBALBYTES:[a-zA-Z0-9_$"\\.-]+]] = global [1024 x i8] zeroinitializer, align 16
; CHECK: @[[GINT1:[a-zA-Z0-9_$"\\.-]+]] = global i32 0, align 4
; CHECK: @[[GINT2:[a-zA-Z0-9_$"\\.-]+]] = global i32 0, align 4
; CHECK: @[[GSTATIC_INT1:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0, align 4
; CHECK: @[[GSTATIC_INT2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0, align 4
; CHECK: @[[GSTATIC_INT3:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0, align 4
; CHECK: @[[GSTATIC_UNDEF_INT1:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef, align 4
; CHECK: @[[GSTATIC_UNDEF_INT2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef, align 4
; CHECK: @[[GI1:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef, align 4
; CHECK: @[[GI2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef, align 4
; CHECK: @[[GS1:[a-zA-Z0-9_$"\\.-]+]] = internal global [[STRUCT_S:%.*]] undef, align 4
; CHECK: @[[GS2:[a-zA-Z0-9_$"\\.-]+]] = internal global [[STRUCT_S:%.*]] zeroinitializer, align 4
; CHECK: @[[GBYTES:[a-zA-Z0-9_$"\\.-]+]] = internal global [1024 x i8] zeroinitializer, align 16
; CHECK: @[[FLAG0:[a-zA-Z0-9_$"\\.-]+]] = global i32 0, align 4
; CHECK: @[[FLAG1:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef, align 4
; CHECK: @[[FLAG2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef, align 4
; CHECK: @[[FLAG3:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0, align 4
; CHECK: @[[A1:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0
; CHECK: @[[A2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 0
; CHECK: @[[A3:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef
; CHECK: @[[BYTES1:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef
; CHECK: @[[BYTES2:[a-zA-Z0-9_$"\\.-]+]] = internal global i32 undef
;.
define void @write_arg(i32* %p, i32 %v) {
; IS__TUNIT____: Function Attrs: argmemonly nofree nosync nounwind willreturn writeonly
; IS__TUNIT____-LABEL: define {{[^@]+}}@write_arg
; IS__TUNIT____-SAME: (i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P:%.*]], i32 [[V:%.*]]) #[[ATTR0:[0-9]+]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    store i32 [[V]], i32* [[P]], align 4, !tbaa [[TBAA3:![0-9]+]]
; IS__TUNIT____-NEXT:    ret void
;
; IS__CGSCC____: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_arg
; IS__CGSCC____-SAME: (i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[P:%.*]], i32 [[V:%.*]]) #[[ATTR0:[0-9]+]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    store i32 [[V]], i32* [[P]], align 4, !tbaa [[TBAA3:![0-9]+]]
; IS__CGSCC____-NEXT:    ret void
;
entry:
  store i32 %v, i32* %p, align 4, !tbaa !3
  ret void
}

define void @write_random(i32* %p) {
; CHECK-LABEL: define {{[^@]+}}@write_random
; CHECK-SAME: (i32* nocapture nofree writeonly [[P:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CALL:%.*]] = call i32 (...) @random()
; CHECK-NEXT:    store i32 [[CALL]], i32* [[P]], align 4, !tbaa [[TBAA3:![0-9]+]]
; CHECK-NEXT:    ret void
;
entry:
  %call = call i32 (...) @random()
  store i32 %call, i32* %p, align 4, !tbaa !3
  ret void
}

declare i32 @random(...)

;    struct S local_alloca_simplifiable_1(void) {
;      struct S s;
;      s.f1 = 1.1;
;      s.f2 = 2.2;
;      s.f3 = 3.3;
;      write_arg(&s.i1, 1);
;      write_arg(&s.i2, 2);
;      write_arg(&s.i3, 3);
;      struct S r;
;      r.f1 = s.f1;
;      r.f2 = s.f2 * 2;
;      r.f3 = s.f3 + s.f1;
;      r.i1 = s.i1;
;      r.i2 = s.i2 * 2;
;      r.i3 = s.i3 + s.i1;
;      return r;
;    }
define void @local_alloca_simplifiable_1(%struct.S* noalias sret(%struct.S) align 4 %agg.result) {
; IS__TUNIT_OPM: Function Attrs: argmemonly nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_1
; IS__TUNIT_OPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR1:[0-9]+]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[S:%.*]] = alloca [[STRUCT_S]], align 4
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I]]) #[[ATTR9:[0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__TUNIT_OPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__TUNIT_OPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR5:[0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    store float 0x3FF19999A0000000, float* [[F12]], align 4, !tbaa [[TBAA7:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__TUNIT_OPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__TUNIT_OPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__TUNIT_OPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__TUNIT_OPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    store i32 1, i32* [[I19]], align 4, !tbaa [[TBAA12:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 2, 1
; IS__TUNIT_OPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__TUNIT_OPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[ADD15:%.*]] = add nsw i32 3, 1
; IS__TUNIT_OPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__TUNIT_OPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    [[I12:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I12]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: argmemonly nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_1
; IS__TUNIT_NPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR1:[0-9]+]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[S:%.*]] = alloca [[STRUCT_S]], align 4
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I]]) #[[ATTR6:[0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__TUNIT_NPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__TUNIT_NPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR4:[0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    store float 0x3FF19999A0000000, float* [[F12]], align 4, !tbaa [[TBAA7:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__TUNIT_NPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__TUNIT_NPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__TUNIT_NPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__TUNIT_NPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    store i32 1, i32* [[I19]], align 4, !tbaa [[TBAA12:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 2, 1
; IS__TUNIT_NPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__TUNIT_NPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[ADD15:%.*]] = add nsw i32 3, 1
; IS__TUNIT_NPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__TUNIT_NPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    [[I12:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I12]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC_OPM: Function Attrs: argmemonly nofree nosync nounwind willreturn
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_1
; IS__CGSCC_OPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR1:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[S:%.*]] = alloca [[STRUCT_S]], align 4
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I]]) #[[ATTR11:[0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__CGSCC_OPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__CGSCC_OPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR12:[0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    store float 0x3FF19999A0000000, float* [[F12]], align 4, !tbaa [[TBAA7:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__CGSCC_OPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__CGSCC_OPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__CGSCC_OPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__CGSCC_OPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    store i32 1, i32* [[I19]], align 4, !tbaa [[TBAA12:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 2, 1
; IS__CGSCC_OPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__CGSCC_OPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[ADD15:%.*]] = add nsw i32 3, 1
; IS__CGSCC_OPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__CGSCC_OPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    [[I12:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I12]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: argmemonly nofree nosync nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_1
; IS__CGSCC_NPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR1:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[S:%.*]] = alloca [[STRUCT_S]], align 4
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I]]) #[[ATTR8:[0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__CGSCC_NPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__CGSCC_NPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR9:[0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    store float 0x3FF19999A0000000, float* [[F12]], align 4, !tbaa [[TBAA7:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__CGSCC_NPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__CGSCC_NPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__CGSCC_NPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__CGSCC_NPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    store i32 1, i32* [[I19]], align 4, !tbaa [[TBAA12:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 2, 1
; IS__CGSCC_NPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__CGSCC_NPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[ADD15:%.*]] = add nsw i32 3, 1
; IS__CGSCC_NPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__CGSCC_NPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    [[I12:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 24, i8* nocapture nofree noundef nonnull align 4 dereferenceable(24) [[I12]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    ret void
;
entry:
  %s = alloca %struct.S, align 4
  %i = bitcast %struct.S* %s to i8*
  call void @llvm.lifetime.start.p0i8(i64 24, i8* nonnull %i)
  %f1 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 3
  store float 0x3FF19999A0000000, float* %f1, align 4, !tbaa !7
  %f2 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 4
  store float 0x40019999A0000000, float* %f2, align 4, !tbaa !10
  %f3 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 5
  store float 0x400A666660000000, float* %f3, align 4, !tbaa !11
  %i1 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 0
  call void @write_arg(i32* nonnull %i1, i32 1)
  %i2 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 1
  call void @write_arg(i32* nonnull %i2, i32 2)
  %i3 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 2
  call void @write_arg(i32* nonnull %i3, i32 3)
  %f11 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 3
  %i4 = load float, float* %f11, align 4, !tbaa !7
  %f12 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 3
  store float %i4, float* %f12, align 4, !tbaa !7
  %f23 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 4
  %i5 = load float, float* %f23, align 4, !tbaa !10
  %mul = fmul float %i5, 2.000000e+00
  %f24 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 4
  store float %mul, float* %f24, align 4, !tbaa !10
  %f35 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 5
  %i6 = load float, float* %f35, align 4, !tbaa !11
  %f16 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 3
  %i7 = load float, float* %f16, align 4, !tbaa !7
  %add = fadd float %i6, %i7
  %f37 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 5
  store float %add, float* %f37, align 4, !tbaa !11
  %i18 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 0
  %i8 = load i32, i32* %i18, align 4, !tbaa !12
  %i19 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 0
  store i32 %i8, i32* %i19, align 4, !tbaa !12
  %i210 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 1
  %i9 = load i32, i32* %i210, align 4, !tbaa !13
  %mul11 = shl nsw i32 %i9, 1
  %i212 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 1
  store i32 %mul11, i32* %i212, align 4, !tbaa !13
  %i313 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 2
  %i10 = load i32, i32* %i313, align 4, !tbaa !14
  %i114 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 0
  %i11 = load i32, i32* %i114, align 4, !tbaa !12
  %add15 = add nsw i32 %i10, %i11
  %i316 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 2
  store i32 %add15, i32* %i316, align 4, !tbaa !14
  %i12 = bitcast %struct.S* %s to i8*
  call void @llvm.lifetime.end.p0i8(i64 24, i8* nonnull %i12)
  ret void
}

declare void @llvm.lifetime.start.p0i8(i64 immarg, i8* nocapture)

declare void @llvm.lifetime.end.p0i8(i64 immarg, i8* nocapture)

;    void local_alloca_simplifiable_2(void) {
;      char Bytes[1024];
;      for (int i = 0; i < 100; ++i)
;        Bytes[i * 10] = 0;
;      for (int i = 0; i < 10; ++i)
;        ((float *)Bytes)[i * 10 + 1] = 0;
;      for (int i = 0; i < 20; ++i)
;        ((long long int *)Bytes)[i * 10 + 2] = 0;
;      Bytes[1023] = 0;
;      write_arg((int *)&Bytes[500], 0);
;      struct S R;
;      for (int i = 0; i < 1024; ++i)
;        globalBytes[i] = Bytes[i];
;    }
;
define void @local_alloca_simplifiable_2() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_2
; IS__TUNIT_OPM-SAME: () #[[ATTR2:[0-9]+]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[BYTES:%.*]] = alloca [1024 x i8], align 16
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 1024, i8* nocapture nofree noundef nonnull align 16 dereferenceable(1024) [[I]])
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__TUNIT_OPM:       for.cond:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END:%.*]]
; IS__TUNIT_OPM:       for.body:
; IS__TUNIT_OPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 [[I15]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC]]
; IS__TUNIT_OPM:       for.inc:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
; IS__TUNIT_OPM:       for.end:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__TUNIT_OPM:       for.cond2:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup4:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__TUNIT_OPM:       for.body5:
; IS__TUNIT_OPM-NEXT:    [[I16:%.*]] = bitcast [1024 x i8]* [[BYTES]] to float*
; IS__TUNIT_OPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__TUNIT_OPM-NEXT:    [[I18:%.*]] = or i64 [[I17]], 1
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I16]], i64 [[I18]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC9]]
; IS__TUNIT_OPM:       for.inc9:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP17:![0-9]+]]
; IS__TUNIT_OPM:       for.end11:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__TUNIT_OPM:       for.cond13:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC22:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup15:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END24:%.*]]
; IS__TUNIT_OPM:       for.body16:
; IS__TUNIT_OPM-NEXT:    [[I19:%.*]] = bitcast [1024 x i8]* [[BYTES]] to i64*
; IS__TUNIT_OPM-NEXT:    [[I20:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__TUNIT_OPM-NEXT:    [[I21:%.*]] = add nuw nsw i64 [[I20]], 2
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i64, i64* [[I19]], i64 [[I21]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC22]]
; IS__TUNIT_OPM:       for.inc22:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP18:![0-9]+]]
; IS__TUNIT_OPM:       for.end24:
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 1023
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX26:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 500
; IS__TUNIT_OPM-NEXT:    [[I22:%.*]] = bitcast i8* [[ARRAYIDX26]] to i32*
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(524) [[I22]], i32 noundef 0) #[[ATTR6:[0-9]+]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND28:%.*]]
; IS__TUNIT_OPM:       for.cond28:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC36:%.*]] ], [ 0, [[FOR_END24]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY31:%.*]], label [[FOR_COND_CLEANUP30:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup30:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END38:%.*]]
; IS__TUNIT_OPM:       for.body31:
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX35:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__TUNIT_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX35]], align 1, !tbaa [[TBAA19:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC36]]
; IS__TUNIT_OPM:       for.inc36:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND28]], !llvm.loop [[LOOP20:![0-9]+]]
; IS__TUNIT_OPM:       for.end38:
; IS__TUNIT_OPM-NEXT:    [[I24:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 1024, i8* nocapture nofree noundef nonnull align 16 dereferenceable(1024) [[I24]])
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_2
; IS__TUNIT_NPM-SAME: () #[[ATTR2:[0-9]+]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[BYTES:%.*]] = alloca [1024 x i8], align 16
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 1024, i8* nocapture nofree noundef nonnull align 16 dereferenceable(1024) [[I]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__TUNIT_NPM:       for.cond:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END:%.*]]
; IS__TUNIT_NPM:       for.body:
; IS__TUNIT_NPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 [[I15]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC]]
; IS__TUNIT_NPM:       for.inc:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP15:![0-9]+]]
; IS__TUNIT_NPM:       for.end:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__TUNIT_NPM:       for.cond2:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup4:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__TUNIT_NPM:       for.body5:
; IS__TUNIT_NPM-NEXT:    [[I16:%.*]] = bitcast [1024 x i8]* [[BYTES]] to float*
; IS__TUNIT_NPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__TUNIT_NPM-NEXT:    [[I18:%.*]] = or i64 [[I17]], 1
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I16]], i64 [[I18]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC9]]
; IS__TUNIT_NPM:       for.inc9:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP17:![0-9]+]]
; IS__TUNIT_NPM:       for.end11:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__TUNIT_NPM:       for.cond13:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC22:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup15:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END24:%.*]]
; IS__TUNIT_NPM:       for.body16:
; IS__TUNIT_NPM-NEXT:    [[I19:%.*]] = bitcast [1024 x i8]* [[BYTES]] to i64*
; IS__TUNIT_NPM-NEXT:    [[I20:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__TUNIT_NPM-NEXT:    [[I21:%.*]] = add nuw nsw i64 [[I20]], 2
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i64, i64* [[I19]], i64 [[I21]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC22]]
; IS__TUNIT_NPM:       for.inc22:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP18:![0-9]+]]
; IS__TUNIT_NPM:       for.end24:
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 1023
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX26:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 500
; IS__TUNIT_NPM-NEXT:    [[I22:%.*]] = bitcast i8* [[ARRAYIDX26]] to i32*
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(524) [[I22]], i32 noundef 0) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND28:%.*]]
; IS__TUNIT_NPM:       for.cond28:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC36:%.*]] ], [ 0, [[FOR_END24]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY31:%.*]], label [[FOR_COND_CLEANUP30:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup30:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END38:%.*]]
; IS__TUNIT_NPM:       for.body31:
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX35:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__TUNIT_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX35]], align 1, !tbaa [[TBAA19:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC36]]
; IS__TUNIT_NPM:       for.inc36:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND28]], !llvm.loop [[LOOP20:![0-9]+]]
; IS__TUNIT_NPM:       for.end38:
; IS__TUNIT_NPM-NEXT:    [[I24:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 1024, i8* nocapture nofree noundef nonnull align 16 dereferenceable(1024) [[I24]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_2() {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[BYTES:%.*]] = alloca [1024 x i8], align 16
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 1024, i8* nocapture nofree noundef nonnull align 16 dereferenceable(1024) [[I]])
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__CGSCC_OPM:       for.cond:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END:%.*]]
; IS__CGSCC_OPM:       for.body:
; IS__CGSCC_OPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 [[I15]]
; IS__CGSCC_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 2, !tbaa [[TBAA15:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC]]
; IS__CGSCC_OPM:       for.inc:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
; IS__CGSCC_OPM:       for.end:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__CGSCC_OPM:       for.cond2:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup4:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__CGSCC_OPM:       for.body5:
; IS__CGSCC_OPM-NEXT:    [[I16:%.*]] = bitcast [1024 x i8]* [[BYTES]] to float*
; IS__CGSCC_OPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__CGSCC_OPM-NEXT:    [[I18:%.*]] = or i64 [[I17]], 1
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I16]], i64 [[I18]]
; IS__CGSCC_OPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA18:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC9]]
; IS__CGSCC_OPM:       for.inc9:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP19:![0-9]+]]
; IS__CGSCC_OPM:       for.end11:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__CGSCC_OPM:       for.cond13:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC22:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup15:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END24:%.*]]
; IS__CGSCC_OPM:       for.body16:
; IS__CGSCC_OPM-NEXT:    [[I19:%.*]] = bitcast [1024 x i8]* [[BYTES]] to i64*
; IS__CGSCC_OPM-NEXT:    [[I20:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__CGSCC_OPM-NEXT:    [[I21:%.*]] = add nuw nsw i64 [[I20]], 2
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i64, i64* [[I19]], i64 [[I21]]
; IS__CGSCC_OPM-NEXT:    store i64 0, i64* [[ARRAYIDX21]], align 16, !tbaa [[TBAA20:![0-9]+]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC22]]
; IS__CGSCC_OPM:       for.inc22:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP22:![0-9]+]]
; IS__CGSCC_OPM:       for.end24:
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 1023
; IS__CGSCC_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX25]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX26:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 500
; IS__CGSCC_OPM-NEXT:    [[I22:%.*]] = bitcast i8* [[ARRAYIDX26]] to i32*
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nofree noundef nonnull writeonly align 4 dereferenceable(4) [[I22]], i32 noundef 0) #[[ATTR13:[0-9]+]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND28:%.*]]
; IS__CGSCC_OPM:       for.cond28:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC36:%.*]] ], [ 0, [[FOR_END24]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY31:%.*]], label [[FOR_COND_CLEANUP30:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup30:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END38:%.*]]
; IS__CGSCC_OPM:       for.body31:
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX33:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_OPM-NEXT:    [[I23:%.*]] = load i8, i8* [[ARRAYIDX33]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX35:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_OPM-NEXT:    store i8 [[I23]], i8* [[ARRAYIDX35]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC36]]
; IS__CGSCC_OPM:       for.inc36:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND28]], !llvm.loop [[LOOP23:![0-9]+]]
; IS__CGSCC_OPM:       for.end38:
; IS__CGSCC_OPM-NEXT:    [[I24:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 1024, i8* nofree noundef nonnull [[I24]])
; IS__CGSCC_OPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@local_alloca_simplifiable_2() {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[BYTES:%.*]] = alloca [1024 x i8], align 16
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 1024, i8* nocapture nofree noundef nonnull align 16 dereferenceable(1024) [[I]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__CGSCC_NPM:       for.cond:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END:%.*]]
; IS__CGSCC_NPM:       for.body:
; IS__CGSCC_NPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 [[I15]]
; IS__CGSCC_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 2, !tbaa [[TBAA15:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC]]
; IS__CGSCC_NPM:       for.inc:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP16:![0-9]+]]
; IS__CGSCC_NPM:       for.end:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__CGSCC_NPM:       for.cond2:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup4:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__CGSCC_NPM:       for.body5:
; IS__CGSCC_NPM-NEXT:    [[I16:%.*]] = bitcast [1024 x i8]* [[BYTES]] to float*
; IS__CGSCC_NPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__CGSCC_NPM-NEXT:    [[I18:%.*]] = or i64 [[I17]], 1
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I16]], i64 [[I18]]
; IS__CGSCC_NPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA18:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC9]]
; IS__CGSCC_NPM:       for.inc9:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP19:![0-9]+]]
; IS__CGSCC_NPM:       for.end11:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__CGSCC_NPM:       for.cond13:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC22:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup15:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END24:%.*]]
; IS__CGSCC_NPM:       for.body16:
; IS__CGSCC_NPM-NEXT:    [[I19:%.*]] = bitcast [1024 x i8]* [[BYTES]] to i64*
; IS__CGSCC_NPM-NEXT:    [[I20:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__CGSCC_NPM-NEXT:    [[I21:%.*]] = add nuw nsw i64 [[I20]], 2
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX21:%.*]] = getelementptr inbounds i64, i64* [[I19]], i64 [[I21]]
; IS__CGSCC_NPM-NEXT:    store i64 0, i64* [[ARRAYIDX21]], align 16, !tbaa [[TBAA20:![0-9]+]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC22]]
; IS__CGSCC_NPM:       for.inc22:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP22:![0-9]+]]
; IS__CGSCC_NPM:       for.end24:
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 1023
; IS__CGSCC_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX25]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX26:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 500
; IS__CGSCC_NPM-NEXT:    [[I22:%.*]] = bitcast i8* [[ARRAYIDX26]] to i32*
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nofree noundef nonnull writeonly align 4 dereferenceable(4) [[I22]], i32 noundef 0) #[[ATTR10:[0-9]+]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND28:%.*]]
; IS__CGSCC_NPM:       for.cond28:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC36:%.*]] ], [ 0, [[FOR_END24]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY31:%.*]], label [[FOR_COND_CLEANUP30:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup30:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END38:%.*]]
; IS__CGSCC_NPM:       for.body31:
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX33:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_NPM-NEXT:    [[I23:%.*]] = load i8, i8* [[ARRAYIDX33]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX35:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_NPM-NEXT:    store i8 [[I23]], i8* [[ARRAYIDX35]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC36]]
; IS__CGSCC_NPM:       for.inc36:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND28]], !llvm.loop [[LOOP23:![0-9]+]]
; IS__CGSCC_NPM:       for.end38:
; IS__CGSCC_NPM-NEXT:    [[I24:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* [[BYTES]], i64 0, i64 0
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 1024, i8* nofree noundef nonnull [[I24]])
; IS__CGSCC_NPM-NEXT:    ret void
;
entry:
  %Bytes = alloca [1024 x i8], align 16
  %i = getelementptr inbounds [1024 x i8], [1024 x i8]* %Bytes, i64 0, i64 0
  call void @llvm.lifetime.start.p0i8(i64 1024, i8* nonnull %i)
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %indvars.iv = phi i64 [ %indvars.iv.next, %for.inc ], [ 0, %entry ]
  %exitcond = icmp ne i64 %indvars.iv, 100
  br i1 %exitcond, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  br label %for.end

for.body:                                         ; preds = %for.cond
  %i15 = mul nuw nsw i64 %indvars.iv, 10
  %arrayidx = getelementptr inbounds [1024 x i8], [1024 x i8]* %Bytes, i64 0, i64 %i15
  store i8 0, i8* %arrayidx, align 2, !tbaa !15
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  br label %for.cond, !llvm.loop !16

for.end:                                          ; preds = %for.cond.cleanup
  br label %for.cond2

for.cond2:                                        ; preds = %for.inc9, %for.end
  %indvars.iv2 = phi i64 [ %indvars.iv.next3, %for.inc9 ], [ 0, %for.end ]
  %exitcond6 = icmp ne i64 %indvars.iv2, 10
  br i1 %exitcond6, label %for.body5, label %for.cond.cleanup4

for.cond.cleanup4:                                ; preds = %for.cond2
  br label %for.end11

for.body5:                                        ; preds = %for.cond2
  %i16 = bitcast [1024 x i8]* %Bytes to float*
  %i17 = mul nuw nsw i64 %indvars.iv2, 10
  %i18 = or i64 %i17, 1
  %arrayidx8 = getelementptr inbounds float, float* %i16, i64 %i18
  store float 0.000000e+00, float* %arrayidx8, align 4, !tbaa !18
  br label %for.inc9

for.inc9:                                         ; preds = %for.body5
  %indvars.iv.next3 = add nuw nsw i64 %indvars.iv2, 1
  br label %for.cond2, !llvm.loop !19

for.end11:                                        ; preds = %for.cond.cleanup4
  br label %for.cond13

for.cond13:                                       ; preds = %for.inc22, %for.end11
  %indvars.iv7 = phi i64 [ %indvars.iv.next8, %for.inc22 ], [ 0, %for.end11 ]
  %exitcond11 = icmp ne i64 %indvars.iv7, 20
  br i1 %exitcond11, label %for.body16, label %for.cond.cleanup15

for.cond.cleanup15:                               ; preds = %for.cond13
  br label %for.end24

for.body16:                                       ; preds = %for.cond13
  %i19 = bitcast [1024 x i8]* %Bytes to i64*
  %i20 = mul nuw nsw i64 %indvars.iv7, 10
  %i21 = add nuw nsw i64 %i20, 2
  %arrayidx21 = getelementptr inbounds i64, i64* %i19, i64 %i21
  store i64 0, i64* %arrayidx21, align 16, !tbaa !20
  br label %for.inc22

for.inc22:                                        ; preds = %for.body16
  %indvars.iv.next8 = add nuw nsw i64 %indvars.iv7, 1
  br label %for.cond13, !llvm.loop !22

for.end24:                                        ; preds = %for.cond.cleanup15
  %arrayidx25 = getelementptr inbounds [1024 x i8], [1024 x i8]* %Bytes, i64 0, i64 1023
  store i8 0, i8* %arrayidx25, align 1, !tbaa !15
  %arrayidx26 = getelementptr inbounds [1024 x i8], [1024 x i8]* %Bytes, i64 0, i64 500
  %i22 = bitcast i8* %arrayidx26 to i32*
  call void @write_arg(i32* nonnull %i22, i32 0)
  br label %for.cond28

for.cond28:                                       ; preds = %for.inc36, %for.end24
  %indvars.iv12 = phi i64 [ %indvars.iv.next13, %for.inc36 ], [ 0, %for.end24 ]
  %exitcond14 = icmp ne i64 %indvars.iv12, 1024
  br i1 %exitcond14, label %for.body31, label %for.cond.cleanup30

for.cond.cleanup30:                               ; preds = %for.cond28
  br label %for.end38

for.body31:                                       ; preds = %for.cond28
  %arrayidx33 = getelementptr inbounds [1024 x i8], [1024 x i8]* %Bytes, i64 0, i64 %indvars.iv12
  %i23 = load i8, i8* %arrayidx33, align 1, !tbaa !15
  %arrayidx35 = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 %indvars.iv12
  store i8 %i23, i8* %arrayidx35, align 1, !tbaa !15
  br label %for.inc36

for.inc36:                                        ; preds = %for.body31
  %indvars.iv.next13 = add nuw nsw i64 %indvars.iv12, 1
  br label %for.cond28, !llvm.loop !23

for.end38:                                        ; preds = %for.cond.cleanup30
  %i24 = getelementptr inbounds [1024 x i8], [1024 x i8]* %Bytes, i64 0, i64 0
  call void @llvm.lifetime.end.p0i8(i64 1024, i8* nonnull %i24)
  ret void
}

;    int local_alloca_simplifiable_3() {
;      int A = 1;
;      // split
;      A = 2;
;      return A;
;    }
;
define i32 @local_alloca_simplifiable_3() {
; IS__TUNIT____: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@local_alloca_simplifiable_3
; IS__TUNIT____-SAME: () #[[ATTR3:[0-9]+]] {
; IS__TUNIT____-NEXT:    [[A:%.*]] = alloca i32, align 4
; IS__TUNIT____-NEXT:    store i32 1, i32* [[A]], align 4
; IS__TUNIT____-NEXT:    br label [[SPLIT:%.*]]
; IS__TUNIT____:       split:
; IS__TUNIT____-NEXT:    store i32 2, i32* [[A]], align 4
; IS__TUNIT____-NEXT:    [[L:%.*]] = load i32, i32* [[A]], align 4
; IS__TUNIT____-NEXT:    ret i32 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@local_alloca_simplifiable_3
; IS__CGSCC____-SAME: () #[[ATTR2:[0-9]+]] {
; IS__CGSCC____-NEXT:    [[A:%.*]] = alloca i32, align 4
; IS__CGSCC____-NEXT:    store i32 1, i32* [[A]], align 4
; IS__CGSCC____-NEXT:    br label [[SPLIT:%.*]]
; IS__CGSCC____:       split:
; IS__CGSCC____-NEXT:    store i32 2, i32* [[A]], align 4
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i32, i32* [[A]], align 4
; IS__CGSCC____-NEXT:    ret i32 [[L]]
;
  %A = alloca i32, align 4
  store i32 1, i32* %A
  br label %split
split:
  store i32 2, i32* %A
  %l = load i32, i32* %A, align 4
  ret i32 %l
}
;    int local_alloca_simplifiable_4() {
;      int A;
;      return A;
;    }
;
define i32 @local_alloca_simplifiable_4() {
; IS__TUNIT____: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@local_alloca_simplifiable_4
; IS__TUNIT____-SAME: () #[[ATTR3]] {
; IS__TUNIT____-NEXT:    ret i32 undef
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@local_alloca_simplifiable_4
; IS__CGSCC____-SAME: () #[[ATTR2]] {
; IS__CGSCC____-NEXT:    ret i32 undef
;
  %A = alloca i32, align 4
  %l = load i32, i32* %A, align 4
  ret i32 %l
}

;    static int GI1 __attribute__((loader_uninitialized));
;    int multi_obj_simplifiable_1(int cnd) {
;      int L = GI1 = 5;
;      int *p = cnd ? &GI1 : &L;
;      return *p;
;    }
define i32 @multi_obj_simplifiable_1(i32 %cnd) {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_1
; IS__TUNIT_OPM-SAME: (i32 [[CND:%.*]]) #[[ATTR4:[0-9]+]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__TUNIT_OPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__TUNIT_OPM:       cond.true:
; IS__TUNIT_OPM-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT_OPM:       cond.false:
; IS__TUNIT_OPM-NEXT:    br label [[COND_END]]
; IS__TUNIT_OPM:       cond.end:
; IS__TUNIT_OPM-NEXT:    [[I2:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I2]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    ret i32 5
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_1
; IS__TUNIT_NPM-SAME: (i32 [[CND:%.*]]) #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__TUNIT_NPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__TUNIT_NPM:       cond.true:
; IS__TUNIT_NPM-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT_NPM:       cond.false:
; IS__TUNIT_NPM-NEXT:    br label [[COND_END]]
; IS__TUNIT_NPM:       cond.end:
; IS__TUNIT_NPM-NEXT:    [[I2:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I2]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    ret i32 5
;
; IS__CGSCC_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_1
; IS__CGSCC_OPM-SAME: (i32 [[CND:%.*]]) #[[ATTR3:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__CGSCC_OPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__CGSCC_OPM:       cond.true:
; IS__CGSCC_OPM-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC_OPM:       cond.false:
; IS__CGSCC_OPM-NEXT:    br label [[COND_END]]
; IS__CGSCC_OPM:       cond.end:
; IS__CGSCC_OPM-NEXT:    [[I2:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I2]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    ret i32 5
;
; IS__CGSCC_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_1
; IS__CGSCC_NPM-SAME: (i32 [[CND:%.*]]) #[[ATTR3:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__CGSCC_NPM:       cond.true:
; IS__CGSCC_NPM-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC_NPM:       cond.false:
; IS__CGSCC_NPM-NEXT:    br label [[COND_END]]
; IS__CGSCC_NPM:       cond.end:
; IS__CGSCC_NPM-NEXT:    [[I2:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I2]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    ret i32 5
;
entry:
  %L = alloca i32, align 4
  %i = bitcast i32* %L to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* nonnull %i)
  store i32 5, i32* @GI1, align 4, !tbaa !3
  store i32 5, i32* %L, align 4, !tbaa !3
  %tobool.not = icmp eq i32 %cnd, 0
  br i1 %tobool.not, label %cond.false, label %cond.true

cond.true:                                        ; preds = %entry
  br label %cond.end

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi i32* [ @GI1, %cond.true ], [ %L, %cond.false ]
  %i1 = load i32, i32* %cond, align 4, !tbaa !3
  %i2 = bitcast i32* %L to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* nonnull %i2)
  ret i32 %i1
}

;    static int GI2 __attribute__((loader_uninitialized));
;    int multi_obj_simplifiable_2(int cnd) {
;      int L;
;      int *p = cnd ? &GI2 : &L;
;      *p = 5;
;      return *p;
;    }
;
define i32 @multi_obj_simplifiable_2(i32 %cnd) {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_2
; IS__TUNIT_OPM-SAME: (i32 [[CND:%.*]]) #[[ATTR4]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__TUNIT_OPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__TUNIT_OPM:       cond.true:
; IS__TUNIT_OPM-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT_OPM:       cond.false:
; IS__TUNIT_OPM-NEXT:    br label [[COND_END]]
; IS__TUNIT_OPM:       cond.end:
; IS__TUNIT_OPM-NEXT:    [[I1:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    ret i32 5
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_2
; IS__TUNIT_NPM-SAME: (i32 [[CND:%.*]]) #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__TUNIT_NPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__TUNIT_NPM:       cond.true:
; IS__TUNIT_NPM-NEXT:    br label [[COND_END:%.*]]
; IS__TUNIT_NPM:       cond.false:
; IS__TUNIT_NPM-NEXT:    br label [[COND_END]]
; IS__TUNIT_NPM:       cond.end:
; IS__TUNIT_NPM-NEXT:    [[I1:%.*]] = bitcast i32* [[L]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    ret i32 5
;
; IS__CGSCC_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_2
; IS__CGSCC_OPM-SAME: (i32 [[CND:%.*]]) #[[ATTR3]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__CGSCC_OPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__CGSCC_OPM:       cond.true:
; IS__CGSCC_OPM-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC_OPM:       cond.false:
; IS__CGSCC_OPM-NEXT:    br label [[COND_END]]
; IS__CGSCC_OPM:       cond.end:
; IS__CGSCC_OPM-NEXT:    [[I1:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    ret i32 5
;
; IS__CGSCC_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@multi_obj_simplifiable_2
; IS__CGSCC_NPM-SAME: (i32 [[CND:%.*]]) #[[ATTR3]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[L:%.*]] = alloca i32, align 4
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; IS__CGSCC_NPM-NEXT:    br i1 [[TOBOOL_NOT]], label [[COND_FALSE:%.*]], label [[COND_TRUE:%.*]]
; IS__CGSCC_NPM:       cond.true:
; IS__CGSCC_NPM-NEXT:    br label [[COND_END:%.*]]
; IS__CGSCC_NPM:       cond.false:
; IS__CGSCC_NPM-NEXT:    br label [[COND_END]]
; IS__CGSCC_NPM:       cond.end:
; IS__CGSCC_NPM-NEXT:    [[I1:%.*]] = bitcast i32* [[L]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    ret i32 5
;
entry:
  %L = alloca i32, align 4
  %i = bitcast i32* %L to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* nonnull %i)
  %tobool.not = icmp eq i32 %cnd, 0
  br i1 %tobool.not, label %cond.false, label %cond.true

cond.true:                                        ; preds = %entry
  br label %cond.end

cond.false:                                       ; preds = %entry
  br label %cond.end

cond.end:                                         ; preds = %cond.false, %cond.true
  %cond = phi i32* [ @GI2, %cond.true ], [ %L, %cond.false ]
  store i32 5, i32* %cond, align 4, !tbaa !3
  %i1 = bitcast i32* %L to i8*
  %l = load i32, i32* %cond, align 4, !tbaa !3
  call void @llvm.lifetime.end.p0i8(i64 4, i8* nonnull %i1)
  ret i32 %l
}

;    static struct S Gs __attribute__((loader_uninitialized));
;    struct S static_global_simplifiable_1(void) {
;      Gs.f1 = 1.1;
;      Gs.f2 = 2.2;
;      Gs.f3 = 3.3;
;      write_arg(&Gs.i1, 1);
;      write_arg(&Gs.i2, 2);
;      write_arg(&Gs.i3, 3);
;      struct S r;
;      r.f1 = Gs.f1;
;      r.f2 = Gs.f2 * 2;
;      r.f3 = Gs.f3 + Gs.f1;
;      r.i1 = Gs.i1;
;      r.i2 = Gs.i2 * 2;
;      r.i3 = Gs.i3 + Gs.i1;
;      return r;
;    }
;
define void @static_global_simplifiable_1(%struct.S* noalias sret(%struct.S) align 4 %agg.result) {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@static_global_simplifiable_1
; IS__TUNIT_OPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR5]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i32 0, i32 0), i32 noundef 1) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree writeonly align 4 dereferenceable_or_null(20) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 1), i32 noundef 2) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree writeonly align 4 dereferenceable_or_null(16) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 2), i32 noundef 3) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_OPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__TUNIT_OPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__TUNIT_OPM-NEXT:    store float [[MUL]], float* [[F2]], align 4, !tbaa [[TBAA10]]
; IS__TUNIT_OPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__TUNIT_OPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__TUNIT_OPM-NEXT:    store float [[ADD]], float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_OPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    store i32 1, i32* [[I1]], align 4, !tbaa [[TBAA12]]
; IS__TUNIT_OPM-NEXT:    [[MUL1:%.*]] = shl nsw i32 2, 1
; IS__TUNIT_OPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__TUNIT_OPM-NEXT:    store i32 [[MUL1]], i32* [[I2]], align 4, !tbaa [[TBAA13]]
; IS__TUNIT_OPM-NEXT:    [[ADD2:%.*]] = add nsw i32 3, 1
; IS__TUNIT_OPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__TUNIT_OPM-NEXT:    store i32 [[ADD2]], i32* [[I3]], align 4, !tbaa [[TBAA14]]
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@static_global_simplifiable_1
; IS__TUNIT_NPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i32 0, i32 0), i32 noundef 1) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree writeonly align 4 dereferenceable_or_null(20) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 1), i32 noundef 2) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree writeonly align 4 dereferenceable_or_null(16) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 2), i32 noundef 3) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_NPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__TUNIT_NPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__TUNIT_NPM-NEXT:    store float [[MUL]], float* [[F2]], align 4, !tbaa [[TBAA10]]
; IS__TUNIT_NPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__TUNIT_NPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__TUNIT_NPM-NEXT:    store float [[ADD]], float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_NPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    store i32 1, i32* [[I1]], align 4, !tbaa [[TBAA12]]
; IS__TUNIT_NPM-NEXT:    [[MUL1:%.*]] = shl nsw i32 2, 1
; IS__TUNIT_NPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__TUNIT_NPM-NEXT:    store i32 [[MUL1]], i32* [[I2]], align 4, !tbaa [[TBAA13]]
; IS__TUNIT_NPM-NEXT:    [[ADD2:%.*]] = add nsw i32 3, 1
; IS__TUNIT_NPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__TUNIT_NPM-NEXT:    store i32 [[ADD2]], i32* [[I3]], align 4, !tbaa [[TBAA14]]
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC_OPM: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@static_global_simplifiable_1
; IS__CGSCC_OPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR4:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i32 0, i32 0), i32 noundef 1) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(20) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 1), i32 noundef 2) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(16) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 2), i32 noundef 3) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_OPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__CGSCC_OPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__CGSCC_OPM-NEXT:    store float [[MUL]], float* [[F2]], align 4, !tbaa [[TBAA10]]
; IS__CGSCC_OPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__CGSCC_OPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__CGSCC_OPM-NEXT:    store float [[ADD]], float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_OPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    store i32 1, i32* [[I1]], align 4, !tbaa [[TBAA12]]
; IS__CGSCC_OPM-NEXT:    [[MUL1:%.*]] = shl nsw i32 2, 1
; IS__CGSCC_OPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__CGSCC_OPM-NEXT:    store i32 [[MUL1]], i32* [[I2]], align 4, !tbaa [[TBAA13]]
; IS__CGSCC_OPM-NEXT:    [[ADD2:%.*]] = add nsw i32 3, 1
; IS__CGSCC_OPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__CGSCC_OPM-NEXT:    store i32 [[ADD2]], i32* [[I3]], align 4, !tbaa [[TBAA14]]
; IS__CGSCC_OPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@static_global_simplifiable_1
; IS__CGSCC_NPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]]) #[[ATTR4:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(24) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i32 0, i32 0), i32 noundef 1) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(20) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 1), i32 noundef 2) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(16) getelementptr inbounds ([[STRUCT_S]], %struct.S* @Gs1, i64 0, i32 2), i32 noundef 3) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_NPM-NEXT:    [[MUL:%.*]] = fmul float 0x40019999A0000000, 2.000000e+00
; IS__CGSCC_NPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__CGSCC_NPM-NEXT:    store float [[MUL]], float* [[F2]], align 4, !tbaa [[TBAA10]]
; IS__CGSCC_NPM-NEXT:    [[ADD:%.*]] = fadd float 0x400A666660000000, 0x3FF19999A0000000
; IS__CGSCC_NPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__CGSCC_NPM-NEXT:    store float [[ADD]], float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_NPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    store i32 1, i32* [[I1]], align 4, !tbaa [[TBAA12]]
; IS__CGSCC_NPM-NEXT:    [[MUL1:%.*]] = shl nsw i32 2, 1
; IS__CGSCC_NPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__CGSCC_NPM-NEXT:    store i32 [[MUL1]], i32* [[I2]], align 4, !tbaa [[TBAA13]]
; IS__CGSCC_NPM-NEXT:    [[ADD2:%.*]] = add nsw i32 3, 1
; IS__CGSCC_NPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__CGSCC_NPM-NEXT:    store i32 [[ADD2]], i32* [[I3]], align 4, !tbaa [[TBAA14]]
; IS__CGSCC_NPM-NEXT:    ret void
;
entry:
  store float 0x3FF19999A0000000, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 3), align 4, !tbaa !7
  store float 0x40019999A0000000, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 4), align 4, !tbaa !10
  store float 0x400A666660000000, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 5), align 4, !tbaa !11
  call void @write_arg(i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 0), i32 1)
  call void @write_arg(i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 1), i32 2)
  call void @write_arg(i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 2), i32 3)
  %i = load float, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 3), align 4, !tbaa !7
  %f1 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 3
  store float %i, float* %f1, align 4, !tbaa !7
  %i4 = load float, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 4), align 4, !tbaa !10
  %mul = fmul float %i4, 2.000000e+00
  %f2 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 4
  store float %mul, float* %f2, align 4, !tbaa !10
  %i5 = load float, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 5), align 4, !tbaa !11
  %i6 = load float, float* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 3), align 4, !tbaa !7
  %add = fadd float %i5, %i6
  %f3 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 5
  store float %add, float* %f3, align 4, !tbaa !11
  %i7 = load i32, i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 0), align 4, !tbaa !12
  %i1 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 0
  store i32 %i7, i32* %i1, align 4, !tbaa !12
  %i8 = load i32, i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 1), align 4, !tbaa !13
  %mul1 = shl nsw i32 %i8, 1
  %i2 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 1
  store i32 %mul1, i32* %i2, align 4, !tbaa !13
  %i9 = load i32, i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 2), align 4, !tbaa !14
  %i10 = load i32, i32* getelementptr inbounds (%struct.S, %struct.S* @Gs1, i64 0, i32 0), align 4, !tbaa !12
  %add2 = add nsw i32 %i9, %i10
  %i3 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 2
  store i32 %add2, i32* %i3, align 4, !tbaa !14
  ret void
}

;    static char GBytes[1024];
;    void static_global_simplifiable_2(void) {
;      for (int i = 0; i < 100; ++i)
;        GBytes[i * 10] = 0;
;      for (int i = 0; i < 10; ++i)
;        ((float *)GBytes)[i * 10 + 1] = 0;
;      for (int i = 0; i < 20; ++i)
;        ((long long int *)GBytes)[i * 10 + 2] = 0;
;      GBytes[1023] = 0;
;      write_arg((int *)&GBytes[500], 0);
;      struct S R;
;      for (int i = 0; i < 1024; ++i)
;        globalBytes[i] = GBytes[i];
;    }
;
define void @static_global_simplifiable_2() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@static_global_simplifiable_2
; IS__TUNIT_OPM-SAME: () #[[ATTR6]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__TUNIT_OPM:       for.cond:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END:%.*]]
; IS__TUNIT_OPM:       for.body:
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 [[I]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC]]
; IS__TUNIT_OPM:       for.inc:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
; IS__TUNIT_OPM:       for.end:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__TUNIT_OPM:       for.cond2:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup4:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__TUNIT_OPM:       for.body5:
; IS__TUNIT_OPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__TUNIT_OPM-NEXT:    [[I16:%.*]] = or i64 [[I15]], 1
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* bitcast ([1024 x i8]* @GBytes to float*), i64 [[I16]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC9]]
; IS__TUNIT_OPM:       for.inc9:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP22:![0-9]+]]
; IS__TUNIT_OPM:       for.end11:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__TUNIT_OPM:       for.cond13:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup15:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__TUNIT_OPM:       for.body16:
; IS__TUNIT_OPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__TUNIT_OPM-NEXT:    [[I18:%.*]] = add nuw nsw i64 [[I17]], 2
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* bitcast ([1024 x i8]* @GBytes to i64*), i64 [[I18]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC21]]
; IS__TUNIT_OPM:       for.inc21:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP23:![0-9]+]]
; IS__TUNIT_OPM:       for.end23:
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree writeonly align 4 dereferenceable_or_null(524) bitcast (i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 500) to i32*), i32 noundef 0) #[[ATTR6]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND25:%.*]]
; IS__TUNIT_OPM:       for.cond25:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC33:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY28:%.*]], label [[FOR_COND_CLEANUP27:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup27:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END35:%.*]]
; IS__TUNIT_OPM:       for.body28:
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__TUNIT_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC33]]
; IS__TUNIT_OPM:       for.inc33:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND25]], !llvm.loop [[LOOP24:![0-9]+]]
; IS__TUNIT_OPM:       for.end35:
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@static_global_simplifiable_2
; IS__TUNIT_NPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__TUNIT_NPM:       for.cond:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END:%.*]]
; IS__TUNIT_NPM:       for.body:
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 [[I]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC]]
; IS__TUNIT_NPM:       for.inc:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP21:![0-9]+]]
; IS__TUNIT_NPM:       for.end:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__TUNIT_NPM:       for.cond2:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup4:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__TUNIT_NPM:       for.body5:
; IS__TUNIT_NPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__TUNIT_NPM-NEXT:    [[I16:%.*]] = or i64 [[I15]], 1
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* bitcast ([1024 x i8]* @GBytes to float*), i64 [[I16]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC9]]
; IS__TUNIT_NPM:       for.inc9:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP22:![0-9]+]]
; IS__TUNIT_NPM:       for.end11:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__TUNIT_NPM:       for.cond13:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup15:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__TUNIT_NPM:       for.body16:
; IS__TUNIT_NPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__TUNIT_NPM-NEXT:    [[I18:%.*]] = add nuw nsw i64 [[I17]], 2
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* bitcast ([1024 x i8]* @GBytes to i64*), i64 [[I18]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC21]]
; IS__TUNIT_NPM:       for.inc21:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP23:![0-9]+]]
; IS__TUNIT_NPM:       for.end23:
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree writeonly align 4 dereferenceable_or_null(524) bitcast (i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 500) to i32*), i32 noundef 0) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND25:%.*]]
; IS__TUNIT_NPM:       for.cond25:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC33:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY28:%.*]], label [[FOR_COND_CLEANUP27:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup27:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END35:%.*]]
; IS__TUNIT_NPM:       for.body28:
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__TUNIT_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC33]]
; IS__TUNIT_NPM:       for.inc33:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND25]], !llvm.loop [[LOOP24:![0-9]+]]
; IS__TUNIT_NPM:       for.end35:
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@static_global_simplifiable_2() {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__CGSCC_OPM:       for.cond:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END:%.*]]
; IS__CGSCC_OPM:       for.body:
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 [[I]]
; IS__CGSCC_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 2, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC]]
; IS__CGSCC_OPM:       for.inc:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP24:![0-9]+]]
; IS__CGSCC_OPM:       for.end:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__CGSCC_OPM:       for.cond2:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup4:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__CGSCC_OPM:       for.body5:
; IS__CGSCC_OPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__CGSCC_OPM-NEXT:    [[I16:%.*]] = or i64 [[I15]], 1
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* bitcast ([1024 x i8]* @GBytes to float*), i64 [[I16]]
; IS__CGSCC_OPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA18]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC9]]
; IS__CGSCC_OPM:       for.inc9:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP25:![0-9]+]]
; IS__CGSCC_OPM:       for.end11:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__CGSCC_OPM:       for.cond13:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup15:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__CGSCC_OPM:       for.body16:
; IS__CGSCC_OPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__CGSCC_OPM-NEXT:    [[I18:%.*]] = add nuw nsw i64 [[I17]], 2
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* bitcast ([1024 x i8]* @GBytes to i64*), i64 [[I18]]
; IS__CGSCC_OPM-NEXT:    store i64 0, i64* [[ARRAYIDX20]], align 16, !tbaa [[TBAA20]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC21]]
; IS__CGSCC_OPM:       for.inc21:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP26:![0-9]+]]
; IS__CGSCC_OPM:       for.end23:
; IS__CGSCC_OPM-NEXT:    store i8 0, i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 1023), align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nofree noundef nonnull writeonly align 4 dereferenceable(4) bitcast (i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 500) to i32*), i32 noundef 0) #[[ATTR13]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND25:%.*]]
; IS__CGSCC_OPM:       for.cond25:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC33:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY28:%.*]], label [[FOR_COND_CLEANUP27:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup27:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END35:%.*]]
; IS__CGSCC_OPM:       for.body28:
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX30:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_OPM-NEXT:    [[I19:%.*]] = load i8, i8* [[ARRAYIDX30]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_OPM-NEXT:    store i8 [[I19]], i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC33]]
; IS__CGSCC_OPM:       for.inc33:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND25]], !llvm.loop [[LOOP27:![0-9]+]]
; IS__CGSCC_OPM:       for.end35:
; IS__CGSCC_OPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@static_global_simplifiable_2() {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__CGSCC_NPM:       for.cond:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END:%.*]]
; IS__CGSCC_NPM:       for.body:
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 [[I]]
; IS__CGSCC_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 2, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC]]
; IS__CGSCC_NPM:       for.inc:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP24:![0-9]+]]
; IS__CGSCC_NPM:       for.end:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__CGSCC_NPM:       for.cond2:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup4:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__CGSCC_NPM:       for.body5:
; IS__CGSCC_NPM-NEXT:    [[I15:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__CGSCC_NPM-NEXT:    [[I16:%.*]] = or i64 [[I15]], 1
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* bitcast ([1024 x i8]* @GBytes to float*), i64 [[I16]]
; IS__CGSCC_NPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA18]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC9]]
; IS__CGSCC_NPM:       for.inc9:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP25:![0-9]+]]
; IS__CGSCC_NPM:       for.end11:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__CGSCC_NPM:       for.cond13:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup15:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__CGSCC_NPM:       for.body16:
; IS__CGSCC_NPM-NEXT:    [[I17:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__CGSCC_NPM-NEXT:    [[I18:%.*]] = add nuw nsw i64 [[I17]], 2
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* bitcast ([1024 x i8]* @GBytes to i64*), i64 [[I18]]
; IS__CGSCC_NPM-NEXT:    store i64 0, i64* [[ARRAYIDX20]], align 16, !tbaa [[TBAA20]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC21]]
; IS__CGSCC_NPM:       for.inc21:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP26:![0-9]+]]
; IS__CGSCC_NPM:       for.end23:
; IS__CGSCC_NPM-NEXT:    store i8 0, i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 1023), align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nofree noundef nonnull writeonly align 4 dereferenceable(4) bitcast (i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 500) to i32*), i32 noundef 0) #[[ATTR10]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND25:%.*]]
; IS__CGSCC_NPM:       for.cond25:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC33:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY28:%.*]], label [[FOR_COND_CLEANUP27:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup27:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END35:%.*]]
; IS__CGSCC_NPM:       for.body28:
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX30:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_NPM-NEXT:    [[I19:%.*]] = load i8, i8* [[ARRAYIDX30]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_NPM-NEXT:    store i8 [[I19]], i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC33]]
; IS__CGSCC_NPM:       for.inc33:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND25]], !llvm.loop [[LOOP27:![0-9]+]]
; IS__CGSCC_NPM:       for.end35:
; IS__CGSCC_NPM-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %indvars.iv = phi i64 [ %indvars.iv.next, %for.inc ], [ 0, %entry ]
  %exitcond = icmp ne i64 %indvars.iv, 100
  br i1 %exitcond, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  br label %for.end

for.body:                                         ; preds = %for.cond
  %i = mul nuw nsw i64 %indvars.iv, 10
  %arrayidx = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 %i
  store i8 0, i8* %arrayidx, align 2, !tbaa !15
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  br label %for.cond, !llvm.loop !24

for.end:                                          ; preds = %for.cond.cleanup
  br label %for.cond2

for.cond2:                                        ; preds = %for.inc9, %for.end
  %indvars.iv2 = phi i64 [ %indvars.iv.next3, %for.inc9 ], [ 0, %for.end ]
  %exitcond6 = icmp ne i64 %indvars.iv2, 10
  br i1 %exitcond6, label %for.body5, label %for.cond.cleanup4

for.cond.cleanup4:                                ; preds = %for.cond2
  br label %for.end11

for.body5:                                        ; preds = %for.cond2
  %i15 = mul nuw nsw i64 %indvars.iv2, 10
  %i16 = or i64 %i15, 1
  %arrayidx8 = getelementptr inbounds float, float* bitcast ([1024 x i8]* @GBytes to float*), i64 %i16
  store float 0.000000e+00, float* %arrayidx8, align 4, !tbaa !18
  br label %for.inc9

for.inc9:                                         ; preds = %for.body5
  %indvars.iv.next3 = add nuw nsw i64 %indvars.iv2, 1
  br label %for.cond2, !llvm.loop !25

for.end11:                                        ; preds = %for.cond.cleanup4
  br label %for.cond13

for.cond13:                                       ; preds = %for.inc21, %for.end11
  %indvars.iv7 = phi i64 [ %indvars.iv.next8, %for.inc21 ], [ 0, %for.end11 ]
  %exitcond11 = icmp ne i64 %indvars.iv7, 20
  br i1 %exitcond11, label %for.body16, label %for.cond.cleanup15

for.cond.cleanup15:                               ; preds = %for.cond13
  br label %for.end23

for.body16:                                       ; preds = %for.cond13
  %i17 = mul nuw nsw i64 %indvars.iv7, 10
  %i18 = add nuw nsw i64 %i17, 2
  %arrayidx20 = getelementptr inbounds i64, i64* bitcast ([1024 x i8]* @GBytes to i64*), i64 %i18
  store i64 0, i64* %arrayidx20, align 16, !tbaa !20
  br label %for.inc21

for.inc21:                                        ; preds = %for.body16
  %indvars.iv.next8 = add nuw nsw i64 %indvars.iv7, 1
  br label %for.cond13, !llvm.loop !26

for.end23:                                        ; preds = %for.cond.cleanup15
  store i8 0, i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 1023), align 1, !tbaa !15
  call void @write_arg(i32* bitcast (i8* getelementptr inbounds ([1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 500) to i32*), i32 0)
  br label %for.cond25

for.cond25:                                       ; preds = %for.inc33, %for.end23
  %indvars.iv12 = phi i64 [ %indvars.iv.next13, %for.inc33 ], [ 0, %for.end23 ]
  %exitcond14 = icmp ne i64 %indvars.iv12, 1024
  br i1 %exitcond14, label %for.body28, label %for.cond.cleanup27

for.cond.cleanup27:                               ; preds = %for.cond25
  br label %for.end35

for.body28:                                       ; preds = %for.cond25
  %arrayidx30 = getelementptr inbounds [1024 x i8], [1024 x i8]* @GBytes, i64 0, i64 %indvars.iv12
  %i19 = load i8, i8* %arrayidx30, align 1, !tbaa !15
  %arrayidx32 = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 %indvars.iv12
  store i8 %i19, i8* %arrayidx32, align 1, !tbaa !15
  br label %for.inc33

for.inc33:                                        ; preds = %for.body28
  %indvars.iv.next13 = add nuw nsw i64 %indvars.iv12, 1
  br label %for.cond25, !llvm.loop !27

for.end35:                                        ; preds = %for.cond.cleanup27
  ret void
}

;    static int Flag3;
;    int static_global_simplifiable_3() {
;      Flag3 = 1;
;      return Flag3;
;    }
define i32 @static_global_simplifiable_3() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@static_global_simplifiable_3
; IS__TUNIT_OPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_OPM-NEXT:    store i32 1, i32* @Flag3, align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = load i32, i32* @Flag3, align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    ret i32 [[I]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@static_global_simplifiable_3
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:    store i32 1, i32* @Flag3, align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = load i32, i32* @Flag3, align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    ret i32 [[I]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@static_global_simplifiable_3
; IS__CGSCC____-SAME: () #[[ATTR5:[0-9]+]] {
; IS__CGSCC____-NEXT:    store i32 1, i32* @Flag3, align 4, !tbaa [[TBAA3]]
; IS__CGSCC____-NEXT:    [[I:%.*]] = load i32, i32* @Flag3, align 4, !tbaa [[TBAA3]]
; IS__CGSCC____-NEXT:    ret i32 [[I]]
;
  store i32 1, i32* @Flag3, align 4, !tbaa !3
  %i = load i32, i32* @Flag3, align 4, !tbaa !3
  ret i32 %i
}

;    struct S noalias_arg_simplifiable_1(struct S s) {
;      s.f1 = 1.1;
;      s.f2 = 2.2;
;      s.f3 = 3.3;
;      write_arg(&s.i1, 1);
;      write_arg(&s.i2, 2);
;      write_arg(&s.i3, 3);
;      struct S r;
;      r.f1 = s.f1;
;      r.f2 = s.f2 * 2;
;      r.f3 = s.f3 + s.f1;
;      r.i1 = s.i1;
;      r.i2 = s.i2 * 2;
;      r.i3 = s.i3 + s.i1;
;      return r;
;    }
;
define void @noalias_arg_simplifiable_1(%struct.S* noalias sret(%struct.S) align 4 %agg.result, %struct.S* byval(%struct.S) align 8 %s) {
; IS__TUNIT_OPM: Function Attrs: argmemonly nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_1
; IS__TUNIT_OPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]], %struct.S* noalias nocapture nofree nonnull byval([[STRUCT_S]]) align 8 dereferenceable(24) [[S:%.*]]) #[[ATTR1]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_OPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__TUNIT_OPM-NEXT:    store float 0x40019999A0000000, float* [[F2]], align 8, !tbaa [[TBAA10]]
; IS__TUNIT_OPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__TUNIT_OPM-NEXT:    store float 0x400A666660000000, float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_OPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 8 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 8 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR5]]
; IS__TUNIT_OPM-NEXT:    [[F11:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = load float, float* [[F11]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_OPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    store float [[I]], float* [[F12]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_OPM-NEXT:    [[F23:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__TUNIT_OPM-NEXT:    [[I4:%.*]] = load float, float* [[F23]], align 8, !tbaa [[TBAA10]]
; IS__TUNIT_OPM-NEXT:    [[MUL:%.*]] = fmul float [[I4]], 2.000000e+00
; IS__TUNIT_OPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__TUNIT_OPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10]]
; IS__TUNIT_OPM-NEXT:    [[F35:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__TUNIT_OPM-NEXT:    [[I5:%.*]] = load float, float* [[F35]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_OPM-NEXT:    [[F16:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_OPM-NEXT:    [[I6:%.*]] = load float, float* [[F16]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_OPM-NEXT:    [[ADD:%.*]] = fadd float [[I5]], [[I6]]
; IS__TUNIT_OPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__TUNIT_OPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_OPM-NEXT:    [[I18:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    [[I7:%.*]] = load i32, i32* [[I18]], align 8, !tbaa [[TBAA12]]
; IS__TUNIT_OPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    store i32 [[I7]], i32* [[I19]], align 4, !tbaa [[TBAA12]]
; IS__TUNIT_OPM-NEXT:    [[I210:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__TUNIT_OPM-NEXT:    [[I8:%.*]] = load i32, i32* [[I210]], align 4, !tbaa [[TBAA13]]
; IS__TUNIT_OPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 [[I8]], 1
; IS__TUNIT_OPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__TUNIT_OPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13]]
; IS__TUNIT_OPM-NEXT:    [[I313:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT_OPM-NEXT:    [[I9:%.*]] = load i32, i32* [[I313]], align 8, !tbaa [[TBAA14]]
; IS__TUNIT_OPM-NEXT:    [[I114:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_OPM-NEXT:    [[I10:%.*]] = load i32, i32* [[I114]], align 8, !tbaa [[TBAA12]]
; IS__TUNIT_OPM-NEXT:    [[ADD15:%.*]] = add nsw i32 [[I9]], [[I10]]
; IS__TUNIT_OPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__TUNIT_OPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14]]
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: argmemonly nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_1
; IS__TUNIT_NPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]], %struct.S* noalias nocapture nofree nonnull byval([[STRUCT_S]]) align 8 dereferenceable(24) [[S:%.*]]) #[[ATTR1]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_NPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__TUNIT_NPM-NEXT:    store float 0x40019999A0000000, float* [[F2]], align 8, !tbaa [[TBAA10]]
; IS__TUNIT_NPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__TUNIT_NPM-NEXT:    store float 0x400A666660000000, float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_NPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 8 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 8 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    [[F11:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = load float, float* [[F11]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_NPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    store float [[I]], float* [[F12]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_NPM-NEXT:    [[F23:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__TUNIT_NPM-NEXT:    [[I4:%.*]] = load float, float* [[F23]], align 8, !tbaa [[TBAA10]]
; IS__TUNIT_NPM-NEXT:    [[MUL:%.*]] = fmul float [[I4]], 2.000000e+00
; IS__TUNIT_NPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__TUNIT_NPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10]]
; IS__TUNIT_NPM-NEXT:    [[F35:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__TUNIT_NPM-NEXT:    [[I5:%.*]] = load float, float* [[F35]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_NPM-NEXT:    [[F16:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__TUNIT_NPM-NEXT:    [[I6:%.*]] = load float, float* [[F16]], align 4, !tbaa [[TBAA7]]
; IS__TUNIT_NPM-NEXT:    [[ADD:%.*]] = fadd float [[I5]], [[I6]]
; IS__TUNIT_NPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__TUNIT_NPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11]]
; IS__TUNIT_NPM-NEXT:    [[I18:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    [[I7:%.*]] = load i32, i32* [[I18]], align 8, !tbaa [[TBAA12]]
; IS__TUNIT_NPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    store i32 [[I7]], i32* [[I19]], align 4, !tbaa [[TBAA12]]
; IS__TUNIT_NPM-NEXT:    [[I210:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__TUNIT_NPM-NEXT:    [[I8:%.*]] = load i32, i32* [[I210]], align 4, !tbaa [[TBAA13]]
; IS__TUNIT_NPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 [[I8]], 1
; IS__TUNIT_NPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__TUNIT_NPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13]]
; IS__TUNIT_NPM-NEXT:    [[I313:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT_NPM-NEXT:    [[I9:%.*]] = load i32, i32* [[I313]], align 8, !tbaa [[TBAA14]]
; IS__TUNIT_NPM-NEXT:    [[I114:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__TUNIT_NPM-NEXT:    [[I10:%.*]] = load i32, i32* [[I114]], align 8, !tbaa [[TBAA12]]
; IS__TUNIT_NPM-NEXT:    [[ADD15:%.*]] = add nsw i32 [[I9]], [[I10]]
; IS__TUNIT_NPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__TUNIT_NPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14]]
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC_OPM: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_1
; IS__CGSCC_OPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]], %struct.S* noalias nocapture nofree nonnull byval([[STRUCT_S]]) align 8 dereferenceable(24) [[S:%.*]]) #[[ATTR6:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_OPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__CGSCC_OPM-NEXT:    store float 0x40019999A0000000, float* [[F2]], align 8, !tbaa [[TBAA10]]
; IS__CGSCC_OPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__CGSCC_OPM-NEXT:    store float 0x400A666660000000, float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_OPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 8 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 8 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR12]]
; IS__CGSCC_OPM-NEXT:    [[F11:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = load float, float* [[F11]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_OPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    store float [[I]], float* [[F12]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_OPM-NEXT:    [[F23:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__CGSCC_OPM-NEXT:    [[I4:%.*]] = load float, float* [[F23]], align 8, !tbaa [[TBAA10]]
; IS__CGSCC_OPM-NEXT:    [[MUL:%.*]] = fmul float [[I4]], 2.000000e+00
; IS__CGSCC_OPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__CGSCC_OPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10]]
; IS__CGSCC_OPM-NEXT:    [[F35:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__CGSCC_OPM-NEXT:    [[I5:%.*]] = load float, float* [[F35]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_OPM-NEXT:    [[F16:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_OPM-NEXT:    [[I6:%.*]] = load float, float* [[F16]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_OPM-NEXT:    [[ADD:%.*]] = fadd float [[I5]], [[I6]]
; IS__CGSCC_OPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__CGSCC_OPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_OPM-NEXT:    [[I18:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    [[I7:%.*]] = load i32, i32* [[I18]], align 8, !tbaa [[TBAA12]]
; IS__CGSCC_OPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    store i32 [[I7]], i32* [[I19]], align 4, !tbaa [[TBAA12]]
; IS__CGSCC_OPM-NEXT:    [[I210:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__CGSCC_OPM-NEXT:    [[I8:%.*]] = load i32, i32* [[I210]], align 4, !tbaa [[TBAA13]]
; IS__CGSCC_OPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 [[I8]], 1
; IS__CGSCC_OPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__CGSCC_OPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13]]
; IS__CGSCC_OPM-NEXT:    [[I313:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC_OPM-NEXT:    [[I9:%.*]] = load i32, i32* [[I313]], align 8, !tbaa [[TBAA14]]
; IS__CGSCC_OPM-NEXT:    [[I114:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_OPM-NEXT:    [[I10:%.*]] = load i32, i32* [[I114]], align 8, !tbaa [[TBAA12]]
; IS__CGSCC_OPM-NEXT:    [[ADD15:%.*]] = add nsw i32 [[I9]], [[I10]]
; IS__CGSCC_OPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__CGSCC_OPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14]]
; IS__CGSCC_OPM-NEXT:    ret void
;
; IS__CGSCC_NPM: Function Attrs: argmemonly nofree norecurse nosync nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_1
; IS__CGSCC_NPM-SAME: (%struct.S* noalias nocapture nofree nonnull writeonly sret([[STRUCT_S:%.*]]) align 4 dereferenceable(24) [[AGG_RESULT:%.*]], %struct.S* noalias nocapture nofree nonnull byval([[STRUCT_S]]) align 8 dereferenceable(24) [[S:%.*]]) #[[ATTR6:[0-9]+]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[F1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    store float 0x3FF19999A0000000, float* [[F1]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_NPM-NEXT:    [[F2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__CGSCC_NPM-NEXT:    store float 0x40019999A0000000, float* [[F2]], align 8, !tbaa [[TBAA10]]
; IS__CGSCC_NPM-NEXT:    [[F3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__CGSCC_NPM-NEXT:    store float 0x400A666660000000, float* [[F3]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_NPM-NEXT:    [[I1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 8 dereferenceable(24) [[I1]], i32 noundef 1) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    [[I2:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 4 dereferenceable(20) [[I2]], i32 noundef 2) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    [[I3:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nocapture nofree noundef nonnull writeonly align 8 dereferenceable(16) [[I3]], i32 noundef 3) #[[ATTR9]]
; IS__CGSCC_NPM-NEXT:    [[F11:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = load float, float* [[F11]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_NPM-NEXT:    [[F12:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    store float [[I]], float* [[F12]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_NPM-NEXT:    [[F23:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 4
; IS__CGSCC_NPM-NEXT:    [[I4:%.*]] = load float, float* [[F23]], align 8, !tbaa [[TBAA10]]
; IS__CGSCC_NPM-NEXT:    [[MUL:%.*]] = fmul float [[I4]], 2.000000e+00
; IS__CGSCC_NPM-NEXT:    [[F24:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 4
; IS__CGSCC_NPM-NEXT:    store float [[MUL]], float* [[F24]], align 4, !tbaa [[TBAA10]]
; IS__CGSCC_NPM-NEXT:    [[F35:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 5
; IS__CGSCC_NPM-NEXT:    [[I5:%.*]] = load float, float* [[F35]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_NPM-NEXT:    [[F16:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 3
; IS__CGSCC_NPM-NEXT:    [[I6:%.*]] = load float, float* [[F16]], align 4, !tbaa [[TBAA7]]
; IS__CGSCC_NPM-NEXT:    [[ADD:%.*]] = fadd float [[I5]], [[I6]]
; IS__CGSCC_NPM-NEXT:    [[F37:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 5
; IS__CGSCC_NPM-NEXT:    store float [[ADD]], float* [[F37]], align 4, !tbaa [[TBAA11]]
; IS__CGSCC_NPM-NEXT:    [[I18:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    [[I7:%.*]] = load i32, i32* [[I18]], align 8, !tbaa [[TBAA12]]
; IS__CGSCC_NPM-NEXT:    [[I19:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    store i32 [[I7]], i32* [[I19]], align 4, !tbaa [[TBAA12]]
; IS__CGSCC_NPM-NEXT:    [[I210:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 1
; IS__CGSCC_NPM-NEXT:    [[I8:%.*]] = load i32, i32* [[I210]], align 4, !tbaa [[TBAA13]]
; IS__CGSCC_NPM-NEXT:    [[MUL11:%.*]] = shl nsw i32 [[I8]], 1
; IS__CGSCC_NPM-NEXT:    [[I212:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 1
; IS__CGSCC_NPM-NEXT:    store i32 [[MUL11]], i32* [[I212]], align 4, !tbaa [[TBAA13]]
; IS__CGSCC_NPM-NEXT:    [[I313:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC_NPM-NEXT:    [[I9:%.*]] = load i32, i32* [[I313]], align 8, !tbaa [[TBAA14]]
; IS__CGSCC_NPM-NEXT:    [[I114:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 0
; IS__CGSCC_NPM-NEXT:    [[I10:%.*]] = load i32, i32* [[I114]], align 8, !tbaa [[TBAA12]]
; IS__CGSCC_NPM-NEXT:    [[ADD15:%.*]] = add nsw i32 [[I9]], [[I10]]
; IS__CGSCC_NPM-NEXT:    [[I316:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[AGG_RESULT]], i64 0, i32 2
; IS__CGSCC_NPM-NEXT:    store i32 [[ADD15]], i32* [[I316]], align 4, !tbaa [[TBAA14]]
; IS__CGSCC_NPM-NEXT:    ret void
;
entry:
  %f1 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 3
  store float 0x3FF19999A0000000, float* %f1, align 4, !tbaa !7
  %f2 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 4
  store float 0x40019999A0000000, float* %f2, align 8, !tbaa !10
  %f3 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 5
  store float 0x400A666660000000, float* %f3, align 4, !tbaa !11
  %i1 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 0
  call void @write_arg(i32* nonnull %i1, i32 1)
  %i2 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 1
  call void @write_arg(i32* nonnull %i2, i32 2)
  %i3 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 2
  call void @write_arg(i32* nonnull %i3, i32 3)
  %f11 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 3
  %i = load float, float* %f11, align 4, !tbaa !7
  %f12 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 3
  store float %i, float* %f12, align 4, !tbaa !7
  %f23 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 4
  %i4 = load float, float* %f23, align 8, !tbaa !10
  %mul = fmul float %i4, 2.000000e+00
  %f24 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 4
  store float %mul, float* %f24, align 4, !tbaa !10
  %f35 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 5
  %i5 = load float, float* %f35, align 4, !tbaa !11
  %f16 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 3
  %i6 = load float, float* %f16, align 4, !tbaa !7
  %add = fadd float %i5, %i6
  %f37 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 5
  store float %add, float* %f37, align 4, !tbaa !11
  %i18 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 0
  %i7 = load i32, i32* %i18, align 8, !tbaa !12
  %i19 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 0
  store i32 %i7, i32* %i19, align 4, !tbaa !12
  %i210 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 1
  %i8 = load i32, i32* %i210, align 4, !tbaa !13
  %mul11 = shl nsw i32 %i8, 1
  %i212 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 1
  store i32 %mul11, i32* %i212, align 4, !tbaa !13
  %i313 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 2
  %i9 = load i32, i32* %i313, align 8, !tbaa !14
  %i114 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 0
  %i10 = load i32, i32* %i114, align 8, !tbaa !12
  %add15 = add nsw i32 %i9, %i10
  %i316 = getelementptr inbounds %struct.S, %struct.S* %agg.result, i64 0, i32 2
  store i32 %add15, i32* %i316, align 4, !tbaa !14
  ret void
}

;    void noalias_arg_simplifiable_2(char Bytes[1024]) {
;      for (int i = 0; i < 100; ++i)
;        Bytes[i * 10] = 0;
;      for (int i = 0; i < 10; ++i)
;        ((float *)Bytes)[i * 10 + 1] = 0;
;      for (int i = 0; i < 20; ++i)
;        ((long long int *)Bytes)[i * 10 + 2] = 0;
;      Bytes[1023] = 0;
;      write_arg((int *)&Bytes[500], 0);
;      struct S R;
;      for (int i = 0; i < 1024; ++i)
;        globalBytes[i] = Bytes[i];
;    }
;
define void @noalias_arg_simplifiable_2(i8* %Bytes) {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_2
; IS__TUNIT_OPM-SAME: (i8* nocapture nofree [[BYTES:%.*]]) #[[ATTR2]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__TUNIT_OPM:       for.cond:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END:%.*]]
; IS__TUNIT_OPM:       for.body:
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[I]]
; IS__TUNIT_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC]]
; IS__TUNIT_OPM:       for.inc:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
; IS__TUNIT_OPM:       for.end:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__TUNIT_OPM:       for.cond2:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup4:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__TUNIT_OPM:       for.body5:
; IS__TUNIT_OPM-NEXT:    [[I15:%.*]] = bitcast i8* [[BYTES]] to float*
; IS__TUNIT_OPM-NEXT:    [[I16:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__TUNIT_OPM-NEXT:    [[I17:%.*]] = or i64 [[I16]], 1
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I15]], i64 [[I17]]
; IS__TUNIT_OPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA26:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC9]]
; IS__TUNIT_OPM:       for.inc9:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP27:![0-9]+]]
; IS__TUNIT_OPM:       for.end11:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__TUNIT_OPM:       for.cond13:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup15:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__TUNIT_OPM:       for.body16:
; IS__TUNIT_OPM-NEXT:    [[I18:%.*]] = bitcast i8* [[BYTES]] to i64*
; IS__TUNIT_OPM-NEXT:    [[I19:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__TUNIT_OPM-NEXT:    [[I20:%.*]] = add nuw nsw i64 [[I19]], 2
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* [[I18]], i64 [[I20]]
; IS__TUNIT_OPM-NEXT:    store i64 0, i64* [[ARRAYIDX20]], align 8, !tbaa [[TBAA28:![0-9]+]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC21]]
; IS__TUNIT_OPM:       for.inc21:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP30:![0-9]+]]
; IS__TUNIT_OPM:       for.end23:
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX24:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 1023
; IS__TUNIT_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX24]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 500
; IS__TUNIT_OPM-NEXT:    [[I21:%.*]] = bitcast i8* [[ARRAYIDX25]] to i32*
; IS__TUNIT_OPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 [[I21]], i32 noundef 0) #[[ATTR6]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND27:%.*]]
; IS__TUNIT_OPM:       for.cond27:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC35:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__TUNIT_OPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__TUNIT_OPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY30:%.*]], label [[FOR_COND_CLEANUP29:%.*]]
; IS__TUNIT_OPM:       for.cond.cleanup29:
; IS__TUNIT_OPM-NEXT:    br label [[FOR_END37:%.*]]
; IS__TUNIT_OPM:       for.body30:
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[INDVARS_IV12]]
; IS__TUNIT_OPM-NEXT:    [[I22:%.*]] = load i8, i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_OPM-NEXT:    [[ARRAYIDX34:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__TUNIT_OPM-NEXT:    store i8 [[I22]], i8* [[ARRAYIDX34]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_OPM-NEXT:    br label [[FOR_INC35]]
; IS__TUNIT_OPM:       for.inc35:
; IS__TUNIT_OPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__TUNIT_OPM-NEXT:    br label [[FOR_COND27]], !llvm.loop [[LOOP31:![0-9]+]]
; IS__TUNIT_OPM:       for.end37:
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_2
; IS__TUNIT_NPM-SAME: (i8* nocapture nofree [[BYTES:%.*]]) #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__TUNIT_NPM:       for.cond:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END:%.*]]
; IS__TUNIT_NPM:       for.body:
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[I]]
; IS__TUNIT_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC]]
; IS__TUNIT_NPM:       for.inc:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP25:![0-9]+]]
; IS__TUNIT_NPM:       for.end:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__TUNIT_NPM:       for.cond2:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup4:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__TUNIT_NPM:       for.body5:
; IS__TUNIT_NPM-NEXT:    [[I15:%.*]] = bitcast i8* [[BYTES]] to float*
; IS__TUNIT_NPM-NEXT:    [[I16:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__TUNIT_NPM-NEXT:    [[I17:%.*]] = or i64 [[I16]], 1
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I15]], i64 [[I17]]
; IS__TUNIT_NPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA26:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC9]]
; IS__TUNIT_NPM:       for.inc9:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP27:![0-9]+]]
; IS__TUNIT_NPM:       for.end11:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__TUNIT_NPM:       for.cond13:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup15:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__TUNIT_NPM:       for.body16:
; IS__TUNIT_NPM-NEXT:    [[I18:%.*]] = bitcast i8* [[BYTES]] to i64*
; IS__TUNIT_NPM-NEXT:    [[I19:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__TUNIT_NPM-NEXT:    [[I20:%.*]] = add nuw nsw i64 [[I19]], 2
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* [[I18]], i64 [[I20]]
; IS__TUNIT_NPM-NEXT:    store i64 0, i64* [[ARRAYIDX20]], align 8, !tbaa [[TBAA28:![0-9]+]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC21]]
; IS__TUNIT_NPM:       for.inc21:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP30:![0-9]+]]
; IS__TUNIT_NPM:       for.end23:
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX24:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 1023
; IS__TUNIT_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX24]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 500
; IS__TUNIT_NPM-NEXT:    [[I21:%.*]] = bitcast i8* [[ARRAYIDX25]] to i32*
; IS__TUNIT_NPM-NEXT:    call void @write_arg(i32* nocapture nofree nonnull writeonly align 4 [[I21]], i32 noundef 0) #[[ATTR4]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND27:%.*]]
; IS__TUNIT_NPM:       for.cond27:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC35:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__TUNIT_NPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__TUNIT_NPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY30:%.*]], label [[FOR_COND_CLEANUP29:%.*]]
; IS__TUNIT_NPM:       for.cond.cleanup29:
; IS__TUNIT_NPM-NEXT:    br label [[FOR_END37:%.*]]
; IS__TUNIT_NPM:       for.body30:
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[INDVARS_IV12]]
; IS__TUNIT_NPM-NEXT:    [[I22:%.*]] = load i8, i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_NPM-NEXT:    [[ARRAYIDX34:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__TUNIT_NPM-NEXT:    store i8 [[I22]], i8* [[ARRAYIDX34]], align 1, !tbaa [[TBAA19]]
; IS__TUNIT_NPM-NEXT:    br label [[FOR_INC35]]
; IS__TUNIT_NPM:       for.inc35:
; IS__TUNIT_NPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__TUNIT_NPM-NEXT:    br label [[FOR_COND27]], !llvm.loop [[LOOP31:![0-9]+]]
; IS__TUNIT_NPM:       for.end37:
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_2
; IS__CGSCC_OPM-SAME: (i8* [[BYTES:%.*]]) {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__CGSCC_OPM:       for.cond:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END:%.*]]
; IS__CGSCC_OPM:       for.body:
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[I]]
; IS__CGSCC_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC]]
; IS__CGSCC_OPM:       for.inc:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
; IS__CGSCC_OPM:       for.end:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__CGSCC_OPM:       for.cond2:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup4:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__CGSCC_OPM:       for.body5:
; IS__CGSCC_OPM-NEXT:    [[I15:%.*]] = bitcast i8* [[BYTES]] to float*
; IS__CGSCC_OPM-NEXT:    [[I16:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__CGSCC_OPM-NEXT:    [[I17:%.*]] = or i64 [[I16]], 1
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I15]], i64 [[I17]]
; IS__CGSCC_OPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA18]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC9]]
; IS__CGSCC_OPM:       for.inc9:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP29:![0-9]+]]
; IS__CGSCC_OPM:       for.end11:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__CGSCC_OPM:       for.cond13:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup15:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__CGSCC_OPM:       for.body16:
; IS__CGSCC_OPM-NEXT:    [[I18:%.*]] = bitcast i8* [[BYTES]] to i64*
; IS__CGSCC_OPM-NEXT:    [[I19:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__CGSCC_OPM-NEXT:    [[I20:%.*]] = add nuw nsw i64 [[I19]], 2
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* [[I18]], i64 [[I20]]
; IS__CGSCC_OPM-NEXT:    store i64 0, i64* [[ARRAYIDX20]], align 8, !tbaa [[TBAA20]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC21]]
; IS__CGSCC_OPM:       for.inc21:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP30:![0-9]+]]
; IS__CGSCC_OPM:       for.end23:
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX24:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 1023
; IS__CGSCC_OPM-NEXT:    store i8 0, i8* [[ARRAYIDX24]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 500
; IS__CGSCC_OPM-NEXT:    [[I21:%.*]] = bitcast i8* [[ARRAYIDX25]] to i32*
; IS__CGSCC_OPM-NEXT:    call void @write_arg(i32* nofree noundef nonnull writeonly align 4 dereferenceable(4) [[I21]], i32 noundef 0) #[[ATTR13]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND27:%.*]]
; IS__CGSCC_OPM:       for.cond27:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC35:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__CGSCC_OPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__CGSCC_OPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY30:%.*]], label [[FOR_COND_CLEANUP29:%.*]]
; IS__CGSCC_OPM:       for.cond.cleanup29:
; IS__CGSCC_OPM-NEXT:    br label [[FOR_END37:%.*]]
; IS__CGSCC_OPM:       for.body30:
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[INDVARS_IV12]]
; IS__CGSCC_OPM-NEXT:    [[I22:%.*]] = load i8, i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    [[ARRAYIDX34:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_OPM-NEXT:    store i8 [[I22]], i8* [[ARRAYIDX34]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_OPM-NEXT:    br label [[FOR_INC35]]
; IS__CGSCC_OPM:       for.inc35:
; IS__CGSCC_OPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__CGSCC_OPM-NEXT:    br label [[FOR_COND27]], !llvm.loop [[LOOP31:![0-9]+]]
; IS__CGSCC_OPM:       for.end37:
; IS__CGSCC_OPM-NEXT:    ret void
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@noalias_arg_simplifiable_2
; IS__CGSCC_NPM-SAME: (i8* [[BYTES:%.*]]) {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND:%.*]]
; IS__CGSCC_NPM:       for.cond:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_INC:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], 100
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY:%.*]], label [[FOR_COND_CLEANUP:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END:%.*]]
; IS__CGSCC_NPM:       for.body:
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = mul nuw nsw i64 [[INDVARS_IV]], 10
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[I]]
; IS__CGSCC_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC]]
; IS__CGSCC_NPM:       for.inc:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND]], !llvm.loop [[LOOP28:![0-9]+]]
; IS__CGSCC_NPM:       for.end:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND2:%.*]]
; IS__CGSCC_NPM:       for.cond2:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV2:%.*]] = phi i64 [ [[INDVARS_IV_NEXT3:%.*]], [[FOR_INC9:%.*]] ], [ 0, [[FOR_END]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV2]], 10
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND6]], label [[FOR_BODY5:%.*]], label [[FOR_COND_CLEANUP4:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup4:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END11:%.*]]
; IS__CGSCC_NPM:       for.body5:
; IS__CGSCC_NPM-NEXT:    [[I15:%.*]] = bitcast i8* [[BYTES]] to float*
; IS__CGSCC_NPM-NEXT:    [[I16:%.*]] = mul nuw nsw i64 [[INDVARS_IV2]], 10
; IS__CGSCC_NPM-NEXT:    [[I17:%.*]] = or i64 [[I16]], 1
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX8:%.*]] = getelementptr inbounds float, float* [[I15]], i64 [[I17]]
; IS__CGSCC_NPM-NEXT:    store float 0.000000e+00, float* [[ARRAYIDX8]], align 4, !tbaa [[TBAA18]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC9]]
; IS__CGSCC_NPM:       for.inc9:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT3]] = add nuw nsw i64 [[INDVARS_IV2]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND2]], !llvm.loop [[LOOP29:![0-9]+]]
; IS__CGSCC_NPM:       for.end11:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND13:%.*]]
; IS__CGSCC_NPM:       for.cond13:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV7:%.*]] = phi i64 [ [[INDVARS_IV_NEXT8:%.*]], [[FOR_INC21:%.*]] ], [ 0, [[FOR_END11]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND11:%.*]] = icmp ne i64 [[INDVARS_IV7]], 20
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND11]], label [[FOR_BODY16:%.*]], label [[FOR_COND_CLEANUP15:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup15:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END23:%.*]]
; IS__CGSCC_NPM:       for.body16:
; IS__CGSCC_NPM-NEXT:    [[I18:%.*]] = bitcast i8* [[BYTES]] to i64*
; IS__CGSCC_NPM-NEXT:    [[I19:%.*]] = mul nuw nsw i64 [[INDVARS_IV7]], 10
; IS__CGSCC_NPM-NEXT:    [[I20:%.*]] = add nuw nsw i64 [[I19]], 2
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX20:%.*]] = getelementptr inbounds i64, i64* [[I18]], i64 [[I20]]
; IS__CGSCC_NPM-NEXT:    store i64 0, i64* [[ARRAYIDX20]], align 8, !tbaa [[TBAA20]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC21]]
; IS__CGSCC_NPM:       for.inc21:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT8]] = add nuw nsw i64 [[INDVARS_IV7]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND13]], !llvm.loop [[LOOP30:![0-9]+]]
; IS__CGSCC_NPM:       for.end23:
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX24:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 1023
; IS__CGSCC_NPM-NEXT:    store i8 0, i8* [[ARRAYIDX24]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX25:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 500
; IS__CGSCC_NPM-NEXT:    [[I21:%.*]] = bitcast i8* [[ARRAYIDX25]] to i32*
; IS__CGSCC_NPM-NEXT:    call void @write_arg(i32* nofree noundef nonnull writeonly align 4 dereferenceable(4) [[I21]], i32 noundef 0) #[[ATTR10]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND27:%.*]]
; IS__CGSCC_NPM:       for.cond27:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV12:%.*]] = phi i64 [ [[INDVARS_IV_NEXT13:%.*]], [[FOR_INC35:%.*]] ], [ 0, [[FOR_END23]] ]
; IS__CGSCC_NPM-NEXT:    [[EXITCOND14:%.*]] = icmp ne i64 [[INDVARS_IV12]], 1024
; IS__CGSCC_NPM-NEXT:    br i1 [[EXITCOND14]], label [[FOR_BODY30:%.*]], label [[FOR_COND_CLEANUP29:%.*]]
; IS__CGSCC_NPM:       for.cond.cleanup29:
; IS__CGSCC_NPM-NEXT:    br label [[FOR_END37:%.*]]
; IS__CGSCC_NPM:       for.body30:
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX32:%.*]] = getelementptr inbounds i8, i8* [[BYTES]], i64 [[INDVARS_IV12]]
; IS__CGSCC_NPM-NEXT:    [[I22:%.*]] = load i8, i8* [[ARRAYIDX32]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    [[ARRAYIDX34:%.*]] = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 [[INDVARS_IV12]]
; IS__CGSCC_NPM-NEXT:    store i8 [[I22]], i8* [[ARRAYIDX34]], align 1, !tbaa [[TBAA15]]
; IS__CGSCC_NPM-NEXT:    br label [[FOR_INC35]]
; IS__CGSCC_NPM:       for.inc35:
; IS__CGSCC_NPM-NEXT:    [[INDVARS_IV_NEXT13]] = add nuw nsw i64 [[INDVARS_IV12]], 1
; IS__CGSCC_NPM-NEXT:    br label [[FOR_COND27]], !llvm.loop [[LOOP31:![0-9]+]]
; IS__CGSCC_NPM:       for.end37:
; IS__CGSCC_NPM-NEXT:    ret void
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.inc, %entry
  %indvars.iv = phi i64 [ %indvars.iv.next, %for.inc ], [ 0, %entry ]
  %exitcond = icmp ne i64 %indvars.iv, 100
  br i1 %exitcond, label %for.body, label %for.cond.cleanup

for.cond.cleanup:                                 ; preds = %for.cond
  br label %for.end

for.body:                                         ; preds = %for.cond
  %i = mul nuw nsw i64 %indvars.iv, 10
  %arrayidx = getelementptr inbounds i8, i8* %Bytes, i64 %i
  store i8 0, i8* %arrayidx, align 1, !tbaa !15
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %indvars.iv.next = add nuw nsw i64 %indvars.iv, 1
  br label %for.cond, !llvm.loop !28

for.end:                                          ; preds = %for.cond.cleanup
  br label %for.cond2

for.cond2:                                        ; preds = %for.inc9, %for.end
  %indvars.iv2 = phi i64 [ %indvars.iv.next3, %for.inc9 ], [ 0, %for.end ]
  %exitcond6 = icmp ne i64 %indvars.iv2, 10
  br i1 %exitcond6, label %for.body5, label %for.cond.cleanup4

for.cond.cleanup4:                                ; preds = %for.cond2
  br label %for.end11

for.body5:                                        ; preds = %for.cond2
  %i15 = bitcast i8* %Bytes to float*
  %i16 = mul nuw nsw i64 %indvars.iv2, 10
  %i17 = or i64 %i16, 1
  %arrayidx8 = getelementptr inbounds float, float* %i15, i64 %i17
  store float 0.000000e+00, float* %arrayidx8, align 4, !tbaa !18
  br label %for.inc9

for.inc9:                                         ; preds = %for.body5
  %indvars.iv.next3 = add nuw nsw i64 %indvars.iv2, 1
  br label %for.cond2, !llvm.loop !29

for.end11:                                        ; preds = %for.cond.cleanup4
  br label %for.cond13

for.cond13:                                       ; preds = %for.inc21, %for.end11
  %indvars.iv7 = phi i64 [ %indvars.iv.next8, %for.inc21 ], [ 0, %for.end11 ]
  %exitcond11 = icmp ne i64 %indvars.iv7, 20
  br i1 %exitcond11, label %for.body16, label %for.cond.cleanup15

for.cond.cleanup15:                               ; preds = %for.cond13
  br label %for.end23

for.body16:                                       ; preds = %for.cond13
  %i18 = bitcast i8* %Bytes to i64*
  %i19 = mul nuw nsw i64 %indvars.iv7, 10
  %i20 = add nuw nsw i64 %i19, 2
  %arrayidx20 = getelementptr inbounds i64, i64* %i18, i64 %i20
  store i64 0, i64* %arrayidx20, align 8, !tbaa !20
  br label %for.inc21

for.inc21:                                        ; preds = %for.body16
  %indvars.iv.next8 = add nuw nsw i64 %indvars.iv7, 1
  br label %for.cond13, !llvm.loop !30

for.end23:                                        ; preds = %for.cond.cleanup15
  %arrayidx24 = getelementptr inbounds i8, i8* %Bytes, i64 1023
  store i8 0, i8* %arrayidx24, align 1, !tbaa !15
  %arrayidx25 = getelementptr inbounds i8, i8* %Bytes, i64 500
  %i21 = bitcast i8* %arrayidx25 to i32*
  call void @write_arg(i32* nonnull %i21, i32 0)
  br label %for.cond27

for.cond27:                                       ; preds = %for.inc35, %for.end23
  %indvars.iv12 = phi i64 [ %indvars.iv.next13, %for.inc35 ], [ 0, %for.end23 ]
  %exitcond14 = icmp ne i64 %indvars.iv12, 1024
  br i1 %exitcond14, label %for.body30, label %for.cond.cleanup29

for.cond.cleanup29:                               ; preds = %for.cond27
  br label %for.end37

for.body30:                                       ; preds = %for.cond27
  %arrayidx32 = getelementptr inbounds i8, i8* %Bytes, i64 %indvars.iv12
  %i22 = load i8, i8* %arrayidx32, align 1, !tbaa !15
  %arrayidx34 = getelementptr inbounds [1024 x i8], [1024 x i8]* @globalBytes, i64 0, i64 %indvars.iv12
  store i8 %i22, i8* %arrayidx34, align 1, !tbaa !15
  br label %for.inc35

for.inc35:                                        ; preds = %for.body30
  %indvars.iv.next13 = add nuw nsw i64 %indvars.iv12, 1
  br label %for.cond27, !llvm.loop !31

for.end37:                                        ; preds = %for.cond.cleanup29
  ret void
}

;    int local_alloca_not_simplifiable_1() {
;      int X, Y, Z;
;      X = Y = 1;
;      escape(&X);
;      write_random(&Y);
;      Z = X ? 1 : 2;
;      return X + Y + Z;
;    }
;
define i32 @local_alloca_not_simplifiable_1() {
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@local_alloca_not_simplifiable_1() {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[X:%.*]] = alloca i32, align 4
; IS__TUNIT_OPM-NEXT:    [[Y:%.*]] = alloca i32, align 4
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = bitcast i32* [[X]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    [[I1:%.*]] = bitcast i32* [[Y]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR9]]
; IS__TUNIT_OPM-NEXT:    store i32 1, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    store i32 1, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    [[I2:%.*]] = bitcast i32* [[X]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @escape(i8* noundef nonnull align 4 dereferenceable(4) [[I2]])
; IS__TUNIT_OPM-NEXT:    call void @write_random(i32* noalias nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[Y]])
; IS__TUNIT_OPM-NEXT:    [[I3:%.*]] = load i32, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[I3]], 0
; IS__TUNIT_OPM-NEXT:    [[COND:%.*]] = select i1 [[TOBOOL_NOT]], i32 2, i32 1
; IS__TUNIT_OPM-NEXT:    [[I4:%.*]] = load i32, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    [[ADD:%.*]] = add nsw i32 [[I3]], [[I4]]
; IS__TUNIT_OPM-NEXT:    [[ADD1:%.*]] = add nsw i32 [[ADD]], [[COND]]
; IS__TUNIT_OPM-NEXT:    [[I5:%.*]] = bitcast i32* [[Y]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I5]])
; IS__TUNIT_OPM-NEXT:    [[I6:%.*]] = bitcast i32* [[X]] to i8*
; IS__TUNIT_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I6]])
; IS__TUNIT_OPM-NEXT:    ret i32 [[ADD1]]
;
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@local_alloca_not_simplifiable_1() {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[X:%.*]] = alloca i32, align 4
; IS__TUNIT_NPM-NEXT:    [[Y:%.*]] = alloca i32, align 4
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = bitcast i32* [[X]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    [[I1:%.*]] = bitcast i32* [[Y]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR6]]
; IS__TUNIT_NPM-NEXT:    store i32 1, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    store i32 1, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    [[I2:%.*]] = bitcast i32* [[X]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @escape(i8* noundef nonnull align 4 dereferenceable(4) [[I2]])
; IS__TUNIT_NPM-NEXT:    call void @write_random(i32* noalias nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[Y]])
; IS__TUNIT_NPM-NEXT:    [[I3:%.*]] = load i32, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[I3]], 0
; IS__TUNIT_NPM-NEXT:    [[COND:%.*]] = select i1 [[TOBOOL_NOT]], i32 2, i32 1
; IS__TUNIT_NPM-NEXT:    [[I4:%.*]] = load i32, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    [[ADD:%.*]] = add nsw i32 [[I3]], [[I4]]
; IS__TUNIT_NPM-NEXT:    [[ADD1:%.*]] = add nsw i32 [[ADD]], [[COND]]
; IS__TUNIT_NPM-NEXT:    [[I5:%.*]] = bitcast i32* [[Y]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I5]])
; IS__TUNIT_NPM-NEXT:    [[I6:%.*]] = bitcast i32* [[X]] to i8*
; IS__TUNIT_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I6]])
; IS__TUNIT_NPM-NEXT:    ret i32 [[ADD1]]
;
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@local_alloca_not_simplifiable_1() {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[X:%.*]] = alloca i32, align 4
; IS__CGSCC_OPM-NEXT:    [[Y:%.*]] = alloca i32, align 4
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = bitcast i32* [[X]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    [[I1:%.*]] = bitcast i32* [[Y]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR11]]
; IS__CGSCC_OPM-NEXT:    store i32 1, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_OPM-NEXT:    store i32 1, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_OPM-NEXT:    [[I2:%.*]] = bitcast i32* [[X]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @escape(i8* noundef nonnull align 4 dereferenceable(4) [[I2]])
; IS__CGSCC_OPM-NEXT:    call void @write_random(i32* noalias nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[Y]])
; IS__CGSCC_OPM-NEXT:    [[I3:%.*]] = load i32, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_OPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[I3]], 0
; IS__CGSCC_OPM-NEXT:    [[COND:%.*]] = select i1 [[TOBOOL_NOT]], i32 2, i32 1
; IS__CGSCC_OPM-NEXT:    [[I4:%.*]] = load i32, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_OPM-NEXT:    [[ADD:%.*]] = add nsw i32 [[I3]], [[I4]]
; IS__CGSCC_OPM-NEXT:    [[ADD1:%.*]] = add nsw i32 [[ADD]], [[COND]]
; IS__CGSCC_OPM-NEXT:    [[I5:%.*]] = bitcast i32* [[Y]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I5]])
; IS__CGSCC_OPM-NEXT:    [[I6:%.*]] = bitcast i32* [[X]] to i8*
; IS__CGSCC_OPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I6]])
; IS__CGSCC_OPM-NEXT:    ret i32 [[ADD1]]
;
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@local_alloca_not_simplifiable_1() {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[X:%.*]] = alloca i32, align 4
; IS__CGSCC_NPM-NEXT:    [[Y:%.*]] = alloca i32, align 4
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = bitcast i32* [[X]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    [[I1:%.*]] = bitcast i32* [[Y]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.start.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I1]]) #[[ATTR8]]
; IS__CGSCC_NPM-NEXT:    store i32 1, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_NPM-NEXT:    store i32 1, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_NPM-NEXT:    [[I2:%.*]] = bitcast i32* [[X]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @escape(i8* noundef nonnull align 4 dereferenceable(4) [[I2]])
; IS__CGSCC_NPM-NEXT:    call void @write_random(i32* noalias nocapture nofree noundef nonnull writeonly align 4 dereferenceable(4) [[Y]])
; IS__CGSCC_NPM-NEXT:    [[I3:%.*]] = load i32, i32* [[X]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_NPM-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[I3]], 0
; IS__CGSCC_NPM-NEXT:    [[COND:%.*]] = select i1 [[TOBOOL_NOT]], i32 2, i32 1
; IS__CGSCC_NPM-NEXT:    [[I4:%.*]] = load i32, i32* [[Y]], align 4, !tbaa [[TBAA3]]
; IS__CGSCC_NPM-NEXT:    [[ADD:%.*]] = add nsw i32 [[I3]], [[I4]]
; IS__CGSCC_NPM-NEXT:    [[ADD1:%.*]] = add nsw i32 [[ADD]], [[COND]]
; IS__CGSCC_NPM-NEXT:    [[I5:%.*]] = bitcast i32* [[Y]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I5]])
; IS__CGSCC_NPM-NEXT:    [[I6:%.*]] = bitcast i32* [[X]] to i8*
; IS__CGSCC_NPM-NEXT:    call void @llvm.lifetime.end.p0i8(i64 noundef 4, i8* nocapture nofree noundef nonnull align 4 dereferenceable(4) [[I6]])
; IS__CGSCC_NPM-NEXT:    ret i32 [[ADD1]]
;
entry:
  %X = alloca i32, align 4
  %Y = alloca i32, align 4
  %i = bitcast i32* %X to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* nonnull %i)
  %i1 = bitcast i32* %Y to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* nonnull %i1)
  store i32 1, i32* %Y, align 4, !tbaa !3
  store i32 1, i32* %X, align 4, !tbaa !3
  %i2 = bitcast i32* %X to i8*
  call void @escape(i8* nonnull %i2)
  call void @write_random(i32* nonnull %Y)
  %i3 = load i32, i32* %X, align 4, !tbaa !3
  %tobool.not = icmp eq i32 %i3, 0
  %cond = select i1 %tobool.not, i32 2, i32 1
  %i4 = load i32, i32* %Y, align 4, !tbaa !3
  %add = add nsw i32 %i3, %i4
  %add1 = add nsw i32 %add, %cond
  %i5 = bitcast i32* %Y to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* nonnull %i5)
  %i6 = bitcast i32* %X to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* nonnull %i6)
  ret i32 %add1
}

; We could simplify these if we separate accessed bins wrt. alignment (here mod 4).
define i32 @unknown_access_mixed_simplifiable(i32 %arg1, i32 %arg2) {
; IS__TUNIT____: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@unknown_access_mixed_simplifiable
; IS__TUNIT____-SAME: (i32 [[ARG1:%.*]], i32 [[ARG2:%.*]]) #[[ATTR3]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 4
; IS__TUNIT____-NEXT:    [[BC:%.*]] = bitcast %struct.S* [[S]] to i32*
; IS__TUNIT____-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT____-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG1]]
; IS__TUNIT____-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG2]]
; IS__TUNIT____-NEXT:    store i32 7, i32* [[GEP1]], align 4
; IS__TUNIT____-NEXT:    store i32 7, i32* [[GEP2]], align 4
; IS__TUNIT____-NEXT:    store i32 7, i32* [[GEP3]], align 4
; IS__TUNIT____-NEXT:    [[L1:%.*]] = load i32, i32* [[GEP1]], align 4
; IS__TUNIT____-NEXT:    [[L2:%.*]] = load i32, i32* [[GEP2]], align 4
; IS__TUNIT____-NEXT:    [[L3:%.*]] = load i32, i32* [[GEP3]], align 4
; IS__TUNIT____-NEXT:    [[ADD1:%.*]] = add i32 [[L1]], [[L2]]
; IS__TUNIT____-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[L3]]
; IS__TUNIT____-NEXT:    ret i32 [[ADD2]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@unknown_access_mixed_simplifiable
; IS__CGSCC____-SAME: (i32 [[ARG1:%.*]], i32 [[ARG2:%.*]]) #[[ATTR2]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 4
; IS__CGSCC____-NEXT:    [[BC:%.*]] = bitcast %struct.S* [[S]] to i32*
; IS__CGSCC____-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC____-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG1]]
; IS__CGSCC____-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG2]]
; IS__CGSCC____-NEXT:    store i32 7, i32* [[GEP1]], align 4
; IS__CGSCC____-NEXT:    store i32 7, i32* [[GEP2]], align 4
; IS__CGSCC____-NEXT:    store i32 7, i32* [[GEP3]], align 4
; IS__CGSCC____-NEXT:    [[L1:%.*]] = load i32, i32* [[GEP1]], align 4
; IS__CGSCC____-NEXT:    [[L2:%.*]] = load i32, i32* [[GEP2]], align 4
; IS__CGSCC____-NEXT:    [[L3:%.*]] = load i32, i32* [[GEP3]], align 4
; IS__CGSCC____-NEXT:    [[ADD1:%.*]] = add i32 [[L1]], [[L2]]
; IS__CGSCC____-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[L3]]
; IS__CGSCC____-NEXT:    ret i32 [[ADD2]]
;
entry:
  %s = alloca %struct.S, align 4
  %bc = bitcast %struct.S* %s to i32*
  %gep1 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 2
  %gep2 = getelementptr inbounds i32, i32* %bc, i32 %arg1
  %gep3 = getelementptr inbounds i32, i32* %bc, i32 %arg2
  store i32 7, i32* %gep1
  store i32 7, i32* %gep2
  store i32 7, i32* %gep3
  %l1 = load i32, i32* %gep1
  %l2 = load i32, i32* %gep2
  %l3 = load i32, i32* %gep3
  %add1 = add i32 %l1, %l2
  %add2 = add i32 %add1, %l3
  ret i32 %add2
}

; The access to bc4b could go anywhere, nothing is simplifiable.
define i32 @unknown_access_mixed_not_simplifiable(i32 %arg1, i32 %arg2, i32 %arg3) {
; IS__TUNIT____: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@unknown_access_mixed_not_simplifiable
; IS__TUNIT____-SAME: (i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], i32 [[ARG3:%.*]]) #[[ATTR3]] {
; IS__TUNIT____-NEXT:  entry:
; IS__TUNIT____-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 4
; IS__TUNIT____-NEXT:    [[BC:%.*]] = bitcast %struct.S* [[S]] to i32*
; IS__TUNIT____-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__TUNIT____-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG1]]
; IS__TUNIT____-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG2]]
; IS__TUNIT____-NEXT:    [[BC4A:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__TUNIT____-NEXT:    [[GEP4:%.*]] = getelementptr inbounds i8, i8* [[BC4A]], i32 [[ARG3]]
; IS__TUNIT____-NEXT:    [[BC4B:%.*]] = bitcast i8* [[GEP4]] to i32*
; IS__TUNIT____-NEXT:    store i32 7, i32* [[GEP1]], align 4
; IS__TUNIT____-NEXT:    store i32 7, i32* [[GEP2]], align 4
; IS__TUNIT____-NEXT:    store i32 7, i32* [[GEP3]], align 4
; IS__TUNIT____-NEXT:    store i32 7, i32* [[BC4B]], align 4
; IS__TUNIT____-NEXT:    [[L1:%.*]] = load i32, i32* [[GEP1]], align 4
; IS__TUNIT____-NEXT:    [[L2:%.*]] = load i32, i32* [[GEP2]], align 4
; IS__TUNIT____-NEXT:    [[L3:%.*]] = load i32, i32* [[GEP3]], align 4
; IS__TUNIT____-NEXT:    [[L4:%.*]] = load i32, i32* [[BC4B]], align 4
; IS__TUNIT____-NEXT:    [[ADD1:%.*]] = add i32 [[L1]], [[L2]]
; IS__TUNIT____-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[L3]]
; IS__TUNIT____-NEXT:    [[ADD3:%.*]] = add i32 [[ADD2]], [[L4]]
; IS__TUNIT____-NEXT:    ret i32 [[ADD3]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@unknown_access_mixed_not_simplifiable
; IS__CGSCC____-SAME: (i32 [[ARG1:%.*]], i32 [[ARG2:%.*]], i32 [[ARG3:%.*]]) #[[ATTR2]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[S:%.*]] = alloca [[STRUCT_S:%.*]], align 4
; IS__CGSCC____-NEXT:    [[BC:%.*]] = bitcast %struct.S* [[S]] to i32*
; IS__CGSCC____-NEXT:    [[GEP1:%.*]] = getelementptr inbounds [[STRUCT_S]], %struct.S* [[S]], i64 0, i32 2
; IS__CGSCC____-NEXT:    [[GEP2:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG1]]
; IS__CGSCC____-NEXT:    [[GEP3:%.*]] = getelementptr inbounds i32, i32* [[BC]], i32 [[ARG2]]
; IS__CGSCC____-NEXT:    [[BC4A:%.*]] = bitcast %struct.S* [[S]] to i8*
; IS__CGSCC____-NEXT:    [[GEP4:%.*]] = getelementptr inbounds i8, i8* [[BC4A]], i32 [[ARG3]]
; IS__CGSCC____-NEXT:    [[BC4B:%.*]] = bitcast i8* [[GEP4]] to i32*
; IS__CGSCC____-NEXT:    store i32 7, i32* [[GEP1]], align 4
; IS__CGSCC____-NEXT:    store i32 7, i32* [[GEP2]], align 4
; IS__CGSCC____-NEXT:    store i32 7, i32* [[GEP3]], align 4
; IS__CGSCC____-NEXT:    store i32 7, i32* [[BC4B]], align 4
; IS__CGSCC____-NEXT:    [[L1:%.*]] = load i32, i32* [[GEP1]], align 4
; IS__CGSCC____-NEXT:    [[L2:%.*]] = load i32, i32* [[GEP2]], align 4
; IS__CGSCC____-NEXT:    [[L3:%.*]] = load i32, i32* [[GEP3]], align 4
; IS__CGSCC____-NEXT:    [[L4:%.*]] = load i32, i32* [[BC4B]], align 4
; IS__CGSCC____-NEXT:    [[ADD1:%.*]] = add i32 [[L1]], [[L2]]
; IS__CGSCC____-NEXT:    [[ADD2:%.*]] = add i32 [[ADD1]], [[L3]]
; IS__CGSCC____-NEXT:    [[ADD3:%.*]] = add i32 [[ADD2]], [[L4]]
; IS__CGSCC____-NEXT:    ret i32 [[ADD3]]
;
entry:
  %s = alloca %struct.S, align 4
  %bc = bitcast %struct.S* %s to i32*
  %gep1 = getelementptr inbounds %struct.S, %struct.S* %s, i64 0, i32 2
  %gep2 = getelementptr inbounds i32, i32* %bc, i32 %arg1
  %gep3 = getelementptr inbounds i32, i32* %bc, i32 %arg2
  %bc4a = bitcast %struct.S* %s to i8*
  %gep4 = getelementptr inbounds i8, i8* %bc4a, i32 %arg3
  %bc4b = bitcast i8* %gep4 to i32*
  store i32 7, i32* %gep1
  store i32 7, i32* %gep2
  store i32 7, i32* %gep3
  store i32 7, i32* %bc4b
  %l1 = load i32, i32* %gep1
  %l2 = load i32, i32* %gep2
  %l3 = load i32, i32* %gep3
  %l4 = load i32, i32* %bc4b
  %add1 = add i32 %l1, %l2
  %add2 = add i32 %add1, %l3
  %add3 = add i32 %add2, %l4
  ret i32 %add3
}

declare void @escape(i8*)

;    int Flag0 = 0;
;    int global_not_simplifiable_1(int cnd) {
;      return Flag0;
;    }
;
define i32 @global_not_simplifiable_1(i32 %cnd) {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind readonly willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@global_not_simplifiable_1
; IS__TUNIT_OPM-SAME: (i32 [[CND:%.*]]) #[[ATTR7:[0-9]+]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = load i32, i32* @Flag0, align 4, !tbaa [[TBAA3]]
; IS__TUNIT_OPM-NEXT:    ret i32 [[I]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind readonly willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@global_not_simplifiable_1
; IS__TUNIT_NPM-SAME: (i32 [[CND:%.*]]) #[[ATTR5:[0-9]+]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = load i32, i32* @Flag0, align 4, !tbaa [[TBAA3]]
; IS__TUNIT_NPM-NEXT:    ret i32 [[I]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readonly willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@global_not_simplifiable_1
; IS__CGSCC____-SAME: (i32 [[CND:%.*]]) #[[ATTR7:[0-9]+]] {
; IS__CGSCC____-NEXT:  entry:
; IS__CGSCC____-NEXT:    [[I:%.*]] = load i32, i32* @Flag0, align 4, !tbaa [[TBAA3]]
; IS__CGSCC____-NEXT:    ret i32 [[I]]
;
entry:
  %i = load i32, i32* @Flag0, align 4, !tbaa !3
  ret i32 %i
}

;    static int Flag1 __attribute__((loader_uninitialized));
;    int static_global_not_simplifiable_1(int cnd) {
;      int v = Flag1;
;      sync();
;      if (cnd)
;        Flag1 = 1;
;      return v;
;    }
;
define i32 @static_global_not_simplifiable_1(i32 %cnd) {
; CHECK-LABEL: define {{[^@]+}}@static_global_not_simplifiable_1
; CHECK-SAME: (i32 [[CND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    call void @sync()
; CHECK-NEXT:    [[TOBOOL_NOT:%.*]] = icmp eq i32 [[CND]], 0
; CHECK-NEXT:    br i1 [[TOBOOL_NOT]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 1, i32* @Flag1, align 4, !tbaa [[TBAA3]]
; CHECK-NEXT:    br label [[IF_END]]
; CHECK:       if.end:
; CHECK-NEXT:    ret i32 1
;
entry:
  %i = load i32, i32* @Flag1, align 4, !tbaa !3
  call void @sync()
  %tobool.not = icmp eq i32 %cnd, 0
  br i1 %tobool.not, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  store i32 1, i32* @Flag1, align 4, !tbaa !3
  br label %if.end

if.end:                                           ; preds = %if.then, %entry
  ret i32 %i
}

declare void @sync()

;    static int Flag2 __attribute__((loader_uninitialized));
;    int static_global_not_simplifiable_2(int cnd) {
;      Flag2 = 1;
;      sync();
;      int v = Flag2;
;      Flag2 = 2;
;      return v;
;    }
define i32 @static_global_not_simplifiable_2(i32 %cnd) {
; CHECK-LABEL: define {{[^@]+}}@static_global_not_simplifiable_2
; CHECK-SAME: (i32 [[CND:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 1, i32* @Flag2, align 4, !tbaa [[TBAA3]]
; CHECK-NEXT:    call void @sync()
; CHECK-NEXT:    [[I:%.*]] = load i32, i32* @Flag2, align 4, !tbaa [[TBAA3]]
; CHECK-NEXT:    store i32 2, i32* @Flag2, align 4, !tbaa [[TBAA3]]
; CHECK-NEXT:    ret i32 [[I]]
;
entry:
  store i32 1, i32* @Flag2, align 4, !tbaa !3
  call void @sync()
  %i = load i32, i32* @Flag2, align 4, !tbaa !3
  store i32 2, i32* @Flag2, align 4, !tbaa !3
  ret i32 %i
}

;    int write_read{,_static,_static_undef}_global(void) {
;      Gint{,static,_static_undef}1 = 7;
;      return Gint1;
;    }
;    void write{,_static,_static_undef}_global(void) {
;      Gint{,static,_static_undef}2 = 7;
;    }
;    int read{,_static,_static_undef}_global(void) {
;      return Gint{,static,_static_undef}2;
;    }
;
; FIXME: We could replace these loads.
define i32 @write_read_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@write_read_global
; IS__TUNIT_OPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_OPM-NEXT:    store i32 7, i32* @Gint1, align 4
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i32, i32* @Gint1, align 4
; IS__TUNIT_OPM-NEXT:    ret i32 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@write_read_global
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:    store i32 7, i32* @Gint1, align 4
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i32, i32* @Gint1, align 4
; IS__TUNIT_NPM-NEXT:    ret i32 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_read_global
; IS__CGSCC____-SAME: () #[[ATTR5]] {
; IS__CGSCC____-NEXT:    store i32 7, i32* @Gint1, align 4
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i32, i32* @Gint1, align 4
; IS__CGSCC____-NEXT:    ret i32 [[L]]
;
  store i32 7, i32* @Gint1
  %l = load i32, i32* @Gint1
  ret i32 %l
}
define void @write_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@write_global
; IS__TUNIT_OPM-SAME: () #[[ATTR5]] {
; IS__TUNIT_OPM-NEXT:    store i32 7, i32* @Gint2, align 4
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@write_global
; IS__TUNIT_NPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:    store i32 7, i32* @Gint2, align 4
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_global
; IS__CGSCC____-SAME: () #[[ATTR4:[0-9]+]] {
; IS__CGSCC____-NEXT:    store i32 7, i32* @Gint2, align 4
; IS__CGSCC____-NEXT:    ret void
;
  store i32 7, i32* @Gint2
  ret void
}
define i32 @read_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind readonly willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@read_global
; IS__TUNIT_OPM-SAME: () #[[ATTR7]] {
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i32, i32* @Gint2, align 4
; IS__TUNIT_OPM-NEXT:    ret i32 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind readonly willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@read_global
; IS__TUNIT_NPM-SAME: () #[[ATTR5]] {
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i32, i32* @Gint2, align 4
; IS__TUNIT_NPM-NEXT:    ret i32 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readonly willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@read_global
; IS__CGSCC____-SAME: () #[[ATTR7]] {
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i32, i32* @Gint2, align 4
; IS__CGSCC____-NEXT:    ret i32 [[L]]
;
  %l = load i32, i32* @Gint2
  ret i32 %l
}
; FIXME: We could replace these loads.
define i32 @write_read_static_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@write_read_static_global
; IS__TUNIT_OPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_OPM-NEXT:    store i32 7, i32* @Gstatic_int1, align 4
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i32, i32* @Gstatic_int1, align 4
; IS__TUNIT_OPM-NEXT:    ret i32 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@write_read_static_global
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:    store i32 7, i32* @Gstatic_int1, align 4
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i32, i32* @Gstatic_int1, align 4
; IS__TUNIT_NPM-NEXT:    ret i32 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_read_static_global
; IS__CGSCC____-SAME: () #[[ATTR5]] {
; IS__CGSCC____-NEXT:    store i32 7, i32* @Gstatic_int1, align 4
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i32, i32* @Gstatic_int1, align 4
; IS__CGSCC____-NEXT:    ret i32 [[L]]
;
  store i32 7, i32* @Gstatic_int1
  %l = load i32, i32* @Gstatic_int1
  ret i32 %l
}
define void @write_static_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@write_static_global
; IS__TUNIT_OPM-SAME: () #[[ATTR5]] {
; IS__TUNIT_OPM-NEXT:    store i32 7, i32* @Gstatic_int2, align 4
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@write_static_global
; IS__TUNIT_NPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:    store i32 7, i32* @Gstatic_int2, align 4
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_static_global
; IS__CGSCC____-SAME: () #[[ATTR4]] {
; IS__CGSCC____-NEXT:    store i32 7, i32* @Gstatic_int2, align 4
; IS__CGSCC____-NEXT:    ret void
;
  store i32 7, i32* @Gstatic_int2
  ret void
}
define i32 @read_static_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind readonly willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@read_static_global
; IS__TUNIT_OPM-SAME: () #[[ATTR7]] {
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i32, i32* @Gstatic_int2, align 4
; IS__TUNIT_OPM-NEXT:    ret i32 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind readonly willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@read_static_global
; IS__TUNIT_NPM-SAME: () #[[ATTR5]] {
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i32, i32* @Gstatic_int2, align 4
; IS__TUNIT_NPM-NEXT:    ret i32 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readonly willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@read_static_global
; IS__CGSCC____-SAME: () #[[ATTR7]] {
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i32, i32* @Gstatic_int2, align 4
; IS__CGSCC____-NEXT:    ret i32 [[L]]
;
  %l = load i32, i32* @Gstatic_int2
  ret i32 %l
}
define i32 @write_read_static_undef_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@write_read_static_undef_global
; IS__TUNIT_OPM-SAME: () #[[ATTR5]] {
; IS__TUNIT_OPM-NEXT:    ret i32 7
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@write_read_static_undef_global
; IS__TUNIT_NPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:    ret i32 7
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_read_static_undef_global
; IS__CGSCC____-SAME: () #[[ATTR4]] {
; IS__CGSCC____-NEXT:    ret i32 7
;
  store i32 7, i32* @Gstatic_undef_int1
  %l = load i32, i32* @Gstatic_undef_int1
  ret i32 %l
}
define void @write_static_undef_global() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@write_static_undef_global
; IS__TUNIT_OPM-SAME: () #[[ATTR5]] {
; IS__TUNIT_OPM-NEXT:    ret void
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@write_static_undef_global
; IS__TUNIT_NPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:    ret void
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC____-LABEL: define {{[^@]+}}@write_static_undef_global
; IS__CGSCC____-SAME: () #[[ATTR4]] {
; IS__CGSCC____-NEXT:    store i32 7, i32* @Gstatic_undef_int2, align 4
; IS__CGSCC____-NEXT:    ret void
;
  store i32 7, i32* @Gstatic_undef_int2
  ret void
}
define i32 @read_static_undef_global() {
; IS__TUNIT____: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@read_static_undef_global
; IS__TUNIT____-SAME: () #[[ATTR3]] {
; IS__TUNIT____-NEXT:    ret i32 7
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@read_static_undef_global
; IS__CGSCC____-SAME: () #[[ATTR2]] {
; IS__CGSCC____-NEXT:    ret i32 7
;
  %l = load i32, i32* @Gstatic_undef_int2
  ret i32 %l
}

define i32 @single_read_of_static_global() {
; IS__TUNIT____: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT____-LABEL: define {{[^@]+}}@single_read_of_static_global
; IS__TUNIT____-SAME: () #[[ATTR3]] {
; IS__TUNIT____-NEXT:    ret i32 0
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@single_read_of_static_global
; IS__CGSCC____-SAME: () #[[ATTR2]] {
; IS__CGSCC____-NEXT:    ret i32 0
;
  %l = load i32, i32* @Gstatic_int3
  ret i32 %l
}

define i8 @phi_store() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind readnone
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@phi_store
; IS__TUNIT_OPM-SAME: () #[[ATTR8:[0-9]+]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    [[A:%.*]] = alloca i16, align 2
; IS__TUNIT_OPM-NEXT:    [[B:%.*]] = bitcast i16* [[A]] to i8*
; IS__TUNIT_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_OPM:       loop:
; IS__TUNIT_OPM-NEXT:    [[P:%.*]] = phi i8* [ [[B]], [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__TUNIT_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 2
; IS__TUNIT_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_OPM:       end:
; IS__TUNIT_OPM-NEXT:    [[S:%.*]] = getelementptr i8, i8* [[B]], i64 1
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i8, i8* [[S]], align 1
; IS__TUNIT_OPM-NEXT:    ret i8 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind readnone willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@phi_store
; IS__TUNIT_NPM-SAME: () #[[ATTR3]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    [[A:%.*]] = alloca i16, align 2
; IS__TUNIT_NPM-NEXT:    [[B:%.*]] = bitcast i16* [[A]] to i8*
; IS__TUNIT_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_NPM:       loop:
; IS__TUNIT_NPM-NEXT:    [[P:%.*]] = phi i8* [ [[B]], [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__TUNIT_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 2
; IS__TUNIT_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_NPM:       end:
; IS__TUNIT_NPM-NEXT:    [[S:%.*]] = getelementptr i8, i8* [[B]], i64 1
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i8, i8* [[S]], align 1
; IS__TUNIT_NPM-NEXT:    ret i8 [[L]]
;
; IS__CGSCC_OPM: Function Attrs: nofree norecurse nosync nounwind readnone
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@phi_store
; IS__CGSCC_OPM-SAME: () #[[ATTR8:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    [[A:%.*]] = alloca i16, align 2
; IS__CGSCC_OPM-NEXT:    [[B:%.*]] = bitcast i16* [[A]] to i8*
; IS__CGSCC_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_OPM:       loop:
; IS__CGSCC_OPM-NEXT:    [[P:%.*]] = phi i8* [ [[B]], [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__CGSCC_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 2
; IS__CGSCC_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_OPM:       end:
; IS__CGSCC_OPM-NEXT:    [[S:%.*]] = getelementptr i8, i8* [[B]], i64 1
; IS__CGSCC_OPM-NEXT:    [[L:%.*]] = load i8, i8* [[S]], align 1
; IS__CGSCC_OPM-NEXT:    ret i8 [[L]]
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind readnone willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@phi_store
; IS__CGSCC_NPM-SAME: () #[[ATTR2]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    [[A:%.*]] = alloca i16, align 2
; IS__CGSCC_NPM-NEXT:    [[B:%.*]] = bitcast i16* [[A]] to i8*
; IS__CGSCC_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_NPM:       loop:
; IS__CGSCC_NPM-NEXT:    [[P:%.*]] = phi i8* [ [[B]], [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__CGSCC_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 2
; IS__CGSCC_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_NPM:       end:
; IS__CGSCC_NPM-NEXT:    [[S:%.*]] = getelementptr i8, i8* [[B]], i64 1
; IS__CGSCC_NPM-NEXT:    [[L:%.*]] = load i8, i8* [[S]], align 1
; IS__CGSCC_NPM-NEXT:    ret i8 [[L]]
;
entry:
  %a = alloca i16
  %b = bitcast i16* %a to i8*
  br label %loop
loop:
  %p = phi i8* [%b, %entry], [%g, %loop]
  %i = phi i8 [0, %entry], [%o, %loop]
  store i8 1, i8* %p
  %g = getelementptr i8, i8* %p, i64 1
  %o = add nsw i8 %i, 1
  %c = icmp eq i8 %o, 2
  br i1 %c, label %end, label %loop
end:
  %s = getelementptr i8, i8* %b, i64 1
  %l = load i8, i8* %s
  ret i8 %l
}

; FIXME: This function returns 1.
define i8 @phi_no_store_1() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@phi_no_store_1
; IS__TUNIT_OPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_OPM:       loop:
; IS__TUNIT_OPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a1 to i8*), [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__TUNIT_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 3
; IS__TUNIT_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_OPM:       end:
; IS__TUNIT_OPM-NEXT:    [[L11:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 2), align 2
; IS__TUNIT_OPM-NEXT:    [[L12:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 3), align 1
; IS__TUNIT_OPM-NEXT:    [[ADD:%.*]] = add i8 [[L11]], [[L12]]
; IS__TUNIT_OPM-NEXT:    ret i8 [[ADD]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@phi_no_store_1
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_NPM:       loop:
; IS__TUNIT_NPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a1 to i8*), [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__TUNIT_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 3
; IS__TUNIT_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_NPM:       end:
; IS__TUNIT_NPM-NEXT:    [[L11:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 2), align 2
; IS__TUNIT_NPM-NEXT:    [[L12:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 3), align 1
; IS__TUNIT_NPM-NEXT:    [[ADD:%.*]] = add i8 [[L11]], [[L12]]
; IS__TUNIT_NPM-NEXT:    ret i8 [[ADD]]
;
; IS__CGSCC_OPM: Function Attrs: nofree norecurse nosync nounwind
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@phi_no_store_1
; IS__CGSCC_OPM-SAME: () #[[ATTR9:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_OPM:       loop:
; IS__CGSCC_OPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a1 to i8*), [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__CGSCC_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 3
; IS__CGSCC_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_OPM:       end:
; IS__CGSCC_OPM-NEXT:    [[L11:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 2), align 2
; IS__CGSCC_OPM-NEXT:    [[L12:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 3), align 1
; IS__CGSCC_OPM-NEXT:    [[ADD:%.*]] = add i8 [[L11]], [[L12]]
; IS__CGSCC_OPM-NEXT:    ret i8 [[ADD]]
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@phi_no_store_1
; IS__CGSCC_NPM-SAME: () #[[ATTR5]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_NPM:       loop:
; IS__CGSCC_NPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a1 to i8*), [[ENTRY:%.*]] ], [ [[G:%.*]], [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[G]] = getelementptr i8, i8* [[P]], i64 1
; IS__CGSCC_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 3
; IS__CGSCC_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_NPM:       end:
; IS__CGSCC_NPM-NEXT:    [[L11:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 2), align 2
; IS__CGSCC_NPM-NEXT:    [[L12:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a1 to i8*), i64 3), align 1
; IS__CGSCC_NPM-NEXT:    [[ADD:%.*]] = add i8 [[L11]], [[L12]]
; IS__CGSCC_NPM-NEXT:    ret i8 [[ADD]]
;
entry:
  %b = bitcast i32* @a1 to i8*
  br label %loop
loop:
  %p = phi i8* [%b, %entry], [%g, %loop]
  %i = phi i8 [0, %entry], [%o, %loop]
  store i8 1, i8* %p
  %g = getelementptr i8, i8* %p, i64 1
  %o = add nsw i8 %i, 1
  %c = icmp eq i8 %o, 3
  br i1 %c, label %end, label %loop
end:
  %s11 = getelementptr i8, i8* %b, i64 2
  %l11 = load i8, i8* %s11
  %s12 = getelementptr i8, i8* %b, i64 3
  %l12 = load i8, i8* %s12
  %add = add i8 %l11, %l12
  ret i8 %add
}

; FIXME: This function returns 1.
define i8 @phi_no_store_2() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@phi_no_store_2
; IS__TUNIT_OPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_OPM:       loop:
; IS__TUNIT_OPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a2 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    store i8 1, i8* [[P]], align 2
; IS__TUNIT_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__TUNIT_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_OPM:       end:
; IS__TUNIT_OPM-NEXT:    [[L21:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), align 2
; IS__TUNIT_OPM-NEXT:    [[ADD:%.*]] = add i8 [[L21]], 0
; IS__TUNIT_OPM-NEXT:    ret i8 [[ADD]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@phi_no_store_2
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_NPM:       loop:
; IS__TUNIT_NPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a2 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    store i8 1, i8* [[P]], align 2
; IS__TUNIT_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__TUNIT_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_NPM:       end:
; IS__TUNIT_NPM-NEXT:    [[L21:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), align 2
; IS__TUNIT_NPM-NEXT:    ret i8 [[L21]]
;
; IS__CGSCC_OPM: Function Attrs: nofree norecurse nosync nounwind
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@phi_no_store_2
; IS__CGSCC_OPM-SAME: () #[[ATTR9]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_OPM:       loop:
; IS__CGSCC_OPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a2 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    store i8 1, i8* [[P]], align 2
; IS__CGSCC_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__CGSCC_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_OPM:       end:
; IS__CGSCC_OPM-NEXT:    [[L21:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), align 2
; IS__CGSCC_OPM-NEXT:    [[ADD:%.*]] = add i8 [[L21]], 0
; IS__CGSCC_OPM-NEXT:    ret i8 [[ADD]]
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@phi_no_store_2
; IS__CGSCC_NPM-SAME: () #[[ATTR5]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_NPM:       loop:
; IS__CGSCC_NPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a2 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    store i8 1, i8* [[P]], align 2
; IS__CGSCC_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__CGSCC_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_NPM:       end:
; IS__CGSCC_NPM-NEXT:    [[L21:%.*]] = load i8, i8* getelementptr (i8, i8* bitcast (i32* @a2 to i8*), i64 2), align 2
; IS__CGSCC_NPM-NEXT:    ret i8 [[L21]]
;
entry:
  %b = bitcast i32* @a2 to i8*
  br label %loop
loop:
  %p = phi i8* [%b, %entry], [%g, %loop]
  %i = phi i8 [0, %entry], [%o, %loop]
  store i8 1, i8* %p
  %g = getelementptr i8, i8* %b, i64 2
  %o = add nsw i8 %i, 1
  %c = icmp eq i8 %o, 7
  br i1 %c, label %end, label %loop
end:
  %s21 = getelementptr i8, i8* %b, i64 2
  %l21 = load i8, i8* %s21
  %s22 = getelementptr i8, i8* %b, i64 3
  %l22 = load i8, i8* %s22
  %add = add i8 %l21, %l22
  ret i8 %add
}

define i8 @phi_no_store_3() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind writeonly
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@phi_no_store_3
; IS__TUNIT_OPM-SAME: () #[[ATTR6]] {
; IS__TUNIT_OPM-NEXT:  entry:
; IS__TUNIT_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_OPM:       loop:
; IS__TUNIT_OPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a3 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a3 to i8*), i64 2), [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__TUNIT_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_OPM:       end:
; IS__TUNIT_OPM-NEXT:    ret i8 1
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn writeonly
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@phi_no_store_3
; IS__TUNIT_NPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_NPM-NEXT:  entry:
; IS__TUNIT_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__TUNIT_NPM:       loop:
; IS__TUNIT_NPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a3 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a3 to i8*), i64 2), [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__TUNIT_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__TUNIT_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__TUNIT_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__TUNIT_NPM:       end:
; IS__TUNIT_NPM-NEXT:    ret i8 1
;
; IS__CGSCC_OPM: Function Attrs: nofree norecurse nosync nounwind writeonly
; IS__CGSCC_OPM-LABEL: define {{[^@]+}}@phi_no_store_3
; IS__CGSCC_OPM-SAME: () #[[ATTR10:[0-9]+]] {
; IS__CGSCC_OPM-NEXT:  entry:
; IS__CGSCC_OPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_OPM:       loop:
; IS__CGSCC_OPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a3 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a3 to i8*), i64 2), [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_OPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_OPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__CGSCC_OPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_OPM:       end:
; IS__CGSCC_OPM-NEXT:    ret i8 1
;
; IS__CGSCC_NPM: Function Attrs: nofree norecurse nosync nounwind willreturn writeonly
; IS__CGSCC_NPM-LABEL: define {{[^@]+}}@phi_no_store_3
; IS__CGSCC_NPM-SAME: () #[[ATTR4]] {
; IS__CGSCC_NPM-NEXT:  entry:
; IS__CGSCC_NPM-NEXT:    br label [[LOOP:%.*]]
; IS__CGSCC_NPM:       loop:
; IS__CGSCC_NPM-NEXT:    [[P:%.*]] = phi i8* [ bitcast (i32* @a3 to i8*), [[ENTRY:%.*]] ], [ getelementptr (i8, i8* bitcast (i32* @a3 to i8*), i64 2), [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[I:%.*]] = phi i8 [ 0, [[ENTRY]] ], [ [[O:%.*]], [[LOOP]] ]
; IS__CGSCC_NPM-NEXT:    [[O]] = add nsw i8 [[I]], 1
; IS__CGSCC_NPM-NEXT:    [[C:%.*]] = icmp eq i8 [[O]], 7
; IS__CGSCC_NPM-NEXT:    br i1 [[C]], label [[END:%.*]], label [[LOOP]]
; IS__CGSCC_NPM:       end:
; IS__CGSCC_NPM-NEXT:    ret i8 1
;
entry:
  %b = bitcast i32* @a3 to i8*
  %s30 = getelementptr i8, i8* %b, i64 3
  store i8 0, i8* %s30
  br label %loop
loop:
  %p = phi i8* [%b, %entry], [%g, %loop]
  %i = phi i8 [0, %entry], [%o, %loop]
  store i8 1, i8* %p
  %g = getelementptr i8, i8* %b, i64 2
  %o = add nsw i8 %i, 1
  %c = icmp eq i8 %o, 7
  br i1 %c, label %end, label %loop
end:
  %s31 = getelementptr i8, i8* %b, i64 2
  %l31 = load i8, i8* %s31
  %s32 = getelementptr i8, i8* %b, i64 3
  %l32 = load i8, i8* %s32
  %add = add i8 %l31, %l32
  ret i8 %add
}

define i8 @cast_and_load_1() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@cast_and_load_1
; IS__TUNIT_OPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_OPM-NEXT:    store i32 42, i32* @bytes1, align 4
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i8, i8* bitcast (i32* @bytes1 to i8*), align 4
; IS__TUNIT_OPM-NEXT:    ret i8 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@cast_and_load_1
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:    store i32 42, i32* @bytes1, align 4
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i8, i8* bitcast (i32* @bytes1 to i8*), align 4
; IS__TUNIT_NPM-NEXT:    ret i8 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@cast_and_load_1
; IS__CGSCC____-SAME: () #[[ATTR5]] {
; IS__CGSCC____-NEXT:    store i32 42, i32* @bytes1, align 4
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i8, i8* bitcast (i32* @bytes1 to i8*), align 4
; IS__CGSCC____-NEXT:    ret i8 [[L]]
;
  store i32 42, i32* @bytes1
  %bc = bitcast i32* @bytes1 to i8*
  %l = load i8, i8* %bc
  ret i8 %l
}

define i64 @cast_and_load_2() {
; IS__TUNIT_OPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_OPM-LABEL: define {{[^@]+}}@cast_and_load_2
; IS__TUNIT_OPM-SAME: () #[[ATTR4]] {
; IS__TUNIT_OPM-NEXT:    store i32 42, i32* @bytes2, align 4
; IS__TUNIT_OPM-NEXT:    [[L:%.*]] = load i64, i64* bitcast (i32* @bytes2 to i64*), align 4
; IS__TUNIT_OPM-NEXT:    ret i64 [[L]]
;
; IS__TUNIT_NPM: Function Attrs: nofree nosync nounwind willreturn
; IS__TUNIT_NPM-LABEL: define {{[^@]+}}@cast_and_load_2
; IS__TUNIT_NPM-SAME: () #[[ATTR2]] {
; IS__TUNIT_NPM-NEXT:    store i32 42, i32* @bytes2, align 4
; IS__TUNIT_NPM-NEXT:    [[L:%.*]] = load i64, i64* bitcast (i32* @bytes2 to i64*), align 4
; IS__TUNIT_NPM-NEXT:    ret i64 [[L]]
;
; IS__CGSCC____: Function Attrs: nofree norecurse nosync nounwind willreturn
; IS__CGSCC____-LABEL: define {{[^@]+}}@cast_and_load_2
; IS__CGSCC____-SAME: () #[[ATTR5]] {
; IS__CGSCC____-NEXT:    store i32 42, i32* @bytes2, align 4
; IS__CGSCC____-NEXT:    [[L:%.*]] = load i64, i64* bitcast (i32* @bytes2 to i64*), align 4
; IS__CGSCC____-NEXT:    ret i64 [[L]]
;
  store i32 42, i32* @bytes2
  %bc = bitcast i32* @bytes2 to i64*
  %l = load i64, i64* %bc
  ret i64 %l
}

!llvm.module.flags = !{!0, !1}
!llvm.ident = !{!2}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{i32 7, !"uwtable", i32 1}
!2 = !{!"clang version 13.0.0"}
!3 = !{!4, !4, i64 0}
!4 = !{!"int", !5, i64 0}
!5 = !{!"omnipotent char", !6, i64 0}
!6 = !{!"Simple C/C++ TBAA"}
!7 = !{!8, !9, i64 12}
!8 = !{!"S", !4, i64 0, !4, i64 4, !4, i64 8, !9, i64 12, !9, i64 16, !9, i64 20}
!9 = !{!"float", !5, i64 0}
!10 = !{!8, !9, i64 16}
!11 = !{!8, !9, i64 20}
!12 = !{!8, !4, i64 0}
!13 = !{!8, !4, i64 4}
!14 = !{!8, !4, i64 8}
!15 = !{!5, !5, i64 0}
!16 = distinct !{!16, !17}
!17 = !{!"llvm.loop.mustprogress"}
!18 = !{!9, !9, i64 0}
!19 = distinct !{!19, !17}
!20 = !{!21, !21, i64 0}
!21 = !{!"long long", !5, i64 0}
!22 = distinct !{!22, !17}
!23 = distinct !{!23, !17}
!24 = distinct !{!24, !17}
!25 = distinct !{!25, !17}
!26 = distinct !{!26, !17}
!27 = distinct !{!27, !17}
!28 = distinct !{!28, !17}
!29 = distinct !{!29, !17}
!30 = distinct !{!30, !17}
!31 = distinct !{!31, !17}
;.
; IS__TUNIT_OPM: attributes #[[ATTR0]] = { argmemonly nofree nosync nounwind willreturn writeonly }
; IS__TUNIT_OPM: attributes #[[ATTR1]] = { argmemonly nofree nosync nounwind willreturn }
; IS__TUNIT_OPM: attributes #[[ATTR2]] = { nofree nosync nounwind }
; IS__TUNIT_OPM: attributes #[[ATTR3]] = { nofree nosync nounwind readnone willreturn }
; IS__TUNIT_OPM: attributes #[[ATTR4]] = { nofree nosync nounwind willreturn }
; IS__TUNIT_OPM: attributes #[[ATTR5]] = { nofree nosync nounwind willreturn writeonly }
; IS__TUNIT_OPM: attributes #[[ATTR6]] = { nofree nosync nounwind writeonly }
; IS__TUNIT_OPM: attributes #[[ATTR7]] = { nofree nosync nounwind readonly willreturn }
; IS__TUNIT_OPM: attributes #[[ATTR8]] = { nofree nosync nounwind readnone }
; IS__TUNIT_OPM: attributes #[[ATTR9]] = { willreturn }
;.
; IS__TUNIT_NPM: attributes #[[ATTR0]] = { argmemonly nofree nosync nounwind willreturn writeonly }
; IS__TUNIT_NPM: attributes #[[ATTR1]] = { argmemonly nofree nosync nounwind willreturn }
; IS__TUNIT_NPM: attributes #[[ATTR2]] = { nofree nosync nounwind willreturn }
; IS__TUNIT_NPM: attributes #[[ATTR3]] = { nofree nosync nounwind readnone willreturn }
; IS__TUNIT_NPM: attributes #[[ATTR4]] = { nofree nosync nounwind willreturn writeonly }
; IS__TUNIT_NPM: attributes #[[ATTR5]] = { nofree nosync nounwind readonly willreturn }
; IS__TUNIT_NPM: attributes #[[ATTR6]] = { willreturn }
;.
; IS__CGSCC_OPM: attributes #[[ATTR0]] = { argmemonly nofree norecurse nosync nounwind willreturn writeonly }
; IS__CGSCC_OPM: attributes #[[ATTR1]] = { argmemonly nofree nosync nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR2]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR3]] = { nofree nosync nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR4]] = { nofree norecurse nosync nounwind willreturn writeonly }
; IS__CGSCC_OPM: attributes #[[ATTR5]] = { nofree norecurse nosync nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR6]] = { argmemonly nofree norecurse nosync nounwind willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR7]] = { nofree norecurse nosync nounwind readonly willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR8]] = { nofree norecurse nosync nounwind readnone }
; IS__CGSCC_OPM: attributes #[[ATTR9]] = { nofree norecurse nosync nounwind }
; IS__CGSCC_OPM: attributes #[[ATTR10]] = { nofree norecurse nosync nounwind writeonly }
; IS__CGSCC_OPM: attributes #[[ATTR11]] = { willreturn }
; IS__CGSCC_OPM: attributes #[[ATTR12]] = { nounwind willreturn writeonly }
; IS__CGSCC_OPM: attributes #[[ATTR13]] = { nounwind writeonly }
;.
; IS__CGSCC_NPM: attributes #[[ATTR0]] = { argmemonly nofree norecurse nosync nounwind willreturn writeonly }
; IS__CGSCC_NPM: attributes #[[ATTR1]] = { argmemonly nofree nosync nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR2]] = { nofree norecurse nosync nounwind readnone willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR3]] = { nofree nosync nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR4]] = { nofree norecurse nosync nounwind willreturn writeonly }
; IS__CGSCC_NPM: attributes #[[ATTR5]] = { nofree norecurse nosync nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR6]] = { argmemonly nofree norecurse nosync nounwind willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR7]] = { nofree norecurse nosync nounwind readonly willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR8]] = { willreturn }
; IS__CGSCC_NPM: attributes #[[ATTR9]] = { nounwind willreturn writeonly }
; IS__CGSCC_NPM: attributes #[[ATTR10]] = { nounwind writeonly }
;.
; IS__TUNIT____: [[META0:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
; IS__TUNIT____: [[META1:![0-9]+]] = !{i32 7, !"uwtable", i32 1}
; IS__TUNIT____: [[META2:![0-9]+]] = !{!"clang version 13.0.0"}
; IS__TUNIT____: [[TBAA3]] = !{!4, !4, i64 0}
; IS__TUNIT____: [[META4:![0-9]+]] = !{!"int", !5, i64 0}
; IS__TUNIT____: [[META5:![0-9]+]] = !{!"omnipotent char", !6, i64 0}
; IS__TUNIT____: [[META6:![0-9]+]] = !{!"Simple C/C++ TBAA"}
; IS__TUNIT____: [[META7:![0-9]+]] = !{!8, !9, i64 12}
; IS__TUNIT____: [[META8:![0-9]+]] = !{!"S", !4, i64 0, !4, i64 4, !4, i64 8, !9, i64 12, !9, i64 16, !9, i64 20}
; IS__TUNIT____: [[META9:![0-9]+]] = !{!"float", !5, i64 0}
; IS__TUNIT____: [[META10:![0-9]+]] = !{!8, !9, i64 16}
; IS__TUNIT____: [[META11:![0-9]+]] = !{!8, !9, i64 20}
; IS__TUNIT____: [[META12:![0-9]+]] = !{!8, !4, i64 0}
; IS__TUNIT____: [[META13:![0-9]+]] = !{!8, !4, i64 4}
; IS__TUNIT____: [[META14:![0-9]+]] = !{!8, !4, i64 8}
; IS__TUNIT____: [[META15:![0-9]+]] = distinct !{!15, !16}
; IS__TUNIT____: [[META16:![0-9]+]] = !{!"llvm.loop.mustprogress"}
; IS__TUNIT____: [[META17:![0-9]+]] = distinct !{!17, !16}
; IS__TUNIT____: [[META18:![0-9]+]] = distinct !{!18, !16}
; IS__TUNIT____: [[META19:![0-9]+]] = !{!5, !5, i64 0}
; IS__TUNIT____: [[META20:![0-9]+]] = distinct !{!20, !16}
; IS__TUNIT____: [[META21:![0-9]+]] = distinct !{!21, !16}
; IS__TUNIT____: [[META22:![0-9]+]] = distinct !{!22, !16}
; IS__TUNIT____: [[META23:![0-9]+]] = distinct !{!23, !16}
; IS__TUNIT____: [[META24:![0-9]+]] = distinct !{!24, !16}
; IS__TUNIT____: [[META25:![0-9]+]] = distinct !{!25, !16}
; IS__TUNIT____: [[META26:![0-9]+]] = !{!9, !9, i64 0}
; IS__TUNIT____: [[META27:![0-9]+]] = distinct !{!27, !16}
; IS__TUNIT____: [[META28:![0-9]+]] = !{!29, !29, i64 0}
; IS__TUNIT____: [[META29:![0-9]+]] = !{!"long long", !5, i64 0}
; IS__TUNIT____: [[META30:![0-9]+]] = distinct !{!30, !16}
; IS__TUNIT____: [[META31:![0-9]+]] = distinct !{!31, !16}
;.
; IS__CGSCC____: [[META0:![0-9]+]] = !{i32 1, !"wchar_size", i32 4}
; IS__CGSCC____: [[META1:![0-9]+]] = !{i32 7, !"uwtable", i32 1}
; IS__CGSCC____: [[META2:![0-9]+]] = !{!"clang version 13.0.0"}
; IS__CGSCC____: [[TBAA3]] = !{!4, !4, i64 0}
; IS__CGSCC____: [[META4:![0-9]+]] = !{!"int", !5, i64 0}
; IS__CGSCC____: [[META5:![0-9]+]] = !{!"omnipotent char", !6, i64 0}
; IS__CGSCC____: [[META6:![0-9]+]] = !{!"Simple C/C++ TBAA"}
; IS__CGSCC____: [[META7:![0-9]+]] = !{!8, !9, i64 12}
; IS__CGSCC____: [[META8:![0-9]+]] = !{!"S", !4, i64 0, !4, i64 4, !4, i64 8, !9, i64 12, !9, i64 16, !9, i64 20}
; IS__CGSCC____: [[META9:![0-9]+]] = !{!"float", !5, i64 0}
; IS__CGSCC____: [[META10:![0-9]+]] = !{!8, !9, i64 16}
; IS__CGSCC____: [[META11:![0-9]+]] = !{!8, !9, i64 20}
; IS__CGSCC____: [[META12:![0-9]+]] = !{!8, !4, i64 0}
; IS__CGSCC____: [[META13:![0-9]+]] = !{!8, !4, i64 4}
; IS__CGSCC____: [[META14:![0-9]+]] = !{!8, !4, i64 8}
; IS__CGSCC____: [[META15:![0-9]+]] = !{!5, !5, i64 0}
; IS__CGSCC____: [[META16:![0-9]+]] = distinct !{!16, !17}
; IS__CGSCC____: [[META17:![0-9]+]] = !{!"llvm.loop.mustprogress"}
; IS__CGSCC____: [[META18:![0-9]+]] = !{!9, !9, i64 0}
; IS__CGSCC____: [[META19:![0-9]+]] = distinct !{!19, !17}
; IS__CGSCC____: [[META20:![0-9]+]] = !{!21, !21, i64 0}
; IS__CGSCC____: [[META21:![0-9]+]] = !{!"long long", !5, i64 0}
; IS__CGSCC____: [[META22:![0-9]+]] = distinct !{!22, !17}
; IS__CGSCC____: [[META23:![0-9]+]] = distinct !{!23, !17}
; IS__CGSCC____: [[META24:![0-9]+]] = distinct !{!24, !17}
; IS__CGSCC____: [[META25:![0-9]+]] = distinct !{!25, !17}
; IS__CGSCC____: [[META26:![0-9]+]] = distinct !{!26, !17}
; IS__CGSCC____: [[META27:![0-9]+]] = distinct !{!27, !17}
; IS__CGSCC____: [[META28:![0-9]+]] = distinct !{!28, !17}
; IS__CGSCC____: [[META29:![0-9]+]] = distinct !{!29, !17}
; IS__CGSCC____: [[META30:![0-9]+]] = distinct !{!30, !17}
; IS__CGSCC____: [[META31:![0-9]+]] = distinct !{!31, !17}
;.
