/*
 * Copyright (c) 2004, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package nsk.jvmti.scenarios.capability.CM02;

import java.io.PrintStream;

import nsk.share.*;
import nsk.share.jvmti.*;

public class cm02t001 extends DebugeeClass {

    // run test from command line
    public static void main(String argv[]) {
        argv = nsk.share.jvmti.JVMTITest.commonInit(argv);

        // JCK-compatible exit
        System.exit(run(argv, System.out) + Consts.JCK_STATUS_BASE);
    }

    // run test from JCK-compatible environment
    public static int run(String argv[], PrintStream out) {
        return new cm02t001().runIt(argv, out);
    }

    /* =================================================================== */

    // scaffold objects
    ArgumentHandler argHandler = null;
    Log log = null;
    int status = Consts.TEST_PASSED;
    static long timeout = 0;

    // tested thread
    cm02t001Thread thread = null;

    // run debuggee
    public int runIt(String argv[], PrintStream out) {
        argHandler = new ArgumentHandler(argv);
        log = new Log(out, argHandler);
        timeout = argHandler.getWaitTime() * 60000; // milliseconds
        log.display("Timeout = " + timeout + " msc.");

        thread = new cm02t001Thread("Debuggee Thread");

        synchronized (thread.endingMonitor) {
            // run thread
            try {
                // start thread
                synchronized (thread.startingMonitor) {
                    thread.start();
                    thread.startingMonitor.wait(timeout);
                }
                if (!thread.checkReady()) {
                    throw new Failure("Unable to run thread " + thread);
                }

                // testing sync
                log.display("Testing sync: thread ready");
                if ((status = checkStatus(status)) != Consts.TEST_PASSED)
                    return status;
                thread.letFinish();

                // pause to provoke contention on thread.endingMonitor
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                throw new Failure(e);
            }
            log.display("Testing sync: thread finish");
        }

        // wait for thread finish
        try {
            thread.join(timeout);
        } catch (InterruptedException e) {
            throw new Failure(e);
        }

        thread = null;
        System.gc();
        status = checkStatus(status);

        log.display("Testing sync: debuggee exit");
        return status;
    }
}

/* =================================================================== */

class cm02t001Thread extends Thread {
    public Object startingMonitor = new Object();
    public Object endingMonitor = new Object();
    private Object waitingMonitor = new Object();

    public cm02t001Thread(String name) {
        super(name);
    }

    public void run() {
        synchronized (waitingMonitor) {

            Object o = new Object();
            int i = 1;
            long l = 2;
            float f = 3.0F;
            double d = 4.0;

            // notify about starting
            synchronized (startingMonitor) {
                startingMonitor.notify();
            }

            // wait on monitor
            try {
                waitingMonitor.wait(cm02t001.timeout);
            } catch (InterruptedException ignore) {
                // just finish
            }
        }

        // wait until main thread release monitor
        synchronized (endingMonitor) {
        }
    }

    public boolean checkReady() {
        // wait until waitingMonitor released on wait()
        synchronized (waitingMonitor) {
        }
        return true;
    }

    public void letFinish() {
        synchronized (waitingMonitor) {
            waitingMonitor.notify();
        }
    }
}
