Something other than a type or const parameter has been used when one was
expected.

Erroneous code example:

```compile_fail,E0799
fn bad1() -> impl Sized + use<main> {}

fn bad2(x: ()) -> impl Sized + use<x> {}

fn main() {}
```

In the given examples, for `bad1`, the name `main` corresponds to a function
rather than a type or const parameter. In `bad2`, the name `x` corresponds to
a function argument rather than a type or const parameter.

Only type and const parameters, including `Self`, may be captured by
`use<...>` precise capturing bounds.
