/*
    LIB - a librarian for compatible OBJ/LIB files
    Copyright (C) 1995,1996  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: TYPES.H 3.3 1999/02/17 05:18:08 ska Rel ska $
   $Locker: ska $	$Name: v3_2 $	$State: Rel $

	global definitions

*/

#ifndef __TYPES_H
#define __TYPES_H

#include <stdio.h>
#include <suppl.h>		/* supplemental functions */
#include "config.h"

#define CMD_NONE 0
#define CMD_ADD 1
#define CMD_SUB 2
#define CMD_EXT 4
#define CMD_ALL (CMD_ADD | CMD_SUB | CMD_EXT)
#define CMD_DONE 3		/* shift value */
#define CMD_ADDED (CMD_ADD << CMD_DONE)		/* 8 */
#define CMD_SUBED (CMD_SUB << CMD_DONE)		/* 0x10 */
#define CMD_EXTED (CMD_EXT << CMD_DONE)		/* 0x20 */
#define CMD_TWICE 0x40
#define CMD_ERROR 0x80
#define CMD_THROUGH 0x8000	/* don't check for existance when append */

#ifndef _MICROC_
#include <assert.h>
#include <alloc.h>
#define iM(s)
#define nM(s) s
#define wC(mc,nmc) nmc
#else
#define iM(s) s
#define nM(s)
#define wC(mc,nmc) mc
#ifdef NDEBUG
#define assert(a)
#else
#define	assert(a) if(!(a)) abort("assertation failed.");
#endif
#endif
#include <setjmp.h>

#ifndef _MICROC_
	#if __TURBOC__ < 0x300
		#define allocStk malloc
		#define freeStk free
	#endif
#endif
#ifndef allocStk
#define allocStk alloca
#define freeStk(a)
#endif

#ifndef _MICROC_
#define fget(buf,len,fp) fread(buf,1,len,fp)	/* useful shortcuts */
/* #define fput(buf,len,fp) fwrite(buf,1,len,fp) */
#define rr(buf,len,fp) fread(buf,len,1,fp) != 1
#define ww(buf,len,fp) fwrite(buf,len,1,fp) != 1
#define FILEP FILE *
#define Close fclose
#else		/* To avoid bugs in R&W mode of buffer I/O use unbuffered */
#define fget read
#define rr(buf,len,fp) read(buf,len,fp) != (len)
#define ww(buf,len,fp) write(buf,len,fp)
#define FILEP int
#define Close close
#endif

extern FLAG ovrrun;			/* library-size overrun */
extern FLAG upCaseIt;		/* if true: upper-casing all names */
extern FLAG replInternal;	/* glob "+-" internally */
extern FLAG replWarn;		/* not warn if module is not in lib on "-+" */
extern jmp_buf restart;		/* long jump to restart the librarian */
extern byte ybuf[COPYBUF];	/* short-time temporary buffer */

#ifndef _MICROC_
int cbreak(int action);
/* Controls the verbose ^Break checking flag of DOS:
	action == -1:	return the current state of the flag
	action ==  0:	disable verbose ^Break checking
	action ==  1:	enable verbose ^Break checking

	Return:	current or new state (0 == disabled)
*/
#else
int creat(char *fnam, int attr);
/* Create the file fnam with the specified attributes. */
#endif

void *getmem(unsigned const size);
/* allocate dynamic memory and emit an error message if failed */

char *dupstr(const char * const str);
/* duplicate string and emit an error message if failed */

void *dupmem(const int length, const void * const mem);
/* duplicate the memory contents into the local heap and append a trailing
	'\0' character */

void upCaseFct(int mode, char *s);
/* Upper-case the string s.
	If mode == 0, no upper-case; mode == 1, non-file name upper-case;
	mode == 2, file name upper-case
*/

void beautify(char * const str);
/* Insert thousend separators into the string. */

int fsplit(char *fname, char **dr, char **path, char **name, char **ext, int d);
/* Split a file name.
	fname is the file name to split
	dr, path, name, ext:	Pointers, which will receive the results.
							These are malloc'ed and NULL, if the particular
								part is missing.
							dr does not has the ':'.
							the trailing '\\' is stripped. Therefore, path == "" means "\\"
							ext does not contain the leading '.'.
							slashes are transformed into backslashes '/' -> '\\'.
							multiple backslashes are reduced to a single one.

   Return: 	0 if malloc failure
   			!= 0 else
*/
char *fmerge(char *fname, char *dr, char *path, char *name, char *ext);
/* Merge a file name.

	dr, path, name, ext:	Pointers of the path components.
							If one of these is NULL, it is not merged.
							If it is "", it's merged and the standard characters
								are inserted (':', '\\', '.').
	fname:	Pointer to the memory to receive the result.
			If NULL: the necessary memory is malloc'ed.

   Return: pointer to the beginning of the result or NULL if malloc failed.
*/

char *namePart(char *fnam);
/*	Return a pointer to one byte below the first character of the file name
	part of fnam.
*/

char *replName(char *name, char *fnam);
/*	Replaces the filename portion (not included the extension) with
	the potion of fnam.

	The new name is malloc()'ed.
*/

int wildcarded(char *path);
/* Test, if the name portion of the path spec contains wildcards.
	The extension is ignored, too.
*/

void Rewind(FILEP fp, char *fnam);
/* Rewind the file fp and emit an error message, if this fails
*/

void upStr(unsigned char *s, unsigned table);
/* Upcase the string s according the table.
	table == 2 -> normal characters;
	table == 4 -> characters for file names.
*/

#define U_malloc malloc
#define U_free free
#define U_realloc realloc
#define U_strdup strdup

#ifndef _MICROC_
#ifndef NDEBUG
/* Debug functions */
#undef U_malloc
#undef U_free
#undef U_realloc
#undef U_strdup
void U_free(void *poi);
void *U_malloc(const unsigned len);
char *U_strdup(const char * const poi);
void *U_realloc(void *poi, const unsigned len);
#endif
#endif

#endif
