/*
 * hash.h -- define hash table entries, sizes, hash function...
 *
 * SOFTWARE RIGHTS
 *
 * We reserve no LEGAL rights to SORCERER -- SORCERER is in the public
 * domain.  An individual or company may do whatever they wish with
 * source code distributed with SORCERER or the code generated by
 * SORCERER, including the incorporation of SORCERER, or its output, into
 * commerical software.
 *
 * We encourage users to develop software with SORCERER.  However, we do
 * ask that credit is given to us for developing SORCERER.  By "credit",
 * we mean that if you incorporate our source code into one of your
 * programs (commercial product, research project, or otherwise) that you
 * acknowledge this fact somewhere in the documentation, research report,
 * etc...  If you like SORCERER and have developed a nice tool with the
 * output, please mention that you developed it using SORCERER.  In
 * addition, we ask that this header remain intact in our source code.
 * As long as these guidelines are kept, we expect to continue enhancing
 * this system and expect to make other tools available as they are
 * completed.
 *
 * SORCERER 1.00B
 * Terence Parr
 * AHPCRC, University of Minnesota
 * 1992-2001
 */

				/* H a s h  T a b l e  S t u f f */
#ifndef __sorcerer_hash_h__
#define __sorcerer_hash_h__

#include "pcctscfg.h" /* MR20 G. Hobbelt - Use __USE_PROTOS */

#ifndef HashTableSize
#define HashTableSize	553
#endif
#ifndef StrTableSize
#define StrTableSize	40000
#endif

typedef struct _entry {		/* Minimum hash table entry -- superclass */
			char *str;
			struct _entry *next;
		} Entry;

/* Hash 's' using 'size', place into h (s is modified) */
#define Hash(s,h,size)								\
	{while ( *s != '\0' ) h = (h<<1) + *s++;		\
	h %= size;}

#ifdef __USE_PROTOS
Entry	*hash_get(Entry **, char *),
		**newHashTable(void),
		*hash_add(Entry **, char *, Entry *);
char	*mystrdup(char *);
void hashStat( Entry ** );
#else
Entry *hash_get(), **newHashTable(), *hash_add();
char	*mystrdup();
void hashStat();
#endif

#endif

