/* ============================================================
 *
 * This file is a part of digiKam project
 * https://www.digikam.org
 *
 * Date        : 2004-07-09
 * Description : a tool to sharp an image
 *
 * SPDX-FileCopyrightText: 2004-2022 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * ============================================================ */

#ifndef DIGIKAM_EDITOR_SHARPEN_TOOL_H
#define DIGIKAM_EDITOR_SHARPEN_TOOL_H

// Local includes

#include "editortool.h"

using namespace Digikam;

namespace DigikamEditorSharpenToolPlugin
{

class SharpenTool : public EditorToolThreaded
{
    Q_OBJECT

public:

    explicit SharpenTool(QObject* const parent);
    ~SharpenTool()              override;

private Q_SLOTS:

    void slotSaveAsSettings()   override;
    void slotLoadSettings()     override;
    void slotResetSettings()    override;
    void slotSettingsChanged();

private:

    void readSettings()         override;
    void writeSettings()        override;
    void preparePreview()       override;
    void prepareFinal()         override;
    void setPreviewImage()      override;
    void setFinalImage()        override;
    void renderingFinished()    override;

private:

    class Private;
    Private* const d;
};

} // namespace DigikamEditorSharpenToolPlugin

#endif // DIGIKAM_EDITOR_SHARPEN_TOOL_H
