/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.SequenceFeature;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class FeatureSettings
extends Panel
implements ItemListener,
MouseListener,
MouseMotionListener,
ActionListener,
AdjustmentListener {
    FeatureRenderer fr;
    AlignmentPanel ap;
    AlignViewport av;
    Frame frame;
    Panel groupPanel;
    Panel featurePanel = new Panel();
    ScrollPane scrollPane;
    boolean alignmentHasFeatures = false;
    Image linkImage;
    Scrollbar transparency;
    MyCheckbox selectedCheck;
    boolean dragging = false;

    public FeatureSettings(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
        ap.av.featureSettings = this;
        this.fr = ap.seqPanel.seqCanvas.getFeatureRenderer();
        this.transparency = new Scrollbar(0, 100 - (int)(this.fr.transparency * 100.0f), 1, 1, 100);
        if (this.fr.transparencySetter != null) {
            this.transparency.addAdjustmentListener(this);
        } else {
            this.transparency.setEnabled(false);
        }
        URL url = this.getClass().getResource("/images/link.gif");
        if (url != null) {
            this.linkImage = Toolkit.getDefaultToolkit().getImage(url);
        }
        if (this.av.featuresDisplayed == null) {
            this.fr.findAllFeatures();
        }
        this.setTableData();
        this.setLayout(new BorderLayout());
        this.scrollPane = new ScrollPane();
        this.scrollPane.add(this.featurePanel);
        if (this.alignmentHasFeatures) {
            this.add((Component)this.scrollPane, "Center");
        }
        Button invert = new Button("Invert Selection");
        invert.addActionListener(this);
        Panel lowerPanel = new Panel(new GridLayout(2, 1, 5, 10));
        lowerPanel.add(invert);
        Panel tPanel = new Panel(new BorderLayout());
        if (this.fr.transparencySetter != null) {
            tPanel.add((Component)this.transparency, "Center");
            tPanel.add((Component)new Label("Transparency"), "East");
        } else {
            tPanel.add((Component)new Label("Transparency not available in this web browser"), "Center");
        }
        lowerPanel.add((Component)tPanel, "South");
        this.add((Component)lowerPanel, "South");
        if (this.groupPanel != null) {
            this.groupPanel.setLayout(new GridLayout(this.fr.featureGroups.size() / 4 + 1, 4));
            this.groupPanel.validate();
            this.add((Component)this.groupPanel, "North");
        }
        this.frame = new Frame();
        this.frame.add(this);
        final FeatureSettings me = this;
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (me.av.featureSettings == me) {
                    me.av.featureSettings = null;
                    me.ap = null;
                    me.av = null;
                }
            }
        });
        int height = this.featurePanel.getComponentCount() * 50 + 60;
        height = Math.max(200, height);
        height = Math.min(400, height);
        int width = 300;
        JalviewLite.addFrame(this.frame, "Feature Settings", width, height);
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawString("No Features added to this alignment!!", 10, 20);
        g.drawString("(Features can be added from searches or", 10, 40);
        g.drawString("from Jalview / GFF features files)", 10, 60);
    }

    public void setTableData() {
        this.alignmentHasFeatures = this.fr.buildGroupHash();
        if (this.alignmentHasFeatures) {
            this.rebuildGroups();
        }
        this.resetTable(false);
    }

    public void rebuildGroups() {
        boolean rdrw = false;
        if (this.groupPanel == null) {
            this.groupPanel = new Panel();
        } else {
            rdrw = true;
            this.groupPanel.removeAll();
        }
        Enumeration gps = this.fr.featureGroups.keys();
        while (gps.hasMoreElements()) {
            String group = (String)gps.nextElement();
            Boolean vis = (Boolean)this.fr.featureGroups.get(group);
            MyCheckbox check = new MyCheckbox(group, vis, this.fr.featureLinks != null && this.fr.featureLinks.containsKey(group));
            check.addMouseListener(this);
            check.setFont(new Font("Serif", 1, 12));
            check.addItemListener(this);
            this.groupPanel.add(check);
        }
        if (rdrw) {
            this.groupPanel.validate();
        }
    }

    void resetTable(boolean groupsChanged) {
        String group = null;
        Vector<String> visibleChecks = new Vector<String>();
        for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
            if (this.av.alignment.getSequenceAt(i).getSequenceFeatures() == null) continue;
            SequenceFeature[] tmpfeatures = this.av.alignment.getSequenceAt(i).getSequenceFeatures();
            for (int index = 0; index < tmpfeatures.length; ++index) {
                String type;
                group = tmpfeatures[index].featureGroup;
                if (group != null && this.fr.featureGroups.get(group) != null && !((Boolean)this.fr.featureGroups.get(group)).booleanValue() || visibleChecks.contains(type = tmpfeatures[index].getType())) continue;
                visibleChecks.addElement(type);
            }
        }
        int cSize = this.featurePanel.getComponentCount();
        for (int i = 0; i < cSize; ++i) {
            Component[] comps = this.featurePanel.getComponents();
            Checkbox check = (Checkbox)comps[i];
            if (visibleChecks.contains(check.getLabel())) continue;
            this.featurePanel.remove(i);
            --cSize;
            --i;
        }
        if (this.fr.renderOrder != null) {
            for (int ro = this.fr.renderOrder.length - 1; ro > -1; --ro) {
                String item = this.fr.renderOrder[ro];
                if (!visibleChecks.contains(item)) continue;
                visibleChecks.removeElement(item);
                this.addCheck(false, item);
            }
        }
        Enumeration en = visibleChecks.elements();
        while (en.hasMoreElements()) {
            this.addCheck(groupsChanged, en.nextElement().toString());
        }
        this.featurePanel.setLayout(new GridLayout(this.featurePanel.getComponentCount(), 1, 10, 5));
        this.featurePanel.validate();
        if (this.scrollPane != null) {
            this.scrollPane.validate();
        }
        this.itemStateChanged(null);
    }

    void addCheck(boolean groupsChanged, String type) {
        Checkbox check;
        Component[] comps = this.featurePanel.getComponents();
        boolean addCheck = true;
        for (int i = 0; i < this.featurePanel.getComponentCount(); ++i) {
            check = (Checkbox)comps[i];
            if (!check.getLabel().equals(type)) continue;
            addCheck = false;
            break;
        }
        if (addCheck) {
            boolean selected = false;
            if (groupsChanged || this.av.featuresDisplayed.containsKey(type)) {
                selected = true;
            }
            check = new MyCheckbox(type, selected, this.fr.featureLinks != null && this.fr.featureLinks.containsKey(type));
            check.addMouseListener(this);
            check.addMouseMotionListener(this);
            check.setBackground(this.fr.getColour(type));
            check.addItemListener(this);
            if (groupsChanged) {
                this.featurePanel.add((Component)check, 0);
            } else {
                this.featurePanel.add(check);
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        for (int i = 0; i < this.featurePanel.getComponentCount(); ++i) {
            Checkbox check;
            check.setState(!(check = (Checkbox)this.featurePanel.getComponent(i)).getState());
        }
        this.selectionChanged();
    }

    public void itemStateChanged(ItemEvent evt) {
        Checkbox source;
        if (evt != null && this.fr.featureGroups.containsKey((source = (Checkbox)evt.getSource()).getLabel())) {
            this.fr.featureGroups.put(source.getLabel(), new Boolean(source.getState()));
            this.ap.seqPanel.seqCanvas.repaint();
            if (this.ap.overviewPanel != null) {
                this.ap.overviewPanel.updateOverviewImage();
            }
            this.resetTable(true);
            return;
        }
        this.selectionChanged();
    }

    void selectionChanged() {
        Component[] comps = this.featurePanel.getComponents();
        int cSize = comps.length;
        Object[][] tmp = new Object[cSize][3];
        int tmpSize = 0;
        for (int i = 0; i < cSize; ++i) {
            Checkbox check = (Checkbox)comps[i];
            tmp[tmpSize][0] = check.getLabel();
            tmp[tmpSize][1] = this.fr.getColour(check.getLabel());
            tmp[tmpSize][2] = new Boolean(check.getState());
            ++tmpSize;
        }
        Object[][] data = new Object[tmpSize][3];
        System.arraycopy(tmp, 0, data, 0, tmpSize);
        this.fr.setFeaturePriority(data);
        this.ap.paintAlignment(true);
    }

    public void mousePressed(MouseEvent evt) {
        this.selectedCheck = (MyCheckbox)evt.getSource();
        if (this.fr.featureLinks != null && this.fr.featureLinks.containsKey(this.selectedCheck.getLabel()) && evt.getX() > this.selectedCheck.stringWidth + 20) {
            evt.consume();
        }
    }

    public void mouseDragged(MouseEvent evt) {
        if (((Component)evt.getSource()).getParent() != this.featurePanel) {
            return;
        }
        this.dragging = true;
    }

    public void mouseReleased(MouseEvent evt) {
        if (((Component)evt.getSource()).getParent() != this.featurePanel) {
            return;
        }
        Component comp = null;
        Checkbox target = null;
        int height = evt.getY() + evt.getComponent().getLocation().y;
        comp = height > this.featurePanel.getSize().height ? this.featurePanel.getComponent(this.featurePanel.getComponentCount() - 1) : (height < 0 ? this.featurePanel.getComponent(0) : this.featurePanel.getComponentAt(evt.getX(), evt.getY() + evt.getComponent().getLocation().y));
        if (comp != null && comp instanceof Checkbox) {
            target = (Checkbox)comp;
        }
        if (this.selectedCheck != null && target != null && this.selectedCheck != target) {
            int targetIndex = -1;
            for (int i = 0; i < this.featurePanel.getComponentCount(); ++i) {
                if (target != this.featurePanel.getComponent(i)) continue;
                targetIndex = i;
                break;
            }
            this.featurePanel.remove(this.selectedCheck);
            this.featurePanel.add((Component)this.selectedCheck, targetIndex);
            this.featurePanel.validate();
            this.itemStateChanged(null);
        }
    }

    public void setUserColour(String feature, Color col) {
        this.fr.setColour(feature, col);
        this.featurePanel.removeAll();
        this.resetTable(false);
        this.ap.paintAlignment(true);
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
        MyCheckbox check = (MyCheckbox)evt.getSource();
        if (this.fr.featureLinks != null && this.fr.featureLinks.containsKey(check.getLabel()) && evt.getX() > check.stringWidth + 20) {
            evt.consume();
            String link = this.fr.featureLinks.get(check.getLabel()).toString();
            this.ap.alignFrame.showURL(link.substring(link.indexOf("|") + 1), link.substring(0, link.indexOf("|")));
        }
        if (check.getParent() != this.featurePanel) {
            return;
        }
        if (evt.getClickCount() > 1) {
            new UserDefinedColours((Object)this, check.getLabel(), this.fr.getColour(check.getLabel()));
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.fr.transparency = (float)(100 - this.transparency.getValue()) / 100.0f;
        this.ap.seqPanel.seqCanvas.repaint();
    }

    class MyCheckbox
    extends Checkbox {
        public int stringWidth;
        boolean hasLink;

        public MyCheckbox(String label, boolean checked, boolean haslink) {
            super(label, checked);
            FontMetrics fm = FeatureSettings.this.av.nullFrame.getFontMetrics(FeatureSettings.this.av.nullFrame.getFont());
            this.stringWidth = fm.stringWidth(label);
            this.hasLink = haslink;
        }

        public void paint(Graphics g) {
            if (this.hasLink) {
                g.drawImage(FeatureSettings.this.linkImage, this.stringWidth + 25, (this.getSize().height - FeatureSettings.this.linkImage.getHeight(this)) / 2, this);
            }
        }
    }
}

