/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.awt.Color;

public class Blosum62ColourScheme
extends ResidueColourScheme {
    public Color findColour(char res, int j) {
        Color currentColour;
        if ('a' <= res && res <= 'z') {
            res = (char)(res - 32);
        }
        if (this.consensus == null || j >= this.consensus.length || this.consensus[j] == null || this.threshold != 0 && !this.aboveThreshold(res, j)) {
            return Color.white;
        }
        if (!Comparison.isGap(res)) {
            String max = (String)this.consensus[j].get("R");
            if (max.indexOf(res) > -1) {
                currentColour = new Color(154, 154, 255);
            } else {
                int c = 0;
                int max_aa = 0;
                int n = max.length();
                do {
                    c += ResidueProperties.getBLOSUM62(max.charAt(max_aa), res);
                } while (++max_aa < n);
                currentColour = c > 0 ? new Color(204, 204, 255) : Color.white;
            }
            if (this.conservationColouring) {
                currentColour = this.applyConservation(currentColour, j);
            }
        } else {
            return Color.white;
        }
        return currentColour;
    }
}

