/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner;

import gnu.bioinformatics.jaligner.algorithms.SmithWaterman;
import gnu.bioinformatics.jaligner.formats.FASTA;
import gnu.bioinformatics.jaligner.formats.Pair;
import gnu.bioinformatics.jaligner.util.Alignment;
import gnu.bioinformatics.jaligner.util.Matrices;
import gnu.bioinformatics.jaligner.util.Parser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Date;

public class SW {
    public static final float DEFAULT_OPEN_GAP_PENALTY = 10.0f;
    public static final float DEFAULT_EXTEND_GAP_PENALTY = 0.5f;
    public static final String DEFAULT_MATRIX = "BLOSUM62";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        try {
            String s1 = null;
            String s2 = null;
            String matrix = DEFAULT_MATRIX;
            float open = 10.0f;
            float extend = 0.5f;
            String file = null;
            int i = 0;
            while (i < args.length) {
                if (args[i].charAt(0) == '-') {
                    if (args[i].equals("-m")) {
                        matrix = args[++i];
                    } else if (args[i].equals("-o")) {
                        open = Float.parseFloat(args[++i]);
                    } else if (args[i].equals("-e")) {
                        extend = Float.parseFloat(args[++i]);
                    } else if (args[i].equals("-f")) {
                        file = args[++i];
                    } else if (args[i].equals("-h") || args[i].equals("-help")) {
                        SW.printUsage();
                        System.exit(0);
                    } else {
                        System.out.println("Unrecognized option: " + args[i]);
                        SW.printUsage();
                        System.exit(1);
                    }
                } else if (s1 == null) {
                    s1 = args[i];
                } else if (s2 == null) {
                    s2 = args[i];
                } else {
                    System.out.println("Unexpected token: " + args[i]);
                    SW.printUsage();
                    System.exit(1);
                }
                ++i;
            }
            if (s1 == null) {
                System.out.println("Sequence #1 is null");
                SW.printUsage();
                System.exit(1);
            }
            if (s2 == null) {
                System.out.println("Sequence #2 is null");
                SW.printUsage();
                System.exit(1);
            }
            FASTA fasta1 = Parser.loadFASTA(s1);
            FASTA fasta2 = Parser.loadFASTA(s2);
            if (file != null) {
                System.setOut(new PrintStream(new FileOutputStream(file, true)));
            }
            SW.printHeader(file == null ? "stdout" : file);
            Alignment alignment = SW.align(fasta1, fasta2, matrix, open, extend);
            SW.printStatistics(alignment, matrix, open, extend);
            System.out.println(Pair.format(alignment));
            SW.printTailer();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static Alignment align(String sequence1, String sequence2, String matrix, float open, float extend) throws Exception {
        char[] array1 = Parser.prepareSequence(sequence1);
        char[] array2 = Parser.prepareSequence(sequence2);
        return SW.align(array1, array2, matrix, open, extend);
    }

    public static Alignment align(FASTA fasta1, FASTA fasta2, String matrix, float open, float extend) throws Exception {
        char[] ch1 = fasta1.getSequence();
        char[] ch2 = fasta2.getSequence();
        Alignment alignment = SW.align(ch1, ch2, matrix, open, extend);
        alignment.setName1(fasta1.getName());
        alignment.setName2(fasta2.getName());
        return alignment;
    }

    public static Alignment align(File file1, File file2, String matrix, float open, float extend) throws Exception {
        FASTA fasta1 = Parser.loadFASTA(file1);
        FASTA fasta2 = Parser.loadFASTA(file2);
        return SW.align(fasta1, fasta2, matrix, open, extend);
    }

    public static Alignment align(char[] sequence1, char[] sequence2, String matrix, float open, float extend) throws Exception {
        return SmithWaterman.align(sequence1, sequence2, Matrices.getInstance().get(matrix), open, extend);
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println("java -classpath jaligner.jar:matrices.jar gnu.bioinformatics.jaligner.SW <seq1> <seq2> [-m matrix] [-o open] [-e extend] [-a] [-f output]");
        System.out.println("or");
        System.out.println("java -jar jaligner.jar <seq1> <seq2> <-m matrix> [-o open] [-e extend] [-a] [-f output]");
        System.out.println("Example:");
        System.out.println("java -classpath jaligner.jar:matrices.jar gnu.bioinformatics.jaligner.SW seq1.fasta seq2.fasta -m BLOSUM62 -o 10.0 -e 0.5 -a -f out.txt");
        System.out.println();
    }

    private static void printHeader(String output) {
        System.out.println("########################################");
        StringBuffer stringBuffer = new StringBuffer("# Program:\t");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gnu.bioinformatics.jaligner.SW");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(stringBuffer.append(clazz.getName()).toString());
        System.out.println("# Rundate:\t" + new Date().toString());
        System.out.println("# Report_file:\t" + output);
        System.out.println("########################################");
    }

    private static void printStatistics(Alignment alignment, String matrix, float open, float extend) {
        DecimalFormat f1 = new DecimalFormat("0.00");
        DecimalFormat f2 = new DecimalFormat("0.00%");
        int length = alignment.getSequence1().length;
        int identity = alignment.getIdentity();
        int similarity = alignment.getSimilarity();
        int gaps = alignment.getGaps();
        float score = alignment.getScore();
        System.out.println("#=======================================");
        System.out.println("#");
        System.out.println("# Aligned_sequences: 2");
        System.out.println("# 1: " + alignment.getName1());
        System.out.println("# 2: " + alignment.getName2());
        System.out.println("# Matrix: " + matrix);
        System.out.println("# Gap_penalty: " + open);
        System.out.println("# Extend_penalty: " + extend);
        System.out.println("#");
        System.out.println("# Length: " + length);
        System.out.println("# Identity: " + identity + "/" + length + " (" + f2.format((float)identity / (float)length) + ")");
        System.out.println("# Similarity: " + similarity + "/" + length + " (" + f2.format((float)similarity / (float)length) + ")");
        System.out.println("# Gaps: " + gaps + "/" + length + " (" + f2.format((float)gaps / (float)length) + ")");
        System.out.println("# Score: " + f1.format(alignment.getScore()));
        System.out.println("#");
        System.out.println("#");
        System.out.println("#=======================================");
    }

    private static void printTailer() {
        System.out.println("#---------------------------------------");
        System.out.println("# Finished:\t" + new Date().toString());
        System.out.println("#---------------------------------------");
    }
}

