/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Variable;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.RegularSectionLayout;
import ucar.nc2.iosp.hdf5.H5header;

class H5chunkLayout
extends Indexer {
    private Section want;
    private int[] chunkSize;
    private int elemSize;
    private long totalNelems;
    private long totalNelemsDone;
    private boolean done = false;
    private boolean debug = false;
    private int nChunkDims;
    private H5header.DataBTree.DataChunkIterator chunkIterator;
    private Indexer index = null;

    H5chunkLayout(Variable v2, DataType dtype, Section wantSection) throws InvalidRangeException, IOException {
        wantSection = Section.fill(wantSection, v2.getShape());
        this.totalNelems = wantSection.computeSize();
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        assert (vinfo.isChunked);
        assert (vinfo.btree != null);
        this.want = dtype == DataType.CHAR && wantSection.getRank() < vinfo.storageSize.length ? new Section(wantSection).appendRange(1) : wantSection;
        this.nChunkDims = dtype == DataType.CHAR ? vinfo.storageSize.length : vinfo.storageSize.length - 1;
        this.chunkSize = new int[this.nChunkDims];
        System.arraycopy(vinfo.storageSize, 0, this.chunkSize, 0, this.nChunkDims);
        this.elemSize = vinfo.storageSize[vinfo.storageSize.length - 1];
        if (this.debug) {
            System.out.println(" H5chunkIndexer: " + this);
        }
        this.chunkIterator = vinfo.btree.getDataChunkIterator(this.want);
    }

    public long getTotalNelems() {
        return this.totalNelems;
    }

    public int getElemSize() {
        return this.elemSize;
    }

    public boolean hasNext() {
        return !this.done && this.totalNelemsDone < this.totalNelems;
    }

    public Indexer.Chunk next() throws IOException {
        Indexer.Chunk chunk;
        if (this.index == null || !this.index.hasNext()) {
            try {
                H5header.DataBTree.DataChunk dataChunk;
                int[] sectionOrigin;
                Section dataSection;
                do {
                    if (!this.chunkIterator.hasNext()) {
                        this.done = true;
                        return null;
                    }
                    dataChunk = this.chunkIterator.next();
                    sectionOrigin = new int[this.nChunkDims];
                    System.arraycopy(dataChunk.offset, 0, sectionOrigin, 0, this.nChunkDims);
                } while (!(dataSection = new Section(sectionOrigin, this.chunkSize)).intersects(this.want));
                if (this.debug) {
                    System.out.println(" found intersecting section: " + dataSection + " for filePos " + dataChunk.filePos);
                }
                this.index = this.indexFactory(dataChunk, dataChunk.filePos, this.elemSize, dataSection, this.want);
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException(e);
            }
        }
        if ((chunk = this.index.next()) != null) {
            this.totalNelemsDone += (long)chunk.getNelems();
        }
        return chunk;
    }

    protected Indexer indexFactory(H5header.DataBTree.DataChunk dataChunk, long filePos, int elemSize, Section dataSection, Section want) throws IOException, InvalidRangeException {
        return RegularSectionLayout.factory(filePos, elemSize, dataSection, want);
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("want=").append(this.want).append("; ");
        sbuff.append("chunkSize=[");
        for (int i = 0; i < this.chunkSize.length; ++i) {
            if (i > 0) {
                sbuff.append(",");
            }
            sbuff.append(this.chunkSize[i]);
        }
        sbuff.append("] totalNelems=").append(this.totalNelems);
        sbuff.append(" elemSize=").append(this.elemSize);
        return sbuff.toString();
    }
}

