/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/support/ParamNameMapperTest.java,v 1.5 2007/05/05 05:24:05 tcfujii Exp $
 * $Revision: 1.5 $
 * $Date: 2007/05/05 05:24:05 $
 */
package com.sun.enterprise.management.support;

import java.util.Map;

import com.sun.appserv.management.util.misc.MapUtil;


/**
 */
public final class ParamNameMapperTest extends junit.framework.TestCase
{
		public
	ParamNameMapperTest( )
	{
	}

		public void
	testCreate()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
	}
	
		public void
	testEmpty()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "", m.mangleAttributeName( "" ) );
	}
	
	
		public void
	testSingleLowerCaseWord()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello", m.mangleAttributeName( "hello" ) );
		assertEquals( "hello_there", m.mangleAttributeName( "hello_there" ) );
	}
	
		public void
	testSingleLowerCaseLetter()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "x", m.mangleAttributeName( "x" ) );
	}
	
		public void
	testSingleUpperCaseLetter()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "x", m.mangleAttributeName( "X" ) );
	}
	
		public void
	testSingleAllUpperCaseWord()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello", m.mangleAttributeName( "HELLO" ) );
	}
	
		public void
	testSingleUpperCaseWord()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello", m.mangleAttributeName( "Hello" ) );
	}
	
		public void
	testMultipleLowerCaseWords()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello-there-you", m.mangleAttributeName( "hello-there-you" ) );
	}
	
	
		public void
	testMultipleUpperCaseWords()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "hello_there_you", m.mangleAttributeName( "HelloThereYou" ) );
	}
	
		public void
	testAcronyms1()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "ssl_algorithm", m.mangleAttributeName( "SSLAlgorithm" ) );
	}
	
		public void
	testAcronyms2()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "ssl_algorithm_enabled_today",
			m.mangleAttributeName( "SSLAlgorithmEnabledToday" ) );
	}
	
		public void
	testAcronyms3()
	{
		final ParamNameMapper	m	= new ParamNameMapper();
		
		assertEquals( "ssl-tls-http-jndi_algorithm",
			m.mangleAttributeName( "SSL-TLS-HTTP-JNDIAlgorithm" ) );
	}
	
	
		public void
	testOverrides()
	{
		final Map<String,String>	overrides	= MapUtil.newMap(
			new String[]
			{
				"SSLTLS", "ssl_tls",
				"GOOFY", "THECLOWN",
			}
		);
		
		final ParamNameMapper	m	= new ParamNameMapper( overrides );
		
		assertEquals( "ssl_tls", m.mangleAttributeName( "SSLTLS" ) );
		assertEquals( "THECLOWN", m.mangleAttributeName( "GOOFY" ) );
	}
	
}


