/*
 * Copyright (c) 2011 Paulo Zanoni
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef XDG_BASEDIR_H
#define XDG_BASEDIR_H

#include <list>
#include <string>

class XDGBasedir
{
    public:
	enum XDGVariables {
	    XDG_DATA_HOME,
	    XDG_CONFIG_HOME,
	    XDG_DATA_DIRS,
	    XDG_CONFIG_DIRS,
	    XDG_CACHE_HOME,
	    XDG_RUNTIME_DIR
	};

	static std::string getVariable(XDGVariables var);

	// checks if XDG_RUNTIME_DIR is compliant with the specification
	static bool validRuntimeDir();

	static std::list<std::string> findDataFile(const char *fileName);
	static std::list<std::string> findConfigFile(const char *fileName);

    private:
	static std::list<std::string> findFile(const char *fileName,
					       const std::string& userDir,
					       const std::string& systemDirs);
};

#endif
