/*
 * Copyright 2012 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.util

import org.gradle.test.fixtures.file.TestNameTestDirectoryProvider
import org.junit.Rule
import spock.lang.Specification

class TempDirIsUniquePerTestSpec extends Specification {

    @Rule TestNameTestDirectoryProvider temp = new TestNameTestDirectoryProvider()
    static tests = new HashSet()
    static tmpDirs = new HashSet()

    def setup() {
        //it's very important we try to access the test dir in the setup()
        temp.testDirectory
    }
    
    def "testOne"() {
        when:
        tests << "testOne"
        tmpDirs << temp.testDirectory
        
        then:
        tests.size() == tmpDirs.size()
    }

    def "testTwo"() {
        when:
        tests << "testTwo"
        tmpDirs << temp.testDirectory

        then:
        tests.size() == tmpDirs.size()
    }
}
