/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.php.nette2.ui.wizards;

import java.awt.Cursor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.php.nette2.options.Nette2Options;
import org.netbeans.modules.php.nette2.ui.options.Nette2OptionsPanelController;
import org.openide.util.ChangeSupport;

/**
 *
 * @author Ondrej Brejla <obrejla@netbeans.org>
 */
public class NewNette2ProjectPanel extends javax.swing.JPanel implements ChangeListener {
    private ChangeSupport changeSupport = new ChangeSupport(this);

    public NewNette2ProjectPanel() {
        initComponents();
    }

    public String getErrorMessage() {
        String sandboxMessage = Nette2OptionsPanelController.validateSandbox(Nette2Options.getInstance().getSandbox());
        if (sandboxMessage != null) {
            return sandboxMessage;
        }
        if (copyNetteCheckBox.isSelected()) {
            return Nette2OptionsPanelController.validateNetteDirectory(Nette2Options.getInstance().getNetteDirectory());
        }
        return null;
    }

    public boolean isCopyNetteCheckboxSelected() {
        return copyNetteCheckBox.isSelected();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        changeSupport.removeChangeListener(listener);
    }

    @Override
    public void addNotify() {
        Nette2Options.getInstance().addChangeListener(this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        Nette2Options.getInstance().removeChangeListener(this);
        super.removeNotify();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        optionsLabel = new javax.swing.JLabel();
        copyNetteCheckBox = new javax.swing.JCheckBox();

        org.openide.awt.Mnemonics.setLocalizedText(optionsLabel, org.openide.util.NbBundle.getMessage(NewNette2ProjectPanel.class, "NewNette2ProjectPanel.optionsLabel.text")); // NOI18N
        optionsLabel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                optionsLabelMouseEntered(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                optionsLabelMouseReleased(evt);
            }
        });

        copyNetteCheckBox.setMnemonic('C');
        org.openide.awt.Mnemonics.setLocalizedText(copyNetteCheckBox, org.openide.util.NbBundle.getMessage(NewNette2ProjectPanel.class, "NewNette2ProjectPanel.copyNetteCheckBox.text")); // NOI18N
        copyNetteCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                copyNetteCheckBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(optionsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addGroup(layout.createSequentialGroup()
                .addComponent(copyNetteCheckBox)
                .addGap(0, 52, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(optionsLabel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(4, 4, 4)
                .addComponent(copyNetteCheckBox)
                .addContainerGap(55, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void optionsLabelMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_optionsLabelMouseReleased
        OptionsDisplayer.getDefault().open(Nette2OptionsPanelController.getOptionsPath());
    }//GEN-LAST:event_optionsLabelMouseReleased

    private void optionsLabelMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_optionsLabelMouseEntered
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }//GEN-LAST:event_optionsLabelMouseEntered

    private void copyNetteCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_copyNetteCheckBoxActionPerformed
        changeSupport.fireChange();
    }//GEN-LAST:event_copyNetteCheckBoxActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox copyNetteCheckBox;
    private javax.swing.JLabel optionsLabel;
    // End of variables declaration//GEN-END:variables

}
