#include "sw-photo-upload-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_photo_upload_iface_object_info;

struct _SwPhotoUploadIfaceClass {
    GTypeInterface parent_class;
    sw_photo_upload_iface_upload_photo_impl upload_photo;
};

enum {
    SIGNAL_PHOTO_UPLOAD_IFACE_PhotoUploadProgress,
    N_PHOTO_UPLOAD_IFACE_SIGNALS
};
static guint photo_upload_iface_signals[N_PHOTO_UPLOAD_IFACE_SIGNALS] = {0};

static void sw_photo_upload_iface_base_init (gpointer klass);

GType
sw_photo_upload_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwPhotoUploadIfaceClass),
        sw_photo_upload_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwPhotoUploadIface", &info, 0);
    }

  return type;
}

/**
 * sw_photo_upload_iface_upload_photo_impl:
 * @self: The object implementing this interface
 * @in_local_filename: const gchar * (FIXME, generate documentation)
 * @in_fields: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * UploadPhoto on interface com.meego.libsocialweb.PhotoUpload.
 */
static void
sw_photo_upload_iface_upload_photo (SwPhotoUploadIface *self,
    const gchar *in_local_filename,
    GHashTable *in_fields,
    DBusGMethodInvocation *context)
{
  sw_photo_upload_iface_upload_photo_impl impl = (SW_PHOTO_UPLOAD_IFACE_GET_CLASS (self)->upload_photo);

  if (impl != NULL)
    {
      (impl) (self,
        in_local_filename,
        in_fields,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_photo_upload_iface_implement_upload_photo:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the UploadPhoto D-Bus method
 *
 * Register an implementation for the UploadPhoto method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_photo_upload_iface_implement_upload_photo (SwPhotoUploadIfaceClass *klass, sw_photo_upload_iface_upload_photo_impl impl)
{
  klass->upload_photo = impl;
}

/**
 * sw_photo_upload_iface_emit_photo_upload_progress:
 * @instance: The object implementing this interface
 * @arg_opid: gint  (FIXME, generate documentation)
 * @arg_progress: gint  (FIXME, generate documentation)
 * @arg_error_message: const gchar * (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * PhotoUploadProgress signal on interface com.meego.libsocialweb.PhotoUpload.
 */
void
sw_photo_upload_iface_emit_photo_upload_progress (gpointer instance,
    gint arg_opid,
    gint arg_progress,
    const gchar *arg_error_message)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_PHOTO_UPLOAD_IFACE));
  g_signal_emit (instance,
      photo_upload_iface_signals[SIGNAL_PHOTO_UPLOAD_IFACE_PhotoUploadProgress],
      0,
      arg_opid,
      arg_progress,
      arg_error_message);
}

static inline void
sw_photo_upload_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_photo_upload_iface_get_type (),
      &_sw_photo_upload_iface_object_info);

  /**
   * SwPhotoUploadIface::photo-upload-progress:
   * @arg_opid: gint  (FIXME, generate documentation)
   * @arg_progress: gint  (FIXME, generate documentation)
   * @arg_error_message: const gchar * (FIXME, generate documentation)
   *
   * The PhotoUploadProgress D-Bus signal is emitted whenever this GObject signal is.
   */
  photo_upload_iface_signals[SIGNAL_PHOTO_UPLOAD_IFACE_PhotoUploadProgress] =
  g_signal_new ("photo-upload-progress",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      sw_marshal_VOID__INT_INT_STRING,
      G_TYPE_NONE,
      3,
      G_TYPE_INT,
      G_TYPE_INT,
      G_TYPE_STRING);

}
static void
sw_photo_upload_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_photo_upload_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_photo_upload_iface_methods[] = {
  { (GCallback) sw_photo_upload_iface_upload_photo, sw_marshal_VOID__STRING_BOXED_POINTER, 0 },
};

static const DBusGObjectInfo _sw_photo_upload_iface_object_info = {
  0,
  _sw_photo_upload_iface_methods,
  1,
"com.meego.libsocialweb.PhotoUpload\0UploadPhoto\0A\0local_filename\0I\0s\0fields\0I\0a{ss}\0opid\0O\0F\0N\0i\0\0\0",
"com.meego.libsocialweb.PhotoUpload\0PhotoUploadProgress\0\0",
"\0\0",
};


