/*
 * MediathekView
 * Copyright (C) 2014 W. Xaver
 * W.Xaver[at]googlemail.com
 * http://zdfmediathk.sourceforge.net/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.config;

import java.awt.Image;
import javax.swing.ImageIcon;
import mediathek.res.GetIcon;

public class Icons {

    public static final ImageIcon ICON_FILTER_AKT_1 = GetIcon.getProgramIcon("filter-akt-1.png", 32, 32);
    public static final ImageIcon ICON_FILTER_AKT_2 = GetIcon.getProgramIcon("filter-akt-2.png", 32, 32);
    public static final ImageIcon ICON_FILTER_AKT_3 = GetIcon.getProgramIcon("filter-akt-3.png", 32, 32);
    public static final ImageIcon ICON_FILTER_AKT_4 = GetIcon.getProgramIcon("filter-akt-4.png", 32, 32);
    public static final ImageIcon ICON_FILTER_AKT_5 = GetIcon.getProgramIcon("filter-akt-5.png", 32, 32);
    public static final ImageIcon ICON_FILTER_OFF_1 = GetIcon.getProgramIcon("filter-off-1.png", 32, 32);
    public static final ImageIcon ICON_FILTER_OFF_2 = GetIcon.getProgramIcon("filter-off-2.png", 32, 32);
    public static final ImageIcon ICON_FILTER_OFF_3 = GetIcon.getProgramIcon("filter-off-3.png", 32, 32);
    public static final ImageIcon ICON_FILTER_OFF_4 = GetIcon.getProgramIcon("filter-off-4.png", 32, 32);
    public static final ImageIcon ICON_FILTER_OFF_5 = GetIcon.getProgramIcon("filter-off-5.png", 32, 32);
    public static final ImageIcon ICON_FILTER_ON_1 = GetIcon.getProgramIcon("filter-on-1.png", 32, 32);
    public static final ImageIcon ICON_FILTER_ON_2 = GetIcon.getProgramIcon("filter-on-2.png", 32, 32);
    public static final ImageIcon ICON_FILTER_ON_3 = GetIcon.getProgramIcon("filter-on-3.png", 32, 32);
    public static final ImageIcon ICON_FILTER_ON_4 = GetIcon.getProgramIcon("filter-on-4.png", 32, 32);
    public static final ImageIcon ICON_FILTER_ON_5 = GetIcon.getProgramIcon("filter-on-5.png", 32, 32);

    public static final ImageIcon ICON_DIALOG_PLUS = GetIcon.getProgramIcon("dialog-plus.png", 16, 16);
    public static final ImageIcon ICON_DIALOG_MINUS = GetIcon.getProgramIcon("dialog-minus.png", 16, 16);
    public static final ImageIcon ICON_DIALOG_ADD = GetIcon.getProgramIcon("dialog-add.png", 16, 16);
    public static final ImageIcon ICON_DIALOG_EIN_SW = GetIcon.getProgramIcon("dialog-ein-sw.png", 16, 16);

    public static final ImageIcon ICON_ACHTUNG_32 = GetIcon.getProgramIcon("achtung.png", 32, 32);
    public static final ImageIcon ICON_ACHTUNG_16 = GetIcon.getProgramIcon("achtung.png", 16, 16);
    public static final ImageIcon ICON_MENUE_BEENDEN = GetIcon.getProgramIcon("menue-beenden.png", 16, 16);
    public static final ImageIcon ICON_MENUE_BLACKLIST = GetIcon.getProgramIcon("menue-blacklist.png", 16, 16);
    public static final ImageIcon ICON_MENUE_CLEAR = GetIcon.getProgramIcon("menue-clear.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNLOAD_ALLE_STARTEN = GetIcon.getProgramIcon("menue-download-alle-starten.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILM_GESEHEN = GetIcon.getProgramIcon("menue-film-gesehen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNLOAD_GESEHEN = GetIcon.getProgramIcon("menue-download-gesehen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_ABO_NEU = GetIcon.getProgramIcon("menue-abo-neu.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNLOAD_BANDWITH = GetIcon.getProgramIcon("menue-download-bandwith.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNLOAD_AENDERN = GetIcon.getProgramIcon("menue-download-aendern.png", 16, 16);
    public static final ImageIcon ICON_MENUE_EINSTELLUNGEN = GetIcon.getProgramIcon("menue-einstellungen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_ABO_AENDERN = GetIcon.getProgramIcon("menue-abo-aendern.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNOAD_LOESCHEN = GetIcon.getProgramIcon("menue-download-loeschen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNOAD_STARTEN = GetIcon.getProgramIcon("menue-download-starten.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNOAD_STOP = GetIcon.getProgramIcon("menue-download-stop.png", 16, 16);
    public static final ImageIcon ICON_MENUE_ABO_LOESCHEN = GetIcon.getProgramIcon("menue-abo-loeschen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILE_OPEN = GetIcon.getProgramIcon("menue-file-open.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILM_REC = GetIcon.getProgramIcon("menue-film-rec.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILM_START = GetIcon.getProgramIcon("menue-film-start.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILMLISTE_LADEN = GetIcon.getProgramIcon("menue-filmliste-laden.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILTER_LOESCHEN = GetIcon.getProgramIcon("menue-filter-loeschen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_FILTER_SPEICHERN = GetIcon.getProgramIcon("menue-filter-speichern.png", 16, 16);
    public static final ImageIcon ICON_MENUE_HELP = GetIcon.getProgramIcon("menue-help.png", 16, 16);
    public static final ImageIcon ICON_MENUE_HISTORY_ADD = GetIcon.getProgramIcon("menue-history-add.png", 16, 16);
    public static final ImageIcon ICON_MENUE_HISTORY_REMOVE = GetIcon.getProgramIcon("menue-history-remove.png", 16, 16);
    public static final ImageIcon ICON_MENUE_EIN = GetIcon.getProgramIcon("menue-ein.png", 16, 16);
    public static final ImageIcon ICON_MENUE_AUS = GetIcon.getProgramIcon("menue-aus.png", 16, 16);
    public static final ImageIcon ICON_MENUE_VORZIEHEN = GetIcon.getProgramIcon("menue-vorziehen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_UP_DOWN = GetIcon.getProgramIcon("menue-up-down.png", 16, 16);
    public static final ImageIcon ICON_MENUE_DOWNLOAD_ZURUECKSTELLEN = GetIcon.getProgramIcon("menue-download-zurueckstellen.png", 16, 16);
    public static final ImageIcon ICON_MENUE_AKTUALISIEREN = GetIcon.getProgramIcon("menue-aktualisieren.png", 16, 16);

    public static final ImageIcon ICON_CHECKBOX_CLOSE = GetIcon.getProgramIcon("checkbox-close.png", 15, 15);
    public static final ImageIcon ICON_CHECKBOX_EDIT = GetIcon.getProgramIcon("checkbox-edit.png", 16, 16);
    public static final ImageIcon ICON_STATUSBAR_STOP = GetIcon.getProgramIcon("statusbar-stop.png", 13, 13);

    public static final ImageIcon ICON_TABELLE_EIN = GetIcon.getProgramIcon("tabelle-ein.png", 16, 16);
    public static final ImageIcon ICON_TABELLE_AUS = GetIcon.getProgramIcon("tabelle-aus.png", 5, 5);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_CLEAR = GetIcon.getProgramIcon("tabelle-download-clear.png", 20, 20);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_CLEAR_SW = GetIcon.getProgramIcon("tabelle-download-clear-sw.png", 14, 14);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_DEL = GetIcon.getProgramIcon("tabelle-download-del.png", 16, 16);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_DEL_SW = GetIcon.getProgramIcon("tabelle-download-del-sw.png", 14, 14);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_START = GetIcon.getProgramIcon("tabelle-download-start.png", 20, 20);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_START_SW = GetIcon.getProgramIcon("tabelle-download-start-sw.png", 14, 14);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_STOP = GetIcon.getProgramIcon("tabelle-download-stop.png", 18, 18);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_STOP_SW = GetIcon.getProgramIcon("tabelle-download-stop-sw.png", 15, 15);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_FILM_START = GetIcon.getProgramIcon("tabelle-download-film-start.png", 18, 18);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_FILM_START_SW = GetIcon.getProgramIcon("tabelle-download-film-start-sw.png", 14, 14);

    public static final ImageIcon ICON_TABELLE_DOWNOAD_FILTER_UP = GetIcon.getProgramIcon("tabelle-download-filter-up.png", 14, 14);
    public static final ImageIcon ICON_TABELLE_DOWNOAD_FILTER_DOWN = GetIcon.getProgramIcon("tabelle-download-filter-down.png", 14, 14);

    public static final ImageIcon ICON_TABELLE_FILM_REC = GetIcon.getProgramIcon("tabelle-film-rec.png", 18, 18);
    public static final ImageIcon ICON_TABELLE_FILM_REC_SW = GetIcon.getProgramIcon("tabelle-film-rec-sw.png", 16, 16);
    public static final ImageIcon ICON_TABELLE_FILM_START = GetIcon.getProgramIcon("tabelle-film-start.png", 20, 20);
    public static final ImageIcon ICON_TABELLE_FILM_START_SW = GetIcon.getProgramIcon("tabelle-film-start-sw.png", 16, 16);
    public static final ImageIcon ICON_TABELLE_FILM_STOP = GetIcon.getProgramIcon("tabelle-film-stop.png", 17, 17);
    public static final ImageIcon ICON_TABELLE_FILM_STOP_SW = GetIcon.getProgramIcon("tabelle-film-stop-sw.png", 16, 16);

    public static final ImageIcon ICON_SUCHEN = GetIcon.getProgramIcon("suchen.png", 22, 22);
    public static final ImageIcon ICON_BUTTON_REMOVE = GetIcon.getProgramIcon("button-remove.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_ADD = GetIcon.getProgramIcon("button-add.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_AKTUALISIEREN = GetIcon.getProgramIcon("button-aktualisieren.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_MOVE_DOWN = GetIcon.getProgramIcon("button-move-down.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_MOVE_UP = GetIcon.getProgramIcon("button-move-up.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_HELP = GetIcon.getProgramIcon("button-help.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_CLEAR = GetIcon.getProgramIcon("button-clear.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_DEL = GetIcon.getProgramIcon("button-del.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_BLACKLIST_AUS = GetIcon.getProgramIcon("button-blacklist-aus.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_BLACKLIST_EIN = GetIcon.getProgramIcon("button-blacklist-ein.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_FILE_OPEN = GetIcon.getProgramIcon("button-file-open.png", 16, 16);
    public static final ImageIcon ICON_BUTTON_FILTER_ANZEIGEN = GetIcon.getProgramIcon("button-filter-anzeigen.png", 22, 22);

    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_CLEAR_KL = GetIcon.getProgramIcon("toolbar-download-clear.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_CLEAR_GR = GetIcon.getProgramIcon("toolbar-download-clear.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_DEL_KL = GetIcon.getProgramIcon("toolbar-download-del.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_DEL_GR = GetIcon.getProgramIcon("toolbar-download-del.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_UNDO_KL = GetIcon.getProgramIcon("toolbar-download-undo.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_UNDO_GR = GetIcon.getProgramIcon("toolbar-download-undo.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_FILM_START_KL = GetIcon.getProgramIcon("toolbar-download-film-start.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_FILM_START_GR = GetIcon.getProgramIcon("toolbar-download-film-start.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_FILM_INFO_KL = GetIcon.getProgramIcon("toolbar-download-film-info.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_FILM_INFO_GR = GetIcon.getProgramIcon("toolbar-download-film-info.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_REFRESH_KL = GetIcon.getProgramIcon("toolbar-download-refresh.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_REFRESH_GR = GetIcon.getProgramIcon("toolbar-download-refresh.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_ALLE_STARTEN_KL = GetIcon.getProgramIcon("toolbar-download-alle-starten.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_DOWNLOAD_ALLE_STARTEN_GR = GetIcon.getProgramIcon("toolbar-download-alle-starten.png", 32, 32);

    public static final ImageIcon ICON_TOOLBAR_FILME_FILM_START_KL = GetIcon.getProgramIcon("toolbar-filme-film-start.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_FILME_FILM_START_GR = GetIcon.getProgramIcon("toolbar-filme-film-start.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_FILME_FILMLISTE_LADEN_KL = GetIcon.getProgramIcon("toolbar-filme-filmliste-laden.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_FILME_FILMLISTE_LADEN_GR = GetIcon.getProgramIcon("toolbar-filme-filmliste-laden.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_FILME_INFO_KL = GetIcon.getProgramIcon("toolbar-filme-info.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_FILME_INFO_GR = GetIcon.getProgramIcon("toolbar-filme-info.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_FILME_REC_KL = GetIcon.getProgramIcon("toolbar-filme-rec.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_FILME_REC_GR = GetIcon.getProgramIcon("toolbar-filme-rec.png", 32, 32);

    public static final ImageIcon ICON_TOOLBAR_ABO_EIN_KL = GetIcon.getProgramIcon("toolbar-abo-ein.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_ABO_EIN_GR = GetIcon.getProgramIcon("toolbar-abo-ein.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_ABO_AUS_KL = GetIcon.getProgramIcon("toolbar-abo-aus.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_ABO_AUS_GR = GetIcon.getProgramIcon("toolbar-abo-aus.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_ABO_DEL_KL = GetIcon.getProgramIcon("toolbar-abo-del.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_ABO_DEL_GR = GetIcon.getProgramIcon("toolbar-abo-del.png", 32, 32);
    public static final ImageIcon ICON_TOOLBAR_ABO_CONFIG_KL = GetIcon.getProgramIcon("toolbar-abo-config.png", 16, 16);
    public static final ImageIcon ICON_TOOLBAR_ABO_CONFIG_GR = GetIcon.getProgramIcon("toolbar-abo-config.png", 32, 32);

    // Icons TABBED_PANE
    private static final int W = 30, H = 30;
    public static final ImageIcon ICON_TAB_FILM = GetIcon.getProgramIcon("tab-film.png", W, H);
    public static final ImageIcon ICON_TAB_DOWNLOAD = GetIcon.getProgramIcon("tab-download.png", W, H);
    public static final ImageIcon ICON_TAB_ABO = GetIcon.getProgramIcon("tab-abo.png", W, H);
    public static final ImageIcon ICON_TAB_MELDUNG = GetIcon.getProgramIcon("tab-meldung.png", W, H);
    public static final ImageIcon ICON_TAB_FILM_SW = GetIcon.getProgramIcon("tab-film-sw.png", W, H);
    public static final ImageIcon ICON_TAB_DOWNLOAD_SW = GetIcon.getProgramIcon("tab-download-sw.png", W, H);
    public static final ImageIcon ICON_TAB_ABO_SW = GetIcon.getProgramIcon("tab-abo-sw.png", W, H);
    public static final ImageIcon ICON_TAB_MELDUNG_SW = GetIcon.getProgramIcon("tab-meldung-sw.png", W, H);

    private static final int WT = 20, HT = 20;
    public static final ImageIcon ICON_TAB_TOP_FILM = GetIcon.getProgramIcon("tab-film-top.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_DOWNLOAD = GetIcon.getProgramIcon("tab-download-top.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_ABO = GetIcon.getProgramIcon("tab-abo-top.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_MELDUNG = GetIcon.getProgramIcon("tab-meldung-top.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_FILM_SW = GetIcon.getProgramIcon("tab-film-top-sw.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_DOWNLOAD_SW = GetIcon.getProgramIcon("tab-download-top-sw.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_ABO_SW = GetIcon.getProgramIcon("tab-abo-top-sw.png", WT, HT);
    public static final ImageIcon ICON_TAB_TOP_MELDUNG_SW = GetIcon.getProgramIcon("tab-meldung-top-sw.png", WT, HT);

    public static final ImageIcon ICON_NOTIFICATION = GetIcon.getProgramIcon("notification.png", 64, 64);
    public static final ImageIcon ICON_NOTIFICATION_ERROR = GetIcon.getProgramIcon("notification-fehler.png", 64, 64);

    public static final Image ICON_TRAY = GetIcon.getProgramIcon("tray.png", 256, 256).getImage();
    public static final Image ICON_TRAY_ERROR = GetIcon.getProgramIcon("tray-fehler.png", 256, 256).getImage();
    public static final Image ICON_TRAY_DOWNLOAD = GetIcon.getProgramIcon("tray-download.png", 256, 256).getImage();

}
