#! /bin/sh
# Simple wrapper script to execute mkgmap in Debian
set -e

# Override to a specific one using $JAVACMD
ALTERNATIVE_JDK="`readlink -n -f /etc/alternatives/java`"

# Let's get the current architecture -- needed for multiarchified Java
ARCH="`dpkg --print-architecture`"

JAVA_CMDS="$JAVA_HOME/bin/java"
JAVA_CMDS="${JAVA_CMDS} /usr/lib/jvm/java-8-openjdk-$ARCH/bin/java"
JAVA_CMDS="${JAVA_CMDS} /usr/lib/jvm/java-7-openjdk-$ARCH/bin/java"
JAVA_CMDS="${JAVA_CMDS} /usr/bin/java"

if [ -z "${JAVACMD}" ]; then
    for jcmd in $JAVA_CMDS; do
       if [ "z$ALTERNATIVE_JDK" = "z`readlink -n -f $jcmd`" ] && [ -z "${JAVACMD}" ]; then
          JAVACMD="$jcmd"
          break
       fi
    done
fi

if [ -z "${JAVACMD}" ]; then
    for jcmd in $JAVA_CMDS; do
        if [ -x "$jcmd" -a -z "${JAVACMD}" ]; then
            JAVACMD="$jcmd"
            break
        fi
    done
fi

if [ "$JAVACMD" ]; then
    echo "Using $JAVACMD to execute mkgmap."
    exec $JAVACMD -jar /usr/share/mkgmap/mkgmap.jar "$@"
else
    echo "No valid JVM found to run mkgmap."
    exit 1
fi
