/*
 * NASPRO - The NASPRO Architecture for Sound PROcessing
 * Portable runtime library
 *
 * Copyright (C) 2007-2014 Stefano D'Angelo
 *
 * See the COPYING file for license conditions.
 */

#define _WIN32_WINNT	0x501
#define UNICODE

#include "internal.h"

#include <limits.h>

_NACORE_DEF nacore_sem
nacore_sem_new(unsigned int value)
{
	nacore_sem ret;

	if (value > LONG_MAX)
	  {
		errno = EINVAL;
		return NULL;
	  }

	ret = (nacore_sem)CreateSemaphore(NULL, value, LONG_MAX, NULL);
	if (ret == NULL)
	  {
		errno = (GetLastError() == ERROR_NOT_ENOUGH_MEMORY)
			? ENOMEM : NACORE_EUNKNOWN;
		return NULL;
	  }

	return ret;
}

_NACORE_DEF void
nacore_sem_free(nacore_sem sem)
{
	CloseHandle((HANDLE)sem);
}

_NACORE_DEF int
nacore_sem_wait(nacore_sem sem)
{
	WaitForSingleObject((HANDLE)sem, INFINITE);

	return 0;
}

_NACORE_DEF int
nacore_sem_trywait(nacore_sem sem)
{
	return (WaitForSingleObject((HANDLE)sem, 0) == WAIT_TIMEOUT)
	       ? EAGAIN : 0;
}

_NACORE_DEF int
nacore_sem_post(nacore_sem sem)
{
	return (ReleaseSemaphore((HANDLE)sem, 1, NULL) == FALSE)
	       ? NACORE_EUNKNOWN : 0;
}
