/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GARBAGE_COLLECTION_STATEMENT_H_
#define _GARBAGE_COLLECTION_STATEMENT_H_

#include "GTLCore/AST/Statement.h"

namespace GTLCore {
  namespace AST {
    /**
     * @internal
     * @ingroup GTLCore_AST
     * 
     * This statement is used to garbage collect an array or a structure if needed.
     */
    class PointerGarbageCollectionStatement : public Statement {
      public:
        /**
         * @param _pointer to the array or the structure to garbage collect if its ref count
         *                 become equal to 0
         */
        PointerGarbageCollectionStatement( llvm::Value* _pointer, const GTLCore::Type* _type );
        virtual ~PointerGarbageCollectionStatement();
        virtual llvm::BasicBlock* generateStatement( LLVMBackend::GenerationContext&, llvm::BasicBlock* ) const;
        virtual bool isReturnStatement() const { return false; }
      private:
        llvm::Value* m_pointer;
        const GTLCore::Type* m_type;
    };
    /**
     * @internal
     * @ingroup GTLCore_AST
     * 
     * Garbage collection for a list of variables. This is used by the @p VariablesManager to
     * clean after a context, or before a "return" statement.
     */
    class VariablesGarbageCollectionStatement : public Statement {
      public:
        VariablesGarbageCollectionStatement( std::list< VariableNG* > _variablesToCollect );
        virtual ~VariablesGarbageCollectionStatement();
        virtual llvm::BasicBlock* generateStatement( LLVMBackend::GenerationContext&, llvm::BasicBlock* ) const;
        virtual bool isReturnStatement() const { return false; }
      private:
        std::list< VariableNG* > m_variablesToCollect;
    };
  }
}

#endif
