#!/usr/bin/python3

#
# This maintenance script updates the content of the "Orthanc" folder
# to match the latest version of the Orthanc source code.
#

import multiprocessing
import os
import stat
import urllib.request

TARGET = os.path.join(os.path.dirname(__file__), 'Orthanc')
PLUGIN_SDK_VERSION = '1.7.0'
REPOSITORY = 'https://orthanc.uclouvain.be/hg/%s/raw-file'

FILES = [
    ('orthanc', 'OrthancFramework/Resources/CMake/AutoGeneratedCode.cmake', 'CMake'),
    ('orthanc', 'OrthancFramework/Resources/CMake/Compiler.cmake', 'CMake'),
    ('orthanc', 'OrthancFramework/Resources/CMake/DownloadOrthancFramework.cmake', 'CMake'),
    ('orthanc', 'OrthancFramework/Resources/CMake/DownloadPackage.cmake', 'CMake'),
    ('orthanc', 'OrthancFramework/Resources/EmbedResources.py', 'CMake'),

    ('orthanc', 'OrthancFramework/Resources/Toolchains/LinuxStandardBaseToolchain.cmake', '.'),
    ('orthanc', 'OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain32.cmake', '.'),
    ('orthanc', 'OrthancFramework/Resources/Toolchains/MinGW-W64-Toolchain64.cmake', '.'),
    ('orthanc', 'OrthancFramework/Resources/Toolchains/MinGWToolchain.cmake', '.'),

    ('orthanc', 'OrthancServer/Plugins/Samples/Common/ExportedSymbolsPlugins.list', 'Plugins'),
    ('orthanc', 'OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.cpp', 'Plugins'),
    ('orthanc', 'OrthancServer/Plugins/Samples/Common/OrthancPluginCppWrapper.h', 'Plugins'),
    ('orthanc', 'OrthancServer/Plugins/Samples/Common/OrthancPluginException.h', 'Plugins'),
    ('orthanc', 'OrthancServer/Plugins/Samples/Common/OrthancPluginsExports.cmake', 'Plugins'),
    ('orthanc', 'OrthancServer/Plugins/Samples/Common/VersionScriptPlugins.map', 'Plugins'),

    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/StoneToolbox.cpp', '.'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/StoneToolbox.h', '.'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/DicomDatasetReader.cpp', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/DicomDatasetReader.h', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/FullOrthancDataset.cpp', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/FullOrthancDataset.h', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/IDicomDataset.h', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/IOrthancConnection.cpp', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/IOrthancConnection.h', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/OrthancHttpConnection.cpp', 'Stone'),
    ('orthanc-stone', 'OrthancStone/Sources/Toolbox/OrthancDatasets/OrthancHttpConnection.h', 'Stone'),
]

SDK = [
    'orthanc/OrthancCPlugin.h',
]


def Download(x):
    repository = x[0]
    branch = x[1]
    source = x[2]
    target = os.path.join(TARGET, x[3])
    print(target)

    try:
        os.makedirs(os.path.dirname(target))
    except:
        pass

    url = '%s/%s/%s' % (REPOSITORY % repository, branch, source)

    with open(target, 'wb') as f:
        try:
            f.write(urllib.request.urlopen(url).read())
        except:
            print('ERROR: %s' % url)
            raise


commands = []

for f in FILES:
    commands.append([ f[0],
                      'default',
                      f[1],
                      os.path.join(f[2], os.path.basename(f[1])) ])

for f in SDK:
    commands.append([
        'orthanc',
        'Orthanc-%s' % PLUGIN_SDK_VERSION, 
        'Plugins/Include/%s' % f,
        'Sdk-%s/%s' % (PLUGIN_SDK_VERSION, f) 
    ])


pool = multiprocessing.Pool(10)  # simultaneous downloads
pool.map(Download, commands)
