# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VaultCertificateResponse(Model):
    """Certificate corresponding to a vault that can be used by clients to
    register themselves with the vault.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :param properties:
    :type properties:
     ~azure.mgmt.recoveryservices.models.ResourceCertificateDetails
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ResourceCertificateDetails'},
    }

    def __init__(self, *, properties=None, **kwargs) -> None:
        super(VaultCertificateResponse, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.id = None
        self.properties = properties
