# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class SupportingDocumentTypeTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.numbers.v2.regulatory_compliance \
                                  .supporting_document_types.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "supporting_document_types": [],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "supporting_document_types"
                }
            }
            '''
        ))

        actual = self.client.numbers.v2.regulatory_compliance \
                                       .supporting_document_types.list()

        self.assertIsNotNone(actual)

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "supporting_document_types": [
                    {
                        "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "friendly_name": "Passport",
                        "machine_name": "passport",
                        "fields": [
                            {
                                "friendly_name": "Last Name",
                                "machine_name": "last_name",
                                "constraint": "String"
                            }
                        ],
                        "url": "https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "supporting_document_types"
                }
            }
            '''
        ))

        actual = self.client.numbers.v2.regulatory_compliance \
                                       .supporting_document_types.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.numbers.v2.regulatory_compliance \
                                  .supporting_document_types("OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes/OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "sid": "OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "Passport",
                "machine_name": "passport",
                "fields": [
                    {
                        "friendly_name": "Last Name",
                        "machine_name": "last_name",
                        "constraint": "String"
                    }
                ],
                "url": "https://numbers.twilio.com/v2/RegulatoryCompliance/SupportingDocumentTypes/OYaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.numbers.v2.regulatory_compliance \
                                       .supporting_document_types("OYXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)
