/****************************************************************************
**
** Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB)
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtOpenGLExtensions module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
**
** This file was generated by glgen version 0.1
** Command line was: glgen
**
** glgen is Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
**
** This is an auto-generated file.
** Do not edit! All changes made to it will be lost.
**
****************************************************************************/

#include "qopenglextensions.h"
#include <QtGui/qopenglcontext.h>

// MemoryBarrier is a macro on some architectures on Windows
#ifdef Q_OS_WIN
#pragma push_macro("MemoryBarrier")
#undef MemoryBarrier
#endif

QT_BEGIN_NAMESPACE

QAbstractOpenGLExtension::~QAbstractOpenGLExtension()
{
    if (d_ptr)
        delete d_ptr;
}

bool QAbstractOpenGLExtension::initializeOpenGLFunctions()
{
    Q_D(QAbstractOpenGLExtension);
    d->initialized = true;
    return true;
}

bool QAbstractOpenGLExtension::isInitialized() const
{
    Q_D(const QAbstractOpenGLExtension);
    return d->initialized;
}

#if !defined(QT_OPENGL_ES_2)

QOpenGLExtension_3DFX_tbuffer::QOpenGLExtension_3DFX_tbuffer()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_3DFX_tbufferPrivate))
{
}

bool QOpenGLExtension_3DFX_tbuffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_3DFX_tbuffer);

    d->TbufferMask3DFX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glTbufferMask3DFX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_debug_output::QOpenGLExtension_AMD_debug_output()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_debug_outputPrivate))
{
}

bool QOpenGLExtension_AMD_debug_output::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_debug_output);

    d->GetDebugMessageLogAMD = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLenum *, GLuint *, GLuint *, GLsizei *, GLchar *)>(context->getProcAddress("glGetDebugMessageLogAMD"));
    d->DebugMessageCallbackAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLDEBUGPROCAMD , GLvoid *)>(context->getProcAddress("glDebugMessageCallbackAMD"));
    d->DebugMessageInsertAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLsizei , const GLchar *)>(context->getProcAddress("glDebugMessageInsertAMD"));
    d->DebugMessageEnableAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , const GLuint *, GLboolean )>(context->getProcAddress("glDebugMessageEnableAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_draw_buffers_blend::QOpenGLExtension_AMD_draw_buffers_blend()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_draw_buffers_blendPrivate))
{
}

bool QOpenGLExtension_AMD_draw_buffers_blend::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_draw_buffers_blend);

    d->BlendEquationSeparateIndexedAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum )>(context->getProcAddress("glBlendEquationSeparateIndexedAMD"));
    d->BlendEquationIndexedAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glBlendEquationIndexedAMD"));
    d->BlendFuncSeparateIndexedAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glBlendFuncSeparateIndexedAMD"));
    d->BlendFuncIndexedAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum )>(context->getProcAddress("glBlendFuncIndexedAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_multi_draw_indirect::QOpenGLExtension_AMD_multi_draw_indirect()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_multi_draw_indirectPrivate))
{
}

bool QOpenGLExtension_AMD_multi_draw_indirect::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_multi_draw_indirect);

    d->MultiDrawElementsIndirectAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLvoid *, GLsizei , GLsizei )>(context->getProcAddress("glMultiDrawElementsIndirectAMD"));
    d->MultiDrawArraysIndirectAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLvoid *, GLsizei , GLsizei )>(context->getProcAddress("glMultiDrawArraysIndirectAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_name_gen_delete::QOpenGLExtension_AMD_name_gen_delete()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_name_gen_deletePrivate))
{
}

bool QOpenGLExtension_AMD_name_gen_delete::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_name_gen_delete);

    d->IsNameAMD = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glIsNameAMD"));
    d->DeleteNamesAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLuint *)>(context->getProcAddress("glDeleteNamesAMD"));
    d->GenNamesAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint *)>(context->getProcAddress("glGenNamesAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_performance_monitor::QOpenGLExtension_AMD_performance_monitor()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_performance_monitorPrivate))
{
}

bool QOpenGLExtension_AMD_performance_monitor::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_performance_monitor);

    d->GetPerfMonitorCounterDataAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLuint *, GLint *)>(context->getProcAddress("glGetPerfMonitorCounterDataAMD"));
    d->EndPerfMonitorAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glEndPerfMonitorAMD"));
    d->BeginPerfMonitorAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBeginPerfMonitorAMD"));
    d->SelectPerfMonitorCountersAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLboolean , GLuint , GLint , GLuint *)>(context->getProcAddress("glSelectPerfMonitorCountersAMD"));
    d->DeletePerfMonitorsAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glDeletePerfMonitorsAMD"));
    d->GenPerfMonitorsAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenPerfMonitorsAMD"));
    d->GetPerfMonitorCounterInfoAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLvoid *)>(context->getProcAddress("glGetPerfMonitorCounterInfoAMD"));
    d->GetPerfMonitorCounterStringAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetPerfMonitorCounterStringAMD"));
    d->GetPerfMonitorGroupStringAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetPerfMonitorGroupStringAMD"));
    d->GetPerfMonitorCountersAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint *, GLint *, GLsizei , GLuint *)>(context->getProcAddress("glGetPerfMonitorCountersAMD"));
    d->GetPerfMonitorGroupsAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint *, GLsizei , GLuint *)>(context->getProcAddress("glGetPerfMonitorGroupsAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_sample_positions::QOpenGLExtension_AMD_sample_positions()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_sample_positionsPrivate))
{
}

bool QOpenGLExtension_AMD_sample_positions::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_sample_positions);

    d->SetMultisamplefvAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLfloat *)>(context->getProcAddress("glSetMultisamplefvAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_sparse_texture::QOpenGLExtension_AMD_sparse_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_sparse_texturePrivate))
{
}

bool QOpenGLExtension_AMD_sparse_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_sparse_texture);

    d->TexStorageSparseAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLsizei , GLsizei , GLsizei , GLbitfield )>(context->getProcAddress("glTexStorageSparseAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_stencil_operation_extended::QOpenGLExtension_AMD_stencil_operation_extended()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_stencil_operation_extendedPrivate))
{
}

bool QOpenGLExtension_AMD_stencil_operation_extended::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_stencil_operation_extended);

    d->StencilOpValueAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glStencilOpValueAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_AMD_vertex_shader_tesselator::QOpenGLExtension_AMD_vertex_shader_tesselator()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_vertex_shader_tesselatorPrivate))
{
}

bool QOpenGLExtension_AMD_vertex_shader_tesselator::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_vertex_shader_tesselator);

    d->TessellationModeAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glTessellationModeAMD"));
    d->TessellationFactorAMD = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat )>(context->getProcAddress("glTessellationFactorAMD"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_element_array::QOpenGLExtension_APPLE_element_array()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_element_arrayPrivate))
{
}

bool QOpenGLExtension_APPLE_element_array::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_element_array);

    d->MultiDrawRangeElementArrayAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , const GLint *, const GLsizei *, GLsizei )>(context->getProcAddress("glMultiDrawRangeElementArrayAPPLE"));
    d->MultiDrawElementArrayAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *, const GLsizei *, GLsizei )>(context->getProcAddress("glMultiDrawElementArrayAPPLE"));
    d->DrawRangeElementArrayAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLint , GLsizei )>(context->getProcAddress("glDrawRangeElementArrayAPPLE"));
    d->DrawElementArrayAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei )>(context->getProcAddress("glDrawElementArrayAPPLE"));
    d->ElementPointerAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLvoid *)>(context->getProcAddress("glElementPointerAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_fence::QOpenGLExtension_APPLE_fence()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_fencePrivate))
{
}

bool QOpenGLExtension_APPLE_fence::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_fence);

    d->FinishObjectAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glFinishObjectAPPLE"));
    d->TestObjectAPPLE = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glTestObjectAPPLE"));
    d->FinishFenceAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glFinishFenceAPPLE"));
    d->TestFenceAPPLE = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glTestFenceAPPLE"));
    d->IsFenceAPPLE = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsFenceAPPLE"));
    d->SetFenceAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glSetFenceAPPLE"));
    d->DeleteFencesAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteFencesAPPLE"));
    d->GenFencesAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenFencesAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_flush_buffer_range::QOpenGLExtension_APPLE_flush_buffer_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_flush_buffer_rangePrivate))
{
}

bool QOpenGLExtension_APPLE_flush_buffer_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_flush_buffer_range);

    d->FlushMappedBufferRangeAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLintptr , GLsizeiptr )>(context->getProcAddress("glFlushMappedBufferRangeAPPLE"));
    d->BufferParameteriAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glBufferParameteriAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_object_purgeable::QOpenGLExtension_APPLE_object_purgeable()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_object_purgeablePrivate))
{
}

bool QOpenGLExtension_APPLE_object_purgeable::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_object_purgeable);

    d->GetObjectParameterivAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetObjectParameterivAPPLE"));
    d->ObjectUnpurgeableAPPLE = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum )>(context->getProcAddress("glObjectUnpurgeableAPPLE"));
    d->ObjectPurgeableAPPLE = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum )>(context->getProcAddress("glObjectPurgeableAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_texture_range::QOpenGLExtension_APPLE_texture_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_texture_rangePrivate))
{
}

bool QOpenGLExtension_APPLE_texture_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_texture_range);

    d->GetTexParameterPointervAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLvoid* *)>(context->getProcAddress("glGetTexParameterPointervAPPLE"));
    d->TextureRangeAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glTextureRangeAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_vertex_array_object::QOpenGLExtension_APPLE_vertex_array_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_vertex_array_objectPrivate))
{
}

bool QOpenGLExtension_APPLE_vertex_array_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_vertex_array_object);

    d->IsVertexArrayAPPLE = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsVertexArrayAPPLE"));
    d->GenVertexArraysAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenVertexArraysAPPLE"));
    d->DeleteVertexArraysAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteVertexArraysAPPLE"));
    d->BindVertexArrayAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBindVertexArrayAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_vertex_array_range::QOpenGLExtension_APPLE_vertex_array_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_vertex_array_rangePrivate))
{
}

bool QOpenGLExtension_APPLE_vertex_array_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_vertex_array_range);

    d->VertexArrayParameteriAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glVertexArrayParameteriAPPLE"));
    d->FlushVertexArrayRangeAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLvoid *)>(context->getProcAddress("glFlushVertexArrayRangeAPPLE"));
    d->VertexArrayRangeAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLvoid *)>(context->getProcAddress("glVertexArrayRangeAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_APPLE_vertex_program_evaluators::QOpenGLExtension_APPLE_vertex_program_evaluators()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_vertex_program_evaluatorsPrivate))
{
}

bool QOpenGLExtension_APPLE_vertex_program_evaluators::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_vertex_program_evaluators);

    d->MapVertexAttrib2fAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLfloat , GLfloat , GLint , GLint , GLfloat , GLfloat , GLint , GLint , const GLfloat *)>(context->getProcAddress("glMapVertexAttrib2fAPPLE"));
    d->MapVertexAttrib2dAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLdouble , GLdouble , GLint , GLint , GLdouble , GLdouble , GLint , GLint , const GLdouble *)>(context->getProcAddress("glMapVertexAttrib2dAPPLE"));
    d->MapVertexAttrib1fAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLfloat , GLfloat , GLint , GLint , const GLfloat *)>(context->getProcAddress("glMapVertexAttrib1fAPPLE"));
    d->MapVertexAttrib1dAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLdouble , GLdouble , GLint , GLint , const GLdouble *)>(context->getProcAddress("glMapVertexAttrib1dAPPLE"));
    d->IsVertexAttribEnabledAPPLE = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glIsVertexAttribEnabledAPPLE"));
    d->DisableVertexAttribAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glDisableVertexAttribAPPLE"));
    d->EnableVertexAttribAPPLE = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glEnableVertexAttribAPPLE"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_ES2_compatibility::QOpenGLExtension_ARB_ES2_compatibility()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_ES2_compatibilityPrivate))
{
}

bool QOpenGLExtension_ARB_ES2_compatibility::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_ES2_compatibility);

    d->ClearDepthf = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat )>(context->getProcAddress("glClearDepthf"));
    d->DepthRangef = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat )>(context->getProcAddress("glDepthRangef"));
    d->GetShaderPrecisionFormat = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *, GLint *)>(context->getProcAddress("glGetShaderPrecisionFormat"));
    d->ShaderBinary = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *, GLenum , const GLvoid *, GLsizei )>(context->getProcAddress("glShaderBinary"));
    d->ReleaseShaderCompiler = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glReleaseShaderCompiler"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_base_instance::QOpenGLExtension_ARB_base_instance()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_base_instancePrivate))
{
}

bool QOpenGLExtension_ARB_base_instance::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_base_instance);

    d->DrawElementsInstancedBaseVertexBaseInstance = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const void *, GLsizei , GLint , GLuint )>(context->getProcAddress("glDrawElementsInstancedBaseVertexBaseInstance"));
    d->DrawElementsInstancedBaseInstance = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const void *, GLsizei , GLuint )>(context->getProcAddress("glDrawElementsInstancedBaseInstance"));
    d->DrawArraysInstancedBaseInstance = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei , GLsizei , GLuint )>(context->getProcAddress("glDrawArraysInstancedBaseInstance"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_blend_func_extended::QOpenGLExtension_ARB_blend_func_extended()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_blend_func_extendedPrivate))
{
}

bool QOpenGLExtension_ARB_blend_func_extended::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_blend_func_extended);

    d->GetFragDataIndex = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , const GLchar *)>(context->getProcAddress("glGetFragDataIndex"));
    d->BindFragDataLocationIndexed = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , const GLchar *)>(context->getProcAddress("glBindFragDataLocationIndexed"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_cl_event::QOpenGLExtension_ARB_cl_event()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_cl_eventPrivate))
{
}

bool QOpenGLExtension_ARB_cl_event::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_cl_event);

    d->CreateSyncFromCLeventARB = reinterpret_cast<GLsync (QOPENGLF_APIENTRYP)(struct _cl_context * , struct _cl_event * , GLbitfield )>(context->getProcAddress("glCreateSyncFromCLeventARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_clear_buffer_object::QOpenGLExtension_ARB_clear_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_clear_buffer_objectPrivate))
{
}

bool QOpenGLExtension_ARB_clear_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_clear_buffer_object);

    d->ClearBufferSubData = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLintptr , GLsizeiptr , GLenum , GLenum , const void *)>(context->getProcAddress("glClearBufferSubData"));
    d->ClearBufferData = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum , const void *)>(context->getProcAddress("glClearBufferData"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_color_buffer_float::QOpenGLExtension_ARB_color_buffer_float()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_color_buffer_floatPrivate))
{
}

bool QOpenGLExtension_ARB_color_buffer_float::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_color_buffer_float);

    d->ClampColorARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glClampColorARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_compute_shader::QOpenGLExtension_ARB_compute_shader()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_compute_shaderPrivate))
{
}

bool QOpenGLExtension_ARB_compute_shader::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_compute_shader);

    d->DispatchComputeIndirect = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLintptr )>(context->getProcAddress("glDispatchComputeIndirect"));
    d->DispatchCompute = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glDispatchCompute"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_copy_buffer::QOpenGLExtension_ARB_copy_buffer()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_copy_bufferPrivate))
{
}

bool QOpenGLExtension_ARB_copy_buffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_copy_buffer);

    d->CopyBufferSubData = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLintptr , GLintptr , GLsizeiptr )>(context->getProcAddress("glCopyBufferSubData"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_copy_image::QOpenGLExtension_ARB_copy_image()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_copy_imagePrivate))
{
}

bool QOpenGLExtension_ARB_copy_image::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_copy_image);

    d->CopyImageSubData = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLuint , GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei )>(context->getProcAddress("glCopyImageSubData"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_debug_output::QOpenGLExtension_ARB_debug_output()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_debug_outputPrivate))
{
}

bool QOpenGLExtension_ARB_debug_output::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_debug_output);

    d->GetDebugMessageLogARB = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *)>(context->getProcAddress("glGetDebugMessageLogARB"));
    d->DebugMessageCallbackARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLDEBUGPROCARB , const GLvoid *)>(context->getProcAddress("glDebugMessageCallbackARB"));
    d->DebugMessageInsertARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLenum , GLsizei , const GLchar *)>(context->getProcAddress("glDebugMessageInsertARB"));
    d->DebugMessageControlARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , const GLuint *, GLboolean )>(context->getProcAddress("glDebugMessageControlARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_draw_buffers::QOpenGLExtension_ARB_draw_buffers()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_draw_buffersPrivate))
{
}

bool QOpenGLExtension_ARB_draw_buffers::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_draw_buffers);

    d->DrawBuffersARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLenum *)>(context->getProcAddress("glDrawBuffersARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_draw_buffers_blend::QOpenGLExtension_ARB_draw_buffers_blend()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_draw_buffers_blendPrivate))
{
}

bool QOpenGLExtension_ARB_draw_buffers_blend::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_draw_buffers_blend);

    d->BlendFuncSeparateiARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glBlendFuncSeparateiARB"));
    d->BlendFunciARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum )>(context->getProcAddress("glBlendFunciARB"));
    d->BlendEquationSeparateiARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum )>(context->getProcAddress("glBlendEquationSeparateiARB"));
    d->BlendEquationiARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glBlendEquationiARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_draw_elements_base_vertex::QOpenGLExtension_ARB_draw_elements_base_vertex()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_draw_elements_base_vertexPrivate))
{
}

bool QOpenGLExtension_ARB_draw_elements_base_vertex::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_draw_elements_base_vertex);

    d->MultiDrawElementsBaseVertex = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLsizei *, GLenum , const GLvoid* const *, GLsizei , const GLint *)>(context->getProcAddress("glMultiDrawElementsBaseVertex"));
    d->DrawElementsInstancedBaseVertex = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const GLvoid *, GLsizei , GLint )>(context->getProcAddress("glDrawElementsInstancedBaseVertex"));
    d->DrawRangeElementsBaseVertex = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei , GLenum , const GLvoid *, GLint )>(context->getProcAddress("glDrawRangeElementsBaseVertex"));
    d->DrawElementsBaseVertex = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const GLvoid *, GLint )>(context->getProcAddress("glDrawElementsBaseVertex"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_draw_indirect::QOpenGLExtension_ARB_draw_indirect()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_draw_indirectPrivate))
{
}

bool QOpenGLExtension_ARB_draw_indirect::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_draw_indirect);

    d->DrawElementsIndirect = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glDrawElementsIndirect"));
    d->DrawArraysIndirect = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLvoid *)>(context->getProcAddress("glDrawArraysIndirect"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_draw_instanced::QOpenGLExtension_ARB_draw_instanced()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_draw_instancedPrivate))
{
}

bool QOpenGLExtension_ARB_draw_instanced::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_draw_instanced);

    d->DrawElementsInstancedARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const GLvoid *, GLsizei )>(context->getProcAddress("glDrawElementsInstancedARB"));
    d->DrawArraysInstancedARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei , GLsizei )>(context->getProcAddress("glDrawArraysInstancedARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_framebuffer_no_attachments::QOpenGLExtension_ARB_framebuffer_no_attachments()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_framebuffer_no_attachmentsPrivate))
{
}

bool QOpenGLExtension_ARB_framebuffer_no_attachments::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_framebuffer_no_attachments);

    d->GetFramebufferParameteriv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetFramebufferParameteriv"));
    d->FramebufferParameteri = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glFramebufferParameteri"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_framebuffer_object::QOpenGLExtension_ARB_framebuffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_framebuffer_objectPrivate))
{
}

bool QOpenGLExtension_ARB_framebuffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_framebuffer_object);

    d->FramebufferTextureLayer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glFramebufferTextureLayer"));
    d->RenderbufferStorageMultisample = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glRenderbufferStorageMultisample"));
    d->BlitFramebuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint , GLint , GLint , GLint , GLint , GLint , GLbitfield , GLenum )>(context->getProcAddress("glBlitFramebuffer"));
    d->GenerateMipmap = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glGenerateMipmap"));
    d->GetFramebufferAttachmentParameteriv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetFramebufferAttachmentParameteriv"));
    d->FramebufferRenderbuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint )>(context->getProcAddress("glFramebufferRenderbuffer"));
    d->FramebufferTexture3D = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glFramebufferTexture3D"));
    d->FramebufferTexture2D = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glFramebufferTexture2D"));
    d->FramebufferTexture1D = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glFramebufferTexture1D"));
    d->CheckFramebufferStatus = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glCheckFramebufferStatus"));
    d->GenFramebuffers = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenFramebuffers"));
    d->DeleteFramebuffers = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteFramebuffers"));
    d->BindFramebuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindFramebuffer"));
    d->IsFramebuffer = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsFramebuffer"));
    d->GetRenderbufferParameteriv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetRenderbufferParameteriv"));
    d->RenderbufferStorage = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glRenderbufferStorage"));
    d->GenRenderbuffers = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenRenderbuffers"));
    d->DeleteRenderbuffers = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteRenderbuffers"));
    d->BindRenderbuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindRenderbuffer"));
    d->IsRenderbuffer = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsRenderbuffer"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_geometry_shader4::QOpenGLExtension_ARB_geometry_shader4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_geometry_shader4Private))
{
}

bool QOpenGLExtension_ARB_geometry_shader4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_geometry_shader4);

    d->FramebufferTextureFaceARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint , GLenum )>(context->getProcAddress("glFramebufferTextureFaceARB"));
    d->FramebufferTextureLayerARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glFramebufferTextureLayerARB"));
    d->FramebufferTextureARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glFramebufferTextureARB"));
    d->ProgramParameteriARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glProgramParameteriARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_get_program_binary::QOpenGLExtension_ARB_get_program_binary()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_get_program_binaryPrivate))
{
}

bool QOpenGLExtension_ARB_get_program_binary::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_get_program_binary);

    d->ProgramParameteri = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glProgramParameteri"));
    d->ProgramBinary = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLvoid *, GLsizei )>(context->getProcAddress("glProgramBinary"));
    d->GetProgramBinary = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei *, GLenum *, GLvoid *)>(context->getProcAddress("glGetProgramBinary"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_gpu_shader_fp64::QOpenGLExtension_ARB_gpu_shader_fp64()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_gpu_shader_fp64Private))
{
}

bool QOpenGLExtension_ARB_gpu_shader_fp64::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_gpu_shader_fp64);

    d->GetUniformdv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble *)>(context->getProcAddress("glGetUniformdv"));
    d->UniformMatrix4x3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix4x3dv"));
    d->UniformMatrix4x2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix4x2dv"));
    d->UniformMatrix3x4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix3x4dv"));
    d->UniformMatrix3x2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix3x2dv"));
    d->UniformMatrix2x4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix2x4dv"));
    d->UniformMatrix2x3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix2x3dv"));
    d->UniformMatrix4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix4dv"));
    d->UniformMatrix3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix3dv"));
    d->UniformMatrix2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glUniformMatrix2dv"));
    d->Uniform4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glUniform4dv"));
    d->Uniform3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glUniform3dv"));
    d->Uniform2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glUniform2dv"));
    d->Uniform1dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glUniform1dv"));
    d->Uniform4d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glUniform4d"));
    d->Uniform3d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glUniform3d"));
    d->Uniform2d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLdouble , GLdouble )>(context->getProcAddress("glUniform2d"));
    d->Uniform1d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLdouble )>(context->getProcAddress("glUniform1d"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_instanced_arrays::QOpenGLExtension_ARB_instanced_arrays()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_instanced_arraysPrivate))
{
}

bool QOpenGLExtension_ARB_instanced_arrays::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_instanced_arrays);

    d->VertexAttribDivisorARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glVertexAttribDivisorARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_internalformat_query::QOpenGLExtension_ARB_internalformat_query()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_internalformat_queryPrivate))
{
}

bool QOpenGLExtension_ARB_internalformat_query::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_internalformat_query);

    d->GetInternalformativ = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , GLint *)>(context->getProcAddress("glGetInternalformativ"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_internalformat_query2::QOpenGLExtension_ARB_internalformat_query2()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_internalformat_query2Private))
{
}

bool QOpenGLExtension_ARB_internalformat_query2::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_internalformat_query2);

    d->GetInternalformati64v = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , GLint64 *)>(context->getProcAddress("glGetInternalformati64v"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_invalidate_subdata::QOpenGLExtension_ARB_invalidate_subdata()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_invalidate_subdataPrivate))
{
}

bool QOpenGLExtension_ARB_invalidate_subdata::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_invalidate_subdata);

    d->InvalidateSubFramebuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLenum *, GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glInvalidateSubFramebuffer"));
    d->InvalidateFramebuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLenum *)>(context->getProcAddress("glInvalidateFramebuffer"));
    d->InvalidateBufferData = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glInvalidateBufferData"));
    d->InvalidateBufferSubData = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLintptr , GLsizeiptr )>(context->getProcAddress("glInvalidateBufferSubData"));
    d->InvalidateTexImage = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint )>(context->getProcAddress("glInvalidateTexImage"));
    d->InvalidateTexSubImage = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei )>(context->getProcAddress("glInvalidateTexSubImage"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_map_buffer_range::QOpenGLExtension_ARB_map_buffer_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_map_buffer_rangePrivate))
{
}

bool QOpenGLExtension_ARB_map_buffer_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_map_buffer_range);

    d->FlushMappedBufferRange = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLintptr , GLsizeiptr )>(context->getProcAddress("glFlushMappedBufferRange"));
    d->MapBufferRange = reinterpret_cast<GLvoid* (QOPENGLF_APIENTRYP)(GLenum , GLintptr , GLsizeiptr , GLbitfield )>(context->getProcAddress("glMapBufferRange"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_matrix_palette::QOpenGLExtension_ARB_matrix_palette()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_matrix_palettePrivate))
{
}

bool QOpenGLExtension_ARB_matrix_palette::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_matrix_palette);

    d->MatrixIndexPointerARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glMatrixIndexPointerARB"));
    d->MatrixIndexuivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLuint *)>(context->getProcAddress("glMatrixIndexuivARB"));
    d->MatrixIndexusvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLushort *)>(context->getProcAddress("glMatrixIndexusvARB"));
    d->MatrixIndexubvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLubyte *)>(context->getProcAddress("glMatrixIndexubvARB"));
    d->CurrentPaletteMatrixARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glCurrentPaletteMatrixARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_multi_draw_indirect::QOpenGLExtension_ARB_multi_draw_indirect()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_multi_draw_indirectPrivate))
{
}

bool QOpenGLExtension_ARB_multi_draw_indirect::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_multi_draw_indirect);

    d->MultiDrawElementsIndirect = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const void *, GLsizei , GLsizei )>(context->getProcAddress("glMultiDrawElementsIndirect"));
    d->MultiDrawArraysIndirect = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const void *, GLsizei , GLsizei )>(context->getProcAddress("glMultiDrawArraysIndirect"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_multisample::QOpenGLExtension_ARB_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_multisamplePrivate))
{
}

bool QOpenGLExtension_ARB_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_multisample);

    d->SampleCoverageARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLboolean )>(context->getProcAddress("glSampleCoverageARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_multitexture::QOpenGLExtension_ARB_multitexture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_multitexturePrivate))
{
}

bool QOpenGLExtension_ARB_multitexture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_multitexture);

    d->MultiTexCoord4svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glMultiTexCoord4svARB"));
    d->MultiTexCoord4sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort , GLshort , GLshort )>(context->getProcAddress("glMultiTexCoord4sARB"));
    d->MultiTexCoord4ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glMultiTexCoord4ivARB"));
    d->MultiTexCoord4iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint )>(context->getProcAddress("glMultiTexCoord4iARB"));
    d->MultiTexCoord4fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexCoord4fvARB"));
    d->MultiTexCoord4fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glMultiTexCoord4fARB"));
    d->MultiTexCoord4dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMultiTexCoord4dvARB"));
    d->MultiTexCoord4dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMultiTexCoord4dARB"));
    d->MultiTexCoord3svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glMultiTexCoord3svARB"));
    d->MultiTexCoord3sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort , GLshort )>(context->getProcAddress("glMultiTexCoord3sARB"));
    d->MultiTexCoord3ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glMultiTexCoord3ivARB"));
    d->MultiTexCoord3iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint )>(context->getProcAddress("glMultiTexCoord3iARB"));
    d->MultiTexCoord3fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexCoord3fvARB"));
    d->MultiTexCoord3fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glMultiTexCoord3fARB"));
    d->MultiTexCoord3dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMultiTexCoord3dvARB"));
    d->MultiTexCoord3dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMultiTexCoord3dARB"));
    d->MultiTexCoord2svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glMultiTexCoord2svARB"));
    d->MultiTexCoord2sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort )>(context->getProcAddress("glMultiTexCoord2sARB"));
    d->MultiTexCoord2ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glMultiTexCoord2ivARB"));
    d->MultiTexCoord2iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint )>(context->getProcAddress("glMultiTexCoord2iARB"));
    d->MultiTexCoord2fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexCoord2fvARB"));
    d->MultiTexCoord2fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat )>(context->getProcAddress("glMultiTexCoord2fARB"));
    d->MultiTexCoord2dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMultiTexCoord2dvARB"));
    d->MultiTexCoord2dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble )>(context->getProcAddress("glMultiTexCoord2dARB"));
    d->MultiTexCoord1svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glMultiTexCoord1svARB"));
    d->MultiTexCoord1sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort )>(context->getProcAddress("glMultiTexCoord1sARB"));
    d->MultiTexCoord1ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glMultiTexCoord1ivARB"));
    d->MultiTexCoord1iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glMultiTexCoord1iARB"));
    d->MultiTexCoord1fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexCoord1fvARB"));
    d->MultiTexCoord1fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glMultiTexCoord1fARB"));
    d->MultiTexCoord1dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMultiTexCoord1dvARB"));
    d->MultiTexCoord1dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble )>(context->getProcAddress("glMultiTexCoord1dARB"));
    d->ClientActiveTextureARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glClientActiveTextureARB"));
    d->ActiveTextureARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glActiveTextureARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_occlusion_query::QOpenGLExtension_ARB_occlusion_query()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_occlusion_queryPrivate))
{
}

bool QOpenGLExtension_ARB_occlusion_query::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_occlusion_query);

    d->GetQueryObjectuivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint *)>(context->getProcAddress("glGetQueryObjectuivARB"));
    d->GetQueryObjectivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetQueryObjectivARB"));
    d->GetQueryivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetQueryivARB"));
    d->EndQueryARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glEndQueryARB"));
    d->BeginQueryARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBeginQueryARB"));
    d->IsQueryARB = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsQueryARB"));
    d->DeleteQueriesARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteQueriesARB"));
    d->GenQueriesARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenQueriesARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_point_parameters::QOpenGLExtension_ARB_point_parameters()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_point_parametersPrivate))
{
}

bool QOpenGLExtension_ARB_point_parameters::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_point_parameters);

    d->PointParameterfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glPointParameterfvARB"));
    d->PointParameterfARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glPointParameterfARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_program_interface_query::QOpenGLExtension_ARB_program_interface_query()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_program_interface_queryPrivate))
{
}

bool QOpenGLExtension_ARB_program_interface_query::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_program_interface_query);

    d->GetProgramResourceLocationIndex = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLchar *)>(context->getProcAddress("glGetProgramResourceLocationIndex"));
    d->GetProgramResourceLocation = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLchar *)>(context->getProcAddress("glGetProgramResourceLocation"));
    d->GetProgramResourceiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , const GLenum *, GLsizei , GLsizei *, GLint *)>(context->getProcAddress("glGetProgramResourceiv"));
    d->GetProgramResourceName = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetProgramResourceName"));
    d->GetProgramResourceIndex = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLchar *)>(context->getProcAddress("glGetProgramResourceIndex"));
    d->GetProgramInterfaceiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetProgramInterfaceiv"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_provoking_vertex::QOpenGLExtension_ARB_provoking_vertex()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_provoking_vertexPrivate))
{
}

bool QOpenGLExtension_ARB_provoking_vertex::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_provoking_vertex);

    d->ProvokingVertex = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glProvokingVertex"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_robustness::QOpenGLExtension_ARB_robustness()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_robustnessPrivate))
{
}

bool QOpenGLExtension_ARB_robustness::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_robustness);

    d->GetnUniformdvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLdouble *)>(context->getProcAddress("glGetnUniformdvARB"));
    d->GetnUniformuivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLuint *)>(context->getProcAddress("glGetnUniformuivARB"));
    d->GetnUniformivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLint *)>(context->getProcAddress("glGetnUniformivARB"));
    d->GetnUniformfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLfloat *)>(context->getProcAddress("glGetnUniformfvARB"));
    d->GetnCompressedTexImageARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei , GLvoid *)>(context->getProcAddress("glGetnCompressedTexImageARB"));
    d->ReadnPixelsARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , GLsizei , GLvoid *)>(context->getProcAddress("glReadnPixelsARB"));
    d->GetnTexImageARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLenum , GLsizei , GLvoid *)>(context->getProcAddress("glGetnTexImageARB"));
    d->GetnMinmaxARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLboolean , GLenum , GLenum , GLsizei , GLvoid *)>(context->getProcAddress("glGetnMinmaxARB"));
    d->GetnHistogramARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLboolean , GLenum , GLenum , GLsizei , GLvoid *)>(context->getProcAddress("glGetnHistogramARB"));
    d->GetnSeparableFilterARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , GLvoid *, GLsizei , GLvoid *, GLvoid *)>(context->getProcAddress("glGetnSeparableFilterARB"));
    d->GetnConvolutionFilterARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , GLvoid *)>(context->getProcAddress("glGetnConvolutionFilterARB"));
    d->GetnColorTableARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , GLvoid *)>(context->getProcAddress("glGetnColorTableARB"));
    d->GetnPolygonStippleARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLubyte *)>(context->getProcAddress("glGetnPolygonStippleARB"));
    d->GetnPixelMapusvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLushort *)>(context->getProcAddress("glGetnPixelMapusvARB"));
    d->GetnPixelMapuivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLuint *)>(context->getProcAddress("glGetnPixelMapuivARB"));
    d->GetnPixelMapfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLfloat *)>(context->getProcAddress("glGetnPixelMapfvARB"));
    d->GetnMapivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLint *)>(context->getProcAddress("glGetnMapivARB"));
    d->GetnMapfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLfloat *)>(context->getProcAddress("glGetnMapfvARB"));
    d->GetnMapdvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLdouble *)>(context->getProcAddress("glGetnMapdvARB"));
    d->GetGraphicsResetStatusARB = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glGetGraphicsResetStatusARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_sample_shading::QOpenGLExtension_ARB_sample_shading()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_sample_shadingPrivate))
{
}

bool QOpenGLExtension_ARB_sample_shading::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_sample_shading);

    d->MinSampleShadingARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat )>(context->getProcAddress("glMinSampleShadingARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_sampler_objects::QOpenGLExtension_ARB_sampler_objects()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_sampler_objectsPrivate))
{
}

bool QOpenGLExtension_ARB_sampler_objects::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_sampler_objects);

    d->GetSamplerParameterIuiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint *)>(context->getProcAddress("glGetSamplerParameterIuiv"));
    d->GetSamplerParameterfv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetSamplerParameterfv"));
    d->GetSamplerParameterIiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetSamplerParameterIiv"));
    d->GetSamplerParameteriv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetSamplerParameteriv"));
    d->SamplerParameterIuiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLuint *)>(context->getProcAddress("glSamplerParameterIuiv"));
    d->SamplerParameterIiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLint *)>(context->getProcAddress("glSamplerParameterIiv"));
    d->SamplerParameterfv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glSamplerParameterfv"));
    d->SamplerParameterf = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat )>(context->getProcAddress("glSamplerParameterf"));
    d->SamplerParameteriv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLint *)>(context->getProcAddress("glSamplerParameteriv"));
    d->SamplerParameteri = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glSamplerParameteri"));
    d->BindSampler = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glBindSampler"));
    d->IsSampler = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsSampler"));
    d->DeleteSamplers = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteSamplers"));
    d->GenSamplers = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenSamplers"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_separate_shader_objects::QOpenGLExtension_ARB_separate_shader_objects()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_separate_shader_objectsPrivate))
{
}

bool QOpenGLExtension_ARB_separate_shader_objects::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_separate_shader_objects);

    d->GetProgramPipelineInfoLog = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetProgramPipelineInfoLog"));
    d->ValidateProgramPipeline = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glValidateProgramPipeline"));
    d->ProgramUniformMatrix4x3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix4x3dv"));
    d->ProgramUniformMatrix3x4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix3x4dv"));
    d->ProgramUniformMatrix4x2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix4x2dv"));
    d->ProgramUniformMatrix2x4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix2x4dv"));
    d->ProgramUniformMatrix3x2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix3x2dv"));
    d->ProgramUniformMatrix2x3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix2x3dv"));
    d->ProgramUniformMatrix4x3fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix4x3fv"));
    d->ProgramUniformMatrix3x4fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix3x4fv"));
    d->ProgramUniformMatrix4x2fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix4x2fv"));
    d->ProgramUniformMatrix2x4fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix2x4fv"));
    d->ProgramUniformMatrix3x2fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix3x2fv"));
    d->ProgramUniformMatrix2x3fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix2x3fv"));
    d->ProgramUniformMatrix4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix4dv"));
    d->ProgramUniformMatrix3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix3dv"));
    d->ProgramUniformMatrix2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix2dv"));
    d->ProgramUniformMatrix4fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix4fv"));
    d->ProgramUniformMatrix3fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix3fv"));
    d->ProgramUniformMatrix2fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix2fv"));
    d->ProgramUniform4uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform4uiv"));
    d->ProgramUniform4ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glProgramUniform4ui"));
    d->ProgramUniform4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform4dv"));
    d->ProgramUniform4d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramUniform4d"));
    d->ProgramUniform4fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform4fv"));
    d->ProgramUniform4f = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramUniform4f"));
    d->ProgramUniform4iv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform4iv"));
    d->ProgramUniform4i = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glProgramUniform4i"));
    d->ProgramUniform3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform3uiv"));
    d->ProgramUniform3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint , GLuint , GLuint )>(context->getProcAddress("glProgramUniform3ui"));
    d->ProgramUniform3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform3dv"));
    d->ProgramUniform3d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramUniform3d"));
    d->ProgramUniform3fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform3fv"));
    d->ProgramUniform3f = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramUniform3f"));
    d->ProgramUniform3iv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform3iv"));
    d->ProgramUniform3i = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glProgramUniform3i"));
    d->ProgramUniform2uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform2uiv"));
    d->ProgramUniform2ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint , GLuint )>(context->getProcAddress("glProgramUniform2ui"));
    d->ProgramUniform2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform2dv"));
    d->ProgramUniform2d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble , GLdouble )>(context->getProcAddress("glProgramUniform2d"));
    d->ProgramUniform2fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform2fv"));
    d->ProgramUniform2f = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat , GLfloat )>(context->getProcAddress("glProgramUniform2f"));
    d->ProgramUniform2iv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform2iv"));
    d->ProgramUniform2i = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint )>(context->getProcAddress("glProgramUniform2i"));
    d->ProgramUniform1uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform1uiv"));
    d->ProgramUniform1ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint )>(context->getProcAddress("glProgramUniform1ui"));
    d->ProgramUniform1dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform1dv"));
    d->ProgramUniform1d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble )>(context->getProcAddress("glProgramUniform1d"));
    d->ProgramUniform1fv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform1fv"));
    d->ProgramUniform1f = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat )>(context->getProcAddress("glProgramUniform1f"));
    d->ProgramUniform1iv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform1iv"));
    d->ProgramUniform1i = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint )>(context->getProcAddress("glProgramUniform1i"));
    d->GetProgramPipelineiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetProgramPipelineiv"));
    d->IsProgramPipeline = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsProgramPipeline"));
    d->GenProgramPipelines = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenProgramPipelines"));
    d->DeleteProgramPipelines = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteProgramPipelines"));
    d->BindProgramPipeline = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBindProgramPipeline"));
    d->CreateShaderProgramv = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLchar* const *)>(context->getProcAddress("glCreateShaderProgramv"));
    d->ActiveShaderProgram = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glActiveShaderProgram"));
    d->UseProgramStages = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLbitfield , GLuint )>(context->getProcAddress("glUseProgramStages"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_shader_atomic_counters::QOpenGLExtension_ARB_shader_atomic_counters()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_shader_atomic_countersPrivate))
{
}

bool QOpenGLExtension_ARB_shader_atomic_counters::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_shader_atomic_counters);

    d->GetActiveAtomicCounterBufferiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetActiveAtomicCounterBufferiv"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_shader_image_load_store::QOpenGLExtension_ARB_shader_image_load_store()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_shader_image_load_storePrivate))
{
}

bool QOpenGLExtension_ARB_shader_image_load_store::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_shader_image_load_store);

    d->MemoryBarrier = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield )>(context->getProcAddress("glMemoryBarrier"));
    d->BindImageTexture = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLint , GLboolean , GLint , GLenum , GLenum )>(context->getProcAddress("glBindImageTexture"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_shader_objects::QOpenGLExtension_ARB_shader_objects()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_shader_objectsPrivate))
{
}

bool QOpenGLExtension_ARB_shader_objects::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_shader_objects);

    d->GetShaderSourceARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLsizei , GLsizei *, GLcharARB *)>(context->getProcAddress("glGetShaderSourceARB"));
    d->GetUniformivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLint , GLint *)>(context->getProcAddress("glGetUniformivARB"));
    d->GetUniformfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLint , GLfloat *)>(context->getProcAddress("glGetUniformfvARB"));
    d->GetActiveUniformARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLuint , GLsizei , GLsizei *, GLint *, GLenum *, GLcharARB *)>(context->getProcAddress("glGetActiveUniformARB"));
    d->GetUniformLocationARB = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLhandleARB , const GLcharARB *)>(context->getProcAddress("glGetUniformLocationARB"));
    d->GetAttachedObjectsARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLsizei , GLsizei *, GLhandleARB *)>(context->getProcAddress("glGetAttachedObjectsARB"));
    d->GetInfoLogARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLsizei , GLsizei *, GLcharARB *)>(context->getProcAddress("glGetInfoLogARB"));
    d->GetObjectParameterivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLenum , GLint *)>(context->getProcAddress("glGetObjectParameterivARB"));
    d->GetObjectParameterfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLenum , GLfloat *)>(context->getProcAddress("glGetObjectParameterfvARB"));
    d->UniformMatrix4fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glUniformMatrix4fvARB"));
    d->UniformMatrix3fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glUniformMatrix3fvARB"));
    d->UniformMatrix2fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glUniformMatrix2fvARB"));
    d->Uniform4ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint *)>(context->getProcAddress("glUniform4ivARB"));
    d->Uniform3ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint *)>(context->getProcAddress("glUniform3ivARB"));
    d->Uniform2ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint *)>(context->getProcAddress("glUniform2ivARB"));
    d->Uniform1ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint *)>(context->getProcAddress("glUniform1ivARB"));
    d->Uniform4fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glUniform4fvARB"));
    d->Uniform3fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glUniform3fvARB"));
    d->Uniform2fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glUniform2fvARB"));
    d->Uniform1fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glUniform1fvARB"));
    d->Uniform4iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glUniform4iARB"));
    d->Uniform3iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint , GLint )>(context->getProcAddress("glUniform3iARB"));
    d->Uniform2iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint )>(context->getProcAddress("glUniform2iARB"));
    d->Uniform1iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint )>(context->getProcAddress("glUniform1iARB"));
    d->Uniform4fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glUniform4fARB"));
    d->Uniform3fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glUniform3fARB"));
    d->Uniform2fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLfloat , GLfloat )>(context->getProcAddress("glUniform2fARB"));
    d->Uniform1fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLfloat )>(context->getProcAddress("glUniform1fARB"));
    d->ValidateProgramARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB )>(context->getProcAddress("glValidateProgramARB"));
    d->UseProgramObjectARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB )>(context->getProcAddress("glUseProgramObjectARB"));
    d->LinkProgramARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB )>(context->getProcAddress("glLinkProgramARB"));
    d->AttachObjectARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLhandleARB )>(context->getProcAddress("glAttachObjectARB"));
    d->CreateProgramObjectARB = reinterpret_cast<GLhandleARB (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glCreateProgramObjectARB"));
    d->CompileShaderARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB )>(context->getProcAddress("glCompileShaderARB"));
    d->ShaderSourceARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLsizei , const GLcharARB* *, const GLint *)>(context->getProcAddress("glShaderSourceARB"));
    d->CreateShaderObjectARB = reinterpret_cast<GLhandleARB (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glCreateShaderObjectARB"));
    d->DetachObjectARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLhandleARB )>(context->getProcAddress("glDetachObjectARB"));
    d->GetHandleARB = reinterpret_cast<GLhandleARB (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glGetHandleARB"));
    d->DeleteObjectARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB )>(context->getProcAddress("glDeleteObjectARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_shader_storage_buffer_object::QOpenGLExtension_ARB_shader_storage_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_shader_storage_buffer_objectPrivate))
{
}

bool QOpenGLExtension_ARB_shader_storage_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_shader_storage_buffer_object);

    d->ShaderStorageBlockBinding = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glShaderStorageBlockBinding"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_shader_subroutine::QOpenGLExtension_ARB_shader_subroutine()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_shader_subroutinePrivate))
{
}

bool QOpenGLExtension_ARB_shader_subroutine::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_shader_subroutine);

    d->GetProgramStageiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetProgramStageiv"));
    d->GetUniformSubroutineuiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLuint *)>(context->getProcAddress("glGetUniformSubroutineuiv"));
    d->UniformSubroutinesuiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLuint *)>(context->getProcAddress("glUniformSubroutinesuiv"));
    d->GetActiveSubroutineName = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetActiveSubroutineName"));
    d->GetActiveSubroutineUniformName = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetActiveSubroutineUniformName"));
    d->GetActiveSubroutineUniformiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetActiveSubroutineUniformiv"));
    d->GetSubroutineIndex = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLchar *)>(context->getProcAddress("glGetSubroutineIndex"));
    d->GetSubroutineUniformLocation = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLchar *)>(context->getProcAddress("glGetSubroutineUniformLocation"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_shading_language_include::QOpenGLExtension_ARB_shading_language_include()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_shading_language_includePrivate))
{
}

bool QOpenGLExtension_ARB_shading_language_include::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_shading_language_include);

    d->GetNamedStringivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLchar *, GLenum , GLint *)>(context->getProcAddress("glGetNamedStringivARB"));
    d->GetNamedStringARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLchar *, GLsizei , GLint *, GLchar *)>(context->getProcAddress("glGetNamedStringARB"));
    d->IsNamedStringARB = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLint , const GLchar *)>(context->getProcAddress("glIsNamedStringARB"));
    d->CompileShaderIncludeARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLchar* *, const GLint *)>(context->getProcAddress("glCompileShaderIncludeARB"));
    d->DeleteNamedStringARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLchar *)>(context->getProcAddress("glDeleteNamedStringARB"));
    d->NamedStringARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , const GLchar *, GLint , const GLchar *)>(context->getProcAddress("glNamedStringARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_sync::QOpenGLExtension_ARB_sync()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_syncPrivate))
{
}

bool QOpenGLExtension_ARB_sync::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_sync);

    d->GetSynciv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsync , GLenum , GLsizei , GLsizei *, GLint *)>(context->getProcAddress("glGetSynciv"));
    d->GetInteger64v = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint64 *)>(context->getProcAddress("glGetInteger64v"));
    d->WaitSync = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsync , GLbitfield , GLuint64 )>(context->getProcAddress("glWaitSync"));
    d->ClientWaitSync = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLsync , GLbitfield , GLuint64 )>(context->getProcAddress("glClientWaitSync"));
    d->DeleteSync = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsync )>(context->getProcAddress("glDeleteSync"));
    d->IsSync = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLsync )>(context->getProcAddress("glIsSync"));
    d->FenceSync = reinterpret_cast<GLsync (QOPENGLF_APIENTRYP)(GLenum , GLbitfield )>(context->getProcAddress("glFenceSync"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_tessellation_shader::QOpenGLExtension_ARB_tessellation_shader()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_tessellation_shaderPrivate))
{
}

bool QOpenGLExtension_ARB_tessellation_shader::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_tessellation_shader);

    d->PatchParameterfv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glPatchParameterfv"));
    d->PatchParameteri = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glPatchParameteri"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_buffer_object::QOpenGLExtension_ARB_texture_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_buffer_objectPrivate))
{
}

bool QOpenGLExtension_ARB_texture_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_buffer_object);

    d->TexBufferARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glTexBufferARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_buffer_range::QOpenGLExtension_ARB_texture_buffer_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_buffer_rangePrivate))
{
}

bool QOpenGLExtension_ARB_texture_buffer_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_buffer_range);

    d->TexBufferRange = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLintptr , GLsizeiptr )>(context->getProcAddress("glTexBufferRange"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_compression::QOpenGLExtension_ARB_texture_compression()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_compressionPrivate))
{
}

bool QOpenGLExtension_ARB_texture_compression::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_compression);

    d->GetCompressedTexImageARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLvoid *)>(context->getProcAddress("glGetCompressedTexImageARB"));
    d->CompressedTexSubImage1DARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTexSubImage1DARB"));
    d->CompressedTexSubImage2DARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTexSubImage2DARB"));
    d->CompressedTexSubImage3DARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTexSubImage3DARB"));
    d->CompressedTexImage1DARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTexImage1DARB"));
    d->CompressedTexImage2DARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTexImage2DARB"));
    d->CompressedTexImage3DARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTexImage3DARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_multisample::QOpenGLExtension_ARB_texture_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_multisamplePrivate))
{
}

bool QOpenGLExtension_ARB_texture_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_multisample);

    d->SampleMaski = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLbitfield )>(context->getProcAddress("glSampleMaski"));
    d->GetMultisamplefv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetMultisamplefv"));
    d->TexImage3DMultisample = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLint , GLsizei , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTexImage3DMultisample"));
    d->TexImage2DMultisample = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLint , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTexImage2DMultisample"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_storage::QOpenGLExtension_ARB_texture_storage()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_storagePrivate))
{
}

bool QOpenGLExtension_ARB_texture_storage::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_storage);

    d->TexStorage3D = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei , GLsizei , GLsizei )>(context->getProcAddress("glTexStorage3D"));
    d->TexStorage2D = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glTexStorage2D"));
    d->TexStorage1D = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei )>(context->getProcAddress("glTexStorage1D"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_storage_multisample::QOpenGLExtension_ARB_texture_storage_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_storage_multisamplePrivate))
{
}

bool QOpenGLExtension_ARB_texture_storage_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_storage_multisample);

    d->TexStorage3DMultisample = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTexStorage3DMultisample"));
    d->TexStorage2DMultisample = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTexStorage2DMultisample"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_texture_view::QOpenGLExtension_ARB_texture_view()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_texture_viewPrivate))
{
}

bool QOpenGLExtension_ARB_texture_view::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_texture_view);

    d->TextureView = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLenum , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glTextureView"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_timer_query::QOpenGLExtension_ARB_timer_query()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_timer_queryPrivate))
{
}

bool QOpenGLExtension_ARB_timer_query::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_timer_query);

    d->GetQueryObjectui64v = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint64 *)>(context->getProcAddress("glGetQueryObjectui64v"));
    d->GetQueryObjecti64v = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint64 *)>(context->getProcAddress("glGetQueryObjecti64v"));
    d->QueryCounter = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glQueryCounter"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_transform_feedback2::QOpenGLExtension_ARB_transform_feedback2()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_transform_feedback2Private))
{
}

bool QOpenGLExtension_ARB_transform_feedback2::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_transform_feedback2);

    d->DrawTransformFeedback = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glDrawTransformFeedback"));
    d->ResumeTransformFeedback = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glResumeTransformFeedback"));
    d->PauseTransformFeedback = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glPauseTransformFeedback"));
    d->IsTransformFeedback = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsTransformFeedback"));
    d->GenTransformFeedbacks = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenTransformFeedbacks"));
    d->DeleteTransformFeedbacks = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteTransformFeedbacks"));
    d->BindTransformFeedback = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindTransformFeedback"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_transform_feedback3::QOpenGLExtension_ARB_transform_feedback3()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_transform_feedback3Private))
{
}

bool QOpenGLExtension_ARB_transform_feedback3::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_transform_feedback3);

    d->GetQueryIndexediv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetQueryIndexediv"));
    d->EndQueryIndexed = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glEndQueryIndexed"));
    d->BeginQueryIndexed = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint )>(context->getProcAddress("glBeginQueryIndexed"));
    d->DrawTransformFeedbackStream = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint )>(context->getProcAddress("glDrawTransformFeedbackStream"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_transform_feedback_instanced::QOpenGLExtension_ARB_transform_feedback_instanced()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_transform_feedback_instancedPrivate))
{
}

bool QOpenGLExtension_ARB_transform_feedback_instanced::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_transform_feedback_instanced);

    d->DrawTransformFeedbackStreamInstanced = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei )>(context->getProcAddress("glDrawTransformFeedbackStreamInstanced"));
    d->DrawTransformFeedbackInstanced = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei )>(context->getProcAddress("glDrawTransformFeedbackInstanced"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_transpose_matrix::QOpenGLExtension_ARB_transpose_matrix()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_transpose_matrixPrivate))
{
}

bool QOpenGLExtension_ARB_transpose_matrix::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_transpose_matrix);

    d->MultTransposeMatrixdARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glMultTransposeMatrixdARB"));
    d->MultTransposeMatrixfARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glMultTransposeMatrixfARB"));
    d->LoadTransposeMatrixdARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glLoadTransposeMatrixdARB"));
    d->LoadTransposeMatrixfARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glLoadTransposeMatrixfARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_uniform_buffer_object::QOpenGLExtension_ARB_uniform_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_uniform_buffer_objectPrivate))
{
}

bool QOpenGLExtension_ARB_uniform_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_uniform_buffer_object);

    d->UniformBlockBinding = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glUniformBlockBinding"));
    d->GetActiveUniformBlockName = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetActiveUniformBlockName"));
    d->GetActiveUniformBlockiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetActiveUniformBlockiv"));
    d->GetUniformBlockIndex = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint , const GLchar *)>(context->getProcAddress("glGetUniformBlockIndex"));
    d->GetActiveUniformName = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetActiveUniformName"));
    d->GetActiveUniformsiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLuint *, GLenum , GLint *)>(context->getProcAddress("glGetActiveUniformsiv"));
    d->GetUniformIndices = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLchar* const *, GLuint *)>(context->getProcAddress("glGetUniformIndices"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_array_object::QOpenGLExtension_ARB_vertex_array_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_array_objectPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_array_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_array_object);

    d->IsVertexArray = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsVertexArray"));
    d->GenVertexArrays = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenVertexArrays"));
    d->DeleteVertexArrays = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteVertexArrays"));
    d->BindVertexArray = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBindVertexArray"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_attrib_64bit::QOpenGLExtension_ARB_vertex_attrib_64bit()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_attrib_64bitPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_attrib_64bit::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_attrib_64bit);

    d->GetVertexAttribLdv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLdouble *)>(context->getProcAddress("glGetVertexAttribLdv"));
    d->VertexAttribLPointer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexAttribLPointer"));
    d->VertexAttribL4dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL4dv"));
    d->VertexAttribL3dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL3dv"));
    d->VertexAttribL2dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL2dv"));
    d->VertexAttribL1dv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL1dv"));
    d->VertexAttribL4d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttribL4d"));
    d->VertexAttribL3d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttribL3d"));
    d->VertexAttribL2d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttribL2d"));
    d->VertexAttribL1d = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble )>(context->getProcAddress("glVertexAttribL1d"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_attrib_binding::QOpenGLExtension_ARB_vertex_attrib_binding()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_attrib_bindingPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_attrib_binding::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_attrib_binding);

    d->VertexBindingDivisor = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glVertexBindingDivisor"));
    d->VertexAttribBinding = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glVertexAttribBinding"));
    d->VertexAttribLFormat = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLuint )>(context->getProcAddress("glVertexAttribLFormat"));
    d->VertexAttribIFormat = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLuint )>(context->getProcAddress("glVertexAttribIFormat"));
    d->VertexAttribFormat = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLboolean , GLuint )>(context->getProcAddress("glVertexAttribFormat"));
    d->BindVertexBuffer = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLintptr , GLsizei )>(context->getProcAddress("glBindVertexBuffer"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_blend::QOpenGLExtension_ARB_vertex_blend()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_blendPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_blend::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_blend);

    d->VertexBlendARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glVertexBlendARB"));
    d->WeightPointerARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glWeightPointerARB"));
    d->WeightuivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLuint *)>(context->getProcAddress("glWeightuivARB"));
    d->WeightusvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLushort *)>(context->getProcAddress("glWeightusvARB"));
    d->WeightubvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLubyte *)>(context->getProcAddress("glWeightubvARB"));
    d->WeightdvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLdouble *)>(context->getProcAddress("glWeightdvARB"));
    d->WeightfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLfloat *)>(context->getProcAddress("glWeightfvARB"));
    d->WeightivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLint *)>(context->getProcAddress("glWeightivARB"));
    d->WeightsvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLshort *)>(context->getProcAddress("glWeightsvARB"));
    d->WeightbvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLbyte *)>(context->getProcAddress("glWeightbvARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_buffer_object::QOpenGLExtension_ARB_vertex_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_buffer_objectPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_buffer_object);

    d->GetBufferPointervARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLvoid* *)>(context->getProcAddress("glGetBufferPointervARB"));
    d->GetBufferParameterivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetBufferParameterivARB"));
    d->UnmapBufferARB = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glUnmapBufferARB"));
    d->MapBufferARB = reinterpret_cast<GLvoid* (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glMapBufferARB"));
    d->GetBufferSubDataARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLintptrARB , GLsizeiptrARB , GLvoid *)>(context->getProcAddress("glGetBufferSubDataARB"));
    d->BufferSubDataARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLintptrARB , GLsizeiptrARB , const GLvoid *)>(context->getProcAddress("glBufferSubDataARB"));
    d->BufferDataARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizeiptrARB , const GLvoid *, GLenum )>(context->getProcAddress("glBufferDataARB"));
    d->IsBufferARB = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsBufferARB"));
    d->GenBuffersARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenBuffersARB"));
    d->DeleteBuffersARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteBuffersARB"));
    d->BindBufferARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindBufferARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_program::QOpenGLExtension_ARB_vertex_program()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_programPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_program::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_program);

    d->IsProgramARB = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsProgramARB"));
    d->GetVertexAttribPointervARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLvoid* *)>(context->getProcAddress("glGetVertexAttribPointervARB"));
    d->GetVertexAttribivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVertexAttribivARB"));
    d->GetVertexAttribfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetVertexAttribfvARB"));
    d->GetVertexAttribdvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLdouble *)>(context->getProcAddress("glGetVertexAttribdvARB"));
    d->GetProgramStringARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetProgramStringARB"));
    d->GetProgramivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetProgramivARB"));
    d->GetProgramLocalParameterfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetProgramLocalParameterfvARB"));
    d->GetProgramLocalParameterdvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble *)>(context->getProcAddress("glGetProgramLocalParameterdvARB"));
    d->GetProgramEnvParameterfvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetProgramEnvParameterfvARB"));
    d->GetProgramEnvParameterdvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble *)>(context->getProcAddress("glGetProgramEnvParameterdvARB"));
    d->ProgramLocalParameter4fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLfloat *)>(context->getProcAddress("glProgramLocalParameter4fvARB"));
    d->ProgramLocalParameter4fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramLocalParameter4fARB"));
    d->ProgramLocalParameter4dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLdouble *)>(context->getProcAddress("glProgramLocalParameter4dvARB"));
    d->ProgramLocalParameter4dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramLocalParameter4dARB"));
    d->ProgramEnvParameter4fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLfloat *)>(context->getProcAddress("glProgramEnvParameter4fvARB"));
    d->ProgramEnvParameter4fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramEnvParameter4fARB"));
    d->ProgramEnvParameter4dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLdouble *)>(context->getProcAddress("glProgramEnvParameter4dvARB"));
    d->ProgramEnvParameter4dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramEnvParameter4dARB"));
    d->GenProgramsARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenProgramsARB"));
    d->DeleteProgramsARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteProgramsARB"));
    d->BindProgramARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindProgramARB"));
    d->ProgramStringARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glProgramStringARB"));
    d->DisableVertexAttribArrayARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glDisableVertexAttribArrayARB"));
    d->EnableVertexAttribArrayARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glEnableVertexAttribArrayARB"));
    d->VertexAttribPointerARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLboolean , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexAttribPointerARB"));
    d->VertexAttrib4usvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLushort *)>(context->getProcAddress("glVertexAttrib4usvARB"));
    d->VertexAttrib4uivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVertexAttrib4uivARB"));
    d->VertexAttrib4ubvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLubyte *)>(context->getProcAddress("glVertexAttrib4ubvARB"));
    d->VertexAttrib4svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib4svARB"));
    d->VertexAttrib4sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort , GLshort , GLshort , GLshort )>(context->getProcAddress("glVertexAttrib4sARB"));
    d->VertexAttrib4ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVertexAttrib4ivARB"));
    d->VertexAttrib4fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib4fvARB"));
    d->VertexAttrib4fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glVertexAttrib4fARB"));
    d->VertexAttrib4dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib4dvARB"));
    d->VertexAttrib4dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttrib4dARB"));
    d->VertexAttrib4bvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLbyte *)>(context->getProcAddress("glVertexAttrib4bvARB"));
    d->VertexAttrib4NusvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLushort *)>(context->getProcAddress("glVertexAttrib4NusvARB"));
    d->VertexAttrib4NuivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVertexAttrib4NuivARB"));
    d->VertexAttrib4NubvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLubyte *)>(context->getProcAddress("glVertexAttrib4NubvARB"));
    d->VertexAttrib4NubARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLubyte , GLubyte , GLubyte , GLubyte )>(context->getProcAddress("glVertexAttrib4NubARB"));
    d->VertexAttrib4NsvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib4NsvARB"));
    d->VertexAttrib4NivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVertexAttrib4NivARB"));
    d->VertexAttrib4NbvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLbyte *)>(context->getProcAddress("glVertexAttrib4NbvARB"));
    d->VertexAttrib3svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib3svARB"));
    d->VertexAttrib3sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort , GLshort , GLshort )>(context->getProcAddress("glVertexAttrib3sARB"));
    d->VertexAttrib3fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib3fvARB"));
    d->VertexAttrib3fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glVertexAttrib3fARB"));
    d->VertexAttrib3dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib3dvARB"));
    d->VertexAttrib3dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttrib3dARB"));
    d->VertexAttrib2svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib2svARB"));
    d->VertexAttrib2sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort , GLshort )>(context->getProcAddress("glVertexAttrib2sARB"));
    d->VertexAttrib2fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib2fvARB"));
    d->VertexAttrib2fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat )>(context->getProcAddress("glVertexAttrib2fARB"));
    d->VertexAttrib2dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib2dvARB"));
    d->VertexAttrib2dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttrib2dARB"));
    d->VertexAttrib1svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib1svARB"));
    d->VertexAttrib1sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort )>(context->getProcAddress("glVertexAttrib1sARB"));
    d->VertexAttrib1fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib1fvARB"));
    d->VertexAttrib1fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat )>(context->getProcAddress("glVertexAttrib1fARB"));
    d->VertexAttrib1dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib1dvARB"));
    d->VertexAttrib1dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble )>(context->getProcAddress("glVertexAttrib1dARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_shader::QOpenGLExtension_ARB_vertex_shader()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_shaderPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_shader::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_shader);

    d->GetAttribLocationARB = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLhandleARB , const GLcharARB *)>(context->getProcAddress("glGetAttribLocationARB"));
    d->GetActiveAttribARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLuint , GLsizei , GLsizei *, GLint *, GLenum *, GLcharARB *)>(context->getProcAddress("glGetActiveAttribARB"));
    d->BindAttribLocationARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhandleARB , GLuint , const GLcharARB *)>(context->getProcAddress("glBindAttribLocationARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_vertex_type_2_10_10_10_revPrivate))
{
}

bool QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_vertex_type_2_10_10_10_rev);

    d->VertexAttribP4uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , const GLuint *)>(context->getProcAddress("glVertexAttribP4uiv"));
    d->VertexAttribP4ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , GLuint )>(context->getProcAddress("glVertexAttribP4ui"));
    d->VertexAttribP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , const GLuint *)>(context->getProcAddress("glVertexAttribP3uiv"));
    d->VertexAttribP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , GLuint )>(context->getProcAddress("glVertexAttribP3ui"));
    d->VertexAttribP2uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , const GLuint *)>(context->getProcAddress("glVertexAttribP2uiv"));
    d->VertexAttribP2ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , GLuint )>(context->getProcAddress("glVertexAttribP2ui"));
    d->VertexAttribP1uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , const GLuint *)>(context->getProcAddress("glVertexAttribP1uiv"));
    d->VertexAttribP1ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean , GLuint )>(context->getProcAddress("glVertexAttribP1ui"));
    d->SecondaryColorP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glSecondaryColorP3uiv"));
    d->SecondaryColorP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glSecondaryColorP3ui"));
    d->ColorP4uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glColorP4uiv"));
    d->ColorP4ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glColorP4ui"));
    d->ColorP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glColorP3uiv"));
    d->ColorP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glColorP3ui"));
    d->NormalP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glNormalP3uiv"));
    d->NormalP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glNormalP3ui"));
    d->MultiTexCoordP4uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLuint *)>(context->getProcAddress("glMultiTexCoordP4uiv"));
    d->MultiTexCoordP4ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glMultiTexCoordP4ui"));
    d->MultiTexCoordP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLuint *)>(context->getProcAddress("glMultiTexCoordP3uiv"));
    d->MultiTexCoordP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glMultiTexCoordP3ui"));
    d->MultiTexCoordP2uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLuint *)>(context->getProcAddress("glMultiTexCoordP2uiv"));
    d->MultiTexCoordP2ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glMultiTexCoordP2ui"));
    d->MultiTexCoordP1uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLuint *)>(context->getProcAddress("glMultiTexCoordP1uiv"));
    d->MultiTexCoordP1ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glMultiTexCoordP1ui"));
    d->TexCoordP4uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glTexCoordP4uiv"));
    d->TexCoordP4ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glTexCoordP4ui"));
    d->TexCoordP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glTexCoordP3uiv"));
    d->TexCoordP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glTexCoordP3ui"));
    d->TexCoordP2uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glTexCoordP2uiv"));
    d->TexCoordP2ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glTexCoordP2ui"));
    d->TexCoordP1uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glTexCoordP1uiv"));
    d->TexCoordP1ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glTexCoordP1ui"));
    d->VertexP4uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glVertexP4uiv"));
    d->VertexP4ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glVertexP4ui"));
    d->VertexP3uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glVertexP3uiv"));
    d->VertexP3ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glVertexP3ui"));
    d->VertexP2uiv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLuint *)>(context->getProcAddress("glVertexP2uiv"));
    d->VertexP2ui = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glVertexP2ui"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_viewport_array::QOpenGLExtension_ARB_viewport_array()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_viewport_arrayPrivate))
{
}

bool QOpenGLExtension_ARB_viewport_array::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_viewport_array);

    d->GetDoublei_v = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble *)>(context->getProcAddress("glGetDoublei_v"));
    d->GetFloati_v = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetFloati_v"));
    d->DepthRangeIndexed = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble )>(context->getProcAddress("glDepthRangeIndexed"));
    d->DepthRangeArrayv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLdouble *)>(context->getProcAddress("glDepthRangeArrayv"));
    d->ScissorIndexedv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glScissorIndexedv"));
    d->ScissorIndexed = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glScissorIndexed"));
    d->ScissorArrayv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLint *)>(context->getProcAddress("glScissorArrayv"));
    d->ViewportIndexedfv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glViewportIndexedfv"));
    d->ViewportIndexedf = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glViewportIndexedf"));
    d->ViewportArrayv = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glViewportArrayv"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ARB_window_pos::QOpenGLExtension_ARB_window_pos()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ARB_window_posPrivate))
{
}

bool QOpenGLExtension_ARB_window_pos::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ARB_window_pos);

    d->WindowPos3svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glWindowPos3svARB"));
    d->WindowPos3sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort , GLshort )>(context->getProcAddress("glWindowPos3sARB"));
    d->WindowPos3ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glWindowPos3ivARB"));
    d->WindowPos3iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint )>(context->getProcAddress("glWindowPos3iARB"));
    d->WindowPos3fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glWindowPos3fvARB"));
    d->WindowPos3fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glWindowPos3fARB"));
    d->WindowPos3dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glWindowPos3dvARB"));
    d->WindowPos3dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glWindowPos3dARB"));
    d->WindowPos2svARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glWindowPos2svARB"));
    d->WindowPos2sARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort )>(context->getProcAddress("glWindowPos2sARB"));
    d->WindowPos2ivARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glWindowPos2ivARB"));
    d->WindowPos2iARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint )>(context->getProcAddress("glWindowPos2iARB"));
    d->WindowPos2fvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glWindowPos2fvARB"));
    d->WindowPos2fARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat )>(context->getProcAddress("glWindowPos2fARB"));
    d->WindowPos2dvARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glWindowPos2dvARB"));
    d->WindowPos2dARB = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble )>(context->getProcAddress("glWindowPos2dARB"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_draw_buffers::QOpenGLExtension_ATI_draw_buffers()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_draw_buffersPrivate))
{
}

bool QOpenGLExtension_ATI_draw_buffers::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_draw_buffers);

    d->DrawBuffersATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLenum *)>(context->getProcAddress("glDrawBuffersATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_element_array::QOpenGLExtension_ATI_element_array()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_element_arrayPrivate))
{
}

bool QOpenGLExtension_ATI_element_array::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_element_array);

    d->DrawRangeElementArrayATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei )>(context->getProcAddress("glDrawRangeElementArrayATI"));
    d->DrawElementArrayATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei )>(context->getProcAddress("glDrawElementArrayATI"));
    d->ElementPointerATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLvoid *)>(context->getProcAddress("glElementPointerATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_envmap_bumpmap::QOpenGLExtension_ATI_envmap_bumpmap()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_envmap_bumpmapPrivate))
{
}

bool QOpenGLExtension_ATI_envmap_bumpmap::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_envmap_bumpmap);

    d->GetTexBumpParameterfvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat *)>(context->getProcAddress("glGetTexBumpParameterfvATI"));
    d->GetTexBumpParameterivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint *)>(context->getProcAddress("glGetTexBumpParameterivATI"));
    d->TexBumpParameterfvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glTexBumpParameterfvATI"));
    d->TexBumpParameterivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glTexBumpParameterivATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_fragment_shader::QOpenGLExtension_ATI_fragment_shader()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_fragment_shaderPrivate))
{
}

bool QOpenGLExtension_ATI_fragment_shader::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_fragment_shader);

    d->SetFragmentShaderConstantATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glSetFragmentShaderConstantATI"));
    d->AlphaFragmentOp3ATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glAlphaFragmentOp3ATI"));
    d->AlphaFragmentOp2ATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glAlphaFragmentOp2ATI"));
    d->AlphaFragmentOp1ATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glAlphaFragmentOp1ATI"));
    d->ColorFragmentOp3ATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glColorFragmentOp3ATI"));
    d->ColorFragmentOp2ATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glColorFragmentOp2ATI"));
    d->ColorFragmentOp1ATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glColorFragmentOp1ATI"));
    d->SampleMapATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum )>(context->getProcAddress("glSampleMapATI"));
    d->PassTexCoordATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum )>(context->getProcAddress("glPassTexCoordATI"));
    d->EndFragmentShaderATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glEndFragmentShaderATI"));
    d->BeginFragmentShaderATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glBeginFragmentShaderATI"));
    d->DeleteFragmentShaderATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glDeleteFragmentShaderATI"));
    d->BindFragmentShaderATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBindFragmentShaderATI"));
    d->GenFragmentShadersATI = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glGenFragmentShadersATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_map_object_buffer::QOpenGLExtension_ATI_map_object_buffer()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_map_object_bufferPrivate))
{
}

bool QOpenGLExtension_ATI_map_object_buffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_map_object_buffer);

    d->UnmapObjectBufferATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glUnmapObjectBufferATI"));
    d->MapObjectBufferATI = reinterpret_cast<GLvoid* (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glMapObjectBufferATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_pn_triangles::QOpenGLExtension_ATI_pn_triangles()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_pn_trianglesPrivate))
{
}

bool QOpenGLExtension_ATI_pn_triangles::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_pn_triangles);

    d->PNTrianglesfATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glPNTrianglesfATI"));
    d->PNTrianglesiATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glPNTrianglesiATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_separate_stencil::QOpenGLExtension_ATI_separate_stencil()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_separate_stencilPrivate))
{
}

bool QOpenGLExtension_ATI_separate_stencil::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_separate_stencil);

    d->StencilFuncSeparateATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLuint )>(context->getProcAddress("glStencilFuncSeparateATI"));
    d->StencilOpSeparateATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glStencilOpSeparateATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_vertex_array_object::QOpenGLExtension_ATI_vertex_array_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_vertex_array_objectPrivate))
{
}

bool QOpenGLExtension_ATI_vertex_array_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_vertex_array_object);

    d->GetVariantArrayObjectivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVariantArrayObjectivATI"));
    d->GetVariantArrayObjectfvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetVariantArrayObjectfvATI"));
    d->VariantArrayObjectATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLuint , GLuint )>(context->getProcAddress("glVariantArrayObjectATI"));
    d->GetArrayObjectivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetArrayObjectivATI"));
    d->GetArrayObjectfvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetArrayObjectfvATI"));
    d->ArrayObjectATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , GLuint , GLuint )>(context->getProcAddress("glArrayObjectATI"));
    d->FreeObjectBufferATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glFreeObjectBufferATI"));
    d->GetObjectBufferivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetObjectBufferivATI"));
    d->GetObjectBufferfvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetObjectBufferfvATI"));
    d->UpdateObjectBufferATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLsizei , const GLvoid *, GLenum )>(context->getProcAddress("glUpdateObjectBufferATI"));
    d->IsObjectBufferATI = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsObjectBufferATI"));
    d->NewObjectBufferATI = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLsizei , const GLvoid *, GLenum )>(context->getProcAddress("glNewObjectBufferATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_vertex_attrib_array_object::QOpenGLExtension_ATI_vertex_attrib_array_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_vertex_attrib_array_objectPrivate))
{
}

bool QOpenGLExtension_ATI_vertex_attrib_array_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_vertex_attrib_array_object);

    d->GetVertexAttribArrayObjectivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVertexAttribArrayObjectivATI"));
    d->GetVertexAttribArrayObjectfvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetVertexAttribArrayObjectfvATI"));
    d->VertexAttribArrayObjectATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLboolean , GLsizei , GLuint , GLuint )>(context->getProcAddress("glVertexAttribArrayObjectATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_ATI_vertex_streams::QOpenGLExtension_ATI_vertex_streams()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_ATI_vertex_streamsPrivate))
{
}

bool QOpenGLExtension_ATI_vertex_streams::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ATI_vertex_streams);

    d->VertexBlendEnvfATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glVertexBlendEnvfATI"));
    d->VertexBlendEnviATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glVertexBlendEnviATI"));
    d->ClientActiveVertexStreamATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glClientActiveVertexStreamATI"));
    d->NormalStream3dvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glNormalStream3dvATI"));
    d->NormalStream3dATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glNormalStream3dATI"));
    d->NormalStream3fvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glNormalStream3fvATI"));
    d->NormalStream3fATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glNormalStream3fATI"));
    d->NormalStream3ivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glNormalStream3ivATI"));
    d->NormalStream3iATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint )>(context->getProcAddress("glNormalStream3iATI"));
    d->NormalStream3svATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glNormalStream3svATI"));
    d->NormalStream3sATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort , GLshort )>(context->getProcAddress("glNormalStream3sATI"));
    d->NormalStream3bvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLbyte *)>(context->getProcAddress("glNormalStream3bvATI"));
    d->NormalStream3bATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLbyte , GLbyte , GLbyte )>(context->getProcAddress("glNormalStream3bATI"));
    d->VertexStream4dvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glVertexStream4dvATI"));
    d->VertexStream4dATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexStream4dATI"));
    d->VertexStream4fvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glVertexStream4fvATI"));
    d->VertexStream4fATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glVertexStream4fATI"));
    d->VertexStream4ivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glVertexStream4ivATI"));
    d->VertexStream4iATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint )>(context->getProcAddress("glVertexStream4iATI"));
    d->VertexStream4svATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glVertexStream4svATI"));
    d->VertexStream4sATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort , GLshort , GLshort )>(context->getProcAddress("glVertexStream4sATI"));
    d->VertexStream3dvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glVertexStream3dvATI"));
    d->VertexStream3dATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexStream3dATI"));
    d->VertexStream3fvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glVertexStream3fvATI"));
    d->VertexStream3fATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glVertexStream3fATI"));
    d->VertexStream3ivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glVertexStream3ivATI"));
    d->VertexStream3iATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint )>(context->getProcAddress("glVertexStream3iATI"));
    d->VertexStream3svATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glVertexStream3svATI"));
    d->VertexStream3sATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort , GLshort )>(context->getProcAddress("glVertexStream3sATI"));
    d->VertexStream2dvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glVertexStream2dvATI"));
    d->VertexStream2dATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble )>(context->getProcAddress("glVertexStream2dATI"));
    d->VertexStream2fvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glVertexStream2fvATI"));
    d->VertexStream2fATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat )>(context->getProcAddress("glVertexStream2fATI"));
    d->VertexStream2ivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glVertexStream2ivATI"));
    d->VertexStream2iATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint )>(context->getProcAddress("glVertexStream2iATI"));
    d->VertexStream2svATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glVertexStream2svATI"));
    d->VertexStream2sATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort , GLshort )>(context->getProcAddress("glVertexStream2sATI"));
    d->VertexStream1dvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glVertexStream1dvATI"));
    d->VertexStream1dATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble )>(context->getProcAddress("glVertexStream1dATI"));
    d->VertexStream1fvATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glVertexStream1fvATI"));
    d->VertexStream1fATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glVertexStream1fATI"));
    d->VertexStream1ivATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glVertexStream1ivATI"));
    d->VertexStream1iATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glVertexStream1iATI"));
    d->VertexStream1svATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLshort *)>(context->getProcAddress("glVertexStream1svATI"));
    d->VertexStream1sATI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLshort )>(context->getProcAddress("glVertexStream1sATI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_bindable_uniform::QOpenGLExtension_EXT_bindable_uniform()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_bindable_uniformPrivate))
{
}

bool QOpenGLExtension_EXT_bindable_uniform::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_bindable_uniform);

    d->GetUniformOffsetEXT = reinterpret_cast<GLintptr (QOPENGLF_APIENTRYP)(GLuint , GLint )>(context->getProcAddress("glGetUniformOffsetEXT"));
    d->GetUniformBufferSizeEXT = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , GLint )>(context->getProcAddress("glGetUniformBufferSizeEXT"));
    d->UniformBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint )>(context->getProcAddress("glUniformBufferEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_blend_color::QOpenGLExtension_EXT_blend_color()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_blend_colorPrivate))
{
}

bool QOpenGLExtension_EXT_blend_color::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_blend_color);

    d->BlendColorEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glBlendColorEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_blend_equation_separate::QOpenGLExtension_EXT_blend_equation_separate()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_blend_equation_separatePrivate))
{
}

bool QOpenGLExtension_EXT_blend_equation_separate::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_blend_equation_separate);

    d->BlendEquationSeparateEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glBlendEquationSeparateEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_blend_func_separate::QOpenGLExtension_EXT_blend_func_separate()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_blend_func_separatePrivate))
{
}

bool QOpenGLExtension_EXT_blend_func_separate::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_blend_func_separate);

    d->BlendFuncSeparateEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glBlendFuncSeparateEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_blend_minmax::QOpenGLExtension_EXT_blend_minmax()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_blend_minmaxPrivate))
{
}

bool QOpenGLExtension_EXT_blend_minmax::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_blend_minmax);

    d->BlendEquationEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glBlendEquationEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_color_subtable::QOpenGLExtension_EXT_color_subtable()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_color_subtablePrivate))
{
}

bool QOpenGLExtension_EXT_color_subtable::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_color_subtable);

    d->CopyColorSubTableEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLint , GLint , GLsizei )>(context->getProcAddress("glCopyColorSubTableEXT"));
    d->ColorSubTableEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glColorSubTableEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_compiled_vertex_array::QOpenGLExtension_EXT_compiled_vertex_array()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_compiled_vertex_arrayPrivate))
{
}

bool QOpenGLExtension_EXT_compiled_vertex_array::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_compiled_vertex_array);

    d->UnlockArraysEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glUnlockArraysEXT"));
    d->LockArraysEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei )>(context->getProcAddress("glLockArraysEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_convolution::QOpenGLExtension_EXT_convolution()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_convolutionPrivate))
{
}

bool QOpenGLExtension_EXT_convolution::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_convolution);

    d->SeparableFilter2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *, const GLvoid *)>(context->getProcAddress("glSeparableFilter2DEXT"));
    d->GetSeparableFilterEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLvoid *, GLvoid *, GLvoid *)>(context->getProcAddress("glGetSeparableFilterEXT"));
    d->GetConvolutionParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetConvolutionParameterivEXT"));
    d->GetConvolutionParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetConvolutionParameterfvEXT"));
    d->GetConvolutionFilterEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetConvolutionFilterEXT"));
    d->CopyConvolutionFilter2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyConvolutionFilter2DEXT"));
    d->CopyConvolutionFilter1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLsizei )>(context->getProcAddress("glCopyConvolutionFilter1DEXT"));
    d->ConvolutionParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glConvolutionParameterivEXT"));
    d->ConvolutionParameteriEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glConvolutionParameteriEXT"));
    d->ConvolutionParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glConvolutionParameterfvEXT"));
    d->ConvolutionParameterfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat )>(context->getProcAddress("glConvolutionParameterfEXT"));
    d->ConvolutionFilter2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glConvolutionFilter2DEXT"));
    d->ConvolutionFilter1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glConvolutionFilter1DEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_coordinate_frame::QOpenGLExtension_EXT_coordinate_frame()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_coordinate_framePrivate))
{
}

bool QOpenGLExtension_EXT_coordinate_frame::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_coordinate_frame);

    d->BinormalPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glBinormalPointerEXT"));
    d->TangentPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glTangentPointerEXT"));
    d->Binormal3svEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glBinormal3svEXT"));
    d->Binormal3sEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort , GLshort )>(context->getProcAddress("glBinormal3sEXT"));
    d->Binormal3ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glBinormal3ivEXT"));
    d->Binormal3iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint )>(context->getProcAddress("glBinormal3iEXT"));
    d->Binormal3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glBinormal3fvEXT"));
    d->Binormal3fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glBinormal3fEXT"));
    d->Binormal3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glBinormal3dvEXT"));
    d->Binormal3dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glBinormal3dEXT"));
    d->Binormal3bvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLbyte *)>(context->getProcAddress("glBinormal3bvEXT"));
    d->Binormal3bEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbyte , GLbyte , GLbyte )>(context->getProcAddress("glBinormal3bEXT"));
    d->Tangent3svEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glTangent3svEXT"));
    d->Tangent3sEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort , GLshort )>(context->getProcAddress("glTangent3sEXT"));
    d->Tangent3ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glTangent3ivEXT"));
    d->Tangent3iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint )>(context->getProcAddress("glTangent3iEXT"));
    d->Tangent3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glTangent3fvEXT"));
    d->Tangent3fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTangent3fEXT"));
    d->Tangent3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glTangent3dvEXT"));
    d->Tangent3dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glTangent3dEXT"));
    d->Tangent3bvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLbyte *)>(context->getProcAddress("glTangent3bvEXT"));
    d->Tangent3bEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbyte , GLbyte , GLbyte )>(context->getProcAddress("glTangent3bEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_copy_texture::QOpenGLExtension_EXT_copy_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_copy_texturePrivate))
{
}

bool QOpenGLExtension_EXT_copy_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_copy_texture);

    d->CopyTexSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyTexSubImage3DEXT"));
    d->CopyTexSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyTexSubImage2DEXT"));
    d->CopyTexSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint , GLsizei )>(context->getProcAddress("glCopyTexSubImage1DEXT"));
    d->CopyTexImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint )>(context->getProcAddress("glCopyTexImage2DEXT"));
    d->CopyTexImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint )>(context->getProcAddress("glCopyTexImage1DEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_cull_vertex::QOpenGLExtension_EXT_cull_vertex()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_cull_vertexPrivate))
{
}

bool QOpenGLExtension_EXT_cull_vertex::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_cull_vertex);

    d->CullParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat *)>(context->getProcAddress("glCullParameterfvEXT"));
    d->CullParameterdvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble *)>(context->getProcAddress("glCullParameterdvEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_depth_bounds_test::QOpenGLExtension_EXT_depth_bounds_test()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_depth_bounds_testPrivate))
{
}

bool QOpenGLExtension_EXT_depth_bounds_test::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_depth_bounds_test);

    d->DepthBoundsEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLclampd , GLclampd )>(context->getProcAddress("glDepthBoundsEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_direct_state_access::QOpenGLExtension_EXT_direct_state_access()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_direct_state_accessPrivate))
{
}

bool QOpenGLExtension_EXT_direct_state_access::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_direct_state_access);

    d->ProgramUniformMatrix4x3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix4x3dvEXT"));
    d->ProgramUniformMatrix4x2dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix4x2dvEXT"));
    d->ProgramUniformMatrix3x4dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix3x4dvEXT"));
    d->ProgramUniformMatrix3x2dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix3x2dvEXT"));
    d->ProgramUniformMatrix2x4dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix2x4dvEXT"));
    d->ProgramUniformMatrix2x3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix2x3dvEXT"));
    d->ProgramUniformMatrix4dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix4dvEXT"));
    d->ProgramUniformMatrix3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix3dvEXT"));
    d->ProgramUniformMatrix2dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLdouble *)>(context->getProcAddress("glProgramUniformMatrix2dvEXT"));
    d->ProgramUniform4dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform4dvEXT"));
    d->ProgramUniform3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform3dvEXT"));
    d->ProgramUniform2dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform2dvEXT"));
    d->ProgramUniform1dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramUniform1dvEXT"));
    d->ProgramUniform4dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramUniform4dEXT"));
    d->ProgramUniform3dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramUniform3dEXT"));
    d->ProgramUniform2dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble , GLdouble )>(context->getProcAddress("glProgramUniform2dEXT"));
    d->ProgramUniform1dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLdouble )>(context->getProcAddress("glProgramUniform1dEXT"));
    d->MultiTexRenderbufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glMultiTexRenderbufferEXT"));
    d->TextureRenderbufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint )>(context->getProcAddress("glTextureRenderbufferEXT"));
    d->NamedFramebufferTextureFaceEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLint , GLenum )>(context->getProcAddress("glNamedFramebufferTextureFaceEXT"));
    d->NamedFramebufferTextureLayerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glNamedFramebufferTextureLayerEXT"));
    d->NamedFramebufferTextureEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLint )>(context->getProcAddress("glNamedFramebufferTextureEXT"));
    d->NamedRenderbufferStorageMultisampleCoverageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glNamedRenderbufferStorageMultisampleCoverageEXT"));
    d->NamedRenderbufferStorageMultisampleEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glNamedRenderbufferStorageMultisampleEXT"));
    d->GetFramebufferParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetFramebufferParameterivEXT"));
    d->FramebufferReadBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glFramebufferReadBufferEXT"));
    d->FramebufferDrawBuffersEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLenum *)>(context->getProcAddress("glFramebufferDrawBuffersEXT"));
    d->FramebufferDrawBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glFramebufferDrawBufferEXT"));
    d->GenerateMultiTexMipmapEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glGenerateMultiTexMipmapEXT"));
    d->GenerateTextureMipmapEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glGenerateTextureMipmapEXT"));
    d->GetNamedFramebufferAttachmentParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetNamedFramebufferAttachmentParameterivEXT"));
    d->NamedFramebufferRenderbufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint )>(context->getProcAddress("glNamedFramebufferRenderbufferEXT"));
    d->NamedFramebufferTexture3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glNamedFramebufferTexture3DEXT"));
    d->NamedFramebufferTexture2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glNamedFramebufferTexture2DEXT"));
    d->NamedFramebufferTexture1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glNamedFramebufferTexture1DEXT"));
    d->CheckNamedFramebufferStatusEXT = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glCheckNamedFramebufferStatusEXT"));
    d->GetNamedRenderbufferParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetNamedRenderbufferParameterivEXT"));
    d->NamedRenderbufferStorageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glNamedRenderbufferStorageEXT"));
    d->MultiTexBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint )>(context->getProcAddress("glMultiTexBufferEXT"));
    d->TextureBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint )>(context->getProcAddress("glTextureBufferEXT"));
    d->GetNamedBufferSubDataEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLintptr , GLsizeiptr , GLvoid *)>(context->getProcAddress("glGetNamedBufferSubDataEXT"));
    d->GetNamedBufferPointervEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLvoid* *)>(context->getProcAddress("glGetNamedBufferPointervEXT"));
    d->GetNamedBufferParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetNamedBufferParameterivEXT"));
    d->NamedCopyBufferSubDataEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLintptr , GLintptr , GLsizeiptr )>(context->getProcAddress("glNamedCopyBufferSubDataEXT"));
    d->FlushMappedNamedBufferRangeEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLintptr , GLsizeiptr )>(context->getProcAddress("glFlushMappedNamedBufferRangeEXT"));
    d->MapNamedBufferRangeEXT = reinterpret_cast<GLvoid* (QOPENGLF_APIENTRYP)(GLuint , GLintptr , GLsizeiptr , GLbitfield )>(context->getProcAddress("glMapNamedBufferRangeEXT"));
    d->UnmapNamedBufferEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glUnmapNamedBufferEXT"));
    d->MapNamedBufferEXT = reinterpret_cast<GLvoid* (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glMapNamedBufferEXT"));
    d->NamedBufferSubDataEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLintptr , GLsizeiptr , const GLvoid *)>(context->getProcAddress("glNamedBufferSubDataEXT"));
    d->NamedBufferDataEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizeiptr , const GLvoid *, GLenum )>(context->getProcAddress("glNamedBufferDataEXT"));
    d->ProgramUniform4uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform4uivEXT"));
    d->ProgramUniform3uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform3uivEXT"));
    d->ProgramUniform2uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform2uivEXT"));
    d->ProgramUniform1uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramUniform1uivEXT"));
    d->ProgramUniform4uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glProgramUniform4uiEXT"));
    d->ProgramUniform3uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint , GLuint , GLuint )>(context->getProcAddress("glProgramUniform3uiEXT"));
    d->ProgramUniform2uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint , GLuint )>(context->getProcAddress("glProgramUniform2uiEXT"));
    d->ProgramUniform1uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint )>(context->getProcAddress("glProgramUniform1uiEXT"));
    d->ProgramUniformMatrix4x3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix4x3fvEXT"));
    d->ProgramUniformMatrix3x4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix3x4fvEXT"));
    d->ProgramUniformMatrix4x2fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix4x2fvEXT"));
    d->ProgramUniformMatrix2x4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix2x4fvEXT"));
    d->ProgramUniformMatrix3x2fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix3x2fvEXT"));
    d->ProgramUniformMatrix2x3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix2x3fvEXT"));
    d->ProgramUniformMatrix4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix4fvEXT"));
    d->ProgramUniformMatrix3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix3fvEXT"));
    d->ProgramUniformMatrix2fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , GLboolean , const GLfloat *)>(context->getProcAddress("glProgramUniformMatrix2fvEXT"));
    d->ProgramUniform4ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform4ivEXT"));
    d->ProgramUniform3ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform3ivEXT"));
    d->ProgramUniform2ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform2ivEXT"));
    d->ProgramUniform1ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint *)>(context->getProcAddress("glProgramUniform1ivEXT"));
    d->ProgramUniform4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform4fvEXT"));
    d->ProgramUniform3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform3fvEXT"));
    d->ProgramUniform2fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform2fvEXT"));
    d->ProgramUniform1fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramUniform1fvEXT"));
    d->ProgramUniform4iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glProgramUniform4iEXT"));
    d->ProgramUniform3iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glProgramUniform3iEXT"));
    d->ProgramUniform2iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint )>(context->getProcAddress("glProgramUniform2iEXT"));
    d->ProgramUniform1iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint )>(context->getProcAddress("glProgramUniform1iEXT"));
    d->ProgramUniform4fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramUniform4fEXT"));
    d->ProgramUniform3fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramUniform3fEXT"));
    d->ProgramUniform2fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat , GLfloat )>(context->getProcAddress("glProgramUniform2fEXT"));
    d->ProgramUniform1fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLfloat )>(context->getProcAddress("glProgramUniform1fEXT"));
    d->GetMultiTexParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint *)>(context->getProcAddress("glGetMultiTexParameterIuivEXT"));
    d->GetMultiTexParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetMultiTexParameterIivEXT"));
    d->MultiTexParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLuint *)>(context->getProcAddress("glMultiTexParameterIuivEXT"));
    d->MultiTexParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLint *)>(context->getProcAddress("glMultiTexParameterIivEXT"));
    d->GetTextureParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint *)>(context->getProcAddress("glGetTextureParameterIuivEXT"));
    d->GetTextureParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetTextureParameterIivEXT"));
    d->TextureParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , const GLuint *)>(context->getProcAddress("glTextureParameterIuivEXT"));
    d->TextureParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , const GLint *)>(context->getProcAddress("glTextureParameterIivEXT"));
    d->GetNamedProgramLocalParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLuint *)>(context->getProcAddress("glGetNamedProgramLocalParameterIuivEXT"));
    d->GetNamedProgramLocalParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLint *)>(context->getProcAddress("glGetNamedProgramLocalParameterIivEXT"));
    d->NamedProgramLocalParametersI4uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , const GLuint *)>(context->getProcAddress("glNamedProgramLocalParametersI4uivEXT"));
    d->NamedProgramLocalParameterI4uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , const GLuint *)>(context->getProcAddress("glNamedProgramLocalParameterI4uivEXT"));
    d->NamedProgramLocalParameterI4uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glNamedProgramLocalParameterI4uiEXT"));
    d->NamedProgramLocalParametersI4ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , const GLint *)>(context->getProcAddress("glNamedProgramLocalParametersI4ivEXT"));
    d->NamedProgramLocalParameterI4ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , const GLint *)>(context->getProcAddress("glNamedProgramLocalParameterI4ivEXT"));
    d->NamedProgramLocalParameterI4iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glNamedProgramLocalParameterI4iEXT"));
    d->NamedProgramLocalParameters4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glNamedProgramLocalParameters4fvEXT"));
    d->GetNamedProgramStringEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetNamedProgramStringEXT"));
    d->GetNamedProgramivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetNamedProgramivEXT"));
    d->GetNamedProgramLocalParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetNamedProgramLocalParameterfvEXT"));
    d->GetNamedProgramLocalParameterdvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLdouble *)>(context->getProcAddress("glGetNamedProgramLocalParameterdvEXT"));
    d->NamedProgramLocalParameter4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , const GLfloat *)>(context->getProcAddress("glNamedProgramLocalParameter4fvEXT"));
    d->NamedProgramLocalParameter4fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glNamedProgramLocalParameter4fEXT"));
    d->NamedProgramLocalParameter4dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , const GLdouble *)>(context->getProcAddress("glNamedProgramLocalParameter4dvEXT"));
    d->NamedProgramLocalParameter4dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glNamedProgramLocalParameter4dEXT"));
    d->NamedProgramStringEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glNamedProgramStringEXT"));
    d->GetCompressedMultiTexImageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLvoid *)>(context->getProcAddress("glGetCompressedMultiTexImageEXT"));
    d->CompressedMultiTexSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedMultiTexSubImage1DEXT"));
    d->CompressedMultiTexSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedMultiTexSubImage2DEXT"));
    d->CompressedMultiTexSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedMultiTexSubImage3DEXT"));
    d->CompressedMultiTexImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedMultiTexImage1DEXT"));
    d->CompressedMultiTexImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedMultiTexImage2DEXT"));
    d->CompressedMultiTexImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedMultiTexImage3DEXT"));
    d->GetCompressedTextureImageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLvoid *)>(context->getProcAddress("glGetCompressedTextureImageEXT"));
    d->CompressedTextureSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTextureSubImage1DEXT"));
    d->CompressedTextureSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTextureSubImage2DEXT"));
    d->CompressedTextureSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTextureSubImage3DEXT"));
    d->CompressedTextureImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTextureImage1DEXT"));
    d->CompressedTextureImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTextureImage2DEXT"));
    d->CompressedTextureImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLsizei , const GLvoid *)>(context->getProcAddress("glCompressedTextureImage3DEXT"));
    d->GetPointerIndexedvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLvoid* *)>(context->getProcAddress("glGetPointerIndexedvEXT"));
    d->GetDoubleIndexedvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble *)>(context->getProcAddress("glGetDoubleIndexedvEXT"));
    d->GetFloatIndexedvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetFloatIndexedvEXT"));
    d->GetMultiTexGenivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetMultiTexGenivEXT"));
    d->GetMultiTexGenfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetMultiTexGenfvEXT"));
    d->GetMultiTexGendvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLdouble *)>(context->getProcAddress("glGetMultiTexGendvEXT"));
    d->GetMultiTexEnvivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetMultiTexEnvivEXT"));
    d->GetMultiTexEnvfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetMultiTexEnvfvEXT"));
    d->MultiTexGenivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLint *)>(context->getProcAddress("glMultiTexGenivEXT"));
    d->MultiTexGeniEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint )>(context->getProcAddress("glMultiTexGeniEXT"));
    d->MultiTexGenfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexGenfvEXT"));
    d->MultiTexGenfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat )>(context->getProcAddress("glMultiTexGenfEXT"));
    d->MultiTexGendvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLdouble *)>(context->getProcAddress("glMultiTexGendvEXT"));
    d->MultiTexGendEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLdouble )>(context->getProcAddress("glMultiTexGendEXT"));
    d->MultiTexEnvivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLint *)>(context->getProcAddress("glMultiTexEnvivEXT"));
    d->MultiTexEnviEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint )>(context->getProcAddress("glMultiTexEnviEXT"));
    d->MultiTexEnvfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexEnvfvEXT"));
    d->MultiTexEnvfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat )>(context->getProcAddress("glMultiTexEnvfEXT"));
    d->MultiTexCoordPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glMultiTexCoordPointerEXT"));
    d->DisableClientStateIndexedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glDisableClientStateIndexedEXT"));
    d->EnableClientStateIndexedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glEnableClientStateIndexedEXT"));
    d->BindMultiTextureEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glBindMultiTextureEXT"));
    d->CopyMultiTexSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyMultiTexSubImage3DEXT"));
    d->MultiTexSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glMultiTexSubImage3DEXT"));
    d->MultiTexImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glMultiTexImage3DEXT"));
    d->GetMultiTexLevelParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLint *)>(context->getProcAddress("glGetMultiTexLevelParameterivEXT"));
    d->GetMultiTexLevelParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLfloat *)>(context->getProcAddress("glGetMultiTexLevelParameterfvEXT"));
    d->GetMultiTexParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetMultiTexParameterivEXT"));
    d->GetMultiTexParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetMultiTexParameterfvEXT"));
    d->GetMultiTexImageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetMultiTexImageEXT"));
    d->CopyMultiTexSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyMultiTexSubImage2DEXT"));
    d->CopyMultiTexSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLint , GLsizei )>(context->getProcAddress("glCopyMultiTexSubImage1DEXT"));
    d->CopyMultiTexImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint )>(context->getProcAddress("glCopyMultiTexImage2DEXT"));
    d->CopyMultiTexImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint )>(context->getProcAddress("glCopyMultiTexImage1DEXT"));
    d->MultiTexSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glMultiTexSubImage2DEXT"));
    d->MultiTexSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glMultiTexSubImage1DEXT"));
    d->MultiTexImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glMultiTexImage2DEXT"));
    d->MultiTexImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLenum , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glMultiTexImage1DEXT"));
    d->MultiTexParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLint *)>(context->getProcAddress("glMultiTexParameterivEXT"));
    d->MultiTexParameteriEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint )>(context->getProcAddress("glMultiTexParameteriEXT"));
    d->MultiTexParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glMultiTexParameterfvEXT"));
    d->MultiTexParameterfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat )>(context->getProcAddress("glMultiTexParameterfEXT"));
    d->CopyTextureSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyTextureSubImage3DEXT"));
    d->TextureSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTextureSubImage3DEXT"));
    d->TextureImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTextureImage3DEXT"));
    d->GetTextureLevelParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLint *)>(context->getProcAddress("glGetTextureLevelParameterivEXT"));
    d->GetTextureLevelParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLfloat *)>(context->getProcAddress("glGetTextureLevelParameterfvEXT"));
    d->GetTextureParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetTextureParameterivEXT"));
    d->GetTextureParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetTextureParameterfvEXT"));
    d->GetTextureImageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetTextureImageEXT"));
    d->CopyTextureSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei )>(context->getProcAddress("glCopyTextureSubImage2DEXT"));
    d->CopyTextureSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLsizei )>(context->getProcAddress("glCopyTextureSubImage1DEXT"));
    d->CopyTextureImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLsizei , GLint )>(context->getProcAddress("glCopyTextureImage2DEXT"));
    d->CopyTextureImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLint , GLint , GLsizei , GLint )>(context->getProcAddress("glCopyTextureImage1DEXT"));
    d->TextureSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTextureSubImage2DEXT"));
    d->TextureSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTextureSubImage1DEXT"));
    d->TextureImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTextureImage2DEXT"));
    d->TextureImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLenum , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTextureImage1DEXT"));
    d->TextureParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , const GLint *)>(context->getProcAddress("glTextureParameterivEXT"));
    d->TextureParameteriEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLint )>(context->getProcAddress("glTextureParameteriEXT"));
    d->TextureParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glTextureParameterfvEXT"));
    d->TextureParameterfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLfloat )>(context->getProcAddress("glTextureParameterfEXT"));
    d->MatrixMultTransposedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMatrixMultTransposedEXT"));
    d->MatrixMultTransposefEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMatrixMultTransposefEXT"));
    d->MatrixLoadTransposedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMatrixLoadTransposedEXT"));
    d->MatrixLoadTransposefEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMatrixLoadTransposefEXT"));
    d->MatrixPushEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glMatrixPushEXT"));
    d->MatrixPopEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glMatrixPopEXT"));
    d->MatrixOrthoEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMatrixOrthoEXT"));
    d->MatrixFrustumEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMatrixFrustumEXT"));
    d->MatrixTranslatedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMatrixTranslatedEXT"));
    d->MatrixTranslatefEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glMatrixTranslatefEXT"));
    d->MatrixScaledEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMatrixScaledEXT"));
    d->MatrixScalefEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glMatrixScalefEXT"));
    d->MatrixRotatedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glMatrixRotatedEXT"));
    d->MatrixRotatefEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glMatrixRotatefEXT"));
    d->MatrixLoadIdentityEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glMatrixLoadIdentityEXT"));
    d->MatrixMultdEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMatrixMultdEXT"));
    d->MatrixMultfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMatrixMultfEXT"));
    d->MatrixLoaddEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLdouble *)>(context->getProcAddress("glMatrixLoaddEXT"));
    d->MatrixLoadfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glMatrixLoadfEXT"));
    d->PushClientAttribDefaultEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield )>(context->getProcAddress("glPushClientAttribDefaultEXT"));
    d->ClientAttribDefaultEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield )>(context->getProcAddress("glClientAttribDefaultEXT"));
    d->TextureStorage3DMultisampleEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLenum , GLsizei , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTextureStorage3DMultisampleEXT"));
    d->TextureStorage2DMultisampleEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLenum , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTextureStorage2DMultisampleEXT"));
    d->TextureBufferRangeEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLuint , GLintptr , GLsizeiptr )>(context->getProcAddress("glTextureBufferRangeEXT"));
    d->GetNamedFramebufferParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetNamedFramebufferParameterivEXT"));
    d->NamedFramebufferParameteriEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glNamedFramebufferParameteriEXT"));
    d->VertexArrayVertexBindingDivisorEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glVertexArrayVertexBindingDivisorEXT"));
    d->VertexArrayVertexAttribBindingEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glVertexArrayVertexAttribBindingEXT"));
    d->VertexArrayVertexAttribLFormatEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLint , GLenum , GLuint )>(context->getProcAddress("glVertexArrayVertexAttribLFormatEXT"));
    d->VertexArrayVertexAttribIFormatEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLint , GLenum , GLuint )>(context->getProcAddress("glVertexArrayVertexAttribIFormatEXT"));
    d->VertexArrayVertexAttribFormatEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLint , GLenum , GLboolean , GLuint )>(context->getProcAddress("glVertexArrayVertexAttribFormatEXT"));
    d->VertexArrayBindVertexBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , GLintptr , GLsizei )>(context->getProcAddress("glVertexArrayBindVertexBufferEXT"));
    d->ClearNamedBufferSubDataEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizeiptr , GLsizeiptr , GLenum , GLenum , const void *)>(context->getProcAddress("glClearNamedBufferSubDataEXT"));
    d->ClearNamedBufferDataEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLenum , GLenum , const void *)>(context->getProcAddress("glClearNamedBufferDataEXT"));
    d->TextureStorage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLenum , GLsizei , GLsizei , GLsizei )>(context->getProcAddress("glTextureStorage3DEXT"));
    d->TextureStorage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glTextureStorage2DEXT"));
    d->TextureStorage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLenum , GLsizei )>(context->getProcAddress("glTextureStorage1DEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_draw_buffers2::QOpenGLExtension_EXT_draw_buffers2()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_draw_buffers2Private))
{
}

bool QOpenGLExtension_EXT_draw_buffers2::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_draw_buffers2);

    d->IsEnabledIndexedEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glIsEnabledIndexedEXT"));
    d->DisableIndexedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glDisableIndexedEXT"));
    d->EnableIndexedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glEnableIndexedEXT"));
    d->GetIntegerIndexedvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLint *)>(context->getProcAddress("glGetIntegerIndexedvEXT"));
    d->GetBooleanIndexedvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLboolean *)>(context->getProcAddress("glGetBooleanIndexedvEXT"));
    d->ColorMaskIndexedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLboolean , GLboolean , GLboolean , GLboolean )>(context->getProcAddress("glColorMaskIndexedEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_draw_instanced::QOpenGLExtension_EXT_draw_instanced()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_draw_instancedPrivate))
{
}

bool QOpenGLExtension_EXT_draw_instanced::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_draw_instanced);

    d->DrawElementsInstancedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const GLvoid *, GLsizei )>(context->getProcAddress("glDrawElementsInstancedEXT"));
    d->DrawArraysInstancedEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei , GLsizei )>(context->getProcAddress("glDrawArraysInstancedEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_draw_range_elements::QOpenGLExtension_EXT_draw_range_elements()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_draw_range_elementsPrivate))
{
}

bool QOpenGLExtension_EXT_draw_range_elements::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_draw_range_elements);

    d->DrawRangeElementsEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei , GLenum , const GLvoid *)>(context->getProcAddress("glDrawRangeElementsEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_fog_coord::QOpenGLExtension_EXT_fog_coord()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_fog_coordPrivate))
{
}

bool QOpenGLExtension_EXT_fog_coord::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_fog_coord);

    d->FogCoordPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glFogCoordPointerEXT"));
    d->FogCoorddvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glFogCoorddvEXT"));
    d->FogCoorddEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble )>(context->getProcAddress("glFogCoorddEXT"));
    d->FogCoordfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glFogCoordfvEXT"));
    d->FogCoordfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat )>(context->getProcAddress("glFogCoordfEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_framebuffer_blit::QOpenGLExtension_EXT_framebuffer_blit()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_framebuffer_blitPrivate))
{
}

bool QOpenGLExtension_EXT_framebuffer_blit::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_framebuffer_blit);

    d->BlitFramebufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint , GLint , GLint , GLint , GLint , GLint , GLbitfield , GLenum )>(context->getProcAddress("glBlitFramebufferEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_framebuffer_multisample::QOpenGLExtension_EXT_framebuffer_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_framebuffer_multisamplePrivate))
{
}

bool QOpenGLExtension_EXT_framebuffer_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_framebuffer_multisample);

    d->RenderbufferStorageMultisampleEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glRenderbufferStorageMultisampleEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_framebuffer_object::QOpenGLExtension_EXT_framebuffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_framebuffer_objectPrivate))
{
}

bool QOpenGLExtension_EXT_framebuffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_framebuffer_object);

    d->GenerateMipmapEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glGenerateMipmapEXT"));
    d->GetFramebufferAttachmentParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetFramebufferAttachmentParameterivEXT"));
    d->FramebufferRenderbufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint )>(context->getProcAddress("glFramebufferRenderbufferEXT"));
    d->FramebufferTexture3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glFramebufferTexture3DEXT"));
    d->FramebufferTexture2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glFramebufferTexture2DEXT"));
    d->FramebufferTexture1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glFramebufferTexture1DEXT"));
    d->CheckFramebufferStatusEXT = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glCheckFramebufferStatusEXT"));
    d->GenFramebuffersEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenFramebuffersEXT"));
    d->DeleteFramebuffersEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteFramebuffersEXT"));
    d->BindFramebufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindFramebufferEXT"));
    d->IsFramebufferEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsFramebufferEXT"));
    d->GetRenderbufferParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetRenderbufferParameterivEXT"));
    d->RenderbufferStorageEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glRenderbufferStorageEXT"));
    d->GenRenderbuffersEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenRenderbuffersEXT"));
    d->DeleteRenderbuffersEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteRenderbuffersEXT"));
    d->BindRenderbufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindRenderbufferEXT"));
    d->IsRenderbufferEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsRenderbufferEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_geometry_shader4::QOpenGLExtension_EXT_geometry_shader4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_geometry_shader4Private))
{
}

bool QOpenGLExtension_EXT_geometry_shader4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_geometry_shader4);

    d->ProgramParameteriEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glProgramParameteriEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_gpu_program_parameters::QOpenGLExtension_EXT_gpu_program_parameters()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_gpu_program_parametersPrivate))
{
}

bool QOpenGLExtension_EXT_gpu_program_parameters::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_gpu_program_parameters);

    d->ProgramLocalParameters4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramLocalParameters4fvEXT"));
    d->ProgramEnvParameters4fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramEnvParameters4fvEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_gpu_shader4::QOpenGLExtension_EXT_gpu_shader4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_gpu_shader4Private))
{
}

bool QOpenGLExtension_EXT_gpu_shader4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_gpu_shader4);

    d->Uniform4uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint *)>(context->getProcAddress("glUniform4uivEXT"));
    d->Uniform3uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint *)>(context->getProcAddress("glUniform3uivEXT"));
    d->Uniform2uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint *)>(context->getProcAddress("glUniform2uivEXT"));
    d->Uniform1uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint *)>(context->getProcAddress("glUniform1uivEXT"));
    d->Uniform4uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glUniform4uiEXT"));
    d->Uniform3uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint , GLuint , GLuint )>(context->getProcAddress("glUniform3uiEXT"));
    d->Uniform2uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint , GLuint )>(context->getProcAddress("glUniform2uiEXT"));
    d->Uniform1uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint )>(context->getProcAddress("glUniform1uiEXT"));
    d->GetFragDataLocationEXT = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , const GLchar *)>(context->getProcAddress("glGetFragDataLocationEXT"));
    d->BindFragDataLocationEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , const GLchar *)>(context->getProcAddress("glBindFragDataLocationEXT"));
    d->GetUniformuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint *)>(context->getProcAddress("glGetUniformuivEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_histogram::QOpenGLExtension_EXT_histogram()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_histogramPrivate))
{
}

bool QOpenGLExtension_EXT_histogram::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_histogram);

    d->ResetMinmaxEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glResetMinmaxEXT"));
    d->ResetHistogramEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glResetHistogramEXT"));
    d->MinmaxEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLboolean )>(context->getProcAddress("glMinmaxEXT"));
    d->HistogramEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , GLboolean )>(context->getProcAddress("glHistogramEXT"));
    d->GetMinmaxParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetMinmaxParameterivEXT"));
    d->GetMinmaxParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetMinmaxParameterfvEXT"));
    d->GetMinmaxEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLboolean , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetMinmaxEXT"));
    d->GetHistogramParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetHistogramParameterivEXT"));
    d->GetHistogramParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetHistogramParameterfvEXT"));
    d->GetHistogramEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLboolean , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetHistogramEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_index_func::QOpenGLExtension_EXT_index_func()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_index_funcPrivate))
{
}

bool QOpenGLExtension_EXT_index_func::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_index_func);

    d->IndexFuncEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLclampf )>(context->getProcAddress("glIndexFuncEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_index_material::QOpenGLExtension_EXT_index_material()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_index_materialPrivate))
{
}

bool QOpenGLExtension_EXT_index_material::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_index_material);

    d->IndexMaterialEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glIndexMaterialEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_light_texture::QOpenGLExtension_EXT_light_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_light_texturePrivate))
{
}

bool QOpenGLExtension_EXT_light_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_light_texture);

    d->TextureMaterialEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glTextureMaterialEXT"));
    d->TextureLightEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glTextureLightEXT"));
    d->ApplyTextureEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glApplyTextureEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_multi_draw_arrays::QOpenGLExtension_EXT_multi_draw_arrays()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_multi_draw_arraysPrivate))
{
}

bool QOpenGLExtension_EXT_multi_draw_arrays::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_multi_draw_arrays);

    d->MultiDrawElementsEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLsizei *, GLenum , const GLvoid* *, GLsizei )>(context->getProcAddress("glMultiDrawElementsEXT"));
    d->MultiDrawArraysEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *, const GLsizei *, GLsizei )>(context->getProcAddress("glMultiDrawArraysEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_multisample::QOpenGLExtension_EXT_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_multisamplePrivate))
{
}

bool QOpenGLExtension_EXT_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_multisample);

    d->SamplePatternEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glSamplePatternEXT"));
    d->SampleMaskEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLclampf , GLboolean )>(context->getProcAddress("glSampleMaskEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_paletted_texture::QOpenGLExtension_EXT_paletted_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_paletted_texturePrivate))
{
}

bool QOpenGLExtension_EXT_paletted_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_paletted_texture);

    d->GetColorTableParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetColorTableParameterfvEXT"));
    d->GetColorTableParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetColorTableParameterivEXT"));
    d->GetColorTableEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetColorTableEXT"));
    d->ColorTableEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glColorTableEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_pixel_transform::QOpenGLExtension_EXT_pixel_transform()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_pixel_transformPrivate))
{
}

bool QOpenGLExtension_EXT_pixel_transform::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_pixel_transform);

    d->GetPixelTransformParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetPixelTransformParameterfvEXT"));
    d->GetPixelTransformParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetPixelTransformParameterivEXT"));
    d->PixelTransformParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glPixelTransformParameterfvEXT"));
    d->PixelTransformParameterivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glPixelTransformParameterivEXT"));
    d->PixelTransformParameterfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat )>(context->getProcAddress("glPixelTransformParameterfEXT"));
    d->PixelTransformParameteriEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glPixelTransformParameteriEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_point_parameters::QOpenGLExtension_EXT_point_parameters()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_point_parametersPrivate))
{
}

bool QOpenGLExtension_EXT_point_parameters::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_point_parameters);

    d->PointParameterfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glPointParameterfvEXT"));
    d->PointParameterfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glPointParameterfEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_polygon_offset::QOpenGLExtension_EXT_polygon_offset()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_polygon_offsetPrivate))
{
}

bool QOpenGLExtension_EXT_polygon_offset::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_polygon_offset);

    d->PolygonOffsetEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat )>(context->getProcAddress("glPolygonOffsetEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_provoking_vertex::QOpenGLExtension_EXT_provoking_vertex()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_provoking_vertexPrivate))
{
}

bool QOpenGLExtension_EXT_provoking_vertex::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_provoking_vertex);

    d->ProvokingVertexEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glProvokingVertexEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_secondary_color::QOpenGLExtension_EXT_secondary_color()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_secondary_colorPrivate))
{
}

bool QOpenGLExtension_EXT_secondary_color::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_secondary_color);

    d->SecondaryColorPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glSecondaryColorPointerEXT"));
    d->SecondaryColor3usvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLushort *)>(context->getProcAddress("glSecondaryColor3usvEXT"));
    d->SecondaryColor3usEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLushort , GLushort , GLushort )>(context->getProcAddress("glSecondaryColor3usEXT"));
    d->SecondaryColor3uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *)>(context->getProcAddress("glSecondaryColor3uivEXT"));
    d->SecondaryColor3uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glSecondaryColor3uiEXT"));
    d->SecondaryColor3ubvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLubyte *)>(context->getProcAddress("glSecondaryColor3ubvEXT"));
    d->SecondaryColor3ubEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLubyte , GLubyte , GLubyte )>(context->getProcAddress("glSecondaryColor3ubEXT"));
    d->SecondaryColor3svEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glSecondaryColor3svEXT"));
    d->SecondaryColor3sEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort , GLshort )>(context->getProcAddress("glSecondaryColor3sEXT"));
    d->SecondaryColor3ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glSecondaryColor3ivEXT"));
    d->SecondaryColor3iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint )>(context->getProcAddress("glSecondaryColor3iEXT"));
    d->SecondaryColor3fvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glSecondaryColor3fvEXT"));
    d->SecondaryColor3fEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glSecondaryColor3fEXT"));
    d->SecondaryColor3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glSecondaryColor3dvEXT"));
    d->SecondaryColor3dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glSecondaryColor3dEXT"));
    d->SecondaryColor3bvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLbyte *)>(context->getProcAddress("glSecondaryColor3bvEXT"));
    d->SecondaryColor3bEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbyte , GLbyte , GLbyte )>(context->getProcAddress("glSecondaryColor3bEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_separate_shader_objects::QOpenGLExtension_EXT_separate_shader_objects()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_separate_shader_objectsPrivate))
{
}

bool QOpenGLExtension_EXT_separate_shader_objects::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);

    d->CreateShaderProgramEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , const GLchar *)>(context->getProcAddress("glCreateShaderProgramEXT"));
    d->ActiveProgramEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glActiveProgramEXT"));
    d->UseShaderProgramEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glUseShaderProgramEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_shader_image_load_store::QOpenGLExtension_EXT_shader_image_load_store()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_shader_image_load_storePrivate))
{
}

bool QOpenGLExtension_EXT_shader_image_load_store::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_shader_image_load_store);

    d->MemoryBarrierEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield )>(context->getProcAddress("glMemoryBarrierEXT"));
    d->BindImageTextureEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLint , GLboolean , GLint , GLenum , GLint )>(context->getProcAddress("glBindImageTextureEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_stencil_clear_tag::QOpenGLExtension_EXT_stencil_clear_tag()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_stencil_clear_tagPrivate))
{
}

bool QOpenGLExtension_EXT_stencil_clear_tag::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_stencil_clear_tag);

    d->StencilClearTagEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint )>(context->getProcAddress("glStencilClearTagEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_stencil_two_side::QOpenGLExtension_EXT_stencil_two_side()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_stencil_two_sidePrivate))
{
}

bool QOpenGLExtension_EXT_stencil_two_side::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_stencil_two_side);

    d->ActiveStencilFaceEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glActiveStencilFaceEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_subtexture::QOpenGLExtension_EXT_subtexture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_subtexturePrivate))
{
}

bool QOpenGLExtension_EXT_subtexture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_subtexture);

    d->TexSubImage2DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTexSubImage2DEXT"));
    d->TexSubImage1DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTexSubImage1DEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_texture3D::QOpenGLExtension_EXT_texture3D()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_texture3DPrivate))
{
}

bool QOpenGLExtension_EXT_texture3D::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_texture3D);

    d->TexSubImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTexSubImage3DEXT"));
    d->TexImage3DEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTexImage3DEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_texture_buffer_object::QOpenGLExtension_EXT_texture_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_texture_buffer_objectPrivate))
{
}

bool QOpenGLExtension_EXT_texture_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_texture_buffer_object);

    d->TexBufferEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint )>(context->getProcAddress("glTexBufferEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_texture_integer::QOpenGLExtension_EXT_texture_integer()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_texture_integerPrivate))
{
}

bool QOpenGLExtension_EXT_texture_integer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_texture_integer);

    d->ClearColorIuiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glClearColorIuiEXT"));
    d->ClearColorIiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint , GLint )>(context->getProcAddress("glClearColorIiEXT"));
    d->GetTexParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint *)>(context->getProcAddress("glGetTexParameterIuivEXT"));
    d->GetTexParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetTexParameterIivEXT"));
    d->TexParameterIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLuint *)>(context->getProcAddress("glTexParameterIuivEXT"));
    d->TexParameterIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glTexParameterIivEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_texture_object::QOpenGLExtension_EXT_texture_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_texture_objectPrivate))
{
}

bool QOpenGLExtension_EXT_texture_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_texture_object);

    d->PrioritizeTexturesEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *, const GLclampf *)>(context->getProcAddress("glPrioritizeTexturesEXT"));
    d->IsTextureEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsTextureEXT"));
    d->GenTexturesEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenTexturesEXT"));
    d->DeleteTexturesEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteTexturesEXT"));
    d->BindTextureEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindTextureEXT"));
    d->AreTexturesResidentEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *, GLboolean *)>(context->getProcAddress("glAreTexturesResidentEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_texture_perturb_normal::QOpenGLExtension_EXT_texture_perturb_normal()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_texture_perturb_normalPrivate))
{
}

bool QOpenGLExtension_EXT_texture_perturb_normal::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_texture_perturb_normal);

    d->TextureNormalEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glTextureNormalEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_timer_query::QOpenGLExtension_EXT_timer_query()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_timer_queryPrivate))
{
}

bool QOpenGLExtension_EXT_timer_query::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_timer_query);

    d->GetQueryObjectui64vEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint64EXT *)>(context->getProcAddress("glGetQueryObjectui64vEXT"));
    d->GetQueryObjecti64vEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint64EXT *)>(context->getProcAddress("glGetQueryObjecti64vEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_transform_feedback::QOpenGLExtension_EXT_transform_feedback()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_transform_feedbackPrivate))
{
}

bool QOpenGLExtension_EXT_transform_feedback::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_transform_feedback);

    d->GetTransformFeedbackVaryingEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLsizei , GLsizei *, GLsizei *, GLenum *, GLchar *)>(context->getProcAddress("glGetTransformFeedbackVaryingEXT"));
    d->TransformFeedbackVaryingsEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLchar* *, GLenum )>(context->getProcAddress("glTransformFeedbackVaryingsEXT"));
    d->BindBufferBaseEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint )>(context->getProcAddress("glBindBufferBaseEXT"));
    d->BindBufferOffsetEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLintptr )>(context->getProcAddress("glBindBufferOffsetEXT"));
    d->BindBufferRangeEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLintptr , GLsizeiptr )>(context->getProcAddress("glBindBufferRangeEXT"));
    d->EndTransformFeedbackEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glEndTransformFeedbackEXT"));
    d->BeginTransformFeedbackEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glBeginTransformFeedbackEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_vertex_array::QOpenGLExtension_EXT_vertex_array()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_vertex_arrayPrivate))
{
}

bool QOpenGLExtension_EXT_vertex_array::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_vertex_array);

    d->VertexPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexPointerEXT"));
    d->TexCoordPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , GLsizei , const GLvoid *)>(context->getProcAddress("glTexCoordPointerEXT"));
    d->NormalPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLsizei , const GLvoid *)>(context->getProcAddress("glNormalPointerEXT"));
    d->IndexPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLsizei , const GLvoid *)>(context->getProcAddress("glIndexPointerEXT"));
    d->GetPointervEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLvoid* *)>(context->getProcAddress("glGetPointervEXT"));
    d->EdgeFlagPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLsizei , const GLboolean *)>(context->getProcAddress("glEdgeFlagPointerEXT"));
    d->DrawArraysEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei )>(context->getProcAddress("glDrawArraysEXT"));
    d->ColorPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , GLsizei , const GLvoid *)>(context->getProcAddress("glColorPointerEXT"));
    d->ArrayElementEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glArrayElementEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_vertex_attrib_64bit::QOpenGLExtension_EXT_vertex_attrib_64bit()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_vertex_attrib_64bitPrivate))
{
}

bool QOpenGLExtension_EXT_vertex_attrib_64bit::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_vertex_attrib_64bit);

    d->VertexArrayVertexAttribLOffsetEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , GLint , GLenum , GLsizei , GLintptr )>(context->getProcAddress("glVertexArrayVertexAttribLOffsetEXT"));
    d->GetVertexAttribLdvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLdouble *)>(context->getProcAddress("glGetVertexAttribLdvEXT"));
    d->VertexAttribLPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexAttribLPointerEXT"));
    d->VertexAttribL4dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL4dvEXT"));
    d->VertexAttribL3dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL3dvEXT"));
    d->VertexAttribL2dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL2dvEXT"));
    d->VertexAttribL1dvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttribL1dvEXT"));
    d->VertexAttribL4dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttribL4dEXT"));
    d->VertexAttribL3dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttribL3dEXT"));
    d->VertexAttribL2dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttribL2dEXT"));
    d->VertexAttribL1dEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble )>(context->getProcAddress("glVertexAttribL1dEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_vertex_shader::QOpenGLExtension_EXT_vertex_shader()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_vertex_shaderPrivate))
{
}

bool QOpenGLExtension_EXT_vertex_shader::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_vertex_shader);

    d->GetLocalConstantFloatvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetLocalConstantFloatvEXT"));
    d->GetLocalConstantIntegervEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetLocalConstantIntegervEXT"));
    d->GetLocalConstantBooleanvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean *)>(context->getProcAddress("glGetLocalConstantBooleanvEXT"));
    d->GetInvariantFloatvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetInvariantFloatvEXT"));
    d->GetInvariantIntegervEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetInvariantIntegervEXT"));
    d->GetInvariantBooleanvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean *)>(context->getProcAddress("glGetInvariantBooleanvEXT"));
    d->GetVariantPointervEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLvoid* *)>(context->getProcAddress("glGetVariantPointervEXT"));
    d->GetVariantFloatvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetVariantFloatvEXT"));
    d->GetVariantIntegervEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVariantIntegervEXT"));
    d->GetVariantBooleanvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLboolean *)>(context->getProcAddress("glGetVariantBooleanvEXT"));
    d->IsVariantEnabledEXT = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glIsVariantEnabledEXT"));
    d->BindParameterEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glBindParameterEXT"));
    d->BindTextureUnitParameterEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glBindTextureUnitParameterEXT"));
    d->BindTexGenParameterEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum )>(context->getProcAddress("glBindTexGenParameterEXT"));
    d->BindMaterialParameterEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glBindMaterialParameterEXT"));
    d->BindLightParameterEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glBindLightParameterEXT"));
    d->DisableVariantClientStateEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glDisableVariantClientStateEXT"));
    d->EnableVariantClientStateEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glEnableVariantClientStateEXT"));
    d->VariantPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint , const GLvoid *)>(context->getProcAddress("glVariantPointerEXT"));
    d->VariantuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVariantuivEXT"));
    d->VariantusvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLushort *)>(context->getProcAddress("glVariantusvEXT"));
    d->VariantubvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLubyte *)>(context->getProcAddress("glVariantubvEXT"));
    d->VariantdvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVariantdvEXT"));
    d->VariantfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVariantfvEXT"));
    d->VariantivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVariantivEXT"));
    d->VariantsvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVariantsvEXT"));
    d->VariantbvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLbyte *)>(context->getProcAddress("glVariantbvEXT"));
    d->SetLocalConstantEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLvoid *)>(context->getProcAddress("glSetLocalConstantEXT"));
    d->SetInvariantEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLvoid *)>(context->getProcAddress("glSetInvariantEXT"));
    d->GenSymbolsEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLuint )>(context->getProcAddress("glGenSymbolsEXT"));
    d->ExtractComponentEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glExtractComponentEXT"));
    d->InsertComponentEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glInsertComponentEXT"));
    d->WriteMaskEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glWriteMaskEXT"));
    d->SwizzleEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glSwizzleEXT"));
    d->ShaderOp3EXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glShaderOp3EXT"));
    d->ShaderOp2EXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint )>(context->getProcAddress("glShaderOp2EXT"));
    d->ShaderOp1EXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint )>(context->getProcAddress("glShaderOp1EXT"));
    d->DeleteVertexShaderEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glDeleteVertexShaderEXT"));
    d->GenVertexShadersEXT = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glGenVertexShadersEXT"));
    d->BindVertexShaderEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBindVertexShaderEXT"));
    d->EndVertexShaderEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glEndVertexShaderEXT"));
    d->BeginVertexShaderEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glBeginVertexShaderEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_vertex_weighting::QOpenGLExtension_EXT_vertex_weighting()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_vertex_weightingPrivate))
{
}

bool QOpenGLExtension_EXT_vertex_weighting::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_vertex_weighting);

    d->VertexWeightPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexWeightPointerEXT"));
    d->VertexWeightfvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glVertexWeightfvEXT"));
    d->VertexWeightfEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat )>(context->getProcAddress("glVertexWeightfEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_EXT_x11_sync_object::QOpenGLExtension_EXT_x11_sync_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_x11_sync_objectPrivate))
{
}

bool QOpenGLExtension_EXT_x11_sync_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_x11_sync_object);

    d->ImportSyncEXT = reinterpret_cast<GLsync (QOPENGLF_APIENTRYP)(GLenum , GLintptr , GLbitfield )>(context->getProcAddress("glImportSyncEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_GREMEDY_frame_terminator::QOpenGLExtension_GREMEDY_frame_terminator()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_GREMEDY_frame_terminatorPrivate))
{
}

bool QOpenGLExtension_GREMEDY_frame_terminator::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_GREMEDY_frame_terminator);

    d->FrameTerminatorGREMEDY = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glFrameTerminatorGREMEDY"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_GREMEDY_string_marker::QOpenGLExtension_GREMEDY_string_marker()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_GREMEDY_string_markerPrivate))
{
}

bool QOpenGLExtension_GREMEDY_string_marker::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_GREMEDY_string_marker);

    d->StringMarkerGREMEDY = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLvoid *)>(context->getProcAddress("glStringMarkerGREMEDY"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_HP_image_transform::QOpenGLExtension_HP_image_transform()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_HP_image_transformPrivate))
{
}

bool QOpenGLExtension_HP_image_transform::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_HP_image_transform);

    d->GetImageTransformParameterfvHP = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetImageTransformParameterfvHP"));
    d->GetImageTransformParameterivHP = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetImageTransformParameterivHP"));
    d->ImageTransformParameterfvHP = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glImageTransformParameterfvHP"));
    d->ImageTransformParameterivHP = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glImageTransformParameterivHP"));
    d->ImageTransformParameterfHP = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat )>(context->getProcAddress("glImageTransformParameterfHP"));
    d->ImageTransformParameteriHP = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glImageTransformParameteriHP"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_IBM_multimode_draw_arrays::QOpenGLExtension_IBM_multimode_draw_arrays()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_IBM_multimode_draw_arraysPrivate))
{
}

bool QOpenGLExtension_IBM_multimode_draw_arrays::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_IBM_multimode_draw_arrays);

    d->MultiModeDrawElementsIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLenum *, const GLsizei *, GLenum , const GLvoid* const *, GLsizei , GLint )>(context->getProcAddress("glMultiModeDrawElementsIBM"));
    d->MultiModeDrawArraysIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLenum *, const GLint *, const GLsizei *, GLsizei , GLint )>(context->getProcAddress("glMultiModeDrawArraysIBM"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_IBM_vertex_array_lists::QOpenGLExtension_IBM_vertex_array_lists()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_IBM_vertex_array_listsPrivate))
{
}

bool QOpenGLExtension_IBM_vertex_array_lists::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_IBM_vertex_array_lists);

    d->VertexPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glVertexPointerListIBM"));
    d->TexCoordPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glTexCoordPointerListIBM"));
    d->NormalPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glNormalPointerListIBM"));
    d->IndexPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glIndexPointerListIBM"));
    d->FogCoordPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glFogCoordPointerListIBM"));
    d->EdgeFlagPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , const GLboolean* *, GLint )>(context->getProcAddress("glEdgeFlagPointerListIBM"));
    d->SecondaryColorPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glSecondaryColorPointerListIBM"));
    d->ColorPointerListIBM = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLint , const GLvoid* *, GLint )>(context->getProcAddress("glColorPointerListIBM"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_INGR_blend_func_separate::QOpenGLExtension_INGR_blend_func_separate()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_INGR_blend_func_separatePrivate))
{
}

bool QOpenGLExtension_INGR_blend_func_separate::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_INGR_blend_func_separate);

    d->BlendFuncSeparateINGR = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glBlendFuncSeparateINGR"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_INTEL_parallel_arrays::QOpenGLExtension_INTEL_parallel_arrays()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_INTEL_parallel_arraysPrivate))
{
}

bool QOpenGLExtension_INTEL_parallel_arrays::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_INTEL_parallel_arrays);

    d->TexCoordPointervINTEL = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , const GLvoid* *)>(context->getProcAddress("glTexCoordPointervINTEL"));
    d->ColorPointervINTEL = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , const GLvoid* *)>(context->getProcAddress("glColorPointervINTEL"));
    d->NormalPointervINTEL = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLvoid* *)>(context->getProcAddress("glNormalPointervINTEL"));
    d->VertexPointervINTEL = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , const GLvoid* *)>(context->getProcAddress("glVertexPointervINTEL"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_KHR_debug::QOpenGLExtension_KHR_debug()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_KHR_debugPrivate))
{
}

bool QOpenGLExtension_KHR_debug::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_KHR_debug);

    d->GetObjectPtrLabel = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const void *, GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetObjectPtrLabel"));
    d->ObjectPtrLabel = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const void *, GLsizei , const GLchar *)>(context->getProcAddress("glObjectPtrLabel"));
    d->GetObjectLabel = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , GLsizei *, GLchar *)>(context->getProcAddress("glGetObjectLabel"));
    d->ObjectLabel = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLchar *)>(context->getProcAddress("glObjectLabel"));
    d->PopDebugGroup = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glPopDebugGroup"));
    d->PushDebugGroup = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLchar *)>(context->getProcAddress("glPushDebugGroup"));
    d->GetDebugMessageLog = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLenum *, GLenum *, GLuint *, GLenum *, GLsizei *, GLchar *)>(context->getProcAddress("glGetDebugMessageLog"));
    d->DebugMessageCallback = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLDEBUGPROC , const void *)>(context->getProcAddress("glDebugMessageCallback"));
    d->DebugMessageInsert = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLenum , GLsizei , const GLchar *)>(context->getProcAddress("glDebugMessageInsert"));
    d->DebugMessageControl = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLsizei , const GLuint *, GLboolean )>(context->getProcAddress("glDebugMessageControl"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_MESA_resize_buffers::QOpenGLExtension_MESA_resize_buffers()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_MESA_resize_buffersPrivate))
{
}

bool QOpenGLExtension_MESA_resize_buffers::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_MESA_resize_buffers);

    d->ResizeBuffersMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glResizeBuffersMESA"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_MESA_window_pos::QOpenGLExtension_MESA_window_pos()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_MESA_window_posPrivate))
{
}

bool QOpenGLExtension_MESA_window_pos::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_MESA_window_pos);

    d->WindowPos4svMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glWindowPos4svMESA"));
    d->WindowPos4sMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort , GLshort , GLshort )>(context->getProcAddress("glWindowPos4sMESA"));
    d->WindowPos4ivMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glWindowPos4ivMESA"));
    d->WindowPos4iMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint , GLint )>(context->getProcAddress("glWindowPos4iMESA"));
    d->WindowPos4fvMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glWindowPos4fvMESA"));
    d->WindowPos4fMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glWindowPos4fMESA"));
    d->WindowPos4dvMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glWindowPos4dvMESA"));
    d->WindowPos4dMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glWindowPos4dMESA"));
    d->WindowPos3svMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glWindowPos3svMESA"));
    d->WindowPos3sMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort , GLshort )>(context->getProcAddress("glWindowPos3sMESA"));
    d->WindowPos3ivMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glWindowPos3ivMESA"));
    d->WindowPos3iMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint , GLint )>(context->getProcAddress("glWindowPos3iMESA"));
    d->WindowPos3fvMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glWindowPos3fvMESA"));
    d->WindowPos3fMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glWindowPos3fMESA"));
    d->WindowPos3dvMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glWindowPos3dvMESA"));
    d->WindowPos3dMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glWindowPos3dMESA"));
    d->WindowPos2svMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLshort *)>(context->getProcAddress("glWindowPos2svMESA"));
    d->WindowPos2sMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort , GLshort )>(context->getProcAddress("glWindowPos2sMESA"));
    d->WindowPos2ivMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLint *)>(context->getProcAddress("glWindowPos2ivMESA"));
    d->WindowPos2iMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint )>(context->getProcAddress("glWindowPos2iMESA"));
    d->WindowPos2fvMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *)>(context->getProcAddress("glWindowPos2fvMESA"));
    d->WindowPos2fMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat )>(context->getProcAddress("glWindowPos2fMESA"));
    d->WindowPos2dvMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glWindowPos2dvMESA"));
    d->WindowPos2dMESA = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble )>(context->getProcAddress("glWindowPos2dMESA"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_bindless_texture::QOpenGLExtension_NV_bindless_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_bindless_texturePrivate))
{
}

bool QOpenGLExtension_NV_bindless_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_bindless_texture);

    d->IsImageHandleResidentNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint64 )>(context->getProcAddress("glIsImageHandleResidentNV"));
    d->IsTextureHandleResidentNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint64 )>(context->getProcAddress("glIsTextureHandleResidentNV"));
    d->ProgramUniformHandleui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint64 *)>(context->getProcAddress("glProgramUniformHandleui64vNV"));
    d->ProgramUniformHandleui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64 )>(context->getProcAddress("glProgramUniformHandleui64NV"));
    d->UniformHandleui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint64 *)>(context->getProcAddress("glUniformHandleui64vNV"));
    d->UniformHandleui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint64 )>(context->getProcAddress("glUniformHandleui64NV"));
    d->MakeImageHandleNonResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint64 )>(context->getProcAddress("glMakeImageHandleNonResidentNV"));
    d->MakeImageHandleResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint64 , GLenum )>(context->getProcAddress("glMakeImageHandleResidentNV"));
    d->GetImageHandleNV = reinterpret_cast<GLuint64 (QOPENGLF_APIENTRYP)(GLuint , GLint , GLboolean , GLint , GLenum )>(context->getProcAddress("glGetImageHandleNV"));
    d->MakeTextureHandleNonResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint64 )>(context->getProcAddress("glMakeTextureHandleNonResidentNV"));
    d->MakeTextureHandleResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint64 )>(context->getProcAddress("glMakeTextureHandleResidentNV"));
    d->GetTextureSamplerHandleNV = reinterpret_cast<GLuint64 (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glGetTextureSamplerHandleNV"));
    d->GetTextureHandleNV = reinterpret_cast<GLuint64 (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glGetTextureHandleNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_conditional_render::QOpenGLExtension_NV_conditional_render()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_conditional_renderPrivate))
{
}

bool QOpenGLExtension_NV_conditional_render::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_conditional_render);

    d->EndConditionalRenderNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glEndConditionalRenderNV"));
    d->BeginConditionalRenderNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glBeginConditionalRenderNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_copy_image::QOpenGLExtension_NV_copy_image()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_copy_imagePrivate))
{
}

bool QOpenGLExtension_NV_copy_image::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_copy_image);

    d->CopyImageSubDataNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint , GLint , GLint , GLint , GLuint , GLenum , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei )>(context->getProcAddress("glCopyImageSubDataNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_depth_buffer_float::QOpenGLExtension_NV_depth_buffer_float()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_depth_buffer_floatPrivate))
{
}

bool QOpenGLExtension_NV_depth_buffer_float::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_depth_buffer_float);

    d->DepthBoundsdNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble )>(context->getProcAddress("glDepthBoundsdNV"));
    d->ClearDepthdNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble )>(context->getProcAddress("glClearDepthdNV"));
    d->DepthRangedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble , GLdouble )>(context->getProcAddress("glDepthRangedNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_evaluators::QOpenGLExtension_NV_evaluators()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_evaluatorsPrivate))
{
}

bool QOpenGLExtension_NV_evaluators::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_evaluators);

    d->EvalMapsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glEvalMapsNV"));
    d->GetMapAttribParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetMapAttribParameterfvNV"));
    d->GetMapAttribParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetMapAttribParameterivNV"));
    d->GetMapParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetMapParameterfvNV"));
    d->GetMapParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetMapParameterivNV"));
    d->GetMapControlPointsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLsizei , GLsizei , GLboolean , GLvoid *)>(context->getProcAddress("glGetMapControlPointsNV"));
    d->MapParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glMapParameterfvNV"));
    d->MapParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glMapParameterivNV"));
    d->MapControlPointsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLsizei , GLsizei , GLint , GLint , GLboolean , const GLvoid *)>(context->getProcAddress("glMapControlPointsNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_explicit_multisample::QOpenGLExtension_NV_explicit_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_explicit_multisamplePrivate))
{
}

bool QOpenGLExtension_NV_explicit_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_explicit_multisample);

    d->TexRenderbufferNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glTexRenderbufferNV"));
    d->SampleMaskIndexedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLbitfield )>(context->getProcAddress("glSampleMaskIndexedNV"));
    d->GetMultisamplefvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat *)>(context->getProcAddress("glGetMultisamplefvNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_fence::QOpenGLExtension_NV_fence()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_fencePrivate))
{
}

bool QOpenGLExtension_NV_fence::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_fence);

    d->SetFenceNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glSetFenceNV"));
    d->FinishFenceNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glFinishFenceNV"));
    d->GetFenceivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetFenceivNV"));
    d->TestFenceNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glTestFenceNV"));
    d->IsFenceNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsFenceNV"));
    d->GenFencesNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenFencesNV"));
    d->DeleteFencesNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteFencesNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_fragment_program::QOpenGLExtension_NV_fragment_program()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_fragment_programPrivate))
{
}

bool QOpenGLExtension_NV_fragment_program::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_fragment_program);

    d->GetProgramNamedParameterdvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, GLdouble *)>(context->getProcAddress("glGetProgramNamedParameterdvNV"));
    d->GetProgramNamedParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, GLfloat *)>(context->getProcAddress("glGetProgramNamedParameterfvNV"));
    d->ProgramNamedParameter4dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, const GLdouble *)>(context->getProcAddress("glProgramNamedParameter4dvNV"));
    d->ProgramNamedParameter4fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, const GLfloat *)>(context->getProcAddress("glProgramNamedParameter4fvNV"));
    d->ProgramNamedParameter4dNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramNamedParameter4dNV"));
    d->ProgramNamedParameter4fNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramNamedParameter4fNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_framebuffer_multisample_coverage::QOpenGLExtension_NV_framebuffer_multisample_coverage()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_framebuffer_multisample_coveragePrivate))
{
}

bool QOpenGLExtension_NV_framebuffer_multisample_coverage::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_framebuffer_multisample_coverage);

    d->RenderbufferStorageMultisampleCoverageNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLsizei , GLenum , GLsizei , GLsizei )>(context->getProcAddress("glRenderbufferStorageMultisampleCoverageNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_geometry_program4::QOpenGLExtension_NV_geometry_program4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_geometry_program4Private))
{
}

bool QOpenGLExtension_NV_geometry_program4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_geometry_program4);

    d->FramebufferTextureFaceEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint , GLenum )>(context->getProcAddress("glFramebufferTextureFaceEXT"));
    d->FramebufferTextureLayerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint , GLint )>(context->getProcAddress("glFramebufferTextureLayerEXT"));
    d->FramebufferTextureEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint , GLint )>(context->getProcAddress("glFramebufferTextureEXT"));
    d->ProgramVertexLimitNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glProgramVertexLimitNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_gpu_program4::QOpenGLExtension_NV_gpu_program4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_gpu_program4Private))
{
}

bool QOpenGLExtension_NV_gpu_program4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_gpu_program4);

    d->GetProgramEnvParameterIuivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint *)>(context->getProcAddress("glGetProgramEnvParameterIuivNV"));
    d->GetProgramEnvParameterIivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLint *)>(context->getProcAddress("glGetProgramEnvParameterIivNV"));
    d->GetProgramLocalParameterIuivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint *)>(context->getProcAddress("glGetProgramLocalParameterIuivNV"));
    d->GetProgramLocalParameterIivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLint *)>(context->getProcAddress("glGetProgramLocalParameterIivNV"));
    d->ProgramEnvParametersI4uivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramEnvParametersI4uivNV"));
    d->ProgramEnvParameterI4uivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLuint *)>(context->getProcAddress("glProgramEnvParameterI4uivNV"));
    d->ProgramEnvParameterI4uiNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glProgramEnvParameterI4uiNV"));
    d->ProgramEnvParametersI4ivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLint *)>(context->getProcAddress("glProgramEnvParametersI4ivNV"));
    d->ProgramEnvParameterI4ivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLint *)>(context->getProcAddress("glProgramEnvParameterI4ivNV"));
    d->ProgramEnvParameterI4iNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glProgramEnvParameterI4iNV"));
    d->ProgramLocalParametersI4uivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramLocalParametersI4uivNV"));
    d->ProgramLocalParameterI4uivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLuint *)>(context->getProcAddress("glProgramLocalParameterI4uivNV"));
    d->ProgramLocalParameterI4uiNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glProgramLocalParameterI4uiNV"));
    d->ProgramLocalParametersI4ivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLint *)>(context->getProcAddress("glProgramLocalParametersI4ivNV"));
    d->ProgramLocalParameterI4ivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLint *)>(context->getProcAddress("glProgramLocalParameterI4ivNV"));
    d->ProgramLocalParameterI4iNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glProgramLocalParameterI4iNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_gpu_program5::QOpenGLExtension_NV_gpu_program5()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_gpu_program5Private))
{
}

bool QOpenGLExtension_NV_gpu_program5::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_gpu_program5);

    d->GetProgramSubroutineParameteruivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint *)>(context->getProcAddress("glGetProgramSubroutineParameteruivNV"));
    d->ProgramSubroutineParametersuivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLuint *)>(context->getProcAddress("glProgramSubroutineParametersuivNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_gpu_shader5::QOpenGLExtension_NV_gpu_shader5()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_gpu_shader5Private))
{
}

bool QOpenGLExtension_NV_gpu_shader5::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_gpu_shader5);

    d->ProgramUniform4ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glProgramUniform4ui64vNV"));
    d->ProgramUniform3ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glProgramUniform3ui64vNV"));
    d->ProgramUniform2ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glProgramUniform2ui64vNV"));
    d->ProgramUniform1ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glProgramUniform1ui64vNV"));
    d->ProgramUniform4ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64EXT , GLuint64EXT , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glProgramUniform4ui64NV"));
    d->ProgramUniform3ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64EXT , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glProgramUniform3ui64NV"));
    d->ProgramUniform2ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glProgramUniform2ui64NV"));
    d->ProgramUniform1ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64EXT )>(context->getProcAddress("glProgramUniform1ui64NV"));
    d->ProgramUniform4i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glProgramUniform4i64vNV"));
    d->ProgramUniform3i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glProgramUniform3i64vNV"));
    d->ProgramUniform2i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glProgramUniform2i64vNV"));
    d->ProgramUniform1i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glProgramUniform1i64vNV"));
    d->ProgramUniform4i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint64EXT , GLint64EXT , GLint64EXT , GLint64EXT )>(context->getProcAddress("glProgramUniform4i64NV"));
    d->ProgramUniform3i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint64EXT , GLint64EXT , GLint64EXT )>(context->getProcAddress("glProgramUniform3i64NV"));
    d->ProgramUniform2i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint64EXT , GLint64EXT )>(context->getProcAddress("glProgramUniform2i64NV"));
    d->ProgramUniform1i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint64EXT )>(context->getProcAddress("glProgramUniform1i64NV"));
    d->GetUniformi64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint64EXT *)>(context->getProcAddress("glGetUniformi64vNV"));
    d->Uniform4ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glUniform4ui64vNV"));
    d->Uniform3ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glUniform3ui64vNV"));
    d->Uniform2ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glUniform2ui64vNV"));
    d->Uniform1ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glUniform1ui64vNV"));
    d->Uniform4ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint64EXT , GLuint64EXT , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glUniform4ui64NV"));
    d->Uniform3ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint64EXT , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glUniform3ui64NV"));
    d->Uniform2ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glUniform2ui64NV"));
    d->Uniform1ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint64EXT )>(context->getProcAddress("glUniform1ui64NV"));
    d->Uniform4i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glUniform4i64vNV"));
    d->Uniform3i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glUniform3i64vNV"));
    d->Uniform2i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glUniform2i64vNV"));
    d->Uniform1i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLint64EXT *)>(context->getProcAddress("glUniform1i64vNV"));
    d->Uniform4i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint64EXT , GLint64EXT , GLint64EXT , GLint64EXT )>(context->getProcAddress("glUniform4i64NV"));
    d->Uniform3i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint64EXT , GLint64EXT , GLint64EXT )>(context->getProcAddress("glUniform3i64NV"));
    d->Uniform2i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint64EXT , GLint64EXT )>(context->getProcAddress("glUniform2i64NV"));
    d->Uniform1i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLint64EXT )>(context->getProcAddress("glUniform1i64NV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_half_float::QOpenGLExtension_NV_half_float()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_half_floatPrivate))
{
}

bool QOpenGLExtension_NV_half_float::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_half_float);

    d->VertexAttribs4hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLhalfNV *)>(context->getProcAddress("glVertexAttribs4hvNV"));
    d->VertexAttribs3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLhalfNV *)>(context->getProcAddress("glVertexAttribs3hvNV"));
    d->VertexAttribs2hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLhalfNV *)>(context->getProcAddress("glVertexAttribs2hvNV"));
    d->VertexAttribs1hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLhalfNV *)>(context->getProcAddress("glVertexAttribs1hvNV"));
    d->VertexAttrib4hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLhalfNV *)>(context->getProcAddress("glVertexAttrib4hvNV"));
    d->VertexAttrib4hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLhalfNV , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glVertexAttrib4hNV"));
    d->VertexAttrib3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLhalfNV *)>(context->getProcAddress("glVertexAttrib3hvNV"));
    d->VertexAttrib3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glVertexAttrib3hNV"));
    d->VertexAttrib2hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLhalfNV *)>(context->getProcAddress("glVertexAttrib2hvNV"));
    d->VertexAttrib2hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLhalfNV , GLhalfNV )>(context->getProcAddress("glVertexAttrib2hNV"));
    d->VertexAttrib1hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLhalfNV *)>(context->getProcAddress("glVertexAttrib1hvNV"));
    d->VertexAttrib1hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLhalfNV )>(context->getProcAddress("glVertexAttrib1hNV"));
    d->VertexWeighthvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glVertexWeighthvNV"));
    d->VertexWeighthNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV )>(context->getProcAddress("glVertexWeighthNV"));
    d->SecondaryColor3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glSecondaryColor3hvNV"));
    d->SecondaryColor3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glSecondaryColor3hNV"));
    d->FogCoordhvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glFogCoordhvNV"));
    d->FogCoordhNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV )>(context->getProcAddress("glFogCoordhNV"));
    d->MultiTexCoord4hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLhalfNV *)>(context->getProcAddress("glMultiTexCoord4hvNV"));
    d->MultiTexCoord4hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLhalfNV , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glMultiTexCoord4hNV"));
    d->MultiTexCoord3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLhalfNV *)>(context->getProcAddress("glMultiTexCoord3hvNV"));
    d->MultiTexCoord3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glMultiTexCoord3hNV"));
    d->MultiTexCoord2hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLhalfNV *)>(context->getProcAddress("glMultiTexCoord2hvNV"));
    d->MultiTexCoord2hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLhalfNV , GLhalfNV )>(context->getProcAddress("glMultiTexCoord2hNV"));
    d->MultiTexCoord1hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLhalfNV *)>(context->getProcAddress("glMultiTexCoord1hvNV"));
    d->MultiTexCoord1hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLhalfNV )>(context->getProcAddress("glMultiTexCoord1hNV"));
    d->TexCoord4hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glTexCoord4hvNV"));
    d->TexCoord4hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glTexCoord4hNV"));
    d->TexCoord3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glTexCoord3hvNV"));
    d->TexCoord3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glTexCoord3hNV"));
    d->TexCoord2hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glTexCoord2hvNV"));
    d->TexCoord2hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV )>(context->getProcAddress("glTexCoord2hNV"));
    d->TexCoord1hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glTexCoord1hvNV"));
    d->TexCoord1hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV )>(context->getProcAddress("glTexCoord1hNV"));
    d->Color4hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glColor4hvNV"));
    d->Color4hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glColor4hNV"));
    d->Color3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glColor3hvNV"));
    d->Color3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glColor3hNV"));
    d->Normal3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glNormal3hvNV"));
    d->Normal3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glNormal3hNV"));
    d->Vertex4hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glVertex4hvNV"));
    d->Vertex4hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glVertex4hNV"));
    d->Vertex3hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glVertex3hvNV"));
    d->Vertex3hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV , GLhalfNV )>(context->getProcAddress("glVertex3hNV"));
    d->Vertex2hvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLhalfNV *)>(context->getProcAddress("glVertex2hvNV"));
    d->Vertex2hNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLhalfNV , GLhalfNV )>(context->getProcAddress("glVertex2hNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_occlusion_query::QOpenGLExtension_NV_occlusion_query()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_occlusion_queryPrivate))
{
}

bool QOpenGLExtension_NV_occlusion_query::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_occlusion_query);

    d->GetOcclusionQueryuivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint *)>(context->getProcAddress("glGetOcclusionQueryuivNV"));
    d->GetOcclusionQueryivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetOcclusionQueryivNV"));
    d->EndOcclusionQueryNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glEndOcclusionQueryNV"));
    d->BeginOcclusionQueryNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBeginOcclusionQueryNV"));
    d->IsOcclusionQueryNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsOcclusionQueryNV"));
    d->DeleteOcclusionQueriesNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteOcclusionQueriesNV"));
    d->GenOcclusionQueriesNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenOcclusionQueriesNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_parameter_buffer_object::QOpenGLExtension_NV_parameter_buffer_object()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_parameter_buffer_objectPrivate))
{
}

bool QOpenGLExtension_NV_parameter_buffer_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_parameter_buffer_object);

    d->ProgramBufferParametersIuivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei , const GLuint *)>(context->getProcAddress("glProgramBufferParametersIuivNV"));
    d->ProgramBufferParametersIivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei , const GLint *)>(context->getProcAddress("glProgramBufferParametersIivNV"));
    d->ProgramBufferParametersfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramBufferParametersfvNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_path_rendering::QOpenGLExtension_NV_path_rendering()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_path_renderingPrivate))
{
}

bool QOpenGLExtension_NV_path_rendering::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_path_rendering);

    d->PointAlongPathNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei , GLfloat , GLfloat *, GLfloat *, GLfloat *, GLfloat *)>(context->getProcAddress("glPointAlongPathNV"));
    d->GetPathLengthNV = reinterpret_cast<GLfloat (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei )>(context->getProcAddress("glGetPathLengthNV"));
    d->IsPointInStrokePathNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat )>(context->getProcAddress("glIsPointInStrokePathNV"));
    d->IsPointInFillPathNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLfloat , GLfloat )>(context->getProcAddress("glIsPointInFillPathNV"));
    d->GetPathTexGenfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetPathTexGenfvNV"));
    d->GetPathTexGenivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetPathTexGenivNV"));
    d->GetPathColorGenfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetPathColorGenfvNV"));
    d->GetPathColorGenivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetPathColorGenivNV"));
    d->GetPathSpacingNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLenum , const GLvoid *, GLuint , GLfloat , GLfloat , GLenum , GLfloat *)>(context->getProcAddress("glGetPathSpacingNV"));
    d->GetPathMetricRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield , GLuint , GLsizei , GLsizei , GLfloat *)>(context->getProcAddress("glGetPathMetricRangeNV"));
    d->GetPathMetricsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield , GLsizei , GLenum , const GLvoid *, GLuint , GLsizei , GLfloat *)>(context->getProcAddress("glGetPathMetricsNV"));
    d->GetPathDashArrayNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat *)>(context->getProcAddress("glGetPathDashArrayNV"));
    d->GetPathCoordsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat *)>(context->getProcAddress("glGetPathCoordsNV"));
    d->GetPathCommandsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLubyte *)>(context->getProcAddress("glGetPathCommandsNV"));
    d->GetPathParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetPathParameterfvNV"));
    d->GetPathParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetPathParameterivNV"));
    d->CoverStrokePathInstancedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLenum , const GLvoid *, GLuint , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glCoverStrokePathInstancedNV"));
    d->CoverFillPathInstancedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLenum , const GLvoid *, GLuint , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glCoverFillPathInstancedNV"));
    d->CoverStrokePathNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glCoverStrokePathNV"));
    d->CoverFillPathNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glCoverFillPathNV"));
    d->PathFogGenNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glPathFogGenNV"));
    d->PathTexGenNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , const GLfloat *)>(context->getProcAddress("glPathTexGenNV"));
    d->PathColorGenNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glPathColorGenNV"));
    d->PathCoverDepthFuncNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glPathCoverDepthFuncNV"));
    d->StencilStrokePathInstancedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLenum , const GLvoid *, GLuint , GLint , GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glStencilStrokePathInstancedNV"));
    d->StencilFillPathInstancedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLenum , const GLvoid *, GLuint , GLenum , GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glStencilFillPathInstancedNV"));
    d->StencilStrokePathNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint )>(context->getProcAddress("glStencilStrokePathNV"));
    d->StencilFillPathNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint )>(context->getProcAddress("glStencilFillPathNV"));
    d->PathStencilDepthOffsetNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat )>(context->getProcAddress("glPathStencilDepthOffsetNV"));
    d->PathStencilFuncNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLuint )>(context->getProcAddress("glPathStencilFuncNV"));
    d->PathDashArrayNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glPathDashArrayNV"));
    d->PathParameterfNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat )>(context->getProcAddress("glPathParameterfNV"));
    d->PathParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glPathParameterfvNV"));
    d->PathParameteriNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glPathParameteriNV"));
    d->PathParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLint *)>(context->getProcAddress("glPathParameterivNV"));
    d->TransformPathNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glTransformPathNV"));
    d->InterpolatePathsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , GLfloat )>(context->getProcAddress("glInterpolatePathsNV"));
    d->CopyPathNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glCopyPathNV"));
    d->WeightPathsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLuint *, const GLfloat *)>(context->getProcAddress("glWeightPathsNV"));
    d->PathGlyphRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLvoid *, GLbitfield , GLuint , GLsizei , GLenum , GLuint , GLfloat )>(context->getProcAddress("glPathGlyphRangeNV"));
    d->PathGlyphsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLvoid *, GLbitfield , GLsizei , GLenum , const GLvoid *, GLenum , GLuint , GLfloat )>(context->getProcAddress("glPathGlyphsNV"));
    d->PathStringNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glPathStringNV"));
    d->PathSubCoordsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei , GLenum , const GLvoid *)>(context->getProcAddress("glPathSubCoordsNV"));
    d->PathSubCommandsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLsizei , GLsizei , const GLubyte *, GLsizei , GLenum , const GLvoid *)>(context->getProcAddress("glPathSubCommandsNV"));
    d->PathCoordsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , GLenum , const GLvoid *)>(context->getProcAddress("glPathCoordsNV"));
    d->PathCommandsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *, GLsizei , GLenum , const GLvoid *)>(context->getProcAddress("glPathCommandsNV"));
    d->IsPathNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsPathNV"));
    d->DeletePathsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei )>(context->getProcAddress("glDeletePathsNV"));
    d->GenPathsNV = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLsizei )>(context->getProcAddress("glGenPathsNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_pixel_data_range::QOpenGLExtension_NV_pixel_data_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_pixel_data_rangePrivate))
{
}

bool QOpenGLExtension_NV_pixel_data_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_pixel_data_range);

    d->FlushPixelDataRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glFlushPixelDataRangeNV"));
    d->PixelDataRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glPixelDataRangeNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_point_sprite::QOpenGLExtension_NV_point_sprite()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_point_spritePrivate))
{
}

bool QOpenGLExtension_NV_point_sprite::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_point_sprite);

    d->PointParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glPointParameterivNV"));
    d->PointParameteriNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glPointParameteriNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_present_video::QOpenGLExtension_NV_present_video()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_present_videoPrivate))
{
}

bool QOpenGLExtension_NV_present_video::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_present_video);

    d->GetVideoui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint64EXT *)>(context->getProcAddress("glGetVideoui64vNV"));
    d->GetVideoi64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint64EXT *)>(context->getProcAddress("glGetVideoi64vNV"));
    d->GetVideouivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint *)>(context->getProcAddress("glGetVideouivNV"));
    d->GetVideoivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVideoivNV"));
    d->PresentFrameDualFillNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint64EXT , GLuint , GLuint , GLenum , GLenum , GLuint , GLenum , GLuint , GLenum , GLuint , GLenum , GLuint )>(context->getProcAddress("glPresentFrameDualFillNV"));
    d->PresentFrameKeyedNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint64EXT , GLuint , GLuint , GLenum , GLenum , GLuint , GLuint , GLenum , GLuint , GLuint )>(context->getProcAddress("glPresentFrameKeyedNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_primitive_restart::QOpenGLExtension_NV_primitive_restart()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_primitive_restartPrivate))
{
}

bool QOpenGLExtension_NV_primitive_restart::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_primitive_restart);

    d->PrimitiveRestartIndexNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glPrimitiveRestartIndexNV"));
    d->PrimitiveRestartNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glPrimitiveRestartNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_register_combiners::QOpenGLExtension_NV_register_combiners()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_register_combinersPrivate))
{
}

bool QOpenGLExtension_NV_register_combiners::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_register_combiners);

    d->GetFinalCombinerInputParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetFinalCombinerInputParameterivNV"));
    d->GetFinalCombinerInputParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetFinalCombinerInputParameterfvNV"));
    d->GetCombinerOutputParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetCombinerOutputParameterivNV"));
    d->GetCombinerOutputParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetCombinerOutputParameterfvNV"));
    d->GetCombinerInputParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum , GLint *)>(context->getProcAddress("glGetCombinerInputParameterivNV"));
    d->GetCombinerInputParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetCombinerInputParameterfvNV"));
    d->FinalCombinerInputNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glFinalCombinerInputNV"));
    d->CombinerOutputNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum , GLenum , GLenum , GLenum , GLboolean , GLboolean , GLboolean )>(context->getProcAddress("glCombinerOutputNV"));
    d->CombinerInputNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLenum , GLenum , GLenum )>(context->getProcAddress("glCombinerInputNV"));
    d->CombinerParameteriNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glCombinerParameteriNV"));
    d->CombinerParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glCombinerParameterivNV"));
    d->CombinerParameterfNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glCombinerParameterfNV"));
    d->CombinerParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glCombinerParameterfvNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_register_combiners2::QOpenGLExtension_NV_register_combiners2()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_register_combiners2Private))
{
}

bool QOpenGLExtension_NV_register_combiners2::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_register_combiners2);

    d->GetCombinerStageParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetCombinerStageParameterfvNV"));
    d->CombinerStageParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glCombinerStageParameterfvNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_shader_buffer_load::QOpenGLExtension_NV_shader_buffer_load()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_shader_buffer_loadPrivate))
{
}

bool QOpenGLExtension_NV_shader_buffer_load::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_shader_buffer_load);

    d->ProgramUniformui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glProgramUniformui64vNV"));
    d->ProgramUniformui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64EXT )>(context->getProcAddress("glProgramUniformui64NV"));
    d->GetUniformui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLuint64EXT *)>(context->getProcAddress("glGetUniformui64vNV"));
    d->Uniformui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLsizei , const GLuint64EXT *)>(context->getProcAddress("glUniformui64vNV"));
    d->Uniformui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLuint64EXT )>(context->getProcAddress("glUniformui64NV"));
    d->GetIntegerui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint64EXT *)>(context->getProcAddress("glGetIntegerui64vNV"));
    d->GetNamedBufferParameterui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint64EXT *)>(context->getProcAddress("glGetNamedBufferParameterui64vNV"));
    d->GetBufferParameterui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLuint64EXT *)>(context->getProcAddress("glGetBufferParameterui64vNV"));
    d->IsNamedBufferResidentNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsNamedBufferResidentNV"));
    d->MakeNamedBufferNonResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glMakeNamedBufferNonResidentNV"));
    d->MakeNamedBufferResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum )>(context->getProcAddress("glMakeNamedBufferResidentNV"));
    d->IsBufferResidentNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glIsBufferResidentNV"));
    d->MakeBufferNonResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glMakeBufferNonResidentNV"));
    d->MakeBufferResidentNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glMakeBufferResidentNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_texture_barrier::QOpenGLExtension_NV_texture_barrier()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_texture_barrierPrivate))
{
}

bool QOpenGLExtension_NV_texture_barrier::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_texture_barrier);

    d->TextureBarrierNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glTextureBarrierNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_texture_multisample::QOpenGLExtension_NV_texture_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_texture_multisamplePrivate))
{
}

bool QOpenGLExtension_NV_texture_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_texture_multisample);

    d->TextureImage3DMultisampleCoverageNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLsizei , GLint , GLsizei , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTextureImage3DMultisampleCoverageNV"));
    d->TextureImage2DMultisampleCoverageNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLsizei , GLint , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTextureImage2DMultisampleCoverageNV"));
    d->TextureImage3DMultisampleNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLint , GLsizei , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTextureImage3DMultisampleNV"));
    d->TextureImage2DMultisampleNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLsizei , GLint , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTextureImage2DMultisampleNV"));
    d->TexImage3DMultisampleCoverageNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLsizei , GLint , GLsizei , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTexImage3DMultisampleCoverageNV"));
    d->TexImage2DMultisampleCoverageNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , GLsizei , GLint , GLsizei , GLsizei , GLboolean )>(context->getProcAddress("glTexImage2DMultisampleCoverageNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_transform_feedback::QOpenGLExtension_NV_transform_feedback()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_transform_feedbackPrivate))
{
}

bool QOpenGLExtension_NV_transform_feedback::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_transform_feedback);

    d->TransformFeedbackStreamAttribsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLint *, GLsizei , const GLint *, GLenum )>(context->getProcAddress("glTransformFeedbackStreamAttribsNV"));
    d->GetTransformFeedbackVaryingNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLint *)>(context->getProcAddress("glGetTransformFeedbackVaryingNV"));
    d->GetActiveVaryingNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLsizei , GLsizei *, GLsizei *, GLenum *, GLchar *)>(context->getProcAddress("glGetActiveVaryingNV"));
    d->GetVaryingLocationNV = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint , const GLchar *)>(context->getProcAddress("glGetVaryingLocationNV"));
    d->ActiveVaryingNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLchar *)>(context->getProcAddress("glActiveVaryingNV"));
    d->TransformFeedbackVaryingsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLint *, GLenum )>(context->getProcAddress("glTransformFeedbackVaryingsNV"));
    d->BindBufferBaseNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint )>(context->getProcAddress("glBindBufferBaseNV"));
    d->BindBufferOffsetNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLintptr )>(context->getProcAddress("glBindBufferOffsetNV"));
    d->BindBufferRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint , GLintptr , GLsizeiptr )>(context->getProcAddress("glBindBufferRangeNV"));
    d->TransformFeedbackAttribsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *, GLenum )>(context->getProcAddress("glTransformFeedbackAttribsNV"));
    d->EndTransformFeedbackNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glEndTransformFeedbackNV"));
    d->BeginTransformFeedbackNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glBeginTransformFeedbackNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_transform_feedback2::QOpenGLExtension_NV_transform_feedback2()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_transform_feedback2Private))
{
}

bool QOpenGLExtension_NV_transform_feedback2::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_transform_feedback2);

    d->DrawTransformFeedbackNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glDrawTransformFeedbackNV"));
    d->ResumeTransformFeedbackNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glResumeTransformFeedbackNV"));
    d->PauseTransformFeedbackNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glPauseTransformFeedbackNV"));
    d->IsTransformFeedbackNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsTransformFeedbackNV"));
    d->GenTransformFeedbacksNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenTransformFeedbacksNV"));
    d->DeleteTransformFeedbacksNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteTransformFeedbacksNV"));
    d->BindTransformFeedbackNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindTransformFeedbackNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_vdpau_interop::QOpenGLExtension_NV_vdpau_interop()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_vdpau_interopPrivate))
{
}

bool QOpenGLExtension_NV_vdpau_interop::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_vdpau_interop);

    d->VDPAUUnmapSurfacesNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLvdpauSurfaceNV *)>(context->getProcAddress("glVDPAUUnmapSurfacesNV"));
    d->VDPAUMapSurfacesNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLvdpauSurfaceNV *)>(context->getProcAddress("glVDPAUMapSurfacesNV"));
    d->VDPAUSurfaceAccessNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLvdpauSurfaceNV , GLenum )>(context->getProcAddress("glVDPAUSurfaceAccessNV"));
    d->VDPAUGetSurfaceivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLvdpauSurfaceNV , GLenum , GLsizei , GLsizei *, GLint *)>(context->getProcAddress("glVDPAUGetSurfaceivNV"));
    d->VDPAUUnregisterSurfaceNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLvdpauSurfaceNV )>(context->getProcAddress("glVDPAUUnregisterSurfaceNV"));
    d->VDPAUIsSurfaceNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLvdpauSurfaceNV )>(context->getProcAddress("glVDPAUIsSurfaceNV"));
    d->VDPAURegisterOutputSurfaceNV = reinterpret_cast<GLvdpauSurfaceNV (QOPENGLF_APIENTRYP)(GLvoid *, GLenum , GLsizei , const GLuint *)>(context->getProcAddress("glVDPAURegisterOutputSurfaceNV"));
    d->VDPAURegisterVideoSurfaceNV = reinterpret_cast<GLvdpauSurfaceNV (QOPENGLF_APIENTRYP)(const GLvoid *, GLenum , GLsizei , const GLuint *)>(context->getProcAddress("glVDPAURegisterVideoSurfaceNV"));
    d->VDPAUFiniNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glVDPAUFiniNV"));
    d->VDPAUInitNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLvoid *, const GLvoid *)>(context->getProcAddress("glVDPAUInitNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_vertex_array_range::QOpenGLExtension_NV_vertex_array_range()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_vertex_array_rangePrivate))
{
}

bool QOpenGLExtension_NV_vertex_array_range::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_vertex_array_range);

    d->VertexArrayRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLvoid *)>(context->getProcAddress("glVertexArrayRangeNV"));
    d->FlushVertexArrayRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glFlushVertexArrayRangeNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_vertex_attrib_integer_64bit::QOpenGLExtension_NV_vertex_attrib_integer_64bit()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_vertex_attrib_integer_64bitPrivate))
{
}

bool QOpenGLExtension_NV_vertex_attrib_integer_64bit::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_vertex_attrib_integer_64bit);

    d->VertexAttribLFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLsizei )>(context->getProcAddress("glVertexAttribLFormatNV"));
    d->GetVertexAttribLui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint64EXT *)>(context->getProcAddress("glGetVertexAttribLui64vNV"));
    d->GetVertexAttribLi64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint64EXT *)>(context->getProcAddress("glGetVertexAttribLi64vNV"));
    d->VertexAttribL4ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint64EXT *)>(context->getProcAddress("glVertexAttribL4ui64vNV"));
    d->VertexAttribL3ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint64EXT *)>(context->getProcAddress("glVertexAttribL3ui64vNV"));
    d->VertexAttribL2ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint64EXT *)>(context->getProcAddress("glVertexAttribL2ui64vNV"));
    d->VertexAttribL1ui64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint64EXT *)>(context->getProcAddress("glVertexAttribL1ui64vNV"));
    d->VertexAttribL4ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint64EXT , GLuint64EXT , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glVertexAttribL4ui64NV"));
    d->VertexAttribL3ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint64EXT , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glVertexAttribL3ui64NV"));
    d->VertexAttribL2ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint64EXT , GLuint64EXT )>(context->getProcAddress("glVertexAttribL2ui64NV"));
    d->VertexAttribL1ui64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint64EXT )>(context->getProcAddress("glVertexAttribL1ui64NV"));
    d->VertexAttribL4i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint64EXT *)>(context->getProcAddress("glVertexAttribL4i64vNV"));
    d->VertexAttribL3i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint64EXT *)>(context->getProcAddress("glVertexAttribL3i64vNV"));
    d->VertexAttribL2i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint64EXT *)>(context->getProcAddress("glVertexAttribL2i64vNV"));
    d->VertexAttribL1i64vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint64EXT *)>(context->getProcAddress("glVertexAttribL1i64vNV"));
    d->VertexAttribL4i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint64EXT , GLint64EXT , GLint64EXT , GLint64EXT )>(context->getProcAddress("glVertexAttribL4i64NV"));
    d->VertexAttribL3i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint64EXT , GLint64EXT , GLint64EXT )>(context->getProcAddress("glVertexAttribL3i64NV"));
    d->VertexAttribL2i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint64EXT , GLint64EXT )>(context->getProcAddress("glVertexAttribL2i64NV"));
    d->VertexAttribL1i64NV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint64EXT )>(context->getProcAddress("glVertexAttribL1i64NV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_vertex_buffer_unified_memory::QOpenGLExtension_NV_vertex_buffer_unified_memory()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_vertex_buffer_unified_memoryPrivate))
{
}

bool QOpenGLExtension_NV_vertex_buffer_unified_memory::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_vertex_buffer_unified_memory);

    d->GetIntegerui64i_vNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint64EXT *)>(context->getProcAddress("glGetIntegerui64i_vNV"));
    d->VertexAttribIFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLsizei )>(context->getProcAddress("glVertexAttribIFormatNV"));
    d->VertexAttribFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLboolean , GLsizei )>(context->getProcAddress("glVertexAttribFormatNV"));
    d->FogCoordFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei )>(context->getProcAddress("glFogCoordFormatNV"));
    d->SecondaryColorFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei )>(context->getProcAddress("glSecondaryColorFormatNV"));
    d->EdgeFlagFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei )>(context->getProcAddress("glEdgeFlagFormatNV"));
    d->TexCoordFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei )>(context->getProcAddress("glTexCoordFormatNV"));
    d->IndexFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei )>(context->getProcAddress("glIndexFormatNV"));
    d->ColorFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei )>(context->getProcAddress("glColorFormatNV"));
    d->NormalFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei )>(context->getProcAddress("glNormalFormatNV"));
    d->VertexFormatNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint , GLenum , GLsizei )>(context->getProcAddress("glVertexFormatNV"));
    d->BufferAddressRangeNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLuint64EXT , GLsizeiptr )>(context->getProcAddress("glBufferAddressRangeNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_vertex_program::QOpenGLExtension_NV_vertex_program()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_vertex_programPrivate))
{
}

bool QOpenGLExtension_NV_vertex_program::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_vertex_program);

    d->VertexAttribs4ubvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLubyte *)>(context->getProcAddress("glVertexAttribs4ubvNV"));
    d->VertexAttribs4svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLshort *)>(context->getProcAddress("glVertexAttribs4svNV"));
    d->VertexAttribs4fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glVertexAttribs4fvNV"));
    d->VertexAttribs4dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLdouble *)>(context->getProcAddress("glVertexAttribs4dvNV"));
    d->VertexAttribs3svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLshort *)>(context->getProcAddress("glVertexAttribs3svNV"));
    d->VertexAttribs3fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glVertexAttribs3fvNV"));
    d->VertexAttribs3dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLdouble *)>(context->getProcAddress("glVertexAttribs3dvNV"));
    d->VertexAttribs2svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLshort *)>(context->getProcAddress("glVertexAttribs2svNV"));
    d->VertexAttribs2fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glVertexAttribs2fvNV"));
    d->VertexAttribs2dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLdouble *)>(context->getProcAddress("glVertexAttribs2dvNV"));
    d->VertexAttribs1svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLshort *)>(context->getProcAddress("glVertexAttribs1svNV"));
    d->VertexAttribs1fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glVertexAttribs1fvNV"));
    d->VertexAttribs1dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei , const GLdouble *)>(context->getProcAddress("glVertexAttribs1dvNV"));
    d->VertexAttrib4ubvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLubyte *)>(context->getProcAddress("glVertexAttrib4ubvNV"));
    d->VertexAttrib4ubNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLubyte , GLubyte , GLubyte , GLubyte )>(context->getProcAddress("glVertexAttrib4ubNV"));
    d->VertexAttrib4svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib4svNV"));
    d->VertexAttrib4sNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort , GLshort , GLshort , GLshort )>(context->getProcAddress("glVertexAttrib4sNV"));
    d->VertexAttrib4fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib4fvNV"));
    d->VertexAttrib4fNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glVertexAttrib4fNV"));
    d->VertexAttrib4dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib4dvNV"));
    d->VertexAttrib4dNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttrib4dNV"));
    d->VertexAttrib3svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib3svNV"));
    d->VertexAttrib3sNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort , GLshort , GLshort )>(context->getProcAddress("glVertexAttrib3sNV"));
    d->VertexAttrib3fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib3fvNV"));
    d->VertexAttrib3fNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glVertexAttrib3fNV"));
    d->VertexAttrib3dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib3dvNV"));
    d->VertexAttrib3dNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttrib3dNV"));
    d->VertexAttrib2svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib2svNV"));
    d->VertexAttrib2sNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort , GLshort )>(context->getProcAddress("glVertexAttrib2sNV"));
    d->VertexAttrib2fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib2fvNV"));
    d->VertexAttrib2fNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat )>(context->getProcAddress("glVertexAttrib2fNV"));
    d->VertexAttrib2dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib2dvNV"));
    d->VertexAttrib2dNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble , GLdouble )>(context->getProcAddress("glVertexAttrib2dNV"));
    d->VertexAttrib1svNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttrib1svNV"));
    d->VertexAttrib1sNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLshort )>(context->getProcAddress("glVertexAttrib1sNV"));
    d->VertexAttrib1fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLfloat *)>(context->getProcAddress("glVertexAttrib1fvNV"));
    d->VertexAttrib1fNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat )>(context->getProcAddress("glVertexAttrib1fNV"));
    d->VertexAttrib1dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLdouble *)>(context->getProcAddress("glVertexAttrib1dvNV"));
    d->VertexAttrib1dNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLdouble )>(context->getProcAddress("glVertexAttrib1dNV"));
    d->VertexAttribPointerNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexAttribPointerNV"));
    d->TrackMatrixNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLenum )>(context->getProcAddress("glTrackMatrixNV"));
    d->RequestResidentProgramsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glRequestResidentProgramsNV"));
    d->ProgramParameters4fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLfloat *)>(context->getProcAddress("glProgramParameters4fvNV"));
    d->ProgramParameters4dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLdouble *)>(context->getProcAddress("glProgramParameters4dvNV"));
    d->ProgramParameter4fvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLfloat *)>(context->getProcAddress("glProgramParameter4fvNV"));
    d->ProgramParameter4fNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glProgramParameter4fNV"));
    d->ProgramParameter4dvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLdouble *)>(context->getProcAddress("glProgramParameter4dvNV"));
    d->ProgramParameter4dNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLdouble , GLdouble , GLdouble , GLdouble )>(context->getProcAddress("glProgramParameter4dNV"));
    d->LoadProgramNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLsizei , const GLubyte *)>(context->getProcAddress("glLoadProgramNV"));
    d->IsProgramNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsProgramNV"));
    d->GetVertexAttribPointervNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLvoid* *)>(context->getProcAddress("glGetVertexAttribPointervNV"));
    d->GetVertexAttribivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVertexAttribivNV"));
    d->GetVertexAttribfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetVertexAttribfvNV"));
    d->GetVertexAttribdvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLdouble *)>(context->getProcAddress("glGetVertexAttribdvNV"));
    d->GetTrackMatrixivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetTrackMatrixivNV"));
    d->GetProgramStringNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLubyte *)>(context->getProcAddress("glGetProgramStringNV"));
    d->GetProgramivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetProgramivNV"));
    d->GetProgramParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetProgramParameterfvNV"));
    d->GetProgramParameterdvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , GLenum , GLdouble *)>(context->getProcAddress("glGetProgramParameterdvNV"));
    d->GenProgramsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLuint *)>(context->getProcAddress("glGenProgramsNV"));
    d->ExecuteProgramNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint , const GLfloat *)>(context->getProcAddress("glExecuteProgramNV"));
    d->DeleteProgramsNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *)>(context->getProcAddress("glDeleteProgramsNV"));
    d->BindProgramNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLuint )>(context->getProcAddress("glBindProgramNV"));
    d->AreProgramsResidentNV = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLsizei , const GLuint *, GLboolean *)>(context->getProcAddress("glAreProgramsResidentNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_vertex_program4::QOpenGLExtension_NV_vertex_program4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_vertex_program4Private))
{
}

bool QOpenGLExtension_NV_vertex_program4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_vertex_program4);

    d->GetVertexAttribIuivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLuint *)>(context->getProcAddress("glGetVertexAttribIuivEXT"));
    d->GetVertexAttribIivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVertexAttribIivEXT"));
    d->VertexAttribIPointerEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLenum , GLsizei , const GLvoid *)>(context->getProcAddress("glVertexAttribIPointerEXT"));
    d->VertexAttribI4usvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLushort *)>(context->getProcAddress("glVertexAttribI4usvEXT"));
    d->VertexAttribI4ubvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLubyte *)>(context->getProcAddress("glVertexAttribI4ubvEXT"));
    d->VertexAttribI4svEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLshort *)>(context->getProcAddress("glVertexAttribI4svEXT"));
    d->VertexAttribI4bvEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLbyte *)>(context->getProcAddress("glVertexAttribI4bvEXT"));
    d->VertexAttribI4uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVertexAttribI4uivEXT"));
    d->VertexAttribI3uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVertexAttribI3uivEXT"));
    d->VertexAttribI2uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVertexAttribI2uivEXT"));
    d->VertexAttribI1uivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLuint *)>(context->getProcAddress("glVertexAttribI1uivEXT"));
    d->VertexAttribI4ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVertexAttribI4ivEXT"));
    d->VertexAttribI3ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVertexAttribI3ivEXT"));
    d->VertexAttribI2ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVertexAttribI2ivEXT"));
    d->VertexAttribI1ivEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , const GLint *)>(context->getProcAddress("glVertexAttribI1ivEXT"));
    d->VertexAttribI4uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glVertexAttribI4uiEXT"));
    d->VertexAttribI3uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint , GLuint )>(context->getProcAddress("glVertexAttribI3uiEXT"));
    d->VertexAttribI2uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLuint )>(context->getProcAddress("glVertexAttribI2uiEXT"));
    d->VertexAttribI1uiEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint )>(context->getProcAddress("glVertexAttribI1uiEXT"));
    d->VertexAttribI4iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint , GLint )>(context->getProcAddress("glVertexAttribI4iEXT"));
    d->VertexAttribI3iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint , GLint )>(context->getProcAddress("glVertexAttribI3iEXT"));
    d->VertexAttribI2iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint , GLint )>(context->getProcAddress("glVertexAttribI2iEXT"));
    d->VertexAttribI1iEXT = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLint )>(context->getProcAddress("glVertexAttribI1iEXT"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_NV_video_capture::QOpenGLExtension_NV_video_capture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_video_capturePrivate))
{
}

bool QOpenGLExtension_NV_video_capture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_video_capture);

    d->VideoCaptureStreamParameterdvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , const GLdouble *)>(context->getProcAddress("glVideoCaptureStreamParameterdvNV"));
    d->VideoCaptureStreamParameterfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glVideoCaptureStreamParameterfvNV"));
    d->VideoCaptureStreamParameterivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , const GLint *)>(context->getProcAddress("glVideoCaptureStreamParameterivNV"));
    d->VideoCaptureNV = reinterpret_cast<GLenum (QOPENGLF_APIENTRYP)(GLuint , GLuint *, GLuint64EXT *)>(context->getProcAddress("glVideoCaptureNV"));
    d->GetVideoCaptureStreamdvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLdouble *)>(context->getProcAddress("glGetVideoCaptureStreamdvNV"));
    d->GetVideoCaptureStreamfvNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetVideoCaptureStreamfvNV"));
    d->GetVideoCaptureStreamivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVideoCaptureStreamivNV"));
    d->GetVideoCaptureivNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetVideoCaptureivNV"));
    d->EndVideoCaptureNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glEndVideoCaptureNV"));
    d->BindVideoCaptureStreamTextureNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLenum , GLuint )>(context->getProcAddress("glBindVideoCaptureStreamTextureNV"));
    d->BindVideoCaptureStreamBufferNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLuint , GLenum , GLintptrARB )>(context->getProcAddress("glBindVideoCaptureStreamBufferNV"));
    d->BeginVideoCaptureNV = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glBeginVideoCaptureNV"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_PGI_misc_hints::QOpenGLExtension_PGI_misc_hints()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_PGI_misc_hintsPrivate))
{
}

bool QOpenGLExtension_PGI_misc_hints::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_PGI_misc_hints);

    d->HintPGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glHintPGI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_detail_texture::QOpenGLExtension_SGIS_detail_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_detail_texturePrivate))
{
}

bool QOpenGLExtension_SGIS_detail_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_detail_texture);

    d->GetDetailTexFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat *)>(context->getProcAddress("glGetDetailTexFuncSGIS"));
    d->DetailTexFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLfloat *)>(context->getProcAddress("glDetailTexFuncSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_fog_function::QOpenGLExtension_SGIS_fog_function()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_fog_functionPrivate))
{
}

bool QOpenGLExtension_SGIS_fog_function::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_fog_function);

    d->GetFogFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat *)>(context->getProcAddress("glGetFogFuncSGIS"));
    d->FogFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , const GLfloat *)>(context->getProcAddress("glFogFuncSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_multisample::QOpenGLExtension_SGIS_multisample()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_multisamplePrivate))
{
}

bool QOpenGLExtension_SGIS_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_multisample);

    d->SamplePatternSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glSamplePatternSGIS"));
    d->SampleMaskSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLclampf , GLboolean )>(context->getProcAddress("glSampleMaskSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_pixel_texture::QOpenGLExtension_SGIS_pixel_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_pixel_texturePrivate))
{
}

bool QOpenGLExtension_SGIS_pixel_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_pixel_texture);

    d->GetPixelTexGenParameterfvSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat *)>(context->getProcAddress("glGetPixelTexGenParameterfvSGIS"));
    d->GetPixelTexGenParameterivSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint *)>(context->getProcAddress("glGetPixelTexGenParameterivSGIS"));
    d->PixelTexGenParameterfvSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glPixelTexGenParameterfvSGIS"));
    d->PixelTexGenParameterfSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glPixelTexGenParameterfSGIS"));
    d->PixelTexGenParameterivSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glPixelTexGenParameterivSGIS"));
    d->PixelTexGenParameteriSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glPixelTexGenParameteriSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_point_parameters::QOpenGLExtension_SGIS_point_parameters()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_point_parametersPrivate))
{
}

bool QOpenGLExtension_SGIS_point_parameters::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_point_parameters);

    d->PointParameterfvSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glPointParameterfvSGIS"));
    d->PointParameterfSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glPointParameterfSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_sharpen_texture::QOpenGLExtension_SGIS_sharpen_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_sharpen_texturePrivate))
{
}

bool QOpenGLExtension_SGIS_sharpen_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_sharpen_texture);

    d->GetSharpenTexFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat *)>(context->getProcAddress("glGetSharpenTexFuncSGIS"));
    d->SharpenTexFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLfloat *)>(context->getProcAddress("glSharpenTexFuncSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_texture4D::QOpenGLExtension_SGIS_texture4D()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_texture4DPrivate))
{
}

bool QOpenGLExtension_SGIS_texture4D::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_texture4D);

    d->TexSubImage4DSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLint , GLint , GLint , GLint , GLsizei , GLsizei , GLsizei , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTexSubImage4DSGIS"));
    d->TexImage4DSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLenum , GLsizei , GLsizei , GLsizei , GLsizei , GLint , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glTexImage4DSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_texture_color_mask::QOpenGLExtension_SGIS_texture_color_mask()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_texture_color_maskPrivate))
{
}

bool QOpenGLExtension_SGIS_texture_color_mask::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_texture_color_mask);

    d->TextureColorMaskSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLboolean , GLboolean , GLboolean , GLboolean )>(context->getProcAddress("glTextureColorMaskSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIS_texture_filter4::QOpenGLExtension_SGIS_texture_filter4()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIS_texture_filter4Private))
{
}

bool QOpenGLExtension_SGIS_texture_filter4::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIS_texture_filter4);

    d->TexFilterFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , const GLfloat *)>(context->getProcAddress("glTexFilterFuncSGIS"));
    d->GetTexFilterFuncSGIS = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetTexFilterFuncSGIS"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_async::QOpenGLExtension_SGIX_async()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_asyncPrivate))
{
}

bool QOpenGLExtension_SGIX_async::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_async);

    d->IsAsyncMarkerSGIX = reinterpret_cast<GLboolean (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glIsAsyncMarkerSGIX"));
    d->DeleteAsyncMarkersSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLsizei )>(context->getProcAddress("glDeleteAsyncMarkersSGIX"));
    d->GenAsyncMarkersSGIX = reinterpret_cast<GLuint (QOPENGLF_APIENTRYP)(GLsizei )>(context->getProcAddress("glGenAsyncMarkersSGIX"));
    d->PollAsyncSGIX = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint *)>(context->getProcAddress("glPollAsyncSGIX"));
    d->FinishAsyncSGIX = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLuint *)>(context->getProcAddress("glFinishAsyncSGIX"));
    d->AsyncMarkerSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glAsyncMarkerSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_flush_raster::QOpenGLExtension_SGIX_flush_raster()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_flush_rasterPrivate))
{
}

bool QOpenGLExtension_SGIX_flush_raster::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_flush_raster);

    d->FlushRasterSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glFlushRasterSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_fragment_lighting::QOpenGLExtension_SGIX_fragment_lighting()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_fragment_lightingPrivate))
{
}

bool QOpenGLExtension_SGIX_fragment_lighting::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_fragment_lighting);

    d->LightEnviSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glLightEnviSGIX"));
    d->GetFragmentMaterialivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetFragmentMaterialivSGIX"));
    d->GetFragmentMaterialfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetFragmentMaterialfvSGIX"));
    d->GetFragmentLightivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetFragmentLightivSGIX"));
    d->GetFragmentLightfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetFragmentLightfvSGIX"));
    d->FragmentMaterialivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glFragmentMaterialivSGIX"));
    d->FragmentMaterialiSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glFragmentMaterialiSGIX"));
    d->FragmentMaterialfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glFragmentMaterialfvSGIX"));
    d->FragmentMaterialfSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat )>(context->getProcAddress("glFragmentMaterialfSGIX"));
    d->FragmentLightModelivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glFragmentLightModelivSGIX"));
    d->FragmentLightModeliSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glFragmentLightModeliSGIX"));
    d->FragmentLightModelfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glFragmentLightModelfvSGIX"));
    d->FragmentLightModelfSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glFragmentLightModelfSGIX"));
    d->FragmentLightivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glFragmentLightivSGIX"));
    d->FragmentLightiSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint )>(context->getProcAddress("glFragmentLightiSGIX"));
    d->FragmentLightfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glFragmentLightfvSGIX"));
    d->FragmentLightfSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat )>(context->getProcAddress("glFragmentLightfSGIX"));
    d->FragmentColorMaterialSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum )>(context->getProcAddress("glFragmentColorMaterialSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_framezoom::QOpenGLExtension_SGIX_framezoom()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_framezoomPrivate))
{
}

bool QOpenGLExtension_SGIX_framezoom::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_framezoom);

    d->FrameZoomSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glFrameZoomSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_igloo_interface::QOpenGLExtension_SGIX_igloo_interface()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_igloo_interfacePrivate))
{
}

bool QOpenGLExtension_SGIX_igloo_interface::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_igloo_interface);

    d->IglooInterfaceSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLvoid *)>(context->getProcAddress("glIglooInterfaceSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_instruments::QOpenGLExtension_SGIX_instruments()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_instrumentsPrivate))
{
}

bool QOpenGLExtension_SGIX_instruments::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_instruments);

    d->StopInstrumentsSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glStopInstrumentsSGIX"));
    d->StartInstrumentsSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glStartInstrumentsSGIX"));
    d->ReadInstrumentsSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glReadInstrumentsSGIX"));
    d->PollInstrumentsSGIX = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)(GLint *)>(context->getProcAddress("glPollInstrumentsSGIX"));
    d->InstrumentsBufferSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLsizei , GLint *)>(context->getProcAddress("glInstrumentsBufferSGIX"));
    d->GetInstrumentsSGIX = reinterpret_cast<GLint (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glGetInstrumentsSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_list_priority::QOpenGLExtension_SGIX_list_priority()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_list_priorityPrivate))
{
}

bool QOpenGLExtension_SGIX_list_priority::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_list_priority);

    d->ListParameterivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLint *)>(context->getProcAddress("glListParameterivSGIX"));
    d->ListParameteriSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint )>(context->getProcAddress("glListParameteriSGIX"));
    d->ListParameterfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , const GLfloat *)>(context->getProcAddress("glListParameterfvSGIX"));
    d->ListParameterfSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat )>(context->getProcAddress("glListParameterfSGIX"));
    d->GetListParameterivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLint *)>(context->getProcAddress("glGetListParameterivSGIX"));
    d->GetListParameterfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLenum , GLfloat *)>(context->getProcAddress("glGetListParameterfvSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_pixel_texture::QOpenGLExtension_SGIX_pixel_texture()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_pixel_texturePrivate))
{
}

bool QOpenGLExtension_SGIX_pixel_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_pixel_texture);

    d->PixelTexGenSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum )>(context->getProcAddress("glPixelTexGenSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_polynomial_ffd::QOpenGLExtension_SGIX_polynomial_ffd()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_polynomial_ffdPrivate))
{
}

bool QOpenGLExtension_SGIX_polynomial_ffd::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_polynomial_ffd);

    d->LoadIdentityDeformationMapSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield )>(context->getProcAddress("glLoadIdentityDeformationMapSGIX"));
    d->DeformSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbitfield )>(context->getProcAddress("glDeformSGIX"));
    d->DeformationMap3fSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat , GLfloat , GLint , GLint , GLfloat , GLfloat , GLint , GLint , GLfloat , GLfloat , GLint , GLint , const GLfloat *)>(context->getProcAddress("glDeformationMap3fSGIX"));
    d->DeformationMap3dSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLdouble , GLdouble , GLint , GLint , GLdouble , GLdouble , GLint , GLint , GLdouble , GLdouble , GLint , GLint , const GLdouble *)>(context->getProcAddress("glDeformationMap3dSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_reference_plane::QOpenGLExtension_SGIX_reference_plane()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_reference_planePrivate))
{
}

bool QOpenGLExtension_SGIX_reference_plane::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_reference_plane);

    d->ReferencePlaneSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLdouble *)>(context->getProcAddress("glReferencePlaneSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_sprite::QOpenGLExtension_SGIX_sprite()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_spritePrivate))
{
}

bool QOpenGLExtension_SGIX_sprite::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_sprite);

    d->SpriteParameterivSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLint *)>(context->getProcAddress("glSpriteParameterivSGIX"));
    d->SpriteParameteriSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint )>(context->getProcAddress("glSpriteParameteriSGIX"));
    d->SpriteParameterfvSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , const GLfloat *)>(context->getProcAddress("glSpriteParameterfvSGIX"));
    d->SpriteParameterfSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLfloat )>(context->getProcAddress("glSpriteParameterfSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGIX_tag_sample_buffer::QOpenGLExtension_SGIX_tag_sample_buffer()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGIX_tag_sample_bufferPrivate))
{
}

bool QOpenGLExtension_SGIX_tag_sample_buffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGIX_tag_sample_buffer);

    d->TagSampleBufferSGIX = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glTagSampleBufferSGIX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SGI_color_table::QOpenGLExtension_SGI_color_table()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SGI_color_tablePrivate))
{
}

bool QOpenGLExtension_SGI_color_table::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SGI_color_table);

    d->GetColorTableParameterivSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint *)>(context->getProcAddress("glGetColorTableParameterivSGI"));
    d->GetColorTableParameterfvSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLfloat *)>(context->getProcAddress("glGetColorTableParameterfvSGI"));
    d->GetColorTableSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLenum , GLvoid *)>(context->getProcAddress("glGetColorTableSGI"));
    d->CopyColorTableSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLint , GLint , GLsizei )>(context->getProcAddress("glCopyColorTableSGI"));
    d->ColorTableParameterivSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLint *)>(context->getProcAddress("glColorTableParameterivSGI"));
    d->ColorTableParameterfvSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , const GLfloat *)>(context->getProcAddress("glColorTableParameterfvSGI"));
    d->ColorTableSGI = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLenum , GLsizei , GLenum , GLenum , const GLvoid *)>(context->getProcAddress("glColorTableSGI"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SUNX_constant_data::QOpenGLExtension_SUNX_constant_data()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SUNX_constant_dataPrivate))
{
}

bool QOpenGLExtension_SUNX_constant_data::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SUNX_constant_data);

    d->FinishTextureSUNX = reinterpret_cast<void (QOPENGLF_APIENTRYP)()>(context->getProcAddress("glFinishTextureSUNX"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SUN_global_alpha::QOpenGLExtension_SUN_global_alpha()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SUN_global_alphaPrivate))
{
}

bool QOpenGLExtension_SUN_global_alpha::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SUN_global_alpha);

    d->GlobalAlphaFactoruiSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glGlobalAlphaFactoruiSUN"));
    d->GlobalAlphaFactorusSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLushort )>(context->getProcAddress("glGlobalAlphaFactorusSUN"));
    d->GlobalAlphaFactorubSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLubyte )>(context->getProcAddress("glGlobalAlphaFactorubSUN"));
    d->GlobalAlphaFactordSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLdouble )>(context->getProcAddress("glGlobalAlphaFactordSUN"));
    d->GlobalAlphaFactorfSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat )>(context->getProcAddress("glGlobalAlphaFactorfSUN"));
    d->GlobalAlphaFactoriSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLint )>(context->getProcAddress("glGlobalAlphaFactoriSUN"));
    d->GlobalAlphaFactorsSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLshort )>(context->getProcAddress("glGlobalAlphaFactorsSUN"));
    d->GlobalAlphaFactorbSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLbyte )>(context->getProcAddress("glGlobalAlphaFactorbSUN"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SUN_mesh_array::QOpenGLExtension_SUN_mesh_array()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SUN_mesh_arrayPrivate))
{
}

bool QOpenGLExtension_SUN_mesh_array::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SUN_mesh_array);

    d->DrawMeshArraysSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLint , GLsizei , GLsizei )>(context->getProcAddress("glDrawMeshArraysSUN"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SUN_triangle_list::QOpenGLExtension_SUN_triangle_list()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SUN_triangle_listPrivate))
{
}

bool QOpenGLExtension_SUN_triangle_list::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SUN_triangle_list);

    d->ReplacementCodePointerSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLenum , GLsizei , const GLvoid* *)>(context->getProcAddress("glReplacementCodePointerSUN"));
    d->ReplacementCodeubvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLubyte *)>(context->getProcAddress("glReplacementCodeubvSUN"));
    d->ReplacementCodeusvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLushort *)>(context->getProcAddress("glReplacementCodeusvSUN"));
    d->ReplacementCodeuivSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *)>(context->getProcAddress("glReplacementCodeuivSUN"));
    d->ReplacementCodeubSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLubyte )>(context->getProcAddress("glReplacementCodeubSUN"));
    d->ReplacementCodeusSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLushort )>(context->getProcAddress("glReplacementCodeusSUN"));
    d->ReplacementCodeuiSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint )>(context->getProcAddress("glReplacementCodeuiSUN"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}

QOpenGLExtension_SUN_vertex::QOpenGLExtension_SUN_vertex()
 : QAbstractOpenGLExtension(*(new QOpenGLExtension_SUN_vertexPrivate))
{
}

bool QOpenGLExtension_SUN_vertex::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_SUN_vertex);

    d->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *, const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN"));
    d->ReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN"));
    d->ReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN"));
    d->ReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN"));
    d->ReplacementCodeuiTexCoord2fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiTexCoord2fVertex3fvSUN"));
    d->ReplacementCodeuiTexCoord2fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiTexCoord2fVertex3fSUN"));
    d->ReplacementCodeuiColor4fNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiColor4fNormal3fVertex3fvSUN"));
    d->ReplacementCodeuiColor4fNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiColor4fNormal3fVertex3fSUN"));
    d->ReplacementCodeuiNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiNormal3fVertex3fvSUN"));
    d->ReplacementCodeuiNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiNormal3fVertex3fSUN"));
    d->ReplacementCodeuiColor3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiColor3fVertex3fvSUN"));
    d->ReplacementCodeuiColor3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiColor3fVertex3fSUN"));
    d->ReplacementCodeuiColor4ubVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLubyte *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiColor4ubVertex3fvSUN"));
    d->ReplacementCodeuiColor4ubVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLubyte , GLubyte , GLubyte , GLubyte , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiColor4ubVertex3fSUN"));
    d->ReplacementCodeuiVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLuint *, const GLfloat *)>(context->getProcAddress("glReplacementCodeuiVertex3fvSUN"));
    d->ReplacementCodeuiVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLuint , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glReplacementCodeuiVertex3fSUN"));
    d->TexCoord4fColor4fNormal3fVertex4fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glTexCoord4fColor4fNormal3fVertex4fvSUN"));
    d->TexCoord4fColor4fNormal3fVertex4fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord4fColor4fNormal3fVertex4fSUN"));
    d->TexCoord2fColor4fNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glTexCoord2fColor4fNormal3fVertex3fvSUN"));
    d->TexCoord2fColor4fNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord2fColor4fNormal3fVertex3fSUN"));
    d->TexCoord2fNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glTexCoord2fNormal3fVertex3fvSUN"));
    d->TexCoord2fNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord2fNormal3fVertex3fSUN"));
    d->TexCoord2fColor3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glTexCoord2fColor3fVertex3fvSUN"));
    d->TexCoord2fColor3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord2fColor3fVertex3fSUN"));
    d->TexCoord2fColor4ubVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLubyte *, const GLfloat *)>(context->getProcAddress("glTexCoord2fColor4ubVertex3fvSUN"));
    d->TexCoord2fColor4ubVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLubyte , GLubyte , GLubyte , GLubyte , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord2fColor4ubVertex3fSUN"));
    d->TexCoord4fVertex4fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *)>(context->getProcAddress("glTexCoord4fVertex4fvSUN"));
    d->TexCoord4fVertex4fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord4fVertex4fSUN"));
    d->TexCoord2fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *)>(context->getProcAddress("glTexCoord2fVertex3fvSUN"));
    d->TexCoord2fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glTexCoord2fVertex3fSUN"));
    d->Color4fNormal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *, const GLfloat *)>(context->getProcAddress("glColor4fNormal3fVertex3fvSUN"));
    d->Color4fNormal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glColor4fNormal3fVertex3fSUN"));
    d->Normal3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *)>(context->getProcAddress("glNormal3fVertex3fvSUN"));
    d->Normal3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glNormal3fVertex3fSUN"));
    d->Color3fVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLfloat *, const GLfloat *)>(context->getProcAddress("glColor3fVertex3fvSUN"));
    d->Color3fVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLfloat , GLfloat , GLfloat , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glColor3fVertex3fSUN"));
    d->Color4ubVertex3fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLubyte *, const GLfloat *)>(context->getProcAddress("glColor4ubVertex3fvSUN"));
    d->Color4ubVertex3fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLubyte , GLubyte , GLubyte , GLubyte , GLfloat , GLfloat , GLfloat )>(context->getProcAddress("glColor4ubVertex3fSUN"));
    d->Color4ubVertex2fvSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(const GLubyte *, const GLfloat *)>(context->getProcAddress("glColor4ubVertex2fvSUN"));
    d->Color4ubVertex2fSUN = reinterpret_cast<void (QOPENGLF_APIENTRYP)(GLubyte , GLubyte , GLubyte , GLubyte , GLfloat , GLfloat )>(context->getProcAddress("glColor4ubVertex2fSUN"));
    QAbstractOpenGLExtension::initializeOpenGLFunctions();
    return true;
}


#else

QOpenGLExtension_OES_EGL_image::QOpenGLExtension_OES_EGL_image()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_OES_EGL_imagePrivate))
{
}

bool QOpenGLExtension_OES_EGL_image::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_OES_EGL_image);

    d->EGLImageTargetTexture2DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLeglImageOES image))context->getProcAddress("glEGLImageTargetTexture2DOES");
    d->EGLImageTargetRenderbufferStorageOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLeglImageOES image))context->getProcAddress("glEGLImageTargetRenderbufferStorageOES");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_OES_get_program_binary::QOpenGLExtension_OES_get_program_binary()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_OES_get_program_binaryPrivate))
{
}

bool QOpenGLExtension_OES_get_program_binary::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_OES_get_program_binary);

    d->GetProgramBinaryOES = (void (QOPENGLF_APIENTRYP)(GLuint program, GLsizei bufSize, GLsizei *length, GLenum *binaryFormat, GLvoid *binary))context->getProcAddress("glGetProgramBinaryOES");
    d->ProgramBinaryOES = (void (QOPENGLF_APIENTRYP)(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLint length))context->getProcAddress("glProgramBinaryOES");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_OES_mapbuffer::QOpenGLExtension_OES_mapbuffer()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_OES_mapbufferPrivate))
{
}

bool QOpenGLExtension_OES_mapbuffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_OES_mapbuffer);

    d->MapBufferOES = (void* (QOPENGLF_APIENTRYP)(GLenum target, GLenum access))context->getProcAddress("glMapBufferOES");
    d->UnmapBufferOES = (GLboolean (QOPENGLF_APIENTRYP)(GLenum target))context->getProcAddress("glUnmapBufferOES");
    d->GetBufferPointervOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLenum pname, GLvoid** params))context->getProcAddress("glGetBufferPointervOES");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_OES_texture_3D::QOpenGLExtension_OES_texture_3D()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_OES_texture_3DPrivate))
{
}

bool QOpenGLExtension_OES_texture_3D::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_OES_texture_3D);

    d->TexImage3DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels))context->getProcAddress("glTexImage3DOES");
    d->TexSubImage3DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels))context->getProcAddress("glTexSubImage3DOES");
    d->CopyTexSubImage3DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height))context->getProcAddress("glCopyTexSubImage3DOES");
    d->CompressedTexImage3DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data))context->getProcAddress("glCompressedTexImage3DOES");
    d->CompressedTexSubImage3DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data))context->getProcAddress("glCompressedTexSubImage3DOES");
    d->FramebufferTexture3DOES = (void (QOPENGLF_APIENTRYP)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset))context->getProcAddress("glFramebufferTexture3DOES");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_OES_vertex_array_object::QOpenGLExtension_OES_vertex_array_object()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_OES_vertex_array_objectPrivate))
{
}

bool QOpenGLExtension_OES_vertex_array_object::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_OES_vertex_array_object);

    d->BindVertexArrayOES = (void (QOPENGLF_APIENTRYP)(GLuint array))context->getProcAddress("glBindVertexArrayOES");
    d->DeleteVertexArraysOES = (void (QOPENGLF_APIENTRYP)(GLsizei n, const GLuint *arrays))context->getProcAddress("glDeleteVertexArraysOES");
    d->GenVertexArraysOES = (void (QOPENGLF_APIENTRYP)(GLsizei n, GLuint *arrays))context->getProcAddress("glGenVertexArraysOES");
    d->IsVertexArrayOES = (GLboolean (QOPENGLF_APIENTRYP)(GLuint array))context->getProcAddress("glIsVertexArrayOES");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_AMD_performance_monitor::QOpenGLExtension_AMD_performance_monitor()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_AMD_performance_monitorPrivate))
{
}

bool QOpenGLExtension_AMD_performance_monitor::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_AMD_performance_monitor);

    d->GetPerfMonitorGroupsAMD = (void (QOPENGLF_APIENTRYP)(GLint *numGroups, GLsizei groupsSize, GLuint *groups))context->getProcAddress("glGetPerfMonitorGroupsAMD");
    d->GetPerfMonitorCountersAMD = (void (QOPENGLF_APIENTRYP)(GLuint group, GLint *numCounters, GLint *maxActiveCounters, GLsizei counterSize, GLuint *counters))context->getProcAddress("glGetPerfMonitorCountersAMD");
    d->GetPerfMonitorGroupStringAMD = (void (QOPENGLF_APIENTRYP)(GLuint group, GLsizei bufSize, GLsizei *length, GLchar *groupString))context->getProcAddress("glGetPerfMonitorGroupStringAMD");
    d->GetPerfMonitorCounterStringAMD = (void (QOPENGLF_APIENTRYP)(GLuint group, GLuint counter, GLsizei bufSize, GLsizei *length, GLchar *counterString))context->getProcAddress("glGetPerfMonitorCounterStringAMD");
    d->GetPerfMonitorCounterInfoAMD = (void (QOPENGLF_APIENTRYP)(GLuint group, GLuint counter, GLenum pname, GLvoid *data))context->getProcAddress("glGetPerfMonitorCounterInfoAMD");
    d->GenPerfMonitorsAMD = (void (QOPENGLF_APIENTRYP)(GLsizei n, GLuint *monitors))context->getProcAddress("glGenPerfMonitorsAMD");
    d->DeletePerfMonitorsAMD = (void (QOPENGLF_APIENTRYP)(GLsizei n, GLuint *monitors))context->getProcAddress("glDeletePerfMonitorsAMD");
    d->SelectPerfMonitorCountersAMD = (void (QOPENGLF_APIENTRYP)(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint *countersList))context->getProcAddress("glSelectPerfMonitorCountersAMD");
    d->BeginPerfMonitorAMD = (void (QOPENGLF_APIENTRYP)(GLuint monitor))context->getProcAddress("glBeginPerfMonitorAMD");
    d->EndPerfMonitorAMD = (void (QOPENGLF_APIENTRYP )(GLuint monitor))context->getProcAddress("glEndPerfMonitorAMD");
    d->GetPerfMonitorCounterDataAMD = (void (QOPENGLF_APIENTRYP)(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint *data, GLint *bytesWritten))context->getProcAddress("glGetPerfMonitorCounterDataAMD");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_ANGLE_framebuffer_blit::QOpenGLExtension_ANGLE_framebuffer_blit()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_ANGLE_framebuffer_blitPrivate))
{
}

bool QOpenGLExtension_ANGLE_framebuffer_blit::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ANGLE_framebuffer_blit);

    d->BlitFramebufferANGLE = (void (QOPENGLF_APIENTRYP)(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter))context->getProcAddress("glBlitFramebufferANGLE");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_ANGLE_framebuffer_multisample::QOpenGLExtension_ANGLE_framebuffer_multisample()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_ANGLE_framebuffer_multisamplePrivate))
{
}

bool QOpenGLExtension_ANGLE_framebuffer_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ANGLE_framebuffer_multisample);

    d->RenderbufferStorageMultisampleANGLE = (void (QOPENGLF_APIENTRYP)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))context->getProcAddress("glRenderbufferStorageMultisampleANGLE");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_ANGLE_instanced_arrays::QOpenGLExtension_ANGLE_instanced_arrays()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_ANGLE_instanced_arraysPrivate))
{
}

bool QOpenGLExtension_ANGLE_instanced_arrays::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ANGLE_instanced_arrays);

    d->DrawArraysInstancedANGLE = (void (QOPENGLF_APIENTRYP)(GLenum mode, GLint first, GLsizei count, GLsizei primcount))context->getProcAddress("glDrawArraysInstancedANGLE");
    d->DrawElementsInstancedANGLE = (void (QOPENGLF_APIENTRYP)(GLenum mode, GLsizei count, GLenum type, const void *indices, GLsizei primcount))context->getProcAddress("glDrawElementsInstancedANGLE");
    d->VertexAttribDivisorANGLE = (void (QOPENGLF_APIENTRYP)(GLuint index, GLuint divisor))context->getProcAddress("glVertexAttribDivisorANGLE");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_ANGLE_translated_shader_source::QOpenGLExtension_ANGLE_translated_shader_source()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_ANGLE_translated_shader_sourcePrivate))
{
}

bool QOpenGLExtension_ANGLE_translated_shader_source::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_ANGLE_translated_shader_source);

    d->GetTranslatedShaderSourceANGLE = (void (QOPENGLF_APIENTRYP)(GLuint shader, GLsizei bufsize, GLsizei *length, GLchar *source))context->getProcAddress("glGetTranslatedShaderSourceANGLE");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_APPLE_framebuffer_multisample::QOpenGLExtension_APPLE_framebuffer_multisample()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_APPLE_framebuffer_multisamplePrivate))
{
}

bool QOpenGLExtension_APPLE_framebuffer_multisample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_APPLE_framebuffer_multisample);

    d->RenderbufferStorageMultisampleAPPLE = (void (QOPENGLF_APIENTRYP)(GLenum, GLsizei, GLenum, GLsizei, GLsizei))context->getProcAddress("glRenderbufferStorageMultisampleAPPLE");
    d->ResolveMultisampleFramebufferAPPLE = (void (QOPENGLF_APIENTRYP)(void))context->getProcAddress("glResolveMultisampleFramebufferAPPLE");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_debug_label::QOpenGLExtension_EXT_debug_label()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_debug_labelPrivate))
{
}

bool QOpenGLExtension_EXT_debug_label::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_debug_label);

    d->LabelObjectEXT = (void (QOPENGLF_APIENTRYP)(GLenum type, GLuint object, GLsizei length, const GLchar *label))context->getProcAddress("glLabelObjectEXT");
    d->GetObjectLabelEXT = (void (QOPENGLF_APIENTRYP)(GLenum type, GLuint object, GLsizei bufSize, GLsizei *length, GLchar *label))context->getProcAddress("glGetObjectLabelEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_debug_marker::QOpenGLExtension_EXT_debug_marker()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_debug_markerPrivate))
{
}

bool QOpenGLExtension_EXT_debug_marker::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_debug_marker);

    d->InsertEventMarkerEXT = (void (QOPENGLF_APIENTRYP)(GLsizei length, const GLchar *marker))context->getProcAddress("glInsertEventMarkerEXT");
    d->PushGroupMarkerEXT = (void (QOPENGLF_APIENTRYP)(GLsizei length, const GLchar *marker))context->getProcAddress("glPushGroupMarkerEXT");
    d->PopGroupMarkerEXT = (void (QOPENGLF_APIENTRYP)(void))context->getProcAddress("glPopGroupMarkerEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_discard_framebuffer::QOpenGLExtension_EXT_discard_framebuffer()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_discard_framebufferPrivate))
{
}

bool QOpenGLExtension_EXT_discard_framebuffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_discard_framebuffer);

    d->DiscardFramebufferEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLsizei numAttachments, const GLenum *attachments))context->getProcAddress("glDiscardFramebufferEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_multisampled_render_to_texture::QOpenGLExtension_EXT_multisampled_render_to_texture()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_multisampled_render_to_texturePrivate))
{
}

bool QOpenGLExtension_EXT_multisampled_render_to_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_multisampled_render_to_texture);

    d->RenderbufferStorageMultisampleEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height))context->getProcAddress("glRenderbufferStorageMultisampleEXT");
    d->FramebufferTexture2DMultisampleEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLsizei samples))context->getProcAddress("glFramebufferTexture2DMultisampleEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_multi_draw_arrays::QOpenGLExtension_EXT_multi_draw_arrays()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_multi_draw_arraysPrivate))
{
}

bool QOpenGLExtension_EXT_multi_draw_arrays::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_multi_draw_arrays);

    d->MultiDrawArraysEXT = (void (QOPENGLF_APIENTRYP)(GLenum mode, GLint *first, GLsizei *count, GLsizei primcount))context->getProcAddress("glMultiDrawArraysEXT");
    d->MultiDrawElementsEXT = (void (QOPENGLF_APIENTRYP)(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* *indices, GLsizei primcount))context->getProcAddress("glMultiDrawElementsEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_occlusion_query_boolean::QOpenGLExtension_EXT_occlusion_query_boolean()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_occlusion_query_booleanPrivate))
{
}

bool QOpenGLExtension_EXT_occlusion_query_boolean::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_occlusion_query_boolean);

    d->GenQueriesEXT = (void (QOPENGLF_APIENTRYP)(GLsizei n, GLuint *ids))context->getProcAddress("glGenQueriesEXT");
    d->DeleteQueriesEXT = (void (QOPENGLF_APIENTRYP)(GLsizei n, const GLuint *ids))context->getProcAddress("glDeleteQueriesEXT");
    d->IsQueryEXT = (GLboolean (QOPENGLF_APIENTRYP)(GLuint id))context->getProcAddress("glIsQueryEXT");
    d->BeginQueryEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLuint id))context->getProcAddress("glBeginQueryEXT");
    d->EndQueryEXT = (void (QOPENGLF_APIENTRYP)(GLenum target))context->getProcAddress("glEndQueryEXT");
    d->GetQueryivEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLenum pname, GLint *params))context->getProcAddress("glGetQueryivEXT");
    d->GetQueryObjectuivEXT = (void (QOPENGLF_APIENTRYP)(GLuint id, GLenum pname, GLuint *params))context->getProcAddress("glGetQueryObjectuivEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_robustness::QOpenGLExtension_EXT_robustness()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_robustnessPrivate))
{
}

bool QOpenGLExtension_EXT_robustness::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_robustness);

    d->GetGraphicsResetStatusEXT = (GLenum (QOPENGLF_APIENTRYP)(void))context->getProcAddress("glGetGraphicsResetStatusEXT");
    d->ReadnPixelsEXT = (void (QOPENGLF_APIENTRYP)(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void *data))context->getProcAddress("glReadnPixelsEXT");
    d->GetnUniformfvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei bufSize, float *params))context->getProcAddress("glGetnUniformfvEXT");
    d->GetnUniformivEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei bufSize, GLint *params))context->getProcAddress("glGetnUniformivEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_separate_shader_objects::QOpenGLExtension_EXT_separate_shader_objects()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_separate_shader_objectsPrivate))
{
}

bool QOpenGLExtension_EXT_separate_shader_objects::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_separate_shader_objects);

    d->UseProgramStagesEXT = (void (QOPENGLF_APIENTRYP)(GLuint pipeline, GLbitfield stages, GLuint program))context->getProcAddress("glUseProgramStagesEXT");
    d->ActiveShaderProgramEXT = (void (QOPENGLF_APIENTRYP)(GLuint pipeline, GLuint program))context->getProcAddress("glActiveShaderProgramEXT");
    d->CreateShaderProgramvEXT = (GLuint (QOPENGLF_APIENTRYP)(GLenum type, GLsizei count, const GLchar **strings))context->getProcAddress("glCreateShaderProgramvEXT");
    d->BindProgramPipelineEXT = (void (QOPENGLF_APIENTRYP)(GLuint pipeline))context->getProcAddress("glBindProgramPipelineEXT");
    d->DeleteProgramPipelinesEXT = (void (QOPENGLF_APIENTRYP)(GLsizei n, const GLuint *pipelines))context->getProcAddress("glDeleteProgramPipelinesEXT");
    d->GenProgramPipelinesEXT = (void (QOPENGLF_APIENTRYP)(GLsizei n, GLuint *pipelines))context->getProcAddress("glGenProgramPipelinesEXT");
    d->IsProgramPipelineEXT = (GLboolean (QOPENGLF_APIENTRYP)(GLuint pipeline))context->getProcAddress("glIsProgramPipelineEXT");
    d->ProgramParameteriEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLenum pname, GLint value))context->getProcAddress("glProgramParameteriEXT");
    d->GetProgramPipelineivEXT = (void (QOPENGLF_APIENTRYP)(GLuint pipeline, GLenum pname, GLint *params))context->getProcAddress("glGetProgramPipelineivEXT");
    d->ProgramUniform1iEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLint x))context->getProcAddress("glProgramUniform1iEXT");
    d->ProgramUniform2iEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLint x, GLint y))context->getProcAddress("glProgramUniform2iEXT");
    d->ProgramUniform3iEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLint x, GLint y, GLint z))context->getProcAddress("glProgramUniform3iEXT");
    d->ProgramUniform4iEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w))context->getProcAddress("glProgramUniform4iEXT");
    d->ProgramUniform1fEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLfloat x))context->getProcAddress("glProgramUniform1fEXT");
    d->ProgramUniform2fEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLfloat x, GLfloat y))context->getProcAddress("glProgramUniform2fEXT");
    d->ProgramUniform3fEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z))context->getProcAddress("glProgramUniform3fEXT");
    d->ProgramUniform4fEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w))context->getProcAddress("glProgramUniform4fEXT");
    d->ProgramUniform1ivEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLint *value))context->getProcAddress("glProgramUniform1ivEXT");
    d->ProgramUniform2ivEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLint *value))context->getProcAddress("glProgramUniform2ivEXT");
    d->ProgramUniform3ivEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLint *value))context->getProcAddress("glProgramUniform3ivEXT");
    d->ProgramUniform4ivEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLint *value))context->getProcAddress("glProgramUniform4ivEXT");
    d->ProgramUniform1fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLfloat *value))context->getProcAddress("glProgramUniform1fvEXT");
    d->ProgramUniform2fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLfloat *value))context->getProcAddress("glProgramUniform2fvEXT");
    d->ProgramUniform3fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLfloat *value))context->getProcAddress("glProgramUniform3fvEXT");
    d->ProgramUniform4fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, const GLfloat *value))context->getProcAddress("glProgramUniform4fvEXT");
    d->ProgramUniformMatrix2fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))context->getProcAddress("glProgramUniformMatrix2fvEXT");
    d->ProgramUniformMatrix3fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))context->getProcAddress("glProgramUniformMatrix3fvEXT");
    d->ProgramUniformMatrix4fvEXT = (void (QOPENGLF_APIENTRYP)(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat *value))context->getProcAddress("glProgramUniformMatrix4fvEXT");
    d->ValidateProgramPipelineEXT = (void (QOPENGLF_APIENTRYP)(GLuint pipeline))context->getProcAddress("glValidateProgramPipelineEXT");
    d->GetProgramPipelineInfoLogEXT = (void (QOPENGLF_APIENTRYP)(GLuint pipeline, GLsizei bufSize, GLsizei *length, GLchar *infoLog))context->getProcAddress("glGetProgramPipelineInfoLogEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_EXT_texture_storage::QOpenGLExtension_EXT_texture_storage()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_EXT_texture_storagePrivate))
{
}

bool QOpenGLExtension_EXT_texture_storage::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_EXT_texture_storage);

    d->TexStorage1DEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))context->getProcAddress("glTexStorage1DEXT");
    d->TexStorage2DEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))context->getProcAddress("glTexStorage2DEXT");
    d->TexStorage3DEXT = (void (QOPENGLF_APIENTRYP)(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))context->getProcAddress("glTexStorage3DEXT");
    d->TextureStorage1DEXT = (void (QOPENGLF_APIENTRYP)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width))context->getProcAddress("glTextureStorage1DEXT");
    d->TextureStorage2DEXT = (void (QOPENGLF_APIENTRYP)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height))context->getProcAddress("glTextureStorage2DEXT");
    d->TextureStorage3DEXT = (void (QOPENGLF_APIENTRYP)(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth))context->getProcAddress("glTextureStorage3DEXT");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_IMG_multisampled_render_to_texture::QOpenGLExtension_IMG_multisampled_render_to_texture()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_IMG_multisampled_render_to_texturePrivate))
{
}

bool QOpenGLExtension_IMG_multisampled_render_to_texture::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_IMG_multisampled_render_to_texture);

    d->RenderbufferStorageMultisampleIMG = (void (QOPENGLF_APIENTRYP)(GLenum, GLsizei, GLenum, GLsizei, GLsizei))context->getProcAddress("glRenderbufferStorageMultisampleIMG");
    d->FramebufferTexture2DMultisampleIMG = (void (QOPENGLF_APIENTRYP)(GLenum, GLenum, GLenum, GLuint, GLint, GLsizei))context->getProcAddress("glFramebufferTexture2DMultisampleIMG");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_NV_coverage_sample::QOpenGLExtension_NV_coverage_sample()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_coverage_samplePrivate))
{
}

bool QOpenGLExtension_NV_coverage_sample::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_coverage_sample);

    d->CoverageMaskNV = (void (QOPENGLF_APIENTRYP)(GLboolean mask))context->getProcAddress("glCoverageMaskNV");
    d->CoverageOperationNV = (void (QOPENGLF_APIENTRYP)(GLenum operation))context->getProcAddress("glCoverageOperationNV");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_NV_draw_buffers::QOpenGLExtension_NV_draw_buffers()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_draw_buffersPrivate))
{
}

bool QOpenGLExtension_NV_draw_buffers::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_draw_buffers);

    d->DrawBuffersNV = (void (QOPENGLF_APIENTRYP)(GLsizei n, const GLenum *bufs))context->getProcAddress("glDrawBuffersNV");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_NV_fence::QOpenGLExtension_NV_fence()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_fencePrivate))
{
}

bool QOpenGLExtension_NV_fence::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_fence);

    d->DeleteFencesNV = (void (QOPENGLF_APIENTRYP)(GLsizei n, const GLuint *fences))context->getProcAddress("glDeleteFencesNV");
    d->GenFencesNV = (void (QOPENGLF_APIENTRYP)(GLsizei n, GLuint *fences))context->getProcAddress("glGenFencesNV");
    d->IsFenceNV = (GLboolean (QOPENGLF_APIENTRYP)(GLuint fence))context->getProcAddress("glIsFenceNV");
    d->TestFenceNV = (GLboolean (QOPENGLF_APIENTRYP)(GLuint fence))context->getProcAddress("glTestFenceNV");
    d->GetFenceivNV = (void (QOPENGLF_APIENTRYP)(GLuint fence, GLenum pname, GLint *params))context->getProcAddress("glGetFenceivNV");
    d->FinishFenceNV = (void (QOPENGLF_APIENTRYP)(GLuint fence))context->getProcAddress("glFinishFenceNV");
    d->SetFenceNV = (void (QOPENGLF_APIENTRYP)(GLuint fence, GLenum condition))context->getProcAddress("glSetFenceNV");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_NV_read_buffer::QOpenGLExtension_NV_read_buffer()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_NV_read_bufferPrivate))
{
}

bool QOpenGLExtension_NV_read_buffer::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_NV_read_buffer);

    d->ReadBufferNV = (void (QOPENGLF_APIENTRYP)(GLenum mode))context->getProcAddress("glReadBufferNV");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_QCOM_alpha_test::QOpenGLExtension_QCOM_alpha_test()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_QCOM_alpha_testPrivate))
{
}

bool QOpenGLExtension_QCOM_alpha_test::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_QCOM_alpha_test);

    d->AlphaFuncQCOM = (void (QOPENGLF_APIENTRYP )(GLenum func, GLclampf ref))context->getProcAddress("glAlphaFuncQCOM");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_QCOM_driver_control::QOpenGLExtension_QCOM_driver_control()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_QCOM_driver_controlPrivate))
{
}

bool QOpenGLExtension_QCOM_driver_control::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_QCOM_driver_control);

    d->GetDriverControlsQCOM = (void (QOPENGLF_APIENTRYP)(GLint *num, GLsizei size, GLuint *driverControls))context->getProcAddress("glGetDriverControlsQCOM");
    d->GetDriverControlStringQCOM = (void (QOPENGLF_APIENTRYP)(GLuint driverControl, GLsizei bufSize, GLsizei *length, GLchar *driverControlString))context->getProcAddress("glGetDriverControlStringQCOM");
    d->EnableDriverControlQCOM = (void (QOPENGLF_APIENTRYP)(GLuint driverControl))context->getProcAddress("glEnableDriverControlQCOM");
    d->DisableDriverControlQCOM = (void (QOPENGLF_APIENTRYP)(GLuint driverControl))context->getProcAddress("glDisableDriverControlQCOM");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_QCOM_extended_get::QOpenGLExtension_QCOM_extended_get()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_QCOM_extended_getPrivate))
{
}

bool QOpenGLExtension_QCOM_extended_get::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_QCOM_extended_get);

    d->ExtGetTexturesQCOM = (void (QOPENGLF_APIENTRYP)(GLuint *textures, GLint maxTextures, GLint *numTextures))context->getProcAddress("glExtGetTexturesQCOM");
    d->ExtGetBuffersQCOM = (void (QOPENGLF_APIENTRYP)(GLuint *buffers, GLint maxBuffers, GLint *numBuffers))context->getProcAddress("glExtGetBuffersQCOM");
    d->ExtGetRenderbuffersQCOM = (void (QOPENGLF_APIENTRYP)(GLuint *renderbuffers, GLint maxRenderbuffers, GLint *numRenderbuffers))context->getProcAddress("glExtGetRenderbuffersQCOM");
    d->ExtGetFramebuffersQCOM = (void (QOPENGLF_APIENTRYP)(GLuint *framebuffers, GLint maxFramebuffers, GLint *numFramebuffers))context->getProcAddress("glExtGetFramebuffersQCOM");
    d->ExtGetTexLevelParameterivQCOM = (void (QOPENGLF_APIENTRYP)(GLuint texture, GLenum face, GLint level, GLenum pname, GLint *params))context->getProcAddress("glExtGetTexLevelParameterivQCOM");
    d->ExtTexObjectStateOverrideiQCOM = (void (QOPENGLF_APIENTRYP)(GLenum target, GLenum pname, GLint param))context->getProcAddress("glExtTexObjectStateOverrideiQCOM");
    d->ExtGetTexSubImageQCOM = (void (QOPENGLF_APIENTRYP)(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, GLvoid *texels))context->getProcAddress("glExtGetTexSubImageQCOM");
    d->ExtGetBufferPointervQCOM = (void (QOPENGLF_APIENTRYP)(GLenum target, GLvoid **params))context->getProcAddress("glExtGetBufferPointervQCOM");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_QCOM_extended_get2::QOpenGLExtension_QCOM_extended_get2()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_QCOM_extended_get2Private))
{
}

bool QOpenGLExtension_QCOM_extended_get2::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_QCOM_extended_get2);

    d->ExtGetShadersQCOM = (void (QOPENGLF_APIENTRYP)(GLuint *shaders, GLint maxShaders, GLint *numShaders))context->getProcAddress("glExtGetShadersQCOM");
    d->ExtGetProgramsQCOM = (void (QOPENGLF_APIENTRYP)(GLuint *programs, GLint maxPrograms, GLint *numPrograms))context->getProcAddress("glExtGetProgramsQCOM");
    d->ExtIsProgramBinaryQCOM = (GLboolean (QOPENGLF_APIENTRYP)(GLuint program))context->getProcAddress("glExtIsProgramBinaryQCOM");
    d->ExtGetProgramBinarySourceQCOM = (void (QOPENGLF_APIENTRYP)(GLuint program, GLenum shadertype, GLchar *source, GLint *length))context->getProcAddress("glExtGetProgramBinarySourceQCOM");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

QOpenGLExtension_QCOM_tiled_rendering::QOpenGLExtension_QCOM_tiled_rendering()
    : QAbstractOpenGLExtension(*(new QOpenGLExtension_QCOM_tiled_renderingPrivate))
{
}

bool QOpenGLExtension_QCOM_tiled_rendering::initializeOpenGLFunctions()
{
    if (isInitialized())
        return true;

    QOpenGLContext *context = QOpenGLContext::currentContext();
    if (!context) {
        qWarning("A current OpenGL context is required to resolve OpenGL extension functions");
        return false;
    }

    // Resolve the functions
    Q_D(QOpenGLExtension_QCOM_tiled_rendering);

    d->StartTilingQCOM = (void (QOPENGLF_APIENTRYP)(GLuint x, GLuint y, GLuint width, GLuint height, GLbitfield preserveMask))context->getProcAddress("glStartTilingQCOM");
    d->EndTilingQCOM = (void (QOPENGLF_APIENTRYP)(GLbitfield preserveMask))context->getProcAddress("glEndTilingQCOM");
    return QAbstractOpenGLExtension::initializeOpenGLFunctions();
}

#endif

QT_END_NAMESPACE

#ifdef Q_OS_WIN
#pragma pop_macro("MemoryBarrier")
#endif
