% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colOrderStats.R, R/rowOrderStats.R
\name{colOrderStats,DelayedMatrix-method}
\alias{colOrderStats,DelayedMatrix-method}
\alias{rowOrderStats,DelayedMatrix-method}
\title{Calculates an order statistic for each row (column) of a matrix-like object}
\usage{
\S4method{colOrderStats}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  which,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)

\S4method{rowOrderStats}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  which,
  force_block_processing = FALSE,
  ...,
  useNames = TRUE
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{which}{An integer index in [1,K] ([1,N]) indicating which order
statistic to be returned}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates an order statistic for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowOrderStats}} /
\code{matrixStats::\link[matrixStats]{colOrderStats}}.
}
\examples{
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))
# Only using columns 2-3
colOrderStats(dm_Matrix, cols = 2:3, which = 1)

# Different algorithms, specified by `which`, may give different results
rowOrderStats(dm_Matrix, which = 1)
rowOrderStats(dm_Matrix, which = 2)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowOrderStats}()} and
\code{matrixStats::\link[matrixStats:rowOrderStats]{colOrderStats}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
}
}
\author{
Peter Hickey
}
