% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5S_extras.R
\name{H5Sselect_index}
\alias{H5Sselect_index}
\title{Select elements of a dataspace using R-style indexing}
\usage{
H5Sselect_index(h5space, index)
}
\arguments{
\item{h5space}{\linkS4class{H5IdComponent} object representing a dataspace.}

\item{index}{A list of integer indices. The length of the list corresponds to
the number of dimensions of the HDF5 array. If a list element is \code{NULL},
all elements of the respective dimension are selected.}
}
\description{
Combines a hyperslab selection specified by \code{start}, \code{stride}, \code{count} and
\code{block} arguments with the current selection for the dataspace represented by
\code{h5space}.
}
\details{
\code{H5Sselect_hyperslab} is similar to, but subtly different from,
\code{\link[=H5Scombine_hyperslab]{H5Scombine_hyperslab()}}.  The former modifies the selection of the
dataspace provided in the \code{h5space} argument, while the later returns a new
dataspace with the combined selection.
}
\examples{

## create a 1 dimensional dataspace
sid <- H5Screate_simple(c(10,5,3))

## Select elements that lie in in the rows 1-3, columns 2-4, 
## and the entire 3rd dimension
H5Sselect_index(sid, list(1:3, 2:4, NULL))

## We can check the number of selected points. 
## This should be 27 (3 * 3 * 3)
H5Sget_select_npoints(sid)

## always close dataspaces after usage to free resources
H5Sclose(sid)

}
