% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{detect_step}
\alias{detect_step}
\title{Detect if a particular step or check is used in a recipe}
\usage{
detect_step(recipe, name)
}
\arguments{
\item{recipe}{A recipe to check.}

\item{name}{Character name of a step or check, omitted the prefix. That is,
to check if \code{step_intercept} is present, use \code{name = intercept}.}
}
\value{
Logical indicating if recipes contains given step.
}
\description{
Detect if a particular step or check is used in a recipe
}
\examples{
rec <- recipe(Species ~ ., data = iris) \%>\%
  step_intercept()

detect_step(rec, "step_intercept")
}
