% This LilyPond file was generated by Rosegarden 23.06
\include "nederlands.ly"
\version "2.12.0"
\header {
    composer = "D. Michael McIntyre"
    copyright = "Copyright © 2004 D. Michael McIntyre"
    subtitle = "The Product of a Most Pleasant Day"
    title = "The Rose Garden"
    tagline = "Created using Rosegarden 23.06 and LilyPond"
}
#(set-global-staff-size 18)
#(set-default-paper-size "a4")
global = { 
    \time 4/4
    \skip 1*132 
}
globalTempo = {
    \override Score.MetronomeMark #'transparent = ##t
    \tempo 4 = 115  
}
\score {
    << % common
        % Force offset of colliding notes in chords:
        \override Score.NoteColumn #'force-hshift = #1.0
        % Allow fingerings inside the staff (configured from export options):
        \override Score.Fingering #'staff-padding = #'()

        \context Staff = "track 2, Flute (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Flute (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Flute"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 1.0" {
                % Segment: Flute (recorded) (edited)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*4 
                \clef "treble"
                \key g \major
                R1  |
%% 5
                a'' 4 g'' 8 ^( fis'' 2 ) 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 \skip 8 r8  |
                a'' 4 g'' 8 -\tenuto fis'' 4. -\tenuto \times 2/3 { g'' 8 -\tenuto [ r e'' -\tenuto _~ ] }  |
                e'' 2 _~ e'' 4 -\staccato _~ e''  |
                d'' 2. -\tenuto d''' 4  |
%% 10
                c''' 2. b'' 8 -\tenuto [ a'' ]  |
                < b'' a'' > 4 -\tenuto-\staccato < g'' a'' > -\tenuto-\staccato b'' -\tenuto fis'' -\tenuto  |
                < g'' a'' > 4 -\tenuto-\staccato r8 fis'' -\tenuto e'' 4 -\tenuto-\staccato < d'' e'' > 8 -\tenuto fis'' -\tenuto  |
                g'' 4 -\tenuto r8 e'' 4. < g'' a'' > 4 -\staccato  |
                g'' 4. fis'' -\tenuto < e'' fis'' > 8 -\tenuto r  |
%% 15
                < g'' g'' > 4 -\tenuto-\staccato _~ < g'' fis'' > 4. -\tenuto _~ r8 d'' 4  |
                e'' 4 -\tenuto e'' -\staccato e'' -\tenuto fis'' 8 g''  |
                d'' 4. -\tenuto c'' 2 -\tenuto _~ c'' 8 -\tenuto _~  |
                c'' 2. -\tenuto _~ d'' 8. r16  |
                fis'' 4. g'' -\tenuto d'' 4 -\tenuto _~  |
%% 20
                d'' 2 -\tenuto _~ r4 d'' 8 r  |
                d'' 1 -\tenuto  |
                R1*2  |
                r2 r4 d'' -\staccato  |
%% 25
                d'' 1  |
                fis'' 4. -\tenuto g'' a'' 4  |
                < g'' fis'' > 4 -\tenuto-\staccato < e'' fis'' > 8 -\tenuto r r4 r8 g'' -\tenuto  |
                fis'' 4 -\tenuto e'' 8 -\tenuto d'' 4. -\tenuto e'' 4  |
                d'' 4. -\tenuto c'' -\tenuto b' 4 -\tenuto  |
%% 30
                a' 2. -\tenuto < b' c'' > 8 -\tenuto r  |
                < d'' c'' > 16. -\tenuto r32 r8 r g' 4. -\tenuto \times 2/3 { a' 8 -\tenuto [ b' -\tenuto ] r }  |
                c'' 4. -\tenuto fis' e' 4  |
                < g' fis' > 2 -\tenuto r4 fis' 8. -\tenuto r16  |
                fis' 4 -\tenuto _~ fis' 2 -\tenuto _~ d' 8 -\tenuto e'  |
%% 35
                fis' 1 -\tenuto _~  |
                fis' 2 -\tenuto _~ r4 g' -\staccato  |
                d'' 2. -\tenuto g'' 4  |
                fis'' 2. -\tenuto g'' 4 -\tenuto  |
                fis'' 4. -\tenuto e'' -\tenuto d'' 4 -\tenuto  |
%% 40
                g'' 4 -\tenuto r8 g'' 4. -\tenuto a'' 4  |
                g'' 4 -\tenuto fis'' 8 -\tenuto e'' -\tenuto d'' 2 -\tenuto _~  |
                d'' 1 -\tenuto _~  |
                a'' 4 -\tenuto a'' -\tenuto g'' 2  |
                R1  |
%% 45
                a'' 4 -\tenuto a'' -\tenuto g'' -\tenuto fis'' -\tenuto  |
                e'' 4. -\tenuto d'' -\tenuto fis'' 4 -\tenuto  |
                g'' 4. e'' 2 -\tenuto r8  |
                R1  |
                a'' 4 -\tenuto g'' 8 -\tenuto fis'' 2 -\tenuto _~ fis'' 8 -\tenuto _~  |
%% 50
                fis'' 1 -\tenuto _~  |
                < b'' a'' > 4 -\tenuto-\staccato g'' 8 -\tenuto fis'' 4. -\tenuto e'' 4 -\tenuto  |
                < fis'' g'' > 4 -\staccato < fis'' e'' > -\tenuto-\staccato < fis'' e'' > -\tenuto-\staccato < g'' e'' > -\tenuto-\staccato  |
                d'' 4 -\tenuto e'' 8 -\tenuto fis'' 2 r8  |
                e'' 2. -\tenuto fis'' 4 -\tenuto 
                % warning: overlong bar truncated here |
%% 55
                \skip 8 r8 fis'' 4 -\staccato fis'' -\tenuto e''  |
                fis'' 8 -\tenuto [ e'' -\tenuto < d'' e'' > -\tenuto ) ^( ] r r4 d'' -\staccato  |
                d'' 1 -\tenuto _~  |
                d'' 2 -\tenuto _~ c'' 4 -\tenuto d'' -\staccato  |
                d'' 1 -\tenuto 
                % warning: overlong bar truncated here |
%% 60
                \skip 2 b' 4 -\tenuto d''  |
                d'' 1  |
                R1*3  |
%% 65
                a'' 4 g'' 8 -\tenuto fis'' 2 -\tenuto _~ fis'' 8 -\tenuto _~  |
                fis'' 1 -\tenuto _~  |
                a'' 4 -\tenuto g'' 8 -\tenuto fis'' 4. -\tenuto \times 2/3 { g'' 8 -\tenuto [ r fis'' -\tenuto _~ ] }  |
                fis'' 4 -\tenuto _~ e'' 8 -\tenuto fis'' 4 -\tenuto g'' 8 -\tenuto fis'' [ e'' ]  |
                d'' 4 -\tenuto e'' -\tenuto fis'' -\tenuto c'' -\tenuto  |
%% 70
                d'' 8 -\tenuto e'' 4. -\tenuto d'' 2 -\tenuto _~  |
                d'' 1 -\tenuto _~  |
                d'' 2. -\tenuto _~ d''' 8 r  |
                d''' 1  |
                c''' 2. -\tenuto b'' 4 -\tenuto  |
%% 75
                < c''' b'' > 4 -\tenuto-\staccato < a'' b'' > 8 -\tenuto r r2  |
                b'' 4. a'' -\tenuto g'' 4 -\tenuto  |
                a'' 4 -\tenuto < g'' fis'' > 2 -\tenuto r4  |
                fis'' 2. -\tenuto < e'' fis'' > 4 -\tenuto-\staccato  |
                g'' 4. a'' -\tenuto < fis'' e'' > 4 -\tenuto-\staccato  |
%% 80
                < fis'' e'' > 4 -\staccato < d'' e'' > -\tenuto-\staccato fis'' d'' 16 -\staccato e'' 8 -\staccato-\tenuto r16  |
                e'' 4 d'' -\staccato d'' 2 -\tenuto _~  |
                d'' 2 -\tenuto _~ r8 b' 4 -\tenuto r8  |
                b' 4 -\tenuto d'' -\tenuto r8 d'' 4.  |
                d'' 4. -\tenuto b' d'' 8 r  |
%% 85
                d'' 1  |
                R1  |
                r2 d'' 8. r16 d'' 16. r32 r8  |
                d'' 4. -\tenuto b' -\tenuto d'' 8 r  |
                a'' 4 a'' 8 -\tenuto g'' 2 _~ g'' 8 _~  |
%% 90
                g'' 1 _~  |
                a'' 4 -\tenuto g'' 8 -\tenuto fis'' 4. -\tenuto g'' 8 -\tenuto fis'' -\tenuto _~  |
                fis'' 4 -\tenuto _~ e'' 8 -\tenuto fis'' 4 -\tenuto g'' 8 -\tenuto [ fis'' ] e'' -\staccato  |
                d'' 2 fis'' 4 -\tenuto e''  |
                < g'' fis'' > 2 -\tenuto r4 e'' -\staccato  |
%% 95
                d'' 1 -\tenuto  |
                R1*5  |
                r2 \times 2/3 { a'' 8 [ r g'' -\staccato ] } fis'' -\staccato g'' 16 r  |
                a'' 4 -\tenuto r8 g'' 4. -\tenuto r4  |
                R1  |
                \times 2/3 { a'' 8 -\tenuto [ g'' -\staccato ] r } fis'' r e'' 4 -\staccato fis'' 8 r  |
%% 105
                g'' 1  |
                < g'' fis'' > 8 -\tenuto-\staccato r e'' -\tenuto fis'' ^( r ) g'' 4 a''  |
                d'' 4. -\tenuto d''' -\tenuto < c''' b'' > 8 -\tenuto r  |
                c''' 4 -\tenuto < b'' a'' > -\tenuto-\staccato r8 b'' -\tenuto c''' 4  |
                b'' 4. -\tenuto a'' 2 -\tenuto r8  |
%% 110
                c''' 4 -\tenuto < b'' a'' > 4. -\tenuto r8 g'' -\tenuto [ fis'' ]  |
                g'' 4 -\tenuto a'' 8 -\staccato a'' 4. -\tenuto r8 a''  |
                g'' 4 -\tenuto fis'' -\tenuto e'' -\tenuto d'' 8 -\tenuto e'' 32 -\staccato r r16  |
                d''' 4. -\tenuto c''' -\tenuto b'' 4 -\tenuto  |
                a'' 2. -\tenuto d'' 4  |
%% 115
                d''' 4. -\tenuto c''' -\tenuto < b'' a'' > 4 -\tenuto-\staccato  |
                b'' 4 -\tenuto a'' < g'' fis'' > 8 r g'' 4  |
                a'' 4. g'' 2 -\tenuto r8  |
                r2 r4 g'' 8 r  |
                a'' 4 -\tenuto r8 g'' 2 -\tenuto r8  |
%% 120
                R1*5  |
%% 125
                a'' 4 -\tenuto g'' 8 -\staccato fis'' 2 -\tenuto r8  |
                R1  |
                a'' 8. r16 g'' 8 -\tenuto-\staccato fis'' 2 fis'' 8 -\staccato  |
                g'' 8. r16 fis'' 4 \times 2/3 { e'' 8 -\tenuto [ d'' -\tenuto ] r } e'' 16 -\tenuto \times 2/3 { fis'' 8 -\staccato r } 
                % warning: bar too short, padding with rests
                % 487680 + 3760 < 491520  &&  47/48 < 4/4
                r64  |
                g'' 4. e'' 2 -\tenuto r8  |
%% 130
                < d''' c''' > 8 -\tenuto r b'' -\tenuto-\staccato r64 r a'' 2 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 r2  |
                \bar "|."
            } % Voice

            % End of segment Flute (recorded) (edited)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 3, Kalimba (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Kalimba (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Kalimba"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 2.0" {
                % Segment: Kalimba (recorded) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*12 
                \key g \major
                r2 r4 r8 a' 16 r  |
                a' 4 -\staccato r8 g' 4 r8 fis' -\staccato r  |
                g' 4 r8 a' 4 r8 r a' 16 r  |
%% 15
                a' 4 -\staccato r8 g' 4 r8 fis' r  |
                g' 4 -\staccato fis' 16 r e' 4 -\tenuto r8 fis' r  |
                g' 4 -\tenuto r8 d' 4 -\tenuto r8 r4  |
                R1  |
                g' 4 -\tenuto r8 d' 4. r4  |
%% 20
                fis' 8 r g' r a' r b' r  |
                a' 4 -\tenuto r8 g' 4 r8 r4  |
                R1  |
                b' 4 r b' 4. r8  |
                b' 8 r a' r g' r a' r  |
%% 25
                g' 4 r8 fis' 4. r4  |
                g' 8 r fis' -\staccato e' 4 -\tenuto-\staccato fis' 8. r16 r8  |
                g' 4 -\staccato fis' 8 -\staccato [ e' ] r d' 4 -\staccato e' 8 -\tenuto  |
                r8 fis' r g' 4 -\staccato a' 8 -\staccato g' -\staccato fis' 16 -\staccato r  |
                < g' fis' > 8 -\staccato-\tenuto r < e' fis' > -\tenuto-\staccato r g' 4. -\tenuto r8  |
%% 30
                R1  |
                g' 8 -\staccato fis' 16 -\staccato r < e' fis' > 8 -\staccato r ) g' 4 -\staccato d'' 8 r  |
                c'' 8 -\tenuto-\staccato b' 4 -\staccato a' -\tenuto r8 g' r  |
                fis' 4 r8 g' 4 -\tenuto r8 a' r  |
                g' 4 -\tenuto r8 fis' 4 -\tenuto r8 e' r  |
%% 35
                fis' 4 -\tenuto r8 g' 4 -\tenuto r8 a' 4 -\staccato  |
                g' 8 -\staccato [ fis' ] r e' 4 -\staccato d' 16 r e' -\staccato r fis' -\staccato r  |
                g' 16. r32 g' 8. r16 fis' 8 -\staccato fis' 4 r  |
                R1  |
                g' 8 -\staccato g' 4 -\staccato fis' 16 -\staccato r fis' 8 r e' 16 r e' 8 
                % warning: overlong bar truncated here |
%% 40
                \skip 16 r16 fis' r fis' r g' 8 -\staccato [ fis' -\staccato e' 16 ] r d' r e' -\staccato r  |
                fis' 4 -\staccato r8 e' 16 -\staccato r e' 16. r32 r8 r4  |
                R1  |
                fis' 4 -\staccato r8 e' 16 r e' 4 r8 fis' -\tenuto  |
                r8 e' 4 -\staccato fis' 16 r g' 16. r32 r8 a' r  |
%% 45
                g' 8 -\staccato g' 16. r32 ) r8 fis' -\staccato fis' r e' 16. r32 d'' 8  |
                r8 c'' -\staccato b' -\staccato a' -\staccato b' r a' r  |
                g' 8 -\staccato [ g' ] r fis' 16 r fis' 8 r e' 16 r d'' 16. r32  |
                r8 c'' -\staccato b' -\staccato a' -\staccato b' -\staccato [ a' -\staccato ] g' -\staccato a' 16 -\staccato r  |
                b' 4 r8 a' 16 r a' 4 r  |
%% 50
                R1  |
                b' 4 r8 a' -\staccato a' 4 -\staccato g' 16 r g' 8 -\tenuto  |
                r8 a' 4 -\staccato b' -\staccato a' 8 -\staccato g' -\tenuto fis' -\staccato  |
                g' 4 r8 e' 16 r e' 4 -\staccato r  |
                R1  |
%% 55
                g' 8. r16 r8 e' 16 r e' 4 -\staccato fis' 16 r fis' 8 -\tenuto  |
                r8 g' 4 -\staccato a' -\staccato g' 8 -\staccato fis' 16 r g' r  |
                fis' 8 r e' -\staccato r d' r r d'' -\tenuto  |
                r8 d'' 4 -\staccato c'' 8 -\staccato d'' -\staccato c'' -\staccato b' -\staccato c'' -\staccato  |
                d'' 8 -\tenuto-\staccato d'' 4 -\staccato c'' 8 -\staccato < b' c'' > 4 -\staccato b' 16 r b' 8 
                % warning: overlong bar truncated here |
%% 60
                \skip 16 r16 c'' 4 -\staccato d'' -\staccato c'' 8 -\staccato b' 16. r32 r8  |
                < d'' b' > 8 -\staccato < d'' b' > 16.. -\tenuto r64 r8 < a' c'' > 16 r < a' c'' > 4 -\staccato < b' g' > 16 r < g' b' > 8  |
                r8 < a' c'' > -\staccato < c'' a' > -\staccato r < c'' a' > 16. r32 r8 r4  |
                < d'' b' > 8 -\staccato < d'' b' > -\staccato r < c'' a' > -\staccato < c'' a' > r < g' b' > 16 r < g' b' > 8 -\tenuto  |
                r8 < a' c'' > -\tenuto-\staccato < a' c'' > -\staccato r < c'' a' > 16. r32 r8 r4  |
%% 65
                < d'' b' > 8 -\staccato < d'' b' > r < c'' a' > 16 r < c'' a' > 4 -\staccato < d'' b' > 8 -\staccato < b' d'' > -\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 r16 r8 r4 r2  |
                < d'' b' > 8 -\staccato < d'' b' > r < a' c'' > 16 r < c'' a' > 8 r < d'' b' > 16 r < d'' b' > 8 -\staccato  |
                R1  |
                d'' 4 r8 b' 4 -\tenuto r8 c'' 16. r32 b' 8 -\staccato  |
%% 70
                c'' 4 r8 d'' 4 -\tenuto r8 c'' -\staccato b' -\staccato  |
                c'' 8 b' 16 r a' 8 -\staccato b' 4 -\staccato a' 16 r g' 8 -\staccato a' 16 r  |
                b' 8 r a' 16. r32 r8 g' r fis' -\staccato r  |
                fis' 8 -\staccato g' 16. r32 r8 a' 4 -\tenuto r8 r4  |
                R1  |
%% 75
                fis' 8 -\staccato g' 16. r32 r8 a' r g' -\staccato fis' -\tenuto-\staccato g' 16 -\staccato r  |
                a' 8 r g' 16 -\staccato r fis' -\staccato r g' -\staccato r fis' -\staccato r < e' fis' > -\staccato r r8  |
                g' 4 r r2  |
                r2 r4 e' 16 r fis' r  |
                g' 4 -\staccato r8 fis' -\staccato r4 e' 8 r  |
%% 80
                fis' 8 -\staccato e' 16 r d' r e' r fis' 8 -\staccato r d' -\staccato r  |
                d'' 8 -\staccato d'' 16. r32 r8 c'' -\staccato c'' r b' 16 -\staccato r b' 8 )  |
                r2 r4 d' 8 -\staccato r  |
                d'' 16 r d'' 8 r c'' 16 -\staccato r c'' 8 r b' -\staccato b' -\tenuto  |
                r8 c'' r d'' r c'' -\staccato b' 16 r r8  |
%% 85
                < d'' b' > 8 -\staccato < d'' b' > 16. -\tenuto r32 r8 < a' c'' > -\staccato < a' c'' > r < b' g' > 16 r < g' b' > 8 -\staccato  |
                R1  |
                < b' d'' > 8 -\staccato < b' d'' > 16.. -\tenuto r64 r8 < c'' a' > -\staccato < a' c'' > r < b' g' > 16 r < g' b' > 8 -\staccato  |
                R1  |
                fis' 8 r r e' 16. r32 r2  |
%% 90
                r2 r  |
                fis' 8 r r e' r2  |
                d' 16. r32 r8 e' 16. r32 r8 fis' -\staccato r g' r  |
                g' 8 -\staccato [ g' ] r fis' 16 r fis' 8 r e' -\staccato a' -\tenuto  |
                r8 g' -\staccato r4 r2  |
%% 95
                g' 8 -\staccato [ g' ] r fis' 16 r fis' 8 r e' 16 r a' 8  |
                r8 g' r d'' 4 -\staccato c'' 8 -\staccato < b' c'' > 16 -\tenuto-\staccato r c'' -\staccato r  |
                d'' 8 -\staccato [ d'' -\staccato ] r c'' -\staccato c'' r b' -\staccato b' -\staccato  |
                R1  |
                d'' 8 -\staccato [ d'' ] r c'' 16 r c'' 8 r b' 16 r b' 16. -\tenuto \clef "treble"
                r32 
                % warning: overlong bar truncated here |
%% 100
                \skip 4 \skip 8 \skip 16 \skip 32 r4 r8 a' 16 r a' 32 -\staccato 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 g' 4 r8 fis' -\staccato r g' 32 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 a' 4 r8 r a' 16 r a' 32 -\staccato 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 g' 4 r8 fis' r g' 32 -\staccato 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 fis' 16 r e' 4 -\tenuto r8 fis' r g' 32 -\tenuto 
                % warning: overlong bar truncated here |
%% 105
                \skip 8 \skip 16 \skip 32 r8 d' 4 -\tenuto r8 r4 r32 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 \skip 8 \skip 16 \skip 32 g' 32 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 d' 4. r4 fis' 32 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 r8 g' r a' r b' r a' 32 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 g' 4 r8 r4 r32 
                % warning: overlong bar truncated here |
%% 110
                \skip 2 \skip 4 \skip 8 \skip 16 \skip 32 b' 32 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r4 b' 4. r8 b' 32 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 r8 a' r g' r a' r g' 32 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 fis' 4. r4 g' 32 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 r8 fis' -\staccato e' 4 -\tenuto-\staccato fis' 8. r16 r8 g' 32 -\staccato 
                % warning: overlong bar truncated here |
%% 115
                \skip 8 \skip 16 \skip 32 fis' 8 -\staccato [ e' ] r d' 4 -\staccato e' 8 -\tenuto r32 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 fis' 8 r g' 4 -\staccato a' 8 -\staccato g' -\staccato fis' 16 -\staccato r < g' fis' > 32 -\staccato-\tenuto 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 r8 < e' fis' > -\tenuto-\staccato r g' 4. -\tenuto r8 r32 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 \skip 8 \skip 16 \skip 32 g' 32 -\staccato 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 fis' 16 -\staccato r < e' fis' > 8 -\staccato r ) g' 4 -\staccato d'' 8 r c'' 32 -\tenuto-\staccato 
                % warning: overlong bar truncated here |
%% 120
                \skip 16 \skip 32 b' 4 -\staccato a' -\tenuto r8 g' r fis' 32 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 g' 4 -\tenuto r8 a' r g' 32 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 fis' 4 -\tenuto r8 e' r fis' 32 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 g' 4 -\tenuto r8 a' 4 -\staccato g' 32 -\staccato 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 fis' 8 r e' 4 -\staccato d' 16 r e' -\staccato r fis' -\staccato r g' 32 
                % warning: overlong bar truncated here |
%% 125
                \skip 16 r32 g' 8. r16 fis' 8 -\staccato fis' 4 r r32 
                % warning: overlong bar truncated here |
                \skip 2 \skip 4 \skip 8 \skip 16 \skip 32 g' 32 -\staccato 
                % warning: overlong bar truncated here |
                \skip 16 \skip 32 g' 4 -\staccato fis' 16 -\staccato r fis' 8 r e' 16 r e' 8 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 483840 + 3821 < 487680  &&  31/32 < 4/4
                r64  |
                \skip 32 r16 fis' r fis' r g' 8 -\staccato [ fis' -\staccato e' 16 ] r d' r e' -\staccato r r32 
                % warning: overlong bar truncated here |
                \skip 8 \skip 16 \skip 32 r8 r16 r r r32 r8 r4 r32 
                % warning: overlong bar truncated here
                % warning: bar too short, padding with rests
                % 491520 + 3701 < 495360  &&  31/32 < 4/4
                r32  |
%% 130
                \skip 2 \skip 4 \skip 8 \skip 16 \skip 32 r32 
                % warning: overlong bar truncated here |
            } % Voice

            % End of segment Kalimba (recorded) (split)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 4, Dulcimer (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Dulcimer (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Dulcimer-Hammered"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 3.0" {
                % Segment: Hammered Dulcimer (left pan) (step recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \repeat unfold 10 {
                    \clef "treble"
                    \key g \major
                    d' 8 \sustainOn [ a' fis' d'' ] a' [ fis' d'' a' ]  |
                    d' 8 [ a' fis' cis'' ] a' [ fis' cis'' a' ]  |
                    d' 8 [ a' fis' c'' ] a' [ fis' c'' a' ]  |
                    d' 8 [ a' fis' b' ] a' [ fis' b' a' ]  |
%% 5
                    c' 8 [ g' e' c'' ] g' [ e' c'' g' ]  |
                    c' 8 [ g' e' b' ] g' [ e' b' g' ]  |
                    c' 8 [ g' e' bes' ] g' [ e' bes' g' ]  |
                    c' 8 [ g' e' a' ] g' [ e' a' g' ]  |
                    g' 8 [ d'' b' g'' ] d'' [ b' g'' d'' ]  |
%% 10
                    g' 8 [ d'' b' fis'' ] d'' [ b' fis'' d'' ]  |
                    g' 8 [ d'' b' f'' ] d'' [ b' f'' d'' ]  |
                    g' 8 [ d'' b' e'' ] d'' [ b' e'' d'' ]  |
                } % close repeat
            } % Voice

            % End of segment Hammered Dulcimer (left pan) (step recorded)

            \context Voice = "voice 3.0" {
                % Segment: Hammered Dulcimer (left pan) (step recorded) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*121 
                \clef "treble"
                \key g \major
                d' 8 \sustainOn [ a' fis' d'' ] a' [ fis' d'' a' ]  |
                d' 8 [ a' fis' cis'' ] a' [ fis' cis'' a' ]  |
                d' 8 [ a' fis' c'' ] a' [ fis' c'' a' ]  |
                d' 8 [ a' fis' b' ] a' [ fis' b' a' ]  |
%% 125
                c' 8 [ g' e' c'' ] g' [ e' c'' g' ]  |
                c' 8 [ g' e' b' ] g' [ e' b' g' ]  |
                c' 8 [ g' e' bes' ] g' [ e' bes' g' ]  |
                c' 8 [ g' e' a' ] g' [ e' a' g' ]  |
                g' 8 [ d'' b' g'' ] d'' [ b' g'' d'' ]  |
%% 130
                g' 8 [ d'' b' fis'' ] d'' [ b' fis'' d'' ]  |
            } % Voice

            % End of segment Hammered Dulcimer (left pan) (step recorded) (split)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 5, Dulcimer (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Dulcimer (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Dulcimer-Hammered"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 4.0" {
                % Segment: Hammered Dulcimer (right pan) (copied , transposed, and doctored)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \repeat unfold 10 {
                    \clef "treble"
                    \key g \major
                    \stemDown d'' 8 [ a'' fis'' d''' ] a'' [ fis'' d''' a'' ] \stemNeutral  |
                    \stemDown d'' 8 [ a'' fis'' cis''' ] a'' [ fis'' cis''' a'' ] \stemNeutral  |
                    \stemDown d'' 8 [ a'' fis'' c''' ] a'' [ fis'' c''' a'' ] \stemNeutral  |
                    \stemDown d'' 8 [ a'' fis'' b'' ] a'' [ fis'' b'' a'' ] \stemNeutral  |
%% 5
                    \stemDown c'' 8 [ g'' e'' c''' ] g'' [ e'' c''' g'' ] \stemNeutral  |
                    \stemDown c'' 8 [ g'' e'' b'' ] g'' [ e'' b'' g'' ] \stemNeutral  |
                    \stemDown c'' 8 [ g'' e'' bes'' ] g'' [ e'' bes'' g'' ] \stemNeutral  |
                    \stemDown c'' 8 [ g'' e'' a'' ] g'' [ e'' a'' g'' ] \stemNeutral  |
                    g 8 [ d' b g' ] d' [ b g' d' ]  |
%% 10
                    g 8 [ d' b fis' ] d' [ b fis' d' ]  |
                    g 8 [ d' b f' ] d' [ b f' d' ]  |
                    g 8 [ d' b e' ] d' [ b e' d' ]  |
                } % close repeat
            } % Voice

            % End of segment Hammered Dulcimer (right pan) (copied , transposed, and doctored)

            \context Voice = "voice 4.0" {
                % Segment: Hammered Dulcimer (right pan) (copied , transposed, and doctored) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*121 
                \clef "treble"
                \key g \major
                \stemDown d'' 8 [ a'' fis'' d''' ] a'' [ fis'' d''' a'' ] \stemNeutral  |
                \stemDown d'' 8 [ a'' fis'' cis''' ] a'' [ fis'' cis''' a'' ] \stemNeutral  |
                \stemDown d'' 8 [ a'' fis'' c''' ] a'' [ fis'' c''' a'' ] \stemNeutral  |
                \stemDown d'' 8 [ a'' fis'' b'' ] a'' [ fis'' b'' a'' ] \stemNeutral  |
%% 125
                \stemDown c'' 8 [ g'' e'' c''' ] g'' [ e'' c''' g'' ] \stemNeutral  |
                \stemDown c'' 8 [ g'' e'' b'' ] g'' [ e'' b'' g'' ] \stemNeutral  |
                \stemDown c'' 8 [ g'' e'' bes'' ] g'' [ e'' bes'' g'' ] \stemNeutral  |
                \stemDown c'' 8 [ g'' e'' a'' ] g'' [ e'' a'' g'' ] \stemNeutral  |
                g 8 [ d' b g' ] d' [ b g' d' ]  |
%% 130
                g 8 [ d' b fis' ] d' [ b fis' d' ]  |
            } % Voice

            % End of segment Hammered Dulcimer (right pan) (copied , transposed, and doctored) (split)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 6, Fretless (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Fretless (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Fretless Bass"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 5.0" {
                % Segment: Intro Bass (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*5 
%% 5
                \clef "bass"
                c, 4. -\tenuto g, c, 8 -\staccato r  |
                c, 4. -\tenuto g, -\tenuto c, 8 -\staccato r  |
                c, 4. g, -\tenuto c, 8 -\staccato r  |
                c, 4. g, c, 8 -\staccato r  |
                g,, 4 r32 d, 4. -\tenuto g,, 8 -\staccato r 
                % warning: bar too short, padding with rests
                % 30720 + 3480 < 34560  &&  29/32 < 4/4
                r32 r16  |
%% 10
                g,, 4. -\tenuto d, g,, 8 -\staccato r  |
                g,, 4. -\tenuto d, -\tenuto g,, 8 -\staccato r  |
                g,, 4 -\tenuto a,, -\tenuto b,, -\tenuto c, -\tenuto  |
            } % Voice

            % End of segment Intro Bass (recorded)

            \context Voice = "voice 5.0" {
                % Segment: Looping Bass (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*13 
                \repeat unfold 9 {
                    \clef "bass"
                    d, 4. -\tenuto a, d, 8 -\staccato r  |
                    d, 4. -\tenuto a, -\tenuto d, 8 -\staccato r  |
%% 15
                    d, 4. a, -\tenuto d, 8 -\staccato r  |
                    d, 4. -\tenuto a, 4 -\tenuto r8 d, r  |
                    c, 4. -\tenuto g, -\tenuto c, 8 -\staccato r  |
                    c, 4. g, -\tenuto c, 8 -\staccato r  |
                    c, 4. -\tenuto g, -\tenuto c, 8 -\staccato r  |
%% 20
                    c, 4. g, c, 8 -\staccato r  |
                    g,, 4. -\tenuto d, -\tenuto g,, 8 -\staccato r  |
                    g,, 4. -\tenuto d, -\tenuto g,, 8 -\staccato r  |
                    g,, 4. d, -\tenuto g,, 8 -\staccato r  |
                    g,, 4 -\tenuto a,, -\tenuto b,, -\tenuto c, -\tenuto  |
                } % close repeat
            } % Voice

            % End of segment Looping Bass (recorded)

            \context Voice = "voice 5.0" {
                % Segment: Looping Bass (recorded) (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*121 
                \clef "bass"
                d, 4. -\tenuto a, d, 8 -\staccato r  |
                d, 4. -\tenuto a, -\tenuto d, 8 -\staccato r  |
                d, 4. a, -\tenuto d, 8 -\staccato r  |
                d, 4. -\tenuto a, 4 -\tenuto r8 d, r  |
%% 125
                c, 4. -\tenuto g, -\tenuto c, 8 -\staccato r  |
                c, 4. g, -\tenuto c, 8 -\staccato r  |
                c, 4. -\tenuto g, -\tenuto c, 8 -\staccato r  |
                c, 4. g, c, 8 -\staccato r  |
                g,, 4. -\tenuto d, -\tenuto g,, 8 -\staccato r  |
%% 130
                g,, 4. -\tenuto d, -\tenuto g,, 8 -\staccato r8 r64 
                % warning: overlong bar truncated here |
            } % Voice

            % End of segment Looping Bass (recorded) (split)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 7, Guiro (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Guiro (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Standard"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 6.0" {
                % Segment: Standard
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \repeat unfold 64 {
%% 0
                    cis'' 16 -\staccato r cis'' r d'' -\tenuto r cis'' r cis'' r cis'' r d'' r cis'' -\staccato r  |
                    cis'' 16 -\staccato cis'' d'' -\tenuto cis'' cis'' cis'' d'' cis'' -\staccato 
                    % warning: bar too short, padding with rests
                    % 0 + 1920 < 3840  &&  1/2 < 4/4
                    r2  |
                } % close repeat
            } % Voice

            % End of segment Standard

            \context Voice = "voice 6.0" {
                % Segment: Standard
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*128 
                \repeat unfold 1 {
                    cis'' 16 -\staccato r cis'' r d'' -\tenuto r cis'' r cis'' r cis'' r d'' r cis'' -\staccato r  |
                    cis'' 16 -\staccato cis'' d'' -\tenuto cis'' cis'' cis'' d'' cis'' -\staccato 
                    % warning: bar too short, padding with rests
                    % 491520 + 1920 < 495360  &&  1/2 < 4/4
                    r2  |
                } % close repeat
            } % Voice

            % End of segment Standard

            \context Voice = "voice 6.0" {
                % Segment: Standard (split)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*130 
%% 130
                cis'' 16 -\staccato r cis'' r d'' -\tenuto r cis'' r cis'' r cis'' r d'' r cis'' -\staccato r  |
            } % Voice

            % End of segment Standard (split)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 8, Perc. Accents (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Perc. Accents (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Standard"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 7.0" {
                % Segment: Perc. Accents (PC51f.sf2) (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*4 
                \repeat unfold 1 {
                    r2 r4 r8 ees'' -\staccato  |
%% 5
                    ees'' 8 r r4 r2  |
                    r2 r4 r8 ees'' -\staccato  |
                    ees'' 8 r r4 r2  |
                    r2 r4 \times 2/3 { r8 ees'' r }  |
                    ees'' 16. r32 r8 r4 r2  |
%% 10
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
%% 15
                    ees'' 16. r32 r8 r4 r2  |
                    r2 r  |
                    ees'' 8 -\staccato [ ees'' -\staccato ] r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
%% 20
                    r2 r4 \times 2/3 { r8 ees'' -\staccato r }  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' -\staccato  |
                    ees'' 16. r32 r8 r4 r2  |
                    r2 r4 \times 2/3 { r8 ees'' r }  |
%% 25
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' -\staccato  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r  |
                    r2 r  |
%% 30
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
%% 35
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 \times 2/3 { r8 r ees'' -\staccato }  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
%% 40
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 \times 2/3 { r8 ees'' -\staccato r }  |
                    ees'' 8 r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
%% 45
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 -\staccato r  |
                    ees'' 8 -\staccato r r4 r2  |
%% 50
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
%% 55
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 \times 2/3 { r8 r ees'' -\staccato }  |
                    ees'' 8 -\staccato r r4 r2  |
%% 60
                    r2 r4 r8 ees'' 16 -\staccato r  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
%% 65
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 16 -\staccato r  |
                    ees'' 8 -\staccato r r r64 r16 r2 
                    % warning: bar too short, padding with rests
                    % 261120 + 3660 < 264960  &&  61/64 < 4/4
                    r64 r32  |
%% 70
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r32. r8 r16 r2 
                    % warning: bar too short, padding with rests
                    % 268800 + 3780 < 272640  &&  63/64 < 4/4
                    r64  |
                    r2 r4 \times 2/3 { r8 ees'' -\staccato r }  |
                    ees'' 8 -\staccato r r c''' 2 r8  |
                    r2 r4 r8 ees'' 16 r  |
%% 75
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 \times 2/3 { r8 r ees'' -\staccato }  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 r16 ees'' 32. r64  |
                    ees'' 8 -\staccato r r4 r2  |
%% 80
                    r2 r4 \times 2/3 { r8 r ees'' -\staccato }  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
%% 85
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r4 r2  |
%% 90
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
%% 95
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 32. r64 r16  |
                    ees'' 16 r r8 r4 r2  |
%% 100
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 16 r r8 r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
                    ees'' 8 -\staccato r r4 r2  |
                    r2 r4 r8 ees'' 16 r  |
%% 105
                    ees'' 32. -\tenuto r64 r16 r8 r4 r2  |
                } % close repeat
            } % Voice

            % End of segment Perc. Accents (PC51f.sf2) (recorded)

            \context Voice = "voice 7.0" {
                % Segment: Perc. Accents (PC51f.sf2) (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*106 
                r2 r4 r8 ees'' -\staccato  |
                ees'' 8 r r4 r2  |
                r2 r4 r8 ees'' -\staccato  |
                ees'' 8 r r4 r2  |
%% 110
                r2 r4 \times 2/3 { r8 ees'' r }  |
                ees'' 16. r32 r8 r4 r2  |
                r2 r4 r8 ees'' 16 r  |
                ees'' 8 r r4 r2  |
                r2 r4 r8 ees'' 16 r  |
%% 115
                ees'' 8 -\staccato r r4 r2  |
                r2 r4 r8 ees'' 16 r  |
                ees'' 16. r32 r8 r4 r2  |
                r2 r  |
                ees'' 8 -\staccato [ ees'' -\staccato ] r4 r2  |
%% 120
                r2 r4 r8 ees'' 16 r  |
                ees'' 8 -\staccato r r4 r2  |
                r2 r4 \times 2/3 { r8 ees'' -\staccato r }  |
                ees'' 8 -\staccato r r4 r2  |
                r2 r4 r8 ees'' -\staccato  |
%% 125
                ees'' 16. r32 r8 r4 r2  |
                r2 r4 \times 2/3 { r8 ees'' r }  |
                ees'' 8 -\staccato r r4 r2  |
                r2 r4 r8 ees'' -\staccato  |
                ees'' 8 -\staccato r r4 r2  |
%% 130
                r16 r32 r r8 r4 
                % warning: bar too short, padding with rests
                % 495360 + 1920 < 499200  &&  1/2 < 4/4
                r2  |
                c''' 2 r  |
                \bar "|."
            } % Voice

            % End of segment Perc. Accents (PC51f.sf2) (recorded)

            % End voice 0
        >> % Staff ends

        \context Staff = "track 9, Vibes (PC51f.sf2)" << 
            \set Staff.instrumentName = \markup { \center-column { "Vibes (PC51f.sf2) " } }
            \set Staff.midiInstrument = "Vibraphone"
            \set Score.skipBars = ##t
            \set Staff.printKeyCancellation = ##f
            \new Voice \global
            \new Voice \globalTempo
            \set Staff.autoBeaming = ##f % turns off all autobeaming

            \context Voice = "voice 8.0" {
                % Segment: Vibes (w) (Roland) (recorded)
                \override Voice.TextScript #'padding = #2.0
                \override MultiMeasureRest #'expand-limit = 1

                \skip 1*18 
                \clef "treble"
                \key g \major
                r2 r4 g 8 -\staccato r  |
                a 16 r r8 r4 r2  |
%% 20
                c' 16 r c' 16. r32 r16 r32 d' 4 -\staccato c' 16 -\tenuto r32 r64 b 8 -\staccato \times 2/3 { r c' r }  |
                b 2 r  |
                r2 r  |
                r2 r4 \times 2/3 { r8 r b -\staccato }  |
                b 4 -\staccato a 8 r g r b r  |
%% 25
                a 1 -\tenuto 
                % warning: overlong bar truncated here |
                \skip 2 r4 g 16. a 8 -\staccato r32  |
                b 8. -\tenuto r32 a 16. r16 g 4 -\tenuto r8 \times 2/3 { r g r }  |
                a 16. r32 g 16 r fis 4 -\staccato e 8 r fis 16 r g r  |
                a 4 -\tenuto r8 d 4. -\tenuto r4  |
%% 30
                r2 r8 r16 r32 fis 8 r32 r8  |
                a 4 r8 d 4 r8 d' r  |
                \times 2/3 { c' 8 _( r ) } r b \times 2/3 { r a -\staccato r } a' -\staccato r 
                % warning: bar too short, padding with rests
                % 119040 + 3520 < 122880  &&  11/12 < 4/4
                r16  |
                g' 16 r g' 8 \times 2/3 { r _( g' r ) } \times 2/3 { r f' r } g' r  |
                g' 8 -\staccato fis' 16 r g' r fis' r e' 8 -\staccato r \times 2/3 { r e' -\staccato r }  |
%% 35
                fis' 16 r fis' 8 -\staccato r fis' 16. r32 r8 g' -\staccato r fis' -\staccato  |
                r8 e' -\staccato r d' 16. r32 r4 d' 8 -\staccato r  |
                d' 8 -\staccato r r4 r2  |
                r2 r4 a 16. r32 r8  |
                d' 8 -\staccato r r c' -\staccato r4 d' 16. r32 r8  |
%% 40
                r2 r4 d' 8 -\staccato r  |
                fis' 16 r r8 \times 2/3 { r _( g' r ) } r2  |
                r2 r4 d' 8 -\staccato r  |
                fis' 8 -\staccato r \times 2/3 { r _( g' r ) } r2  |
                r2 r  |
%% 45
                fis 16 r fis 8 -\staccato \times 2/3 { r g r } r a 16. r32 r4  |
                g 8 -\staccato [ g -\staccato ] \times 2/3 { r fis r } r e -\staccato r4  |
                fis 16 r fis r \times 2/3 { r8 _( e r ) } r4 r8 d 16 r  |
                e 8 -\staccato r fis -\staccato r g -\staccato r e 16. r32 r8  |
                d 16 r d 8 -\staccato \times 2/3 { r a r } a r \times 2/3 { g -\staccato [ g _( ] r ) }  |
%% 50
                r4 r16 r32 d' 8 -\staccato d' -\staccato c' -\staccato b 16 \times 2/3 { r8 c' -\staccato r }  |
                g 16 r g 8 -\staccato r d' -\staccato d' r c' 16 r b 8 -\staccato  |
                r8 c' 16. r32 r8 d' r c' -\staccato \times 2/3 { b [ c' -\staccato ] r }  |
                d' 16. r32 r8 r c' -\staccato r2  |
                r2 r  |
%% 55
                < d' c' > 8 -\staccato r \times 2/3 { r c' r } r2  |
                r2 r  |
                d' 16. r32 r8 r4 r r8 d' 16 r  |
                fis' 8 -\staccato r \times 2/3 { r g' r } r r16 r32 a' 16. r16 r8  |
                g' 8 -\staccato r r4 r2  |
%% 60
                r2 r  |
                fis' 8 -\staccato [ fis' -\staccato ] \times 2/3 { r _( e' r ) } r2  |
                d' 8 -\staccato r \times 2/3 { r e' r } r2  |
                fis' 8 -\staccato [ fis' -\staccato ] r e' -\staccato r2  |
                d' 16. r32 r8 r e' -\staccato r2  |
%% 65
                c' 8 -\staccato [ c' -\staccato ] \times 2/3 { r d' r } r2  |
                r2 r  |
                c' 8 -\staccato [ c' -\staccato ] \times 2/3 { r d' -\staccato r } r4 r8 d' 16 r  |
                e' 16. r32 r8 fis' -\staccato r g' -\staccato r a' 16. r32 r8  |
                g' 8 r r fis' 16 r r2  |
%% 70
                r2 r  |
                g' 8 r r fis' -\staccato r2  |
                r2 r  |
                e' 8 r \times 2/3 { r fis' r } r2  |
                r2 r  |
%% 75
                e' 8 -\staccato r \times 2/3 { r fis' r } r r16 g' 16. r32 r16 r8  |
                \times 2/3 { r8 g' -\staccato r } fis' 16 r r8 \times 2/3 { g' -\staccato [ fis' -\staccato ] r } e' 16 r fis' r  |
                g' 8 -\staccato r \times 2/3 { r d' -\staccato r } d' 16. r32 r8 e' 16 r fis' r  |
                r2 r4 \times 2/3 { d' 8 -\staccato [ e' -\staccato ] r }  |
                fis' 16 r r8 \times 2/3 { r c' -\staccato r } c' 16 r r r32 d' 16 \times 2/3 { r8 e' r }  |
%% 80
                r8 d' -\staccato r c' 16. r32 r8 d' 16 r e' 8 -\staccato r  |
                d' 16 r r8 r4 r a 8 -\staccato r  |
                d' 16 r r8 r4 r a 8 -\staccato r  |
                d' 8 -\staccato r r4 r a 8 -\staccato r  |
                d' 16. r32 r8 a 16 r g r \times 2/3 { r r a -\tenuto } r r32 b 16 r32 r16 r8  |
%% 85
                c' 16 r c' 8 -\staccato \times 2/3 { r b -\staccato r } b -\staccato r16 r32 g 16 r32 r16 a 8 -\staccato  |
                r8 c' -\staccato \times 2/3 { r b r } r2  |
                b 16 r b 8 -\staccato \times 2/3 { r g -\staccato r } a -\staccato r16 r32 fis 16 -\tenuto \times 2/3 { r8 g r }  |
                r16 r32 fis 16 r32 r e 8 -\staccato fis 32. r64 r32 r16 g r r8 d 16 r r8  |
                e 32. r64 r16 fis 32. r64 r16 g r a r b 8 -\staccato r r4  |
%% 90
                R1  |
                d 16 r e r fis r g -\staccato r a 8 -\staccato r \times 2/3 { b -\staccato [ c' -\staccato ] r }  |
                d' 16 r r8 d' -\staccato r \times 2/3 { d' [ c' -\staccato ] r } d' -\staccato r  |
                d' 16 r d' r \times 2/3 { r8 fis' -\staccato r } fis' -\staccato r e' -\staccato r  |
                R1  |
%% 95
                fis' 16 r fis' 8 -\staccato r e' -\staccato r2  |
                r8 fis' -\staccato e' -\staccato fis' 16 r e' r fis' r e' r fis' r  |
                g' 8 -\staccato g' 16 r fis' 32. r64 r16 r8 r2  |
                \times 2/3 { g' 8 [ g' -\staccato ] r } fis' 16 -\staccato r r8 r2  |
                g' 8 -\staccato g' 16 r32 fis' 16 r32 r16 g' 8 -\staccato \times 2/3 { r g' r } fis' 32. r64 r16 g' 8 -\staccato  |
%% 100
                r8 fis' 16 r \times 2/3 { e' 8 -\staccato [ fis' -\staccato ] r } g' 16 r fis' r e' r fis' r  |
                e' 16 -\tenuto r r8 r4 r2  |
                R1  |
                g' 16 r r8 r4 r2  |
                g' 16 r g' 8 -\staccato r g' r fis' -\staccato \times 2/3 { e' -\staccato [ fis' -\staccato ] r }  |
%% 105
                g' 8 r r4 r2  |
                r2 r8 r16 r32 r64 g' 16 -\tenuto \times 2/3 { r8 fis' r }  |
                g' 8 r fis' 16 r g' 8 r4 r8 fis' -\staccato  |
                \times 2/3 { g' 8 [ fis' -\staccato ] r } e' 16 r fis' r g' 16. r32 r8 fis' -\staccato e' 16 r  |
                fis' 8 -\staccato [ e' -\staccato ] r d' -\staccato r4 r8 d' 16 r  |
%% 110
                e' 8 -\staccato r fis' 16 r g' 8 -\staccato r4 \times 2/3 { e' 8 -\staccato [ r d' -\staccato ] }  |
                e' 8 -\staccato r fis' 16 r g' 8 -\staccato r a' -\staccato r < b' a' > 16 -\tenuto r  |
                r8 a' -\staccato r g' -\staccato r a' -\staccato g' 16 r a' r  |
                g' 16 r fis' r r8 e' 16 r r2  |
                g' 8 -\staccato [ fis' -\staccato ] \times 2/3 { r e' r } r2  |
%% 115
                g' 8 -\staccato fis' 16 r \times 2/3 { r8 e' r } r2  |
                g' 8 -\staccato [ fis' -\staccato ] r e' -\staccato r d' 16 r c' r d' -\staccato r  |
                e' 16 r r8 r d' -\staccato r2  |
                r2 r  |
                g 16 r f r \times 2/3 { r8 g r } r2  |
%% 120
                g 8 -\staccato fis 32. r64 r16 r8 e 16 r r4 d 8 -\staccato r  |
                e 16 r r8 r fis 32. r64 r16 r2  |
                g 32. r64 r16 r8 r fis 16 r r2  |
                fis 16 r r8 \times 2/3 { r e r } r r16 r32 d 8 -\staccato r32 r8  |
                e 8 -\staccato r16 r32 fis 16 \times 2/3 { r8 g r } \times 2/3 { r fis -\staccato r } \times 2/3 { e [ fis -\staccato ] r }  |
%% 125
                g 16 r r8 r4 r2  |
                r2 r4 g 16 r r8  |
                g 16 r r8 r fis 32. r64 r16 r2  |
                \times 2/3 { g 8 -\staccato [ fis -\staccato ] r } \times 2/3 { e [ fis -\staccato ] r } r2  |
                r2 r  |
%% 130
                r2 r  |
            } % Voice

            % End of segment Vibes (w) (Roland) (recorded)

            % End voice 0
        >> % Staff ends

    >> % notes

    \layout {
        indent = 3.0\cm
        short-indent = 1.5\cm
        \context { \Staff \RemoveEmptyStaves }
        \context { \GrandStaff \accepts "Lyrics" }
    }
%     uncomment to enable generating midi file from the lilypond source
%         \midi {
%         } 
} % score
