The range pattern `...` is no longer allowed.

Erroneous code example:

```edition2021,compile_fail,E0783
match 2u8 {
    0...9 => println!("Got a number less than 10"), // error!
    _ => println!("Got a number 10 or more"),
}
```

Older Rust code using previous editions allowed `...` to stand for exclusive
ranges which are now signified using `..=`.

To make this code compile replace the `...` with `..=`.

```edition2021
match 2u8 {
    0..=9 => println!("Got a number less than 10"), // ok!
    _ => println!("Got a number 10 or more"),
}
```
