/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.lang.reflect.Array;
import java.util.Arrays;
import uk.ac.bristol.star.cdf.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Shaper {
    private final int[] dimSizes_;
    private final boolean[] dimVarys_;

    protected Shaper(int[] nArray, boolean[] blArray) {
        this.dimSizes_ = nArray;
        this.dimVarys_ = blArray;
    }

    public abstract int getRawItemCount();

    public abstract int getShapedItemCount();

    public int[] getDimSizes() {
        return this.dimSizes_;
    }

    public boolean[] getDimVarys() {
        return this.dimVarys_;
    }

    public abstract Class<?> getShapeClass();

    public abstract Object shape(Object var1, boolean var2);

    public abstract int getArrayIndex(int[] var1);

    public static Shaper createShaper(DataType dataType, int[] nArray, boolean[] blArray, boolean bl) {
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = nArray.length;
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = nArray[i];
            n2 *= n5;
            if (!blArray[i]) continue;
            ++n3;
            n *= n5;
        }
        if (n2 == 1) {
            return new ScalarShaper(dataType);
        }
        if (n4 == 1 && n3 == 1) {
            assert (Arrays.equals(blArray, new boolean[]{true}));
            assert (Arrays.equals(nArray, new int[]{n}));
            return new VectorShaper(dataType, n);
        }
        if (n3 == n4) {
            return new SimpleArrayShaper(dataType, nArray, bl);
        }
        return new GeneralShaper(dataType, nArray, blArray, bl);
    }

    private static Class<?> getArrayClass(Class clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    private static class SimpleArrayShaper
    extends GeneralShaper {
        private final DataType dataType_;
        private final boolean rowMajor_;

        public SimpleArrayShaper(DataType dataType, int[] nArray, boolean bl) {
            super(dataType, nArray, SimpleArrayShaper.trueArray(nArray.length), bl);
            this.dataType_ = dataType;
            this.rowMajor_ = bl;
        }

        public Object shape(Object object, boolean bl) {
            if (bl == this.rowMajor_) {
                int n = Array.getLength(object);
                Object object2 = Array.newInstance(this.dataType_.getArrayElementClass(), n);
                System.arraycopy(object, 0, object2, 0, n);
                return object2;
            }
            return super.shape(object, bl);
        }

        private static boolean[] trueArray(int n) {
            boolean[] blArray = new boolean[n];
            Arrays.fill(blArray, true);
            return blArray;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GeneralShaper
    extends Shaper {
        private final DataType dataType_;
        private final int[] dimSizes_;
        private final boolean rowMajor_;
        private final int ndim_;
        private final int rawItemCount_;
        private final int shapedItemCount_;
        private final int[] strides_;
        private final int itemSize_;
        private final Class<?> shapeClass_;

        GeneralShaper(DataType dataType, int[] nArray, boolean[] blArray, boolean bl) {
            super(nArray, blArray);
            this.dataType_ = dataType;
            this.dimSizes_ = nArray;
            this.rowMajor_ = bl;
            this.ndim_ = nArray.length;
            int n = 1;
            int n2 = 1;
            int n3 = 0;
            int n4 = nArray.length;
            this.strides_ = new int[this.ndim_];
            for (int i = 0; i < this.ndim_; ++i) {
                int n5 = bl ? this.ndim_ - i - 1 : i;
                int n6 = nArray[n5];
                n2 *= n6;
                if (!blArray[n5]) continue;
                ++n3;
                this.strides_[n5] = n;
                n *= n6;
            }
            this.rawItemCount_ = n;
            this.shapedItemCount_ = n2;
            this.itemSize_ = this.dataType_.getGroupSize();
            this.shapeClass_ = Shaper.getArrayClass(dataType.getArrayElementClass());
        }

        @Override
        public int getRawItemCount() {
            return this.rawItemCount_;
        }

        @Override
        public int getShapedItemCount() {
            return this.shapedItemCount_;
        }

        @Override
        public int getArrayIndex(int[] nArray) {
            int n = 0;
            for (int i = 0; i < this.ndim_; ++i) {
                n += nArray[i] * this.strides_[i];
            }
            return n * this.itemSize_;
        }

        @Override
        public Class<?> getShapeClass() {
            return this.shapeClass_;
        }

        @Override
        public Object shape(Object object, boolean bl) {
            Object object2 = Array.newInstance(this.dataType_.getArrayElementClass(), this.shapedItemCount_ * this.itemSize_);
            int[] nArray = new int[this.ndim_];
            Arrays.fill(nArray, -1);
            for (int i = 0; i < this.shapedItemCount_; ++i) {
                for (int j = 0; j < this.ndim_; ++j) {
                    int n = bl ? this.ndim_ - j - 1 : j;
                    nArray[n] = (nArray[n] + 1) % this.dimSizes_[n];
                    if (nArray[n] != 0) break;
                }
                System.arraycopy(object, this.getArrayIndex(nArray), object2, i * this.itemSize_, this.itemSize_);
            }
            return object2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VectorShaper
    extends Shaper {
        private final DataType dataType_;
        private final int itemCount_;
        private final int step_;
        private final Class<?> shapeClass_;

        VectorShaper(DataType dataType, int n) {
            super(new int[]{n}, new boolean[]{true});
            this.dataType_ = dataType;
            this.itemCount_ = n;
            this.step_ = dataType.getGroupSize();
            this.shapeClass_ = Shaper.getArrayClass(dataType.getArrayElementClass());
        }

        @Override
        public int getRawItemCount() {
            return this.itemCount_;
        }

        @Override
        public int getShapedItemCount() {
            return this.itemCount_;
        }

        @Override
        public Class<?> getShapeClass() {
            return this.shapeClass_;
        }

        @Override
        public Object shape(Object object, boolean bl) {
            Object object2 = Array.newInstance(this.dataType_.getArrayElementClass(), this.itemCount_);
            System.arraycopy(object, 0, object2, 0, this.itemCount_);
            return object2;
        }

        @Override
        public int getArrayIndex(int[] nArray) {
            return nArray[0] * this.step_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScalarShaper
    extends Shaper {
        private final DataType dataType_;

        ScalarShaper(DataType dataType) {
            super(new int[0], new boolean[0]);
            this.dataType_ = dataType;
        }

        @Override
        public int getRawItemCount() {
            return 1;
        }

        @Override
        public int getShapedItemCount() {
            return 1;
        }

        @Override
        public Class<?> getShapeClass() {
            return this.dataType_.getScalarClass();
        }

        @Override
        public Object shape(Object object, boolean bl) {
            return this.dataType_.getScalar(object, 0);
        }

        @Override
        public int getArrayIndex(int[] nArray) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                throw new IllegalArgumentException("Out of bounds");
            }
            return 0;
        }
    }
}

