; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx  | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-crosslane-shuffle,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2,+fast-variable-perlane-shuffle | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX512

; These patterns are produced by LoopVectorizer for interleaved loads.

define void @load_i8_stride3_vf2(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i8_stride3_vf2:
; SSE:       # %bb.0:
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm1[0],xmm0[1],xmm1[1],xmm0[2],xmm1[2],xmm0[3],xmm1[3],xmm0[4],xmm1[4],xmm0[5],xmm1[5],xmm0[6],xmm1[6],xmm0[7],xmm1[7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm0[0,3,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[1,2,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm2, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm1, %eax
; SSE-NEXT:    movw %ax, (%rsi)
; SSE-NEXT:    movd %xmm2, %eax
; SSE-NEXT:    movw %ax, (%rdx)
; SSE-NEXT:    movd %xmm0, %eax
; SSE-NEXT:    movw %ax, (%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride3_vf2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,3,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,4,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX-NEXT:    vpextrw $0, %xmm0, (%rcx)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride3_vf2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,3,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,4,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,u,u,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpextrw $0, %xmm1, (%rsi)
; AVX512-NEXT:    vpextrw $0, %xmm2, (%rdx)
; AVX512-NEXT:    vpextrw $0, %xmm0, (%rcx)
; AVX512-NEXT:    retq
  %wide.vec = load <6 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <6 x i8> %wide.vec, <6 x i8> poison, <2 x i32> <i32 0, i32 3>
  %strided.vec1 = shufflevector <6 x i8> %wide.vec, <6 x i8> poison, <2 x i32> <i32 1, i32 4>
  %strided.vec2 = shufflevector <6 x i8> %wide.vec, <6 x i8> poison, <2 x i32> <i32 2, i32 5>

  store <2 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <2 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <2 x i8> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i8_stride3_vf4(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i8_stride3_vf4:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,65535,65535,65535,65535]
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1],xmm0[2],xmm2[2],xmm0[3],xmm2[3],xmm0[4],xmm2[4],xmm0[5],xmm2[5],xmm0[6],xmm2[6],xmm0[7],xmm2[7]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[0,3,2,1,4,5,6,7]
; SSE-NEXT:    packuswb %xmm1, %xmm1
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm3[0,3,2,3,4,5,6,7]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[1,0],xmm0[0,0]
; SSE-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm0[2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,2,3,0,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,2,3,4,5,6,7]
; SSE-NEXT:    punpckldq {{.*#+}} xmm0 = xmm0[0],xmm2[0],xmm0[1],xmm2[1]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movd %xmm1, (%rsi)
; SSE-NEXT:    movd %xmm3, (%rdx)
; SSE-NEXT:    movd %xmm0, (%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride3_vf4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,3,6,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,4,7,10,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,8,11,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vmovd %xmm1, (%rsi)
; AVX-NEXT:    vmovd %xmm2, (%rdx)
; AVX-NEXT:    vmovd %xmm0, (%rcx)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride3_vf4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = xmm0[0,3,6,9,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = xmm0[1,4,7,10,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,8,11,u,u,u,u,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vmovd %xmm1, (%rsi)
; AVX512-NEXT:    vmovd %xmm2, (%rdx)
; AVX512-NEXT:    vmovd %xmm0, (%rcx)
; AVX512-NEXT:    retq
  %wide.vec = load <12 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <4 x i32> <i32 0, i32 3, i32 6, i32 9>
  %strided.vec1 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <4 x i32> <i32 1, i32 4, i32 7, i32 10>
  %strided.vec2 = shufflevector <12 x i8> %wide.vec, <12 x i8> poison, <4 x i32> <i32 2, i32 5, i32 8, i32 11>

  store <4 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <4 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <4 x i8> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i8_stride3_vf8(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i8_stride3_vf8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm0
; SSE-NEXT:    movdqa 16(%rdi), %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [255,255,0,255,255,0,255,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm1, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm2[0],xmm4[1],xmm2[1],xmm4[2],xmm2[2],xmm4[3],xmm2[3],xmm4[4],xmm2[4],xmm4[5],xmm2[5],xmm4[6],xmm2[6],xmm4[7],xmm2[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm2[8],xmm3[9],xmm2[9],xmm3[10],xmm2[10],xmm3[11],xmm2[11],xmm3[12],xmm2[12],xmm3[13],xmm2[13],xmm3[14],xmm2[14],xmm3[15],xmm2[15]
; SSE-NEXT:    pandn %xmm3, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm4, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,255,255,0,255,255,0,255,255,255,255,255,255,255,255,255]
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm5
; SSE-NEXT:    por %xmm6, %xmm5
; SSE-NEXT:    punpcklbw {{.*#+}} xmm5 = xmm5[0],xmm2[0],xmm5[1],xmm2[1],xmm5[2],xmm2[2],xmm5[3],xmm2[3],xmm5[4],xmm2[4],xmm5[5],xmm2[5],xmm5[6],xmm2[6],xmm5[7],xmm2[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    por %xmm5, %xmm6
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm6[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm5 = xmm5[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm5 = xmm5[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm5, %xmm5
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,0,255,255,0,255,255,0,255,255,255,255,255,255,255,255]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    pandn %xmm1, %xmm6
; SSE-NEXT:    por %xmm0, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm6 = xmm6[0],xmm2[0],xmm6[1],xmm2[1],xmm6[2],xmm2[2],xmm6[3],xmm2[3],xmm6[4],xmm2[4],xmm6[5],xmm2[5],xmm6[6],xmm2[6],xmm6[7],xmm2[7]
; SSE-NEXT:    movdqa {{.*#+}} xmm0 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movq %xmm4, (%rsi)
; SSE-NEXT:    movq %xmm5, (%rdx)
; SSE-NEXT:    movq %xmm0, (%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride3_vf8:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,xmm1[2,5,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,3,6,9,12,15],zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,zero,xmm1[0,3,6,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,4,7,10,13],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm1[1,4,7,u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,8,11,14],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vmovq %xmm2, (%rsi)
; AVX-NEXT:    vmovq %xmm3, (%rdx)
; AVX-NEXT:    vmovq %xmm0, (%rcx)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride3_vf8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vpshufb {{.*#+}} xmm2 = zero,zero,zero,zero,zero,zero,xmm1[2,5,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = xmm0[0,3,6,9,12,15],zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm2, %xmm3, %xmm2
; AVX512-NEXT:    vpshufb {{.*#+}} xmm3 = zero,zero,zero,zero,zero,xmm1[0,3,6,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm4 = xmm0[1,4,7,10,13],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX512-NEXT:    vpshufb {{.*#+}} xmm1 = zero,zero,zero,zero,zero,xmm1[1,4,7,u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[2,5,8,11,14],zero,zero,zero,xmm0[u,u,u,u,u,u,u,u]
; AVX512-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vmovq %xmm2, (%rsi)
; AVX512-NEXT:    vmovq %xmm3, (%rdx)
; AVX512-NEXT:    vmovq %xmm0, (%rcx)
; AVX512-NEXT:    retq
  %wide.vec = load <24 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %strided.vec1 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %strided.vec2 = shufflevector <24 x i8> %wide.vec, <24 x i8> poison, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>

  store <8 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <8 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <8 x i8> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i8_stride3_vf16(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i8_stride3_vf16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm4
; SSE-NEXT:    movdqa 32(%rdi), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255]
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm6, %xmm6
; SSE-NEXT:    movdqa %xmm2, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    pandn %xmm7, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm2 = xmm2[0],xmm6[0],xmm2[1],xmm6[1],xmm2[2],xmm6[2],xmm2[3],xmm6[3],xmm2[4],xmm6[4],xmm2[5],xmm6[5],xmm2[6],xmm6[6],xmm2[7],xmm6[7]
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    por %xmm8, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm2 = xmm2[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm2[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm2[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm2 = xmm7[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,3,2,3]
; SSE-NEXT:    packuswb %xmm2, %xmm10
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; SSE-NEXT:    pand %xmm2, %xmm10
; SSE-NEXT:    movdqa %xmm0, %xmm7
; SSE-NEXT:    punpckhbw {{.*#+}} xmm7 = xmm7[8],xmm6[8],xmm7[9],xmm6[9],xmm7[10],xmm6[10],xmm7[11],xmm6[11],xmm7[12],xmm6[12],xmm7[13],xmm6[13],xmm7[14],xmm6[14],xmm7[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm9 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm7, %xmm8
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm6[0],xmm0[1],xmm6[1],xmm0[2],xmm6[2],xmm0[3],xmm6[3],xmm0[4],xmm6[4],xmm0[5],xmm6[5],xmm0[6],xmm6[6],xmm0[7],xmm6[7]
; SSE-NEXT:    movdqa %xmm0, %xmm11
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    por %xmm8, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm11[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm8 = xmm8[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,3,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm8 = xmm8[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm8, %xmm11
; SSE-NEXT:    movdqa %xmm2, %xmm8
; SSE-NEXT:    pandn %xmm11, %xmm8
; SSE-NEXT:    por %xmm10, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm10 = [255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    pand %xmm10, %xmm11
; SSE-NEXT:    pandn %xmm5, %xmm10
; SSE-NEXT:    por %xmm11, %xmm10
; SSE-NEXT:    movdqa %xmm10, %xmm11
; SSE-NEXT:    punpckhbw {{.*#+}} xmm11 = xmm11[8],xmm6[8],xmm11[9],xmm6[9],xmm11[10],xmm6[10],xmm11[11],xmm6[11],xmm11[12],xmm6[12],xmm11[13],xmm6[13],xmm11[14],xmm6[14],xmm11[15],xmm6[15]
; SSE-NEXT:    movdqa %xmm9, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm10 = xmm10[0],xmm6[0],xmm10[1],xmm6[1],xmm10[2],xmm6[2],xmm10[3],xmm6[3],xmm10[4],xmm6[4],xmm10[5],xmm6[5],xmm10[6],xmm6[6],xmm10[7],xmm6[7]
; SSE-NEXT:    pand %xmm9, %xmm10
; SSE-NEXT:    por %xmm12, %xmm10
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm10[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm10 = xmm10[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm10 = xmm10[0,1,2,3,5,6,7,4]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm11[1,2,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm11, %xmm10
; SSE-NEXT:    pand %xmm2, %xmm10
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pand %xmm9, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm9
; SSE-NEXT:    por %xmm11, %xmm9
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm9, %xmm9
; SSE-NEXT:    pandn %xmm9, %xmm2
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm5, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    punpckhbw {{.*#+}} xmm4 = xmm4[8],xmm6[8],xmm4[9],xmm6[9],xmm4[10],xmm6[10],xmm4[11],xmm6[11],xmm4[12],xmm6[12],xmm4[13],xmm6[13],xmm4[14],xmm6[14],xmm4[15],xmm6[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm3 = xmm3[0],xmm6[0],xmm3[1],xmm6[1],xmm3[2],xmm6[2],xmm3[3],xmm6[3],xmm3[4],xmm6[4],xmm3[5],xmm6[5],xmm3[6],xmm6[6],xmm3[7],xmm6[7]
; SSE-NEXT:    pand %xmm5, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm5
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm5[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm4, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    pand %xmm4, %xmm3
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm7, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm8, (%rsi)
; SSE-NEXT:    movdqa %xmm2, (%rdx)
; SSE-NEXT:    movdqa %xmm4, (%rcx)
; SSE-NEXT:    retq
;
; AVX-LABEL: load_i8_stride3_vf16:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovdqa (%rdi), %xmm0
; AVX-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13]
; AVX-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX-NEXT:    vpalignr {{.*#+}} xmm3 = xmm2[11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    vpalignr {{.*#+}} xmm2 = xmm3[11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    vmovdqa {{.*#+}} xmm4 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX-NEXT:    vpblendvb %xmm4, %xmm0, %xmm1, %xmm1
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7,8,9,10]
; AVX-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9]
; AVX-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX-NEXT:    vmovdqa %xmm1, (%rdx)
; AVX-NEXT:    vmovdqa %xmm2, (%rcx)
; AVX-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride3_vf16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512-NEXT:    vmovdqa {{.*#+}} xmm3 = [0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13]
; AVX512-NEXT:    vpshufb %xmm3, %xmm0, %xmm0
; AVX512-NEXT:    vpshufb %xmm3, %xmm1, %xmm1
; AVX512-NEXT:    vpshufb %xmm3, %xmm2, %xmm2
; AVX512-NEXT:    vpalignr {{.*#+}} xmm3 = xmm2[11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7,8,9,10]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9,10]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7,8,9,10]
; AVX512-NEXT:    movw $-2048, %ax # imm = 0xF800
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmb %xmm1, %xmm0, %xmm2 {%k1}
; AVX512-NEXT:    vpalignr {{.*#+}} xmm1 = xmm3[11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9,10]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7,8,9,10]
; AVX512-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9]
; AVX512-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX512-NEXT:    vmovdqa %xmm2, (%rdx)
; AVX512-NEXT:    vmovdqa %xmm1, (%rcx)
; AVX512-NEXT:    retq
  %wide.vec = load <48 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <16 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21, i32 24, i32 27, i32 30, i32 33, i32 36, i32 39, i32 42, i32 45>
  %strided.vec1 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <16 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22, i32 25, i32 28, i32 31, i32 34, i32 37, i32 40, i32 43, i32 46>
  %strided.vec2 = shufflevector <48 x i8> %wide.vec, <48 x i8> poison, <16 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23, i32 26, i32 29, i32 32, i32 35, i32 38, i32 41, i32 44, i32 47>

  store <16 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <16 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <16 x i8> %strided.vec2, ptr %out.vec2, align 32

  ret void
}

define void @load_i8_stride3_vf32(ptr %in.vec, ptr %out.vec0, ptr %out.vec1, ptr %out.vec2) nounwind {
; SSE-LABEL: load_i8_stride3_vf32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa 64(%rdi), %xmm2
; SSE-NEXT:    movdqa (%rdi), %xmm5
; SSE-NEXT:    movdqa 16(%rdi), %xmm14
; SSE-NEXT:    movdqa 32(%rdi), %xmm4
; SSE-NEXT:    movdqa 48(%rdi), %xmm13
; SSE-NEXT:    movdqa %xmm13, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [255,255,0,255,255,0,255,255,0,255,255,0,255,255,0,255]
; SSE-NEXT:    movdqa %xmm1, %xmm6
; SSE-NEXT:    pandn %xmm14, %xmm6
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [255,0,255,255,0,255,255,0,255,255,0,255,255,0,255,255]
; SSE-NEXT:    movdqa %xmm7, %xmm8
; SSE-NEXT:    pandn %xmm5, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm0, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm10, %xmm10
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm10[8],xmm3[9],xmm10[9],xmm3[10],xmm10[10],xmm3[11],xmm10[11],xmm3[12],xmm10[12],xmm3[13],xmm10[13],xmm3[14],xmm10[14],xmm3[15],xmm10[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [65535,0,65535,65535,0,65535,65535,0]
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1],xmm0[2],xmm10[2],xmm0[3],xmm10[3],xmm0[4],xmm10[4],xmm0[5],xmm10[5],xmm0[6],xmm10[6],xmm0[7],xmm10[7]
; SSE-NEXT:    pand %xmm5, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,3,2,3]
; SSE-NEXT:    packuswb %xmm3, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm10[8],xmm3[9],xmm10[9],xmm3[10],xmm10[10],xmm3[11],xmm10[11],xmm3[12],xmm10[12],xmm3[13],xmm10[13],xmm3[14],xmm10[14],xmm3[15],xmm10[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm15 = [65535,65535,0,65535,65535,0,65535,65535]
; SSE-NEXT:    movdqa %xmm15, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    punpcklbw {{.*#+}} xmm4 = xmm4[0],xmm10[0],xmm4[1],xmm10[1],xmm4[2],xmm10[2],xmm4[3],xmm10[3],xmm4[4],xmm10[4],xmm4[5],xmm10[5],xmm4[6],xmm10[6],xmm4[7],xmm10[7]
; SSE-NEXT:    movdqa %xmm4, %xmm11
; SSE-NEXT:    movdqa %xmm4, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pand %xmm15, %xmm11
; SSE-NEXT:    por %xmm9, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm11[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm9 = xmm9[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm9[0,3,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm9 = xmm9[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm9, %xmm11
; SSE-NEXT:    movdqa %xmm6, %xmm9
; SSE-NEXT:    pandn %xmm11, %xmm9
; SSE-NEXT:    por %xmm0, %xmm9
; SSE-NEXT:    movdqa %xmm9, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, {{[-0-9]+}}(%r{{[sb]}}p) # 16-byte Spill
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    movdqa %xmm13, %xmm11
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm11, %xmm13
; SSE-NEXT:    punpckhbw {{.*#+}} xmm13 = xmm13[8],xmm10[8],xmm13[9],xmm10[9],xmm13[10],xmm10[10],xmm13[11],xmm10[11],xmm13[12],xmm10[12],xmm13[13],xmm10[13],xmm13[14],xmm10[14],xmm13[15],xmm10[15]
; SSE-NEXT:    movdqa %xmm5, %xmm12
; SSE-NEXT:    pandn %xmm13, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm11 = xmm11[0],xmm10[0],xmm11[1],xmm10[1],xmm11[2],xmm10[2],xmm11[3],xmm10[3],xmm11[4],xmm10[4],xmm11[5],xmm10[5],xmm11[6],xmm10[6],xmm11[7],xmm10[7]
; SSE-NEXT:    pand %xmm5, %xmm11
; SSE-NEXT:    por %xmm12, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,2,1,3]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm11[0,3,2,1,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm11[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm13[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,3,2,3]
; SSE-NEXT:    packuswb %xmm11, %xmm0
; SSE-NEXT:    movdqa 80(%rdi), %xmm13
; SSE-NEXT:    movdqa %xmm13, %xmm9
; SSE-NEXT:    punpckhbw {{.*#+}} xmm9 = xmm9[8],xmm10[8],xmm9[9],xmm10[9],xmm9[10],xmm10[10],xmm9[11],xmm10[11],xmm9[12],xmm10[12],xmm9[13],xmm10[13],xmm9[14],xmm10[14],xmm9[15],xmm10[15]
; SSE-NEXT:    movdqa %xmm15, %xmm12
; SSE-NEXT:    pandn %xmm9, %xmm12
; SSE-NEXT:    punpcklbw {{.*#+}} xmm13 = xmm13[0],xmm10[0],xmm13[1],xmm10[1],xmm13[2],xmm10[2],xmm13[3],xmm10[3],xmm13[4],xmm10[4],xmm13[5],xmm10[5],xmm13[6],xmm10[6],xmm13[7],xmm10[7]
; SSE-NEXT:    movdqa %xmm13, %xmm11
; SSE-NEXT:    pand %xmm15, %xmm11
; SSE-NEXT:    por %xmm12, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm11 = xmm11[2,1,2,3,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm11 = xmm11[0,3,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm11[0,1,2,3,4,7,6,5]
; SSE-NEXT:    packuswb %xmm11, %xmm11
; SSE-NEXT:    movdqa %xmm6, %xmm12
; SSE-NEXT:    pandn %xmm11, %xmm12
; SSE-NEXT:    pand %xmm6, %xmm0
; SSE-NEXT:    por %xmm0, %xmm12
; SSE-NEXT:    movdqa %xmm14, %xmm0
; SSE-NEXT:    pand %xmm7, %xmm0
; SSE-NEXT:    por %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    punpckhbw {{.*#+}} xmm8 = xmm8[8],xmm10[8],xmm8[9],xmm10[9],xmm8[10],xmm10[10],xmm8[11],xmm10[11],xmm8[12],xmm10[12],xmm8[13],xmm10[13],xmm8[14],xmm10[14],xmm8[15],xmm10[15]
; SSE-NEXT:    movdqa %xmm15, %xmm11
; SSE-NEXT:    pandn %xmm8, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0],xmm10[0],xmm0[1],xmm10[1],xmm0[2],xmm10[2],xmm0[3],xmm10[3],xmm0[4],xmm10[4],xmm0[5],xmm10[5],xmm0[6],xmm10[6],xmm0[7],xmm10[7]
; SSE-NEXT:    pand %xmm15, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm11 = xmm0[0,1,2,3,5,6,7,4]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm8[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[1,2,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm11
; SSE-NEXT:    movdqa %xmm15, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm8
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    movdqa %xmm6, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm8
; SSE-NEXT:    pand %xmm6, %xmm11
; SSE-NEXT:    por %xmm11, %xmm8
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pand %xmm7, %xmm3
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm2 # 16-byte Reload
; SSE-NEXT:    pandn %xmm2, %xmm7
; SSE-NEXT:    por %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm10[8],xmm3[9],xmm10[9],xmm3[10],xmm10[10],xmm3[11],xmm10[11],xmm3[12],xmm10[12],xmm3[13],xmm10[13],xmm3[14],xmm10[14],xmm3[15],xmm10[15]
; SSE-NEXT:    movdqa %xmm15, %xmm11
; SSE-NEXT:    pandn %xmm3, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm7 = xmm7[0],xmm10[0],xmm7[1],xmm10[1],xmm7[2],xmm10[2],xmm7[3],xmm10[3],xmm7[4],xmm10[4],xmm7[5],xmm10[5],xmm7[6],xmm10[6],xmm7[7],xmm10[7]
; SSE-NEXT:    pand %xmm15, %xmm7
; SSE-NEXT:    por %xmm11, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm7[0,3,2,1]
; SSE-NEXT:    pshuflw {{.*#+}} xmm7 = xmm7[1,2,3,0,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm7 = xmm7[0,1,2,3,5,6,7,4]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,4,7,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,2,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[1,2,3,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm7
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pand %xmm15, %xmm3
; SSE-NEXT:    pandn %xmm13, %xmm15
; SSE-NEXT:    por %xmm3, %xmm15
; SSE-NEXT:    pand %xmm6, %xmm7
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm15[0,3,2,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,6,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[0,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,2,2,2,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm3 = xmm3[0,1,2,3,5,6,7,4]
; SSE-NEXT:    packuswb %xmm3, %xmm3
; SSE-NEXT:    pandn %xmm3, %xmm6
; SSE-NEXT:    por %xmm7, %xmm6
; SSE-NEXT:    pand %xmm1, %xmm14
; SSE-NEXT:    por {{[-0-9]+}}(%r{{[sb]}}p), %xmm14 # 16-byte Folded Reload
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    punpckhbw {{.*#+}} xmm3 = xmm3[8],xmm10[8],xmm3[9],xmm10[9],xmm3[10],xmm10[10],xmm3[11],xmm10[11],xmm3[12],xmm10[12],xmm3[13],xmm10[13],xmm3[14],xmm10[14],xmm3[15],xmm10[15]
; SSE-NEXT:    movdqa {{.*#+}} xmm7 = [0,65535,65535,0,65535,65535,0,65535]
; SSE-NEXT:    movdqa %xmm7, %xmm11
; SSE-NEXT:    pandn %xmm3, %xmm11
; SSE-NEXT:    punpcklbw {{.*#+}} xmm14 = xmm14[0],xmm10[0],xmm14[1],xmm10[1],xmm14[2],xmm10[2],xmm14[3],xmm10[3],xmm14[4],xmm10[4],xmm14[5],xmm10[5],xmm14[6],xmm10[6],xmm14[7],xmm10[7]
; SSE-NEXT:    pand %xmm7, %xmm14
; SSE-NEXT:    por %xmm11, %xmm14
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm14[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm4 = xmm4[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm4 = xmm4[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm3 = xmm3[2,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm3, %xmm4
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [65535,65535,65535,65535,65535,0,0,0]
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm11 # 16-byte Reload
; SSE-NEXT:    pand %xmm5, %xmm11
; SSE-NEXT:    por %xmm0, %xmm11
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm11[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm11
; SSE-NEXT:    pandn %xmm0, %xmm11
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    por %xmm4, %xmm11
; SSE-NEXT:    movdqa {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm0, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    punpckhbw {{.*#+}} xmm0 = xmm0[8],xmm10[8],xmm0[9],xmm10[9],xmm0[10],xmm10[10],xmm0[11],xmm10[11],xmm0[12],xmm10[12],xmm0[13],xmm10[13],xmm0[14],xmm10[14],xmm0[15],xmm10[15]
; SSE-NEXT:    punpcklbw {{.*#+}} xmm1 = xmm1[0],xmm10[0],xmm1[1],xmm10[1],xmm1[2],xmm10[2],xmm1[3],xmm10[3],xmm1[4],xmm10[4],xmm1[5],xmm10[5],xmm1[6],xmm10[6],xmm1[7],xmm10[7]
; SSE-NEXT:    pand %xmm7, %xmm1
; SSE-NEXT:    pandn %xmm0, %xmm7
; SSE-NEXT:    por %xmm1, %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm7[3,1,2,0]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,4,7,6,5]
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[3,1,2,0]
; SSE-NEXT:    pshuflw {{.*#+}} xmm1 = xmm1[2,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm1 = xmm1[0,1,2,3,6,5,4,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[2,1,2,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[2,1,2,3,4,5,6,7]
; SSE-NEXT:    packuswb %xmm0, %xmm1
; SSE-NEXT:    pand %xmm5, %xmm13
; SSE-NEXT:    pandn %xmm9, %xmm5
; SSE-NEXT:    por %xmm13, %xmm5
; SSE-NEXT:    pand %xmm3, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm5[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,2,1,4,5,6,7]
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; SSE-NEXT:    pshuflw {{.*#+}} xmm0 = xmm0[0,1,0,3,4,5,6,7]
; SSE-NEXT:    pshufhw {{.*#+}} xmm0 = xmm0[0,1,2,3,6,5,4,7]
; SSE-NEXT:    packuswb %xmm0, %xmm0
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm12, 16(%rsi)
; SSE-NEXT:    movaps {{[-0-9]+}}(%r{{[sb]}}p), %xmm0 # 16-byte Reload
; SSE-NEXT:    movaps %xmm0, (%rsi)
; SSE-NEXT:    movdqa %xmm6, 16(%rdx)
; SSE-NEXT:    movdqa %xmm8, (%rdx)
; SSE-NEXT:    movdqa %xmm3, 16(%rcx)
; SSE-NEXT:    movdqa %xmm11, (%rcx)
; SSE-NEXT:    retq
;
; AVX1-LABEL: load_i8_stride3_vf32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX1-NEXT:    vmovdqa 48(%rdi), %xmm3
; AVX1-NEXT:    vmovdqa 64(%rdi), %xmm4
; AVX1-NEXT:    vmovdqa 80(%rdi), %xmm5
; AVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13]
; AVX1-NEXT:    vpshufb %xmm6, %xmm0, %xmm0
; AVX1-NEXT:    vpshufb %xmm6, %xmm3, %xmm3
; AVX1-NEXT:    vpshufb %xmm6, %xmm1, %xmm1
; AVX1-NEXT:    vpshufb %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpshufb %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpshufb %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vpalignr {{.*#+}} xmm6 = xmm5[11,12,13,14,15],xmm3[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm7 = xmm2[11,12,13,14,15],xmm0[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm3 = xmm3[11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm0, %ymm8
; AVX1-NEXT:    vpalignr {{.*#+}} xmm4 = xmm4[11,12,13,14,15],xmm5[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm1 = xmm1[11,12,13,14,15],xmm2[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vinsertf128 $1, %xmm4, %ymm1, %ymm2
; AVX1-NEXT:    vpalignr {{.*#+}} xmm1 = xmm7[11,12,13,14,15],xmm1[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm4 = xmm6[11,12,13,14,15],xmm4[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vbroadcastf128 {{.*#+}} ymm5 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX1-NEXT:    # ymm5 = mem[0,1,0,1]
; AVX1-NEXT:    vandnps %ymm2, %ymm5, %ymm2
; AVX1-NEXT:    vandps %ymm5, %ymm8, %ymm5
; AVX1-NEXT:    vorps %ymm2, %ymm5, %ymm2
; AVX1-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[11,12,13,14,15],xmm7[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm0 = xmm0[10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm3 = xmm3[11,12,13,14,15],xmm6[0,1,2,3,4,5,6,7,8,9,10]
; AVX1-NEXT:    vpalignr {{.*#+}} xmm3 = xmm3[10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9]
; AVX1-NEXT:    vmovdqa %xmm3, 16(%rsi)
; AVX1-NEXT:    vmovdqa %xmm0, (%rsi)
; AVX1-NEXT:    vmovaps %ymm2, (%rdx)
; AVX1-NEXT:    vmovdqa %xmm4, 16(%rcx)
; AVX1-NEXT:    vmovdqa %xmm1, (%rcx)
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_i8_stride3_vf32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %xmm0
; AVX2-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX2-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX2-NEXT:    vinserti128 $1, 48(%rdi), %ymm0, %ymm0
; AVX2-NEXT:    vinserti128 $1, 64(%rdi), %ymm1, %ymm1
; AVX2-NEXT:    vinserti128 $1, 80(%rdi), %ymm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13,0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13]
; AVX2-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpalignr {{.*#+}} ymm3 = ymm2[11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7,8,9,10],ymm2[27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23,24,25,26]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7,8,9,10],ymm0[27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23,24,25,26]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7,8,9,10],ymm1[27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23,24,25,26]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm2 = ymm3[11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7,8,9,10],ymm3[27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23,24,25,26]
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,0,0,0,0,0]
; AVX2-NEXT:    vpblendvb %ymm4, %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7,8,9,10],ymm0[27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23,24,25,26]
; AVX2-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9,26,27,28,29,30,31,16,17,18,19,20,21,22,23,24,25]
; AVX2-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX2-NEXT:    vmovdqa %ymm1, (%rdx)
; AVX2-NEXT:    vmovdqa %ymm2, (%rcx)
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_i8_stride3_vf32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %xmm0
; AVX512-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX512-NEXT:    vmovdqa 32(%rdi), %xmm2
; AVX512-NEXT:    vinserti128 $1, 48(%rdi), %ymm0, %ymm0
; AVX512-NEXT:    vinserti128 $1, 64(%rdi), %ymm1, %ymm1
; AVX512-NEXT:    vinserti128 $1, 80(%rdi), %ymm2, %ymm2
; AVX512-NEXT:    vmovdqa {{.*#+}} ymm3 = [0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13,0,3,6,9,12,15,2,5,8,11,14,1,4,7,10,13]
; AVX512-NEXT:    vpshufb %ymm3, %ymm0, %ymm0
; AVX512-NEXT:    vpshufb %ymm3, %ymm1, %ymm1
; AVX512-NEXT:    vpshufb %ymm3, %ymm2, %ymm2
; AVX512-NEXT:    vpalignr {{.*#+}} ymm3 = ymm2[11,12,13,14,15],ymm0[0,1,2,3,4,5,6,7,8,9,10],ymm2[27,28,29,30,31],ymm0[16,17,18,19,20,21,22,23,24,25,26]
; AVX512-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7,8,9,10],ymm0[27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23,24,25,26]
; AVX512-NEXT:    vpalignr {{.*#+}} ymm1 = ymm1[11,12,13,14,15],ymm2[0,1,2,3,4,5,6,7,8,9,10],ymm1[27,28,29,30,31],ymm2[16,17,18,19,20,21,22,23,24,25,26]
; AVX512-NEXT:    movl $-134154240, %eax # imm = 0xF800F800
; AVX512-NEXT:    kmovd %eax, %k1
; AVX512-NEXT:    vpblendmb %ymm1, %ymm0, %ymm2 {%k1}
; AVX512-NEXT:    vpalignr {{.*#+}} ymm1 = ymm3[11,12,13,14,15],ymm1[0,1,2,3,4,5,6,7,8,9,10],ymm3[27,28,29,30,31],ymm1[16,17,18,19,20,21,22,23,24,25,26]
; AVX512-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[11,12,13,14,15],ymm3[0,1,2,3,4,5,6,7,8,9,10],ymm0[27,28,29,30,31],ymm3[16,17,18,19,20,21,22,23,24,25,26]
; AVX512-NEXT:    vpalignr {{.*#+}} ymm0 = ymm0[10,11,12,13,14,15,0,1,2,3,4,5,6,7,8,9,26,27,28,29,30,31,16,17,18,19,20,21,22,23,24,25]
; AVX512-NEXT:    vmovdqa %ymm0, (%rsi)
; AVX512-NEXT:    vmovdqa %ymm2, (%rdx)
; AVX512-NEXT:    vmovdqa %ymm1, (%rcx)
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %wide.vec = load <96 x i8>, ptr %in.vec, align 32

  %strided.vec0 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <32 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21, i32 24, i32 27, i32 30, i32 33, i32 36, i32 39, i32 42, i32 45, i32 48, i32 51, i32 54, i32 57, i32 60, i32 63, i32 66, i32 69, i32 72, i32 75, i32 78, i32 81, i32 84, i32 87, i32 90, i32 93>
  %strided.vec1 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <32 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22, i32 25, i32 28, i32 31, i32 34, i32 37, i32 40, i32 43, i32 46, i32 49, i32 52, i32 55, i32 58, i32 61, i32 64, i32 67, i32 70, i32 73, i32 76, i32 79, i32 82, i32 85, i32 88, i32 91, i32 94>
  %strided.vec2 = shufflevector <96 x i8> %wide.vec, <96 x i8> poison, <32 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23, i32 26, i32 29, i32 32, i32 35, i32 38, i32 41, i32 44, i32 47, i32 50, i32 53, i32 56, i32 59, i32 62, i32 65, i32 68, i32 71, i32 74, i32 77, i32 80, i32 83, i32 86, i32 89, i32 92, i32 95>

  store <32 x i8> %strided.vec0, ptr %out.vec0, align 32
  store <32 x i8> %strided.vec1, ptr %out.vec1, align 32
  store <32 x i8> %strided.vec2, ptr %out.vec2, align 32

  ret void
}
