[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::idx::structure n 0.1]
[keywords deserialization]
[keywords docidx]
[keywords doctools]
[keywords serialization]
[copyright {2009 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Docidx serialization utilities}]
[category  {Documentation tools}]
[require doctools::idx::structure [opt 0.1]]
[require Tcl 8.4]
[require logger]
[require snit]
[description]

This package provides commands to work with the serializations of
keyword indices as managed by the doctools system v2, and specified in
section [sectref {Keyword index serialization format}].

[para]

This is an internal package of doctools, for use by the higher level
packages handling keyword indices and their conversion into and out of
various other formats, like documents written using [term docidx]
markup.

[section API]

[list_begin definitions]

[call [cmd ::doctools::idx::structure] [method verify] \
	[arg serial] [opt [arg canonvar]]]

This command verifies that the content of [arg serial] is a valid
[term regular] serialization of a keyword index and will throw an
error if that is not the case. The result of the command is the empty
string.

[para]

If the argument [arg canonvar] is specified it is interpreted as the
name of a variable in the calling context. This variable will be
written to if and only if [arg serial] is a valid regular
serialization. Its value will be a boolean, with [const True]
indicating that the serialization is not only valid, but also
[term canonical]. [const False] will be written for a valid, but
non-canonical serialization.

[para]

For the specification of regular and canonical keyword index
serializations see the section
[sectref {Keyword index serialization format}].

[call [cmd ::doctools::idx::structure] [method verify-as-canonical] \
	[arg serial]]

This command verifies that the content of [arg serial] is a valid
[term canonical] serialization of a keyword index and will throw an
error if that is not the case. The result of the command is the empty
string.

[para]

For the specification of canonical keyword index serializations see
the section [sectref {Keyword index serialization format}].

[call [cmd ::doctools::idx::structure] [method canonicalize] [arg serial]]

This command assumes that the content of [arg serial] is a valid
[term regular] serialization of a keyword index and will throw an
error if that is not the case.

[para]

It will then convert the input into the [term canonical] serialization
of the contained keyword index and return it as its result. If the
input is already canonical it will be returned unchanged.

[para]

For the specification of regular and canonical keyword index
serializations see the section
[sectref {Keyword index serialization format}].

[call [cmd ::doctools::idx::structure] [method print] [arg serial]]

This command assumes that the argument [arg serial] contains a valid
regular serialization of a keyword index and returns a string
containing that index in a human readable form.

[para]

The exact format of this form is not specified and cannot be relied on
for parsing or other machine-based activities.

[para]

For the specification of regular keyword index serializations see the
section [sectref {Keyword index serialization format}].

[call [cmd ::doctools::idx::structure] [method merge] \
	[arg seriala] [arg serialb]]

This command accepts the regular serializations of two keyword indices
and uses them to create their union.  The result of the command is the
canonical serialization of this unified keyword index.

[para]

Title and label of the resulting index are taken from the index
contained in [arg serialb]. The set of keys, references and their
connections is the union of the set of keys and references of the two
inputs.

[para]

For the specification of regular and canonical keyword index
serializations see the section
[sectref {Keyword index serialization format}].

[list_end]

[include include/serialization.inc]

[vset CATEGORY doctools]
[include ../common-text/feedback.inc]
[manpage_end]
