<?xml version="1.0"?>
<!--
 -
 -  $Id$
 -
 -  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
 -  project.
 -
 -  Copyright (C) 1998-2024 OpenLink Software
 -
 -  This project is free software; you can redistribute it and/or modify it
 -  under the terms of the GNU General Public License as published by the
 -  Free Software Foundation; only version 2 of the License, dated June 1991.
 -
 -  This program is distributed in the hope that it will be useful, but
 -  WITHOUT ANY WARRANTY; without even the implied warranty of
 -  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 -  General Public License for more details.
 -
 -  You should have received a copy of the GNU General Public License along
 -  with this program; if not, write to the Free Software Foundation, Inc.,
 -  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 -
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xhtml="http://www.w3.org/TR/xhtml1/strict"
                xmlns:wv="http://www.openlinksw.com/Virtuoso/WikiV/" >

<xsl:template match="node()">
  <xsl:copy>
    <xsl:copy-of select="@*" />
    <xsl:apply-templates select="node()" />
  </xsl:copy>
</xsl:template>
  
<xsl:template match="a[@style='wikiword']">
  <xsl:choose>
    <xsl:when test="wv:QueryWikiWordLink($ni_cluster_name,@href)">
      <a>
      <xsl:copy-of select="@*" />
      <xsl:attribute name="href">main.vsp?title=<xsl:value-of select="wv:NormalizeWikiWordLink($ni_cluster_name,@href)" /></xsl:attribute>
      <xsl:apply-templates select="node()" />
      </a>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="node()" />
      <a>
      <xsl:copy-of select="@*" />
      <xsl:attribute name="href">main.vsp?title=<xsl:value-of select="wv:NormalizeWikiWordLink($ni_cluster_name,@href)" /></xsl:attribute>
      <xsl:text>?</xsl:text>
      </a>
    </xsl:otherwise>
  </xsl:choose>      
</xsl:template>

<xsl:template match="/">
  <xsl:copy-of select="@*" />
  <xsl:apply-templates select="node()" />
</xsl:template>

</xsl:stylesheet>
