/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.StringTokenizer;

abstract class DiagramItem
implements EventConsumer {
    Diagram diagram;
    int state;
    final int NONE = 0;
    final int CREATE = 1;
    final int MOVE = 2;
    int x;
    int y;
    int w;
    int h;
    int movex;
    int movey;

    DiagramItem() {
        this.h = 0;
        this.w = 0;
        this.y = 0;
        this.x = 0;
    }

    DiagramItem(StringTokenizer stringTokenizer) throws Exception {
        if (stringTokenizer.countTokens() != 4) {
            throw new IllegalArgumentException();
        }
        this.x = new Integer(stringTokenizer.nextToken());
        this.y = new Integer(stringTokenizer.nextToken());
        this.w = new Integer(stringTokenizer.nextToken());
        this.h = new Integer(stringTokenizer.nextToken());
    }

    abstract void draw(Graphics var1);

    abstract String describe();

    abstract String specify_text();

    abstract int specify_text_x();

    abstract int specify_text_y();

    abstract int specify_line_x1();

    abstract int specify_line_y1();

    abstract int specify_line_x2();

    abstract int specify_line_y2();

    void create() {
        this.state = 1;
    }

    public void yield() {
        this.diagram.editor.current_event_consumer = this.diagram.editor.controls;
        this.state = 0;
    }

    void destroy() {
    }

    void move() {
        this.state = 2;
    }

    public boolean down(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.x = n;
                this.y = n2;
                return true;
            }
            case 2: {
                this.movex = n;
                this.movey = n2;
                return true;
            }
        }
        return false;
    }

    public boolean up(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.w = n - this.x;
                this.h = n2 - this.y;
                this.yield();
                return true;
            }
            case 2: {
                this.x += n - this.movex;
                this.y += n2 - this.movey;
                this.yield();
                return true;
            }
        }
        return false;
    }

    public boolean drag(int n, int n2) {
        switch (this.state) {
            case 1: {
                this.w = n - this.x;
                this.h = n2 - this.y;
                return true;
            }
            case 2: {
                this.x += n - this.movex;
                this.y += n2 - this.movey;
                this.movex = n;
                this.movey = n2;
                return true;
            }
        }
        return false;
    }

    public boolean key(int n) {
        return false;
    }

    abstract double distance(int var1, int var2);
}

