package ONVIF::PTZ::Types::DateTimeRange;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %From_of :ATTR(:get<From>);
my %Until_of :ATTR(:get<Until>);

__PACKAGE__->_factory(
    [ qw(        From
        Until

    ) ],
    {
        'From' => \%From_of,
        'Until' => \%Until_of,
    },
    {
        'From' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
        'Until' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
    },
    {

        'From' => 'From',
        'Until' => 'Until',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::DateTimeRange

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DateTimeRange from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * From


=item * Until




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::DateTimeRange
   From =>  $some_value, # dateTime
   Until =>  $some_value, # dateTime
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

